/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"
#include "achoice.ch"
#include "inkey.ch"
#define LEFT_MARK Chr(175)
#define RIGHT_MARK Chr(174)
#define K_PLUS  43
#define K_MINUS 45

STATIC aLister := {}, nLength

FUNCTION aMarkList(nTopRow, nTopCol, nBottomRow, nBottomCol, aStuff)
   LOCAL aReturn := {}, nCtr, nTemp
   aSize(aLister, nTemp := Len(aStuff))
   aEval(aStuff, {|uElement, nItem| aLister[nItem] :=;
         " "+sSetLength(sMake(uElement), nBottomCol-nTopCol-1)+" "})
   nLength := Len(aLister[1])
   aChoice(nTopRow, nTopCol, nBottomRow, nBottomCol, aLister, .y.,;
         "iMarkList")
   FOR nCtr := 1 to nTemp
      IF LEFT_MARK=Left(aLister[nCtr], 1)
         aAdd(aReturn, {nCtr, aStuff[nCtr]})
      ENDIF
   NEXT
   RETURN aReturn
ENDFUNCTION

STATIC FUNCTION iMarkList(nMode, nElement, nRelRow)
   STATIC lGoDown := .n., lBackUp := .n.
   LOCAL nReturn := AC_CONT, nKey := LastKey()
   DO CASE
   CASE lGoDown
      IF nKey=K_DOWN
         IF nMode!=AC_HITBOTTOM
            KEYBOARD Chr(K_UP)
            lBackUp := .y.
         ENDIF
      ELSE
         IF lBackUp
            KEYBOARD Chr(K_DOWN)
         ENDIF
         lGoDown := lBackUp := .n.
      ENDIF
   CASE nMode=AC_HITTOP .or. nMode=AC_HITBOTTOM
      Tone(125, 0)
   CASE nMode=AC_EXCEPT
      IF nKey=K_ESC
         nReturn := 0
      ELSEIF nKey=K_SPACE
         IF LEFT_MARK=Left(aLister[nElement], 1)
            aLister[nElement] :=;
                  " "+SubStr(aLister[nElement], 2, nLength-2)+" "
         ELSE
            aLister[nElement] :=;
                  LEFT_MARK+SubStr(aLister[nElement], 2, nLength-2)+RIGHT_MARK
         ENDIF
         KEYBOARD Chr(K_DOWN)
         lGoDown := .y.
      ELSEIF nKey=K_PLUS
         aEval(aLister, {|u, nElement|aLister[nElement] :=;
               LEFT_MARK+SubStr(aLister[nElement], 2, nLength-2)+RIGHT_MARK})
      ELSEIF nKey=K_MINUS
         aEval(aLister, {|u, nElement|aLister[nElement] :=;
               " "+SubStr(aLister[nElement], 2, nLength-2)+" "})
      ELSEIF nReturn>32
         nReturn := AC_GOTO
      ENDIF
   ENDCASE
   RETURN nReturn
ENDFUNCTION
