/*

 Ŀ
                                                                        
  File Name...: SAVEREST.PRG                                            
  Author......: Vernon E. Six, Jr.                                      
  Date created: 04-04-94              Date updated: 04-04-94           
  Time created: 09:17:06pm            Time updated: 09:17:06pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "BAS_VERN.CH"

#DEFINE __CURSOR  1
#DEFINE __ROW     2
#DEFINE __COL     3
#DEFINE __COLOR   4
#DEFINE __SCREEN  5
#DEFINE __MAXROW  6
#DEFINE __MAXCOL  7
#DEFINE __PALETTE 8

static saStack := {}     // Multi-Dimensional Array to hold everything


/* HYPERTEXT START
!short: basSaveScrn()   Push a screen onto the "stack"
basSaveScrn()   Push a screen onto the "stack"

^BDescription: ^B

   basSaveScrn() is a greatly improved version of Clipper's own SaveScreen()
   function.  basSaveScrn() not only "pushes" the screen image, it also
   "pushes" the cursor location, the current color attributes and a couple
   of other things.

   If you are not familiar with the concept of PUSHing and POPping and
   "stacks", it is usually explained by the analogy to the way plates are
   dispensed in a cafeteria.  As plates come from the dishwasher they are
   PUSHed onto some kind of spring loaded dispenser stack.  Then as users
   require them, they are POPped off.

   The most recently PUSHed plate is always the first to be POPped.

   The purpose of this type of logic is to always preserve the state of the
   machine at the end of a function to whatever it was at the beginning.


^BSyntax:^B

   basSaveScrn()


^BPass:^B

   Nothing


^BReturns:^B

   Always nil


^BSource:^B

   SAVEREST.PRG


HYPERTEXT END */
function basSaveScrn()

   aadd(saStack,  { SetCursor(), ;
      row(),       ;
      col(),       ;
      SetColor(),  ;
      SaveScreen(0,0,MaxRow(),MaxCol()), ;
      MaxRow(),    ;
      MaxCol(),    ;
      basPalette()    } )

   return nil


/* HYPERTEXT START
!short: basRestScrn()   Pop a screen from the "stack"
basRestScrn()   Pop a screen from the "stack"

^BDescription: ^B

   basRestScrn() is a greatly improved version of Clipper's own RestScreen()
   function.  basRestScrn() "pops" the most recently "pushed" screen from
   the stack.

   If you are not familiar with the concept of PUSHing and POPping and
   "stacks", it is usually explained by the analogy to the way plates are
   dispensed in a cafeteria.  As plates come from the dishwasher they are
   PUSHed onto some kind of spring loaded dispenser stack.  Then as users
   require them, they are POPped off.

   The most recently PUSHed plate is always the first to be POPped.

   The purpose of this type of logic is to always preserve the state of the
   machine at the end of a function to whatever it was at the beginning.


^BSyntax:^B

   basRestScrn( [xSave] )


^BPass:^B

   ^BxSave^B is any valid Clipper expression.  If you pass ^BxSave^B,
   basRestScrn() will not remove the screen from the stack, rather it will
   make a copy of it and restore the display using that copy.


^BReturns:^B

   Always nil


^BSource:^B

   SAVEREST.PRG

HYPERTEXT END */
function basRestScrn(pSAVE)

   if len(saStack) > 0

      SetCursor( saStack[len(saStack), __CURSOR] )

      @ saStack[len(saStack),__ROW], saStack[len(saStack),__COL] SAY ""

      SetColor( saStack[len(saStack),__COLOR] )

      SetMode( saStack[len(saStack),__MAXROW], saStack[len(saStack),__MAXCOL] )

      RestScreen(0, ;
         0, ;
         saStack[len(saStack),__MAXROW], ;
         saStack[len(saStack),__MAXCOL], ;
         saStack[len(saStack),__SCREEN] )

      basPalette( saStack[len(saStack),__PALETTE] )

      if ValType(pSAVE) == "U"
         aDel ( saStack, len(saStack)   )
         aSize( saStack, len(saStack)-1 )
      endif

   endif

   return nil


