/*

 Ŀ
                                                                        
  File Name...: READER.PRG                                              
  Author......: Vernon E. Six, Jr.                                      
  Date created: 04-04-94              Date updated: 09-29-94           
  Time created: 09:31:51pm            Time updated: 08:12:38am         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "BAS_VERN.CH"

#include "getexit.ch"
#include "inkey.ch"
#include "setcurs.ch"
#include "set.ch"

#define __FAKE       9999
#define __TEXT       "Press Any Key To Continue"
#define __BLANK_SECS 45


/* HYPERTEXT START
!short: @...basGET      Replacement for Clipper's @...GET
@...basGET      Replacement for Clipper's @...GET

^BDescription: ^B

   @...basGET is an improved version of Clipper's own @...basGET command.
   The main difference is that all valid clauses are evaluated even in the
   user presses the [PgUp] or [PgDn] keys.  You can also a much better
   message system than you can with native Clipper @...basGET command.


^BSyntax:^B

   @ nRow,nCol [SAY <SayExpr>] ;
      basGET <MemVar>          ;
         [MSGBLOCK bMsg    ]   ;
         [PICTURE  cPicture]   ;
         [WHEN     lPre    ]   ;
         [VALID    lPost   ]   ;
         [SEND     <msg>   ]   ;
         [COLOR    cColor  ]


^BPass:^B

   ^BnRow^B is a numeric expression that should contain the row number for
   the operation.

   ^BnCol^B is a numeric expression that should contain the column number
   for the operation.

   ^B<SayExpr>^B is any valid Clipper "say" expression.

   ^B<MemVar>^B is any valid Clipper variable name.

   ^BbMsg^B is a code block that will be evaluated once when the cursor
   moves into this basGET and once when the cursor leaves this basGET.
   This code will be passed two values as in...

      eval( bMsg, oGet, lMode )

      ^BoGet^B is the actual basGET object (exactly the same as Clipper's
      own GET object) for this basGET

      ^BlMode^B is a logical value that will be set to TRUE if the cursor
      has just moved "into" this basGET.  If the cursor is about to leave
      this basGET, this value will be FALSE.

   ^BcPicture^B is a character expression that should contain any valid
   Clipper GET picture statement.

   ^BlPre^B is a logical expression that should "evaluate" to TRUE if you
   want the cursor to be able to move into this basGET object, otherwise
   this value should "evaluate" to FALSE.

   ^BlPost^B is a logical expression that should "evaluate" to TRUE if you
   want the cursor to be able to leave this basGET object, otherwise this
   value should "evaluate" to FALSE

   ^B<msg>^B is any valid GET send message.  ie: SEND reader := {|| ... }

   ^BcColor^B is a character expression that should contain a normal
   Clipper SetColor() string.

^BReturns:^B

   N/A


^BSource:^B

   READER.PRG  &  BAS_VERN.CH



HYPERTEXT END */



// replacement for GetReader()
function basReader( poGet, pbMsgBlock )

   local nKey     := 0
   local bKeyBlk  := nil

   set scoreboard off

   // Turn the cursor on
   if Set( _SET_INSERT )
      SetCursor( SC_SPECIAL1 )
   else
      SetCursor( SC_INSERT   )
   endif

   begin sequence

      // read the GET if the WHEN condition is satisfied
      if .not. GetPreValidate(poGet)
         break
      endif

      // activate the GET for reading
      poGet:setFocus()

      // if there is a message block... turn it on
      if pbMsgBlock != nil
         eval(pbMsgBlock,poGet,.t.)
      endif

      // Stay here until VALID is satisfied
      while poGet:exitState == GE_NOEXIT

         // check for initial typeout (no editable positions)
         if poGet:typeOut
            poGet:exitState := GE_ENTER
         endif

         // apply keystrokes until exit
         while (poGet:exitState == GE_NOEXIT)

            nKey := basInkeyZero(poGet)

            do case

               case nKey == K_UP
                  poGet:exitState := GE_UP

               case nKey == K_SH_TAB
                  poGet:exitState := GE_UP

               case nKey == K_DOWN
                  poGet:exitState := GE_DOWN

               case nKey == K_TAB
                  poGet:exitState := GE_DOWN

               case nKey == K_ENTER
                  poGet:exitState := GE_ENTER

               case nKey == K_PGUP
                  poGet:exitState := __FAKE
                  keyboard chr(K_CTRL_W)

               case nKey == K_PGDN
                  poGet:exitState := __FAKE
                  keyboard chr(K_CTRL_W)

               case nKey == K_CTRL_HOME
                  poGet:exitState := GE_TOP

               case nKey == K_CTRL_U
                  poGet:Undo()

               case nKey == K_CTRL_W
                  poGet:exitState := __FAKE
                  keyboard chr(K_CTRL_W)

               case nKey == K_CTRL_UP
                  poGet:exitstate := GE_UP

               case nKey == K_CTRL_DOWN
                  poGet:exitstate := GE_DOWN

               case nKey == K_ESC
                  if Set(_SET_ESCAPE)
                     poGet:undo()
                     poGet:exitState := GE_ESCAPE
                  endif

               case nKey == K_INS
                  sCursor()

               otherwise

                  GetApplyKey( poGet, nKey )

            endcase

         enddo

         // disallow exit if the VALID condition is not satisfied
         if .not. GetPostValidate(poGet)
            poGet:exitState := GE_NOEXIT
            clear typeahead
         endif

      enddo

      // fake
      if poGet:ExitState == __FAKE
         poGet:ExitState := GE_ENTER
      endif

      // If there is a message block... turn it off
      if pbMsgBlock != nil
         eval(pbMsgBlock,poGet,.f.)
      endif

      // de-activate the GET
      poGet:killFocus()

   end sequence

   return nil


// toggle cursor mode from normal/insert
static function sCursor()

   Set( _SET_INSERT, !Set(_SET_INSERT) )

   // Who in there right mind uses SCOREBOARD?  YUK!!  I perfer to
   // change the cursor size
   if Set( _SET_INSERT )

      Tone( 1000,.5 )
      Tone( 1800,.5 )

      Tone( 1000,.5 )
      Tone( 1800,.5 )

      SetCursor( SC_SPECIAL1 )

   else

      Tone( 1800,.5 )
      Tone( 1500,.5 )

      Tone( 1800,.5 )
      Tone( 1500,.5 )

      SetCursor( SC_INSERT )

   endif

   return nil





// wait for key and blank screen if necessary
/* HYPERTEXT START
!short: basInkeyZero()  Wait for a key and blank screen if necessary
basInkeyZero()  Wait for a key and blank screen if necessary

^BDescription: ^B

   basInkeyZero() is a smarter version of INKEY(0).  It's primary purpose
   it to wait for a key indefinitely.  If the user doesn't press a key
   within 45 seconds then the screen blanker will be invoked.


^BSyntax:^B

   nKey := basInkeyZero( [oGet] )


^BPass:^B

   ^BoGet^B is a normal Clipper GET object.  If you pass ^BoGet^B then
   basInkeyZero() will process the key the user presses via the "normal"
   Clipper GetDoSetKey() function rather than simply "evaluating" the
   SetKey() code block associated with the key pressed.

^BReturns:^B

   ^BnKey^B is a numeric expression that will contain the INKEY() value of
   the key the user pressed.


^BSource:^B

   READER.PRG

HYPERTEXT END */
function basInkeyZero( poGet )

   local nStart   := _TIME_NOW
   local nBlank   := basAddSecs( nStart, __BLANK_SECS )
   local nKey     := 0
   local bSetKey  := nil

   while .t.

      while nKey == 0

         nKey := inkey()

         if _TIME_NOW > nBlank

            sSaver()

            nStart := _TIME_NOW
            nBlank := basAddSecs( nStart, __BLANK_SECS )

         endif

      enddo

      bSetKey := SetKey(nKey)

      if bSetKey == nil
         exit
      endif

      if pcount() == 0
         eval( bSetKey, ProcName(1), ProcLine(1), "basInkey" )
      else
         GetDoSetKey( poGet, nKey )
      endif

   enddo

   return nKey








// screen saver function
static function sSaver()

   local nMaxCol := maxcol() - len(__TEXT)
   local nKey    := 0

   basSaveScrn()

   SetColor("W/N")

   clear screen

   SetCursor( SC_NONE )

   basSaveScrn()

   while nKey == 0

      DispBegin()

      basRestScrn(.t.)

      @ basRandom( maxrow() ), basRandom( nMaxCol ) say __TEXT color "W+/R"

      DispEnd()

      nKey := inkey(.5)

   enddo

   basRestScrn()
   basRestScrn()

   return nil


