/*

 Ŀ
                                                                        
  File Name...: PICTURE.PRG                                             
  Author......: Vernon E. Six, Jr.                                      
  Date created: 08-26-94              Date updated: 08-26-94           
  Time created: 06:25:42pm            Time updated: 06:25:42pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
  Notes.......: requires FLEXFILE II                                    
                                                                        
 
  

*/

#include "BAS_VERN.CH"

/* HYPERTEXT START
!short: picDisplay()    Display a "saved" ANSI text screen
picDisplay()    Display a "saved" ANSI text screen

^BDescription: ^B

   picDisplay() will display a "saved" ANSI text screen.  A "saved" ANSI
   text screen is a normal ANSI screen created with something like TheDraw,
   LazyDog, AnsiMation, etc and "saved" into a DBV file with picLoad().


^BSyntax:^B

   lSuccess := picDisplay( cDbvName, cPicName, [lMono] )


^BPass:^B

   ^BcDbvName^B is a character expression that should contain the full name
   of the DBV file where ^BcPicName^B was "saved".

   ^BcPicName^B is a character expression that should contain the picture's
   name.  This value must be the same as the one used with picLoad() and is
   NOT case sensitive.

   ^BlMono^B is an optional logical expression that should be set to TRUE
   if you want the "mono" version of ^BcPicName^B displayed, otherwise it
   should be se to FALSE.


^BReturns:^B

   ^BlSuccess^B is a logical expression that will be set to TRUE if
   picDisplay() was successful, otherwise it will be set to FALSE.


^BNotes:^B

   Requires FlexFile II from...

      Ganahl Software, Inc.
      6278 North Federal Hwy Suite 135
      Ft Lauderdale, FL 33308
      Support: (305) 942-5581
      BBS:     (305) 941-4517
      Fax:     (305) 942-2981


^BSource:^B

   PICTURE.PRG

HYPERTEXT END */
function picDisplay( pcDbvName, pcPicture, plMono )

   local lSuccess := .f.
   local aPics    := {}      // { {cPicName,cColorPtr,cMonoPtr}, ... }
   local nPos     := 0

   assume plMono is .f. if missing

   pcPicture := lower(alltrim(pcPicture))

   begin sequence

      if .not. dbvOpen(pcDbvName,"pictures")
         break
      endif

      aPics := dbvRead("pictures")


      nPos  := aScan(aPics, {|x| x[1] == pcPicture } )

      if nPos == 0
         break
      endif

      if plMono
         OutStd( v_Retrieve(aPics[nPos,3],"pictures") )
      else
         OutStd( v_Retrieve(aPics[nPos,2],"pictures") )
      endif

      v_Close("pictures")

      lSuccess := .t.

   end sequence

   return lSuccess



/* HYPERTEXT START
!short: picLoad()       "Save" an ANSI text screen
picLoad()       "Save" an ANSI text screen

^BDescription: ^B

   picLoad() will "save" an ANSI text screen to a specified DBV file.  An
   ANSI text screen is a normal ANSI screen created with something like
   TheDraw, LazyDog, AnsiMation, etc.


^BSyntax:^B

   lSuccess := picLoad( cDbvName, cPicName, cColorFile, cMonoFile )


^BPass:^B

   ^BcDbvName^B is a character expression that should contain the full name
   of the DBV file where ^BcPicName^B was "saved".

   ^BcPicName^B is a character expression that should contain the picture's
   name.  This value will be the same as the one used with picDisplay() and
   is NOT case sensitive.

   ^BcColorFile^B is a character expression that should contain the full
   name of the ANSI screen to "save" as the "color" version of ^BcPicName^B.

   ^BcMonoFile^B is a character expression that should contain the full
   name of the ANSI screen to "save" as the "mono" version of ^BcPicName^B.


^BReturns:^B

   ^BlSuccess^B is a logical expression that will be set to TRUE if picLoad()
    was successful, otherwise it will be set to FALSE.


^BNotes:^B

   Requires FlexFile II from...

      Ganahl Software, Inc.
      6278 North Federal Hwy Suite 135
      Ft Lauderdale, FL 33308
      Support: (305) 942-5581
      BBS:     (305) 941-4517
      Fax:     (305) 942-2981


^BSource:^B

   PICTURE.PRG

HYPERTEXT END */
function picLoad( pcDbvName, pcPicName, pcColorPic, pcMonoPic )

   local nPos     := 0
   local aPics    := {}
   local cColor   := ""
   local cMono    := ""
   local cOldPtr  := ""
   local lSuccess := .f.

   pcPicName := lower(alltrim(pcPicName))

   begin sequence

      if .not. dbvOpen(pcDbvName,"pictures")
         break
      endif

      aPics := dbvRead("pictures")

      nPos  := aScan( aPics, {|x| x[1] == pcPicName } )

      cColor := memoRead(pcColorPic)
      cMono  := memoRead(pcMonoPic)

      if nPos > 0


         cOldPtr := aPics[nPos,2]
         aPics[nPos,2] := v_Replace( cColor, cOldPtr, "pictures" )


         cOldPtr := aPics[nPos,3]
         aPics[nPos,3] := v_Replace( cMono,  cOldPtr, "pictures" )


      else

         aAdd( aPics, { pcPicName, ;
            v_Replace(cColor,"","pictures"), ;
            v_Replace(cMono, "","pictures") } )

      endif

      dbvWrite("pictures",aPics)

      v_Close( "pictures" )

      lSuccess := .t.

   end sequence

   return lSuccess


