/*

  Program Ŀ
                                                                        
  File Name...: PARSE.PRG                                               
  Author......: Vernon E. Six, Jr.                                      
  Date created: 03-13-94              Date updated: 07-31-94           
  Time created: 09:47:51pm            Time updated: 00:44:49am         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "BAS_VERN.CH"

// parse a string for the next word
/* HYPERTEXT START
!short: basParse()      Parse a string for the first word
basParse()      Parse a string for the first word

^BDescription: ^B

   basParse() allows you to parse a string to locate the first word.


^BSyntax:^B

   cWord := basParse( cSearch )


^BPass:^B

   ^BcSearch^B is a character expression that should contain string you want
   to search


^BReturns:^B

   ^BcWord^B is a character expression that will contain the first word of
   ^BcSearch^B in basProper() format.


^BSource:^B

   PARSE.PRG



HYPERTEXT END */
function basParse(pcInput)

   local cRetVal := ""       // return value
   local nNext   := 0        // next space (i.e. seperates words)

   nNext := at(" ",pcInput)

   if nNext == 0 .or. nNext >= len(pcInput)
      cRetVal := alltrim(pcInput)
      pcInput := ""
   else
      cRetVal := substr(pcInput,1,nNext-1)
      pcInput := alltrim( substr(pcInput,nNext) )
   endif

   return basProper(cRetVal)


