/*

 Ŀ
                                                                        
  File Name...: INISTUFF.PRG                                            
  Author......: Vern Six                                                
  Date created: 06-17-94                Date updated: 08-28-94         
  Time created: 02:46:31pm              Time updated: 07:38:00pm       
  CopyRight...: (c) 1994 by FrontLine Software                          
  Notes.......: Requires NanForum ToolKit                               
                                                                        
 
  

*/

#include "fileio.ch"
#include "directry.ch"
#include "BAS_VERN.CH"

static scLastAlias := ""

// {  { cAlias, { cSection, { {cVar,cVal}, {cVar,cVal}, ... } } }, ... }
static saxIniInfo := {}


/* HYPERTEXT START
!short: iniOpen()       Open *.INI file and read contents into memory
iniOpen()       Open *.INI file and read contents into memory

^BDescription: ^B

   iniOpen() is the heart and soul of the *.INI functions.  You must call
   iniOpen() at least once before any calls to other *.INI functions.
   iniOpen() will open the specified *.INI file and read it's contents into
   memory.


^BSyntax:^B

   lSuccess := iniOpen( cFileName, [cIniAlias], [lForce] )


^BPass:^B

   ^BcFileName^B is a character expression that should contain the name of
   your *.INI file.

   ^BcIniAlias^B is an optional character expression that should contain the
   alias name for ^BcFileName^B.  If you don't specify a value for ^BcAlias^B,
   ^BcFileName^B will be used as the default.

   ^BlForce^B is an optional logical expression that should be set to TRUE
   if you want iniOpen() to re-read ^BcFileName^B even if it's already in
   memory.  The default is FALSE which tells iniOpen() to not re-read
   ^BcFileName^B if it's already in memory.


^BReturns:^B

   ^BlSuccess^B is a logical value that will be set to TRUE if iniOpen()
   succeeded in opening the specified *.INI file.


^BNotes:^B

   Requires Nanforum ToolKit available on CompuServe in the CLIPPER forum
   and on our BBS at 817-267-9768


^BSource:^B

   INISTUFF.PRG

HYPERTEXT END */
function iniOpen( pcFileName, pcAlias, plForce )

   local lSuccess    := .f.
   local nHandle     := 0
   local cLine       := ""
   local lSection    := .f.
   local nEqualSign  := 0
   local axIniInfo   := {}
   local nAliasPos   := 0

   assume plForce is .f. if missing

   assume pcAlias is pcFileName if missing
   pcAlias := upper(alltrim(pcAlias))

   begin sequence

      // now delete it from the table
      nAliasPos := aScan( saxIniInfo, {|x| x[1] == pcAlias } )

      if nAliasPos > 0

         if .not. plForce

            // save for all the other functions incase "numb-nuts" doesn't
            // pass an alias
            scLastAlias := pcAlias

            lSuccess := .t.
            break

         endif

         aDel( saxIniInfo, nAliasPos )
         aSize( saxIniInfo, len(saxIniInfo)-1 )

      endif

      if .not. file(pcFileName)
         break
      endif

      nHandle := ft_fUse( pcFileName, FO_READ + FO_SHARED )

      // were we able to open it?
      if nHandle < 0
         break
      endif

      while .not. ft_fEof()

         cLine := alltrim(ft_fReadLn())

         // we don't need blank lines
         if empty(cLine)
            ft_fSkip()
            loop
         endif

         do case

            case left(cLine,1) == ";"

               // new section
            case left(cLine,1) == "[" .and. right(cLine,1) == "]"

               aAdd( axIniInfo, { upper(alltrim(substr(cLine,2,len(cLine)-2))),{}}    )
               lSection := .t.

               // new variable
            case lSection

               nEqualSign := at("=",cLine)

               if nEqualSign > 0

                  aAdd( axIniInfo[len(axIniInfo),2], ;
                     { upper(alltrim(substr(cLine,1,nEqualSign-1))), ;
                     alltrim(substr(cLine,nEqualSign+1) )  } )

               endif

         endcase

         ft_fSkip()

      enddo

      ft_fUse()

      aAdd( saxIniInfo, { pcAlias, axIniInfo } )

      // save for all the other functions incase "numb-nuts" doesn't pass an alias
      scLastAlias := pcAlias

      lSuccess := .t.

   end sequence

   return lSuccess



/* HYPERTEXT START
!short: iniGetStr()     Read a string from *.INI file
iniGetStr()     Read a string from *.INI file

^BDescription: ^B

   iniGetStr() allows your programs to read a string setting from the *.INI
   file previously opened with iniOpen().


^BSyntax:^B

   cString := iniGetStr( cSection, cVarName, [cIniAlias] )


^BPass:^B

   ^BcSection^B is a character expression that should contain the "section"
   name in the *.INI file you want to read.  ^BcSection^B is not case
   sensitive.

   ^BcVarName^B is a character expression that should contain the "variable"
   name of the setting within ^BcSection^B that you want to read.  ^BcVarName^B
   is not case sensitive.

   ^BcIniAlias^B is an optional character expression that should contain the
   alias name for the *.INI file you want to read from.  See iniOpen() for
   more details.  If you don't specify a value for ^BcIniAlias^B, the most
   recently opened *.INI file's alias will be used.

^BReturns:^B

   ^BcString^B is a character expression that will contain the value for
   ^BcVarName^B within section ^BcSection^B in the *.INI file.  NOTE: Leading
   and trailing spaces are removed.


^BNotes:^B

   Requires Nanforum ToolKit available on CompuServe in the CLIPPER forum
   and on our BBS at 817-267-9768


^BSource:^B

   INISTUFF.PRG


HYPERTEXT END */
function iniGetStr(pcSection,pcVar,pcAlias)

   local nAliasPos := 0
   local axIniInfo := {}

   local nSectPos  := 0
   local axVars    := {}      // makes it easier to read

   local nVarPos   := 0
   local cValue    := ""

   pcSection := upper(alltrim(pcSection))
   pcVar     := upper(alltrim(pcVar    ))

   assume pcAlias is scLastAlias if missing
   pcAlias := upper(alltrim(pcAlias))

   begin sequence

      nAliasPos := aScan( saxIniInfo, {|x| x[1] == pcAlias } )

      if nAliasPos == 0
         break
      endif

      axIniInfo := saxIniInfo[nAliasPos,2]

      nSectPos := aScan( axIniInfo, {|s|s[1]==pcSection} )

      if nSectPos == 0
         break
      endif

      axVars := axIniInfo[nSectPos,2]

      nVarPos := aScan( axVars, {|v|v[1]==pcVar} )

      if nVarPos == 0
         break
      endif

      cValue := axVars[nVarPos,2]

   end sequence

   return cValue


/* HYPERTEXT START
!short: iniGetNmbr()    Read a number from *.INI file
iniGetNmbr()    Read a number from *.INI file

^BDescription: ^B

   iniGetNmbr() allows your programs to read a numeric setting from the *.INI
   file previously opened with iniOpen().


^BSyntax:^B

   nValue := iniGetNmbr( cSection, cVarName, [cIniAlias] )


^BPass:^B

   ^BcSection^B is a character expression that should contain the "section"
   name in the *.INI file you want to read.  ^BcSection^B is not case
   sensitive.

   ^BcVarName^B is a character expression that should contain the "variable"
   name of the setting within ^BcSection^B that you want to read.  ^BcVarName^B
   is not case sensitive.

   ^BcIniAlias^B is an optional character expression that should contain the
   alias name for the *.INI file you want to read from.  See iniOpen() for
   more details.  If you don't specify a value for ^BcIniAlias^B, the most
   recently opened *.INI file's alias will be used.


^BReturns:^B

   ^BnValue^B is a numeric expression that will contain the value for
   ^BcVarName^B within section ^BcSection^B in the *.INI file.


^BNotes:^B

   Requires Nanforum ToolKit available on CompuServe in the CLIPPER forum
   and on our BBS at 817-267-9768


^BSource:^B

   INISTUFF.PRG


HYPERTEXT END */
function iniGetNmbr(pcSection,pcVar,pcAlias)
   return val( iniGetStr(pcSection,pcVar,pcAlias) )





/* HYPERTEXT START
!short: iniGetLog()     Read a logical from *.INI file
iniGetLog()     Read a logical from *.INI file

^BDescription: ^B

   iniGetLog() allows your programs to read a logical setting from the *.INI
   file previously opened with iniOpen().


^BSyntax:^B

   lValue := iniGetLog( cSection, cVarName, [cIniAlias] )


^BPass:^B

   ^BcSection^B is a character expression that should contain the "section"
   name in the *.INI file you want to read.  ^BcSection^B is not case
   sensitive.

   ^BcVarName^B is a character expression that should contain the "variable"
   name of the setting within ^BcSection^B that you want to read.  ^BcVarName^B
   is not case sensitive.

   ^BcIniAlias^B is an optional character expression that should contain the
   alias name for the *.INI file you want to read from.  See iniOpen() for
   more details.  If you don't specify a value for ^BcIniAlias^B, the most
   recently opened *.INI file's alias will be used.


^BReturns:^B

   ^BlValue^B is a logical expression that will contain the value for
   ^BcVarName^B within section ^BcSection^B in the *.INI file.


^BNotes:^B

   Requires Nanforum ToolKit available on CompuServe in the CLIPPER forum
   and on our BBS at 817-267-9768


^BSource:^B

   INISTUFF.PRG


HYPERTEXT END */
function iniGetLog(pcSection,pcVar,pcAlias)
   return left(iniGetStr(pcSection,pcVar,pcAlias),1) $ "Yy"






/* HYPERTEXT START
!short: iniGetDate()    Read a date from *.INI file
iniGetDate()    Read a date from *.INI file

^BDescription: ^B

   iniGetDate() allows your programs to read a date setting from the *.INI
   file previously opened with iniOpen().


^BSyntax:^B

   dValue := iniGetDate( cSection, cVarName, [cIniAlias] )


^BPass:^B

   ^BcSection^B is a character expression that should contain the "section"
   name in the *.INI file you want to read.  ^BcSection^B is not case
   sensitive.

   ^BcVarName^B is a character expression that should contain the "variable"
   name of the setting within ^BcSection^B that you want to read.  ^BcVarName^B
   is not case sensitive.

   ^BcIniAlias^B is an optional character expression that should contain the
   alias name for the *.INI file you want to read from.  See iniOpen() for
   more details.  If you don't specify a value for ^BcIniAlias^B, the most
   recently opened *.INI file's alias will be used.


^BReturns:^B

   ^BdValue^B is a date expression that will contain the value for
   ^BcVarName^B within section ^BcSection^B in the *.INI file.


^BNotes:^B

   Requires Nanforum ToolKit available on CompuServe in the CLIPPER forum
   and on our BBS at 817-267-9768


^BSource:^B

   INISTUFF.PRG


HYPERTEXT END */
function iniGetDate(pcSection,pcVar,pcAlias)
   return ctod(iniGetStr(pcSection,pcVar,pcAlias))



/* HYPERTEXT START
!short: iniUpdate()     Update *.INI file
iniUpdate()     Update *.INI file

^BDescription: ^B

   iniUpdate() allows your programs to update settings in the *.INI file
   previously opened with iniOpen().


^BSyntax:^B

   lSuccess := iniUpdate( cFileName, aFields, [cIniAlias] )


^BPass:^B

   ^BcFileName^B is a character expression that should contain the full file
   path and name for the file you want to update.

   ^BaFields^B is an array with the following structure...

      { {cSection,cVarName,xValue}, ...

   ^BcSection^B is a character expression that should contain the "section"
   name in the *.INI file you want to read.  ^BcSection^B is not case
   sensitive.

   ^BcVarName^B is a character expression that should contain the "variable"
   name of the setting within ^BcSection^B that you want to read.  ^BcVarName^B
   is not case sensitive.

   ^BxValue^B is a expression of type character, date, logical or numeric
   that you want to assign to ^BcVarName^B is section ^BcSection^B.

   ^BcIniAlias^B is an optional character expression that should contain the
   alias name for ^BcFileName^B.  If you don't specify a value for ^BcAlias^B,
   ^BcFileName^B will be used as the default.


^BReturns:^B

   ^BlSuccess^B is a logical expression that will be set to TRUE if
   iniUpdate() is successful, otherwise it will be set to FALSE.


^BNotes:^B

   Requires Nanforum ToolKit available on CompuServe in the CLIPPER forum
   and on our BBS at 817-267-9768


^BSource:^B

   INISTUFF.PRG



HYPERTEXT END */
function iniUpdate( pcFileName, pcAlias, paFlds ) // { {cSection,cVarName,xValue}, ... }

   local nInHandle   := 0    // file handle for *.INI file
   local nOutHandle  := 0    // file handle for *.NEW file
   local lSuccess    := .f.  // duh?  Did we make it
   local cLine       := ""   // text line in the *.INI file
   local lSection    := .f.  // we haven't found a section yet
   local nEqualSign  := 0    // were is the equal sign
   local cSection    := ""
   local nPos        := 0
   local cVarName    := ""
   local nAliasPos   := 0

   assume pcAlias is pcFileName if missing
   pcAlias := upper(alltrim(pcAlias))

   begin sequence

      ft_fSelect(1)
      nInHandle := ft_fUse( pcFileName, FO_READ + FO_SHARED )

      // were we able to open it?
      if nInHandle == -1
         break
      endif

      nOutHandle := fCreate("__TEMP__.NEW")

      if nOutHandle < 1
         break
      endif

      // were we able to open it?
      if nOutHandle == -1
         break
      endif

      while .not. ft_fEof()

         cLine := alltrim(ft_fReadLn())

         do case

            case left(cLine,1) == ";"

               fWrite( nOutHandle, cLine + chr(13) + chr(10) )


               // new section
            case left(cLine,1) == "[" .and. right(cLine,1) == "]"

               // see if there is anything new for this section
               while .t.

                  nPos := aScan( paFlds, {|x| upper(alltrim(x[1])) == cSection }           )

                  if nPos == 0
                     exit
                  endif

                  sWriteVar( paFlds, nPos, nOutHandle )

               enddo

               cSection := upper(alltrim(substr(cLine,2,len(cLine)-2)))

               fWrite( nOutHandle, cLine + chr(13) + chr(10) )


               // new variable
            otherwise

               nEqualSign := at("=",cLine)

               if nEqualSign > 0

                  cVarName := upper(alltrim(substr(cLine,1,nEqualSign-1)))

                  nPos := aScan( paFlds, {|x| upper(alltrim(x[1])) == cSection .and. ;
                     upper(alltrim(x[2])) == cVarName }  )

                  if nPos > 0

                     sWriteVar( paFlds, nPos, nOutHandle )

                  else

                     fWrite( nOutHandle, cLine + chr(13) + chr(10) )

                  endif

               else

                  fWrite( nOutHandle, cLine + chr(13) + chr(10) )

               endif

         endcase

         ft_fSkip()

      enddo

      ft_fUse()

      // add any new sections
      while len(paFlds) > 0

         cSection := upper( alltrim(paFlds[1,1]) )

         fWrite( nOutHandle,  "[" + cSection + "]"  + chr(13) + chr(10) )

         // see if there is anything new for this section
         while .t.

            nPos := aScan( paFlds, {|x| upper(alltrim(x[1])) == cSection }           )

            if nPos == 0
               exit
            endif

            sWriteVar( paFlds, nPos, nOutHandle )

         enddo

      enddo

      fClose(nOutHandle)

      copy file ("__TEMP__.NEW") to (pcFileName)


      if .not. iniOpen(pcFileName,pcAlias,.t.)
         break
      endif

      lSuccess := .t.

   end sequence

   if file("__TEMP__.NEW")
      fErase("__TEMP__.NEW")
   endif

   return lSuccess


static function sWriteVar( paFlds, pnPos, pnHandle )

   local cValue := ""
   local xValue := paFlds[pnPos,3]

   do case
      case valtype(xValue) == "C"   ;  cValue := xValue
      case valtype(xValue) == "D"   ;  cValue := dtoc(xValue)
      case valtype(xValue) == "N"   ;  cValue := alltrim(str(xValue))
      case valtype(xValue) == "L"   ;  cValue := if(xValue,"yes","no")
   endcase

   fWrite( pnHandle, paFlds[pnPos,2] + " = " + cValue + chr(13) + chr(10) )

   aDel(paFlds,pnPos)
   aSize(paFlds,len(paFlds)-1)

   return nil







/* HYPERTEXT START
!short: iniSectLst()    Return a list of all the sections in an INI file
iniSectLst()    Return a list of all the sections in an INI file

^BDescription: ^B

   iniSectLst() will return a list of all the sections in the specified
   INI file.


^BSyntax:^B

   acSectLst := iniSectLst( [cIniAlias] )


^BPass:^B

   ^BcIniAlias^B is an optional character expression that should contain the
   alias name for the *.INI file you want to read from.  See iniOpen() for
   more details.  If you don't specify a value for ^BcIniAlias^B, the most
   recently opened *.INI file's alias will be used.

^BReturns:^B

   ^BacSectLst^B is an array of character expressions that will have the
   following structure...

      { cSectName, ... }

   ^BcSectName^B is a character expression that will contain the name of
   the section in the *.INI file you are reading.


^BNotes:^B

   Requires Nanforum ToolKit available on CompuServe in the CLIPPER forum
   and on our BBS at 817-267-9768


^BSource:^B

   INISTUFF.PRG


HYPERTEXT END */
function iniSectLst( pcIniAlias )

   local aSections := {}
   local nLen      := len(saxIniInfo)
   local nI        := 0
   local nAliasPos := aScan( saxIniInfo, {|x| x[1] == pcIniAlias } )
   local axIniInfo := {}

   begin sequence

      if nAliasPos == 0
         break
      endif

      axIniInfo := saxIniInfo[nAliasPos,2]

      for nI := 1 to nLen
         aAdd(aSections,axIniInfo[nI,1])
      next nI

   end sequence

   return aSections


