/*

 Ŀ
                                                                        
  File Name...: DATSORT.PRG                                             
  Author......: Vernon E. Six, Jr.                                      
  Date created: 07-04-94              Date updated: 07-04-94           
  Time created: 01:15:06pm            Time updated: 01:15:06pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/


function DatSort( pcInFile, pcOutFile )

   local nHandle     := 0
   local cLine       := ""
   local axEntries   := {}
   local nLen1       := 0
   local nLen2       := 0
   local nI          := 0
   local nJ          := 0

   cls
   ? "DATSORT v2.0 - HyperText Processor"
   ? "CopyRight (c) 1994 by FrontLine Software"
   ? "All Rights Reserved World Wide"
   ?
   ?

   begin sequence

      if pcount() == 0
         ? "Syntax:  DATSORT {InFile.Ext} {OutFile.Ext}"
         break
      endif

      if .not. file(pcInFile)
         ? "File not found... " + pcInFile
         break
      endif

      nHandle := ft_fUse(pcInFile)

      if nHandle < 1
         ? "Unable to open file... " + pcInFile
         break
      endif

      while .not. ft_fEof()

         cLine := ft_fReadLn()

         if left(cLine,8) == "!short: "
            aAdd(axEntries,{})
         endif

         aAdd( axEntries[len(axEntries)], cLine )

         ft_fSkip()

      enddo

      ft_fUse()

      axEntries := aSort( axEntries,,,{|x,y|x[1] <= y[1]} )

      if file( pcOutFile )
         fErase(pcOutFile)
      endif

      nHandle := fCreate(pcOutFile)

      if nHandle < 1
         ? "Unable to create file... " + pcOutFile
         break
      endif

      nLen1 := len(axEntries)

      for nI := 1 to nLen1

         nLen2 := len(axEntries[nI])
         for nJ := 1 to nLen2

            fWrite(nHandle,axEntries[nI,nJ] + chr(13) + chr(10) )

         next nJ

      next nI

      fClose(nHandle)

   end sequence

   return nil


