   /* tbSimple.prg: A very simple browse of supplier.dbf. 

   Copyright (C) Dave Boettcher 1993. This source code, and functional 
   fragments thereof, may only be distributed unchanged and as part of 
   the file POWER_TB.ARJ. See POWER_TB.TXT for full copyright details.
   
   Last change:  14 May 93       6:48 pm
   */
   
   #include "setcurs.ch"
   #include "inkey.ch"
   #include "box.ch"
   
function main()
   
   local oBrowse
   local oColumn
   local nKey
   local lCont := .T.
   local oldColour := setcolor("w+/b")
   local oldCursor := setcursor(SC_NONE)   
   
   use supplier new
   
   clear screen
   @ 0, 0, 24, 79 box B_DOUBLE
   
   oBrowse := tbrowsedb(1, 1, 23, 78)
   oBrowse:headsep   := ""
   oBrowse:colsep    := "  "
   
   oColumn := TBColumnNew("Name", {|| supplier->name})
   oColumn:width := 30
   oColumn:footsep := ""
   oBrowse:AddColumn(oColumn)
   
   oColumn := TBColumnNew("Street", {|| supplier->street})
   oColumn:width := 20 
   oColumn:footsep := ""
   oBrowse:AddColumn(oColumn)
   
   oColumn := TBColumnNew("Village", {|| supplier->village})
   oColumn:width := 20 
   oColumn:footsep := ""
   oBrowse:AddColumn(oColumn)
   
   oColumn := TBColumnNew("Town", {|| supplier->town})
   oColumn:width := 20
   oColumn:footsep := ""
   oBrowse:AddColumn(oColumn)
   
   oColumn := TBColumnNew("County", {|| supplier->county})
   oColumn:width := 20
   oColumn:footsep := ""
   oBrowse:AddColumn(oColumn)
   
   oColumn := TBColumnNew("Postcode", {|| supplier->postcode})
   oColumn:width := 7
   oColumn:footsep := ""
   oBrowse:AddColumn(oColumn)
   
   oColumn := TBColumnNew("Product", {|| supplier->product})
   oColumn:width := 250
   oColumn:footsep := ""
   oBrowse:AddColumn(oColumn)
   
   do while lCont
      
      do while .not. oBrowse:stable .AND. (nKey := InKey()) == 0
         oBrowse:Stabilize()
      enddo
      
      if oBrowse:stable
         if (oBrowse:hitTop .OR. oBrowse:hitBottom)
            Tone(125,0)
         endif
         nKey := InKey(0)
      endif
      
      do Case
         Case nKey == K_DOWN        ;  oBrowse:Down()
         Case nKey == K_UP          ;  oBrowse:Up()
         Case nKey == K_LEFT        ;  oBrowse:Left()
         Case nKey == K_RIGHT       ;  oBrowse:Right()
         Case nKey == K_PGDN        ;  oBrowse:PageDown()
         Case nKey == K_PGUP        ;  oBrowse:PageUp()
         Case nKey == K_CTRL_PGUP   ;  oBrowse:GoTop()
         Case nKey == K_CTRL_PGDN   ;  oBrowse:GoBottom()
         Case nKey == K_ESC         ;  lCont := .F.
      endcase
      
   enddo
   
   setcolor(oldColour)
   setcursor(oldCursor)
   clear screen
   
   return nil
