/*
 Ŀ
  Module....: ODBUTIL.prg                                                 
  Author....: Steve Kolterman  (DataTech Associates, Inc.)                
  Copyright.: Princeton MICRAN Associates, Inc.                           
  Date......: April 1993                                                  
 Ĵ
  Notes.....: support for data-driven DATADICT.prg                        
 
*/

#include "objectdb.ch"

#define COL_NAMES     1
#define DESCENDINGS   2

#define ALIAS 3
#define UNIQ  4
#define CASE  5
#define ORDER 6

FUNCTION Columns(oTable)
LOCAL cKey:= columns->table

WHILE (columns->table == cKey )

     column():new( oTable ,;
              Trim(columns->column) ,;
              columns->type,;
              columns->length ,;
              columns->decimals  ,;
              Trim(columns->descr)  ,;
              columns->not_null  )

     columns->( dbSkip() )

ENDDO

RETURN NIL

FUNCTION FKeys(oTable)
LOCAL cTable,nRec,oIndex,aIdxData,oTbl
nRec:= fkeys->(recNo())
cTable:= oTable:filename

fkeys->(dbSeek(cTable))

WHILE Trim(fkeys->table)==cTable
    aIdxData:= IdxColData(cTable,fkeys->order)
    oTbl:= db():table(trim(fkeys->ref_table))
    IF fkeys->use_index
       oIndex:= index():new( oTable,;
                IIF( !Empty(fkeys->alias),Trim(fkeys->alias),NIL), ;
                aIdxData[COL_NAMES] ,,;
                oTbl:primaryKey():lCasesens , .F.)
    ENDIF

    rule():new( oTbl , ;
           aIdxData[COL_NAMES] ,;
           oTable,;
           RuleName(fkeys->upd_rule), ;
           RuleName(fkeys->del_rule), ;
           iif( fkeys->use_index, oIndex,) )
    fkeys->(dbSkip())
ENDDO

fkeys->( dbGoto(nRec) )
RETURN NIL

FUNCTION Indexes(oTable)
LOCAL nX,aIdxData,aIndexes,nLen,nLenOrder
aIndexes:= GetIndexes(oTable)
IF (nLen:= Len(aIndexes)) > 0
   nLenOrder:= Len( indexes->order )
   FOR nX:= 1 TO nLen
      aIdxData:= IdxColData(oTable:filename,aIndexes[nX][ORDER] )
      index():new( oTable, ;
      aIndexes[nX][ALIAS], aIdxData[COL_NAMES], aIdxData[DESCENDINGS], ;
      aIndexes[nX][CASE], ;
      .F., ;
      aIndexes[nX][UNIQ] )
   NEXT
ENDIF
RETURN NIL

FUNCTION PKeys(oTable)
LOCAL aIdxData,nRec:= indexes->(recNo())
 indexes->(dbSeek(oTable:filename))
 WHILE Trim(indexes->table)==oTable:filename .and. !indexes->isprimary
    indexes->(dbSkip())
 ENDDO

 aIdxData:= IdxColData(oTable:filename,indexes->order)

 index():new( oTable,;
 IIF(!Empty(indexes->alias),Trim(indexes->alias),NIL) ,;
 aIdxData[COL_NAMES], ,;
 indexes->case_sens, .T. )

 indexes->( dbGoto(nRec) )
RETURN NIL

STATIC FUNCTION GetIndexes(oTable)
LOCAL nRec:= indexes->(recNo()),aIndexes:= {},cTable
cTable:= oTable:filename
IF indexes->( dbSeek(cTable) )
   WHILE Trim(indexes->table) == cTable
      IIF( !indexes->isprimary,Aadd(aIndexes,IdxValues()),)
      indexes->( dbSkip() )
   ENDDO
ENDIF
IIF( indexes->(recNo()) <> nRec, indexes->( dbGoto(nRec) ), )
RETURN aIndexes

STATIC FUNCTION IdxColData(cTable,cOrder)
LOCAL aCols,aDesc,nRec
aCols:= {} ; aDesc:= {}
nRec:= indxcols->(recNo())
indxcols->( dbSeek( Padr(cTable,8)+cOrder) )
WHILE Trim(indxcols->table)+indxcols->order==(cTable+cOrder)
    Aadd( aCols,Trim(indxcols->column))
    Aadd( aDesc,indxcols->descending )
    indxcols->(dbSkip())
ENDDO
indxcols->(dbGoto(nRec))
RETURN {aCols,aDesc}

STATIC FUNCTION RuleName(cRule)
RETURN IIF(cRule=="C","CASCASE",;
       IIF(cRule=="N","NULLIFY","RESTRICT"))

STATIC FUNCTION IdxValues()
LOCAL aVals[indexes->(Fcount())]
RETURN Aeval(aVals,{|e,n| aVals[n]:= indexes->(FieldGet(n))})
