// MGDemo.prg
//
// Demo of MemoGet
//
// Compile: Clipper MGDEMO /n/m/w/l
// Link   : file MGDEMO, MEMOGET
//
// Compile with /DVARINIT to initialize GET variables to something other
// than blanks

#include "box.ch"
#include "memoget.ch"

procedure main()
    local cName, nAge, cNotes, cAddr, cHistory, getList := {}

    set scoreboard off
    set confirm on

    #ifdef VARINIT
        cName    := padr("Shaun Botha", 25)
        nAge     := 27
        cAddr    := padr("Princeton, NJ", 25)
        cNotes   := "- Hope you enjoy this." + chr(13) + chr(10)+;
                    "- What else can be added ?" + chr(13) + chr(10) +;
                    "- Where on earth is VOC ???"
        cHistory := "7/30/93: Germ of an idea" + chr(13) + chr(10) +;
                    "7/31/93: Programmed"
    #else
        cName    := space(25)
        nAge     := 0
        cAddr    := space(25)
        cNotes   := ""
        cHistory := ""
    #endif

    clear screen

    // Here we are 'GET'ting 2 memo fields - one uses the default memo editor,
    // the other a custom editor defined in this file.  You must specify
    // editor coordinates for the editors to use.  Although it could probably
    // be done without it does provide a standard interface.  I've used
    // the current row and column for both editors' top-left coordinates but
    // one can use any legal coordinates.

    @ 0, 0 say "Name   :" get cName
    @ 1, 0 say "Age    :" get nAge picture "99"
    @ 2, 0 say "Notes  :" get cNotes as memo;
        row(), col(), 20, 50
    @ 3, 0 say "Address:" get cAddr
    @ 4, 0 say "History:" get cHistory as memo;
        row(), col(), 15, 65;
        editor myEditor
    read

    clear screen
return


// Custom editor
function myEditor(cMemo,t,l,b,r)
    local s
    local row, col, clr, curs

    // Save screen environment
    s := saveScreen(t,l,b,r)
    row := row()
    col := col()
    clr := setColor()
    curs := setCursor()

    @ t,l,b,r box B_SINGLE + " "
    @ t,l+1 say "History Editor"
    setColor("n/w")
    cMemo := memoEdit(cMemo, t+1, l+1, b-1, r-1)

    // Restore screen environment
    setPos(row, col)
    setColor(clr)
    setCursor(curs)
    restScreen(t,l,b,r, s)
return cMemo
