; **********************************************************
; ABBREV.LSP
; Copyright (c) Barry R. Bowen 1993
; ----------------------------------------------------------
; Variables:
; ABV    = Abbreviation for term
; ALIST  = Alphabet character list
; CK     = Value to check for
; DCL_ID = Dialog box ID number
; LEN    = Length of the string
; LINE   = String read from file
; RM     = Remainder
; TERM   = Term for abbreviation
; X      = Value selected from action tile
; XX     = Value selected from selection popup list
; ----------------------------------------------------------

(defun C:ABBREV (/ ABV ALIST CK DCL_ID LEN RM TERM X XX)

; --------------------------- CKLIST -----------------------
  (defun cklist ()
    (cond
      ((and (= (get_tile "addlist") "")
        (set_tile "error" "You Must Enter a Term!")
        (mode_tile "addlist" 2)))
      ((and (= (get_tile "abbrev") "")
        (set_tile "error" "You Must Enter an Abbreviation!")
        (mode_tile "abbrev" 2)))
      (T  (setq TERM (get_tile "addlist"))
          (setq ABV (get_tile "abbrev"))
          (done_dialog 4))
    )
  )
; ----------------------------------------------------------

  (setq DCL_ID (load_dialog "abbrev.dcl"))
  (if (not (new_dialog "abbrev" DCL_ID)) (exit))
  (setq ALIST (list "A" "B" "C" "D" "E" "F" "G" "H" "I" "J"
                    "K" "L" "M" "N" "O" "P" "Q" "R" "S" "T"
                    "U" "V" "W" "X" "Y" "Z"))
  (start_list "alist")
  (mapcar 'add_list ALIST)
  (end_list)

  (mode_tile "addlist" 1)
  (mode_tile "abbrev" 1)
  (mode_tile "add" 1)
  (mode_tile "edit" 1)
  (mode_tile "remove" 1)

  (action_tile "alist"  "(setq XX $value) (getlist) (abvlist)")
  (action_tile "add"    "(setq X $value) (cklist)")
  (action_tile "edit"   "(setq X $value) (edlist)")
  (action_tile "remove" "(setq X $value) (remlist)")
  (action_tile "accept" "(done_dialog)")
  (action_tile "cancel" "(done_dialog)")

  (setq what_next (start_dialog))
  (if (= 4 what_next) (addlist))

  (unload_dialog dcl_id)
  (princ)
)

; --------------------------- GETLIST ----------------------
(defun getlist ()
  (setq FILE (open "ABBREV.TXT" "r")
        LINE (read-line FILE)
        CK (substr LINE 1 2))
  (while (/= CK (strcat (nth (atoi XX) ALIST) "/"))
     (setq LINE (read-LINE FILE)
           CK (substr LINE 1 2))
  )
)

; -------------------------- ABVTLIST ----------------------
(defun abvlist ()
  (setq LINE (read-line FILE))
  (mode_tile "addlist" 0)
  (mode_tile "abbrev" 0)
  (mode_tile "add" 0)
;  (mode_tile "edit" 0)
;  (mode_tile "remove" 0)
  (start_list "abv")
  (while (/= (substr LINE 2 1) "/")
    (add_list LINE)
    (setq LINE (read-line FILE))
  )
  (end_list)
  (close FILE)
)

; -------------------------- ADDLIST -----------------------
(defun addlist ()
  (setq LEN (strlen TERM))
  (if (< LEN 44)
    (progn
      (setq RM (- 44 LEN))
      (repeat RM
        (setq TERM (strcat TERM "."))
  ) ) )
  (setq LINE (strcat TERM ABV)
        FILE (open "ABBREV.TXT" "a"))
  (write-line LINE FILE)
  (close FILE)
  (setq SORT "abbrev.txt|sort>abbrev.tmp")
  (command "TYPE" SORT)
  (setq CMD "abbrev.txt")
  (command "del" CMD)
  (setq CMD "rename abbrev.tmp abbrev.txt")
  (command "shell" CMD)
  (graphscr)
  (prompt "\nAbbreviation Added To List!\n")
)
