; TIP902.LSP   One Hour Partition  1HRPAR.LSP (C)1993,  Watson Kilbourne

;;;  Draws a one hour fire partition or smoke partition at any angle
(defun C:1HRPAR (/ CE BM FM OM SP EP WD FS DX AN NX NY NZ NU
   P1 P2 P3 P4 P5 P6 P7 P8 P9 P0 PA PB PC PD PE)
   (setq CE (getvar "CMDECHO"))
   (setq BM (getvar "BLIPMODE"))
   (setq FM (getvar "FILLMODE"))
   (setq OM (getvar "OSMODE"))
   (defun NE (ne)
      (setvar "CMDECHO" CE)
      (setvar "BLIPMODE" BM)
      (setvar "FILLMODE" FM)
      (setvar "OSMODE" OM)
      (princ "Function cancelled ")
      (princ)
   )
   (setq OE *error* *error* NE)
   (setvar "CMDECHO" 0)
   (while (= SP nil) (setq SP (getpoint "\nStart <CL> of partition: ")))
   (while (= EP nil) (setq EP (getpoint "\nEnd point of Partition: ")))
   (setq WD (getdist "\nPick or enter width of partition <1.0>: "))
   (if (= WD nil) (setq WD 1.0))
   (setq FS
   (getstring "\nEnter <S> for Smoke partition <Default is Fire partition>: "))
   (setvar "BLIPMODE" 0)
   (setvar "OSMODE" 0)
   (setvar "FILLMODE" 1)
   (setq DX (distance SP EP)
      AN (angle SP EP)
      NX (/ WD 4)
      NY (/ DX (/ WD 2))
      NZ (fix NY)
      NU (- NZ 1)
      P1 (polar SP (+ AN (/ pi 2)) (/ WD 2))
      P2 (polar SP (+ AN (* pi 1.5)) (/ WD 2))
      P3 (polar P1 AN NX)
      P4 (polar P2 AN NX)
      P5 (polar P1 (+ AN (* pi 1.5)) NX)
      P6 (polar P2 (+ AN (/ pi 2)) NX)
      P7 (polar P3 AN NX)
      P8 (polar P7 AN NX)
      P9 (polar P8 AN NX)
      P0 (polar P9 AN NX)
   )
   (if (or (= FS "s") (= FS "S"))
      (progn
         (command ".SOLID" P1 P3 P5 "" "" ".solid" SP P7 P6 P8 "")
         (repeat NU
            (command ".solid" P2 P9 P4 P0 "")
            (setq SP (polar SP AN (* NX 2))
               P2 (polar P4 AN NX)
               P4 (polar P2 AN NX)
               P9 (polar P9 AN (* NX 2))
               P0 (polar P9 AN NX)
            )
         )
         (setq PA (polar P4 AN NX)
            PB (polar PA AN NX)
            PC (polar PB (+ AN (/ pi 2)) NX)
            PD (polar PC (+ AN (/ pi 2)) NX)
            PE (polar PD (+ AN (/ pi 2)) NX)
         )
         (command ".solid" P2 P4 PE PD "" ".solid" PA PB PC "" "")
      )
      (progn
         (repeat NZ
            (command ".solid" P1 P2 P3 P4 "")
            (setq SP (polar SP AN (* NX 2))
               P1 (polar P3 AN NX)
               P2 (polar P4 AN NX)
               P3 (polar P1 AN NX)
               P4 (polar P2 AN NX)
            )
         )
         (if (>= (distance SP EP) (/ WD 5))
         (command ".solid" P1 P2 P3 P4 ""))
      )
   )
   (setvar "OSMODE" OM)
   (setvar "CMDECHO" CE)
   (setvar "BLIPMODE" BM)
   (setvar "FILLMODE" FM)
   (setq *error* OE OE nil)
   (princ)
); end 1hrpar.lsp
