; TIP938B.LSP: DIAO.LSP    Dimensioning Circles and Arcs   
;                          (c)1993, Ken Leseberg

; Used to add a diameter dimension to a circle or an arc.
; The arrow head and leader are to the outside. 

(defun C:DIAO (/ tmco pk p1a p1 p2 p4 p7 p9 ngl rrad ipt srs str ht lcr loc dst xxx dly ccol tortho pkk)
   (setq tmco (getvar "cmdecho"))
   (setq ccol (getvar "cecolor"))
   (setq tortho (getvar "orthomode"))
   (command "color" "green")
   (setvar "cmdecho" 0)
   (setvar "orthomode" 0)
   (setq pkk (entsel "\nSelect arc or circle: ")
      pk (car (cdr pkk))
      p1a (osnap pk "nea")
      p2 (osnap p1a "cen")
      rrad (distance p1a p2)
   srs 0)
   (while (/= srs 3)
      (setq ipt (grread T)
         srs (car ipt) p7 (cadr ipt)
         ngl (angle p2 p7)
      p1 (polar p2 ngl rrad))
      (grdraw p1 p7 -1)
      (setq xxx 0)
      (setq dly (repeat 10
            (setq xxx (+ xxx 1))
      ))
      (grdraw p1 p7 -1)
   )
   (grdraw p1 p7 -1)
   (setq p4 (polar p1 ngl (* 0.18 (getvar "dimscale")))
   zw (* 0.06 (getvar "dimscale")))
   (setvar "ORTHOMODE" 1)
   (setq p9 (getpoint p7 "\nPick point to finish leader: "))
   (grdraw p1 p7 -1)
   (command "pline" p1 "w" 0 zw p4 "w" 0 0 p7 p9 "")
   (command "color" "11")
   (setq str (strcat "%%c" (rtos (* (getvar "dimlfac") 2.0 rrad)))
      dst (* 1.0 (getvar "dimtxt") (getvar "dimscale"))
      ht (* (getvar "dimtxt") (getvar "dimscale"))
      lcr (polar p9 PI dst)
   loc (polar p9 0.0 dst))
   (if (< (car p9) (car p7))
      (command "text" "j" "mr" lcr ht 0 str)
      (command "text" "j" "ml" loc ht 0 str)
   )
   (setvar "ORTHOMODE" tortho)
   (setvar "cmdecho" tmco)
   (command "color" ccol)
   (prin1)
); end diao.lsp
