; TIP936.LSP: REDUCER.LSP    Special Cones   (c)1993, Stephen G. Houghton 

;*****************************************************************************

(defun c:REDUCER( / olderr srad erad  p p1 p2 delrad actualheight trueheight
      secondconeheight basecenterpoint cone1id cone2id cylinderid
      trans1 dirx diry dirz dirpoint trans2 trans3 transmatrix true
      hollow thickness )

   (princ "\nConverging Cylinder.  Copyright 1993 Steve Houghton.")

   (setq olderr *error*)

   (defun *error* (msg)
      (setq *error* olderr
      olderr nil)
      (princ (strcat "\nError: " msg))
      (princ)
   );defun

   (defun getrad( / true ent entname entdxf enttype radius)  
      (setq true T)
      (while true
         (setq ent (nentsel))
         (if ent
            (progn
               (setq entname (car ent)
                  entdxf (entget entname)
               enttype (cdr (assoc 0 entdxf)))
               (if (or (= enttype "ARC") (= enttype "CIRCLE"))
                  (setq radius (cdr (assoc 40 entdxf))
                  true nil)
                  (princ "\nEntity or subentity must be ARC or CIRCLE")
               );if
            );progn
            (princ "\nMust select entity to extract radius.")
         );if
      );while
      (eval 'radius)
   );defun

   (if (not ap_cone) 
      (progn 
         (princ "\nMust load AME first.")
         (quit)
      );progn
   );if                  

   (initget "RAD rad" 6)
   (setq srad (getdist "\nStarting radius (larger of two): "))

   (if (or (= srad "RAD") (= srad "rad") (null srad))
      (progn
         (setq srad (getrad))
         (princ (strcat "\nStart radius selected: " (rtos srad)))
      );progn
   );if       

   (initget "RAD rad" 6)
   (setq erad (getdist "\nEnding radius: "))

   (if (or (= erad "RAD") (= erad "rad") (null erad))
      (progn
         (setq erad (getrad))
         (princ (strcat "\nEnd radius selected: " (rtos erad)))
      );progn
   );if

   (setq delrad (- srad erad))

   (if (<= delrad 0)
      (progn
         (princ "\nInvalid radii.")
         (quit)
      );progn
   );if

   (initget 1)
   (setq p (getpoint "\nFirst center point of converging cylinder: ")
   p1 (trans p 1 0))

   (initget 1)
   (setq p (getpoint "\nSecond center point of converging cylinder: ")
   p2 (trans p 1 0))

   (initget "Y y N n")
   (setq answer (getkword "\nHollow <N>? "))
   (if (or (= answer "Y") (= answer "y"))
      (progn
         (initget 7)
         (setq hollow T
         true T)
         (while true      
            (setq thickness (getdist "\nTube thickness: "))
            (if (< thickness erad)
               (setq true nil)
               (princ "\nTube thickness is greater or equal to end radius.")
            );if
         );while
      );progn
   );if

   ;here we must calculate the height of the projected cone
   (setq actualheight (distance p1 p2)
      trueheight (/ (* actualheight srad) delrad)
      secondconeheight (- trueheight actualheight)
      basecenterpoint (list 0 0 trueheight)

      cone1id      (ap_cone srad srad trueheight)      
      cone2id      (ap_cone erad erad secondconeheight)
   cylinderid (ap_subtract cone1id cone2id))

   (if hollow      
      (progn
         (setq innerrad (- srad thickness)
            innerheight (/ (* trueheight innerrad) srad)
            cone3id (ap_cone innerrad innerrad innerheight)
         transmat (ap_translate 0 0 (- trueheight innerheight)))

         (ap_move_obj cone3id transmat)

         (setq cylinderid (ap_subtract cylinderid cone3id))
      );progn      
   );if

   (setq trans1 (ap_translate 
         (car p1) 
         (cadr p1)
      (caddr p1))

      dirx (- (car p1) (car p2))
      diry (- (cadr p1) (cadr p2))
      dirz (- (caddr p1) (caddr p2))

      dirpoint (list dirx diry dirz)

      trans2 (ap_pts2xfm '(0 0 0) dirpoint)

      trans3 (ap_translate 0 0 (- trueheight))

   transmatrix (ap_compose trans1 trans2 trans3))

   (ap_move_obj cylinderid transmatrix)

   (ap_post_obj cylinderid)              

   (setq *error* olderr)

   (princ)

); end reducer.lsp
