; TIP918.LSP: CBRK.LSP   Break Circle    (c)1993, Noel de la Merced

;  Breaks a circle using a single point.
;  Erases the original circle and draws an arc
;  that has the same radius and center point
;  as the original circle.
;  This command is a quick and excellent command
;  for hatching a certain portion of a circle,
;  Example: for graphing.  

(DEFUN C:CBRK (/ CMD AA OSN A C D B E F)
   (SETQ CMD (GETVAR "CMDECHO"))
   (SETVAR "CMDECHO" 0)
   (SETQ OSN (GETVAR "OSMODE"))
   (COMMAND "OSNAP" "NEAR")
   (PROMPT "SELECT CIRCLE TO BREAK ")
   (SETQ A (ENTSEL))
   (SETQ C (ENTGET (CAR A)))
   (SETQ D (CDR (ASSOC 10 C)))
   (SETQ CIRC1 (CADR C))
   (SETQ CIRC2 (CDR CIRC1))
   (SETQ CIRC3 "CIRCLE")
   (IF (= CIRC2 CIRC3)
      (PROGN
         (SETQ AA (GETVAR "UCSORG"))
         (COMMAND "UCS" "")
         (PROMPT "USE ONE OF THE OSNAP TO BREAK CIRCLE (DEFAULT = NONE) ")
         (SETQ B (GETPOINT))
         (COMMAND "ERASE" A "")
         (COND
            ((> (CAR D) (CAR B))
               (PROGN
                  (IF (> (CADR D) (CADR B))
                     (PROGN
                        (SETQ E (- (CAR B) 0.0000000001))
                        (SETQ F (+ (CADR B) 0.0000000001))
                     )
                     (PROGN
                        (SETQ E (+ (CAR B) 0.0000000001))
                        (SETQ F (+ (CADR B) 0.0000000001))
                     )           
                  )
               )
            )
            ((< (CAR D) (CAR B))
               (PROGN
                  (IF (> (CADR D) (CADR B))
                     (PROGN
                        (SETQ E (- (CAR B) 0.0000000001))
                        (SETQ F (- (CADR B) 0.0000000001))
                     )
                     (PROGN
                        (SETQ E (+ (CAR B) 0.0000000001))
                        (SETQ F (- (CADR B) 0.0000000001))
                     )
                  )
            ))
            ((= (CAR D) (CAR B))
               (PROGN
                  (IF (> (CADR D) (CADR B))
                     (PROGN
                        (SETQ E (- (CAR B) 0.0000000001))
                        (SETQ F (+ (CADR B) 0.0000000001))
                     )
                     (PROGN
                        (SETQ E (+ (CAR B) 0.0000000001))
                        (SETQ F (- (CADR B) 0.0000000001))
                     )           
                  )
               )
            )
            ((= (CADR D) (CADR B))
               (PROGN
                  (IF (> (CAR D) (CAR B))
                     (PROGN
                        (SETQ E (+ (CAR B) 0.0000000001))
                        (SETQ F (+ (CADR B) 0.0000000001))
                     )
                     (PROGN
                        (SETQ E (- (CAR B) 0.0000000001))
                        (SETQ F (- (CADR B) 0.0000000001))
                     )           
                  )
               )
            )

         )
         (COMMAND "ARC" "C" (list (car D) (cadr D)) (list (car B) (cadr B)) (list E F))
      );PROGN
      (PROMPT "\nEntity selected is not a circle.")
   );IF
   (SETVAR "OSMODE" OSN)
   (COMMAND "UCS" "O" AA)
   (SETVAR "CMDECHO" CMD)
   (PRINC)
); end cbrk.lsp
