;TIP914.LSP : WEED.LSP  Eliminate Unnecessary Vertices  (c)1993, Skyler Mills

;***********************************************************
;  Weeds polyline contour vertices and writes to script file
;  Written by Skyler Mills  July 1993
;***********************************************************

(defun C:WEED (/ A A1 A2 ANGDIFF D1 D2 EOL FN FOUT INDEX LS
   NUMPL PLNAME PNT1 PNT2 V0 V1 V2 VCOUNT VNAME VSAVED
   WEEDEG WEEDIST WEEDRAD ZSTR)
   (setq FN (getstring "\nScript File Name: "))
   (setq FN (strcat FN ".SCR"))
   (setq FOUT (open FN "w"))
   (setq WEEDIST (getreal "\nEnter Weeding Distance: "))
   (setq WEEDEG (getreal "\nEnter Weeding Angle (degrees): "))
   (setq WEEDRAD (* pi (/ WEEDEG 180.0)))
   (setq A (ssget '((0 . "POLYLINE"))))
   (setq NUMPL (sslength A))
   (prompt "\nProcessing")
   (setq INDEX 0)
   (setq VCOUNT 0)
   (setq VSAVED 0)
   (setq ANGDIFF 0)
   ;                       Start Polyline Loop
   (repeat NUMPL
      (setq PLNAME (ssname A INDEX))
      (command "PEDIT" PLNAME "D" "")
      (setq INDEX (1+ INDEX))
      (prompt ".")
      (setq VNAME (entnext PLNAME))
      (setq V0 (entget VNAME))
      (setq VCOUNT (1+ VCOUNT))
      (setq LS (cdr (assoc 10 V0)))
      (setq ZSTR (rtos (caddr LS)))
      (write-line (strcat "Elev " ZSTR " 0") FOUT)
      (write-line "PLINE" FOUT)
      (write-line (strcat (rtos (car LS)) "," (rtos (cadr LS))) FOUT)
      (setq VSAVED (1+ VSAVED))
      (setq VNAME (entnext VNAME))
      (setq V1 (entget VNAME))
      (setq PNT1 (cdr (assoc 10 V1)))
      (setq VCOUNT (1+ VCOUNT))
      (setq D1 (distance LS PNT1))
      (setq A1 (angle LS PNT1))
      (setq EOL nil)
      (setq PNT2 nil)
      ;                         Start Vertex Loop
      (while (not EOL)
         (setq VNAME (entnext VNAME))
         (setq V2 (entget VNAME))
         (if (/= (cdr (assoc 0 V2)) "SEQEND")
            (progn
               (setq PNT2 (cdr (assoc 10 V2)))
               (setq VCOUNT (1+ VCOUNT))
               (setq D2 (distance PNT1 PNT2))
               (setq A2 (angle PNT1 PNT2))
               (setq ANGDIFF (- A2 A1))
               (if (or (> (abs ANGDIFF) WEEDRAD) (> D1 WEEDIST))
                  (progn
                     (write-line (strcat (rtos (car PNT1)) "," (rtos (cadr PNT1))) FOUT)
                     (setq VSAVED (1+ VSAVED))
                     (setq LS PNT1)
                     (setq D1 D2)
                     (setq A1 A2)
                  )
                  (progn
                     (setq D1 (distance LS PNT2))
                     (setq A1 (angle LS PNT2))
                  )
               )
               (setq PNT1 PNT2)
            )
            (progn
               (if (not PNT2)
                  (write-line (strcat (rtos (car PNT1)) "," (rtos (cadr PNT1))) FOUT)
                  (write-line (strcat (rtos (car PNT2)) "," (rtos (cadr PNT2))) FOUT)
               )
               (setq VSAVED (1+ VSAVED))
               (write-line "" FOUT)
               (setq EOL "TRUE")
            )
         )
      )
   )
   (write-line "Elev 0 0" FOUT)
   (close FOUT)
   (textscr)
   (prompt "\nPolylines processed: ")
   (prin1 NUMPL)
   (prompt "\nVertices processed: ")
   (prin1 VCOUNT)
   (prompt "\nVertices saved: ")
   (prin1 VSAVED)
   (prompt "\nVertices deleted: ")
   (prin1 (- VCOUNT VSAVED))
   (prin1)
   (prompt "\nWeeding Distance = ")
   (prin1 WEEDIST)
   (prompt "\nWeeding Angle = ")
   (prin1 WEEDEG)
   (prin1)
); end weed.lsp

