//
// TabPro.DCL - Copyright 1993 by Mountain Software
//
// This file is used by TabPro, the AutoCAD Spreadsheet Interface
//
// THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
// WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
// PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.
//
//*===================================================================*

dcl_settings : default_dcl_settings { audit_level = 1; }

tabpro : dialog
{
    label = "TabPro (c) Mountain Software";
    initial_focus = "file";
    //*----- File -----
    :column {
        :row {
        //*----- File
            : button {
                label = "File ";
                fixed_width=true;
                width = 5;
                key = "file";
                mnemonic = "F";
            }
            : edit_box {
                key = "file_box";
                width = 25;
            }
        }
        :row {
        //*----- Range
            : button {
                label = "Range";
                fixed_width=true;
                width = 5;
                key = "range";
                mnemonic = "R";
            }
            : edit_box {
                key = "range_box";
                width = 25;
            }
        }
        : boxed_column {
            label = "Text Parameters";
        //*----- Text Layer
            : row {
                : button {
                    label = "Layer...";
                    fixed_width=true;
                    width = 5;
                    key = "layer";
                    mnemonic = "L";
                }
                : popup_list {
                    key = "layer_list";
                    width = 15;
                    popup_height = 7;
                    alignment = right;
                }
            }
        //*----- Text Style
            : row {
                : button {
                    label = "Style...";
                    fixed_width=true;
                    width = 5;
                    key = "style";
                    mnemonic = "S";
                }
                : popup_list {
                    key = "style_list";
                    width = 15;
                    popup_height = 7;
                    alignment = right;
                }
            }
        //*----- Grid
            : row {
                : button {
                    label = "Grid... ";
                    fixed_width=true;
                    width = 5;
                    key = "grid";
                    mnemonic = "G";
                }
        //*----- Grid Layer
                : popup_list {
                    mnemonic = "L";
                    key = "grid_layer";
                    width = 15;
                    popup_height = 7;
                    alignment = right;
                }
            }
        //*----- Text Size
            : edit_box {
                label = "Height";
                mnemonic = "H";
                key = "text_ht";
                edit_width = 18;
            }
        //*----- Row Spacing
            : row {
                : edit_box {
                    label = "Row Scale";
                    mnemonic = "R";
                    key = "row_sf";
                    edit_width = 5;
                }
                : slider {
                    key = "row_slider";
                    width = 12;
                    fixed_width = true;
                    min_value = 100;
                    max_value = 500;
                }
            }
        //*----- Column Spacing
            : row {
                : edit_box {
                    label = "Column Offset";
                    mnemonic = "C";
                    key = "col_of";
                    edit_width = 5;
                }
                : slider {
                    key = "col_slider";
                    width = 12;
                    fixed_width = true;
                    min_value = 0;
                    max_value = 400;
                }
            }
        }
    }
    ok_cancel_help_errtile;
}

ok_cancel1 : column {
    : row {
        fixed_width = true;
        alignment = centered;
        : ok_button { key = "accept_1"; }
        : spacer { width = 2; }
        cancel_button;
    }
}

Grid : dialog
{
    label = "Table Grid";
    allow_accept=true;
    : boxed_radio_row {
        label = "Border";
        : radio_button {
            key = "border_0";
            label = "None";
            mnemonic = "N";
        }
        : radio_button {
            key = "border_1";
            label = "Thin";
            mnemonic = "T";
        }
        : radio_button {
            key = "border_2";
            label = "Medium";
            mnemonic = "M";
        }
        : radio_button {
            key = "border_3";
            label = "tHick";
            mnemonic = "H";
        }
    }
    spacer;
    : boxed_radio_row {
        label = "Grid Lines";
        mnemonic = "D";
        : radio_button {
            key = "grid_0";
            label = "nOne";
            mnemonic = "O";
        }
        : radio_button {
            key = "grid_1";
            label = "Dotted";
            mnemonic = "D";
        }
        : radio_button {
            key = "grid_2";
            label = "dAshed";
            mnemonic = "A";
        }
        : radio_button {
            key = "grid_3";
            label = "Continuous";
            mnemonic = "C";
        }
    }
    spacer;
    ok_cancel1;
}


Range : dialog
{
    label = "Named Ranges";
    : list_box {
        key = "range_list";
        width = 35;
        allow_accept=true;
    }
    ok_cancel1;
}

//  Duplication of the Style Icon Menu

icon_box : image_button
{
    height = 4;
    width = 12;
    fixed_height = true;
    fixed_width = true;
    color=graphics_background;
    allow_accept=true;
}

icon_dialog : dialog
{
    label = "Icon Menu";
    : row {
        : list_box {
            key = "name_list";
            width = 20;
            allow_accept=true;
        }
        : column {
            : row {
                : icon_box { key = "01"; }
                : icon_box { key = "02"; }
                : icon_box { key = "03"; }
                : icon_box { key = "04"; }
            }
            : row {
                : icon_box { key = "05"; }
                : icon_box { key = "06"; }
                : icon_box { key = "07"; }
                : icon_box { key = "08"; }
            }
            : row {
                : icon_box { key = "09"; }
                : icon_box { key = "10"; }
                : icon_box { key = "11"; }
                : icon_box { key = "12"; }
            }
            : row {
                : icon_box { key = "13"; }
                : icon_box { key = "14"; }
                : icon_box { key = "15"; }
                : icon_box { key = "16"; }
            }
            : row {
                : icon_box { key = "17"; }
                : icon_box { key = "18"; }
                : icon_box { key = "19"; }
                : icon_box { key = "20"; }
            }
        }
    }
    : row {
        fixed_width = true;
        alignment = centered;
        : button {
            label = "Previous";
            key = "previous";
            mnemonic = "P";
        }
        : spacer { width = 2; }
        : button {
            label = "Next";
            key = "next";
            mnemonic = "N";
        }
        : spacer { width = 2; }
        ok_button;
        : spacer { width = 2; }
        cancel_button;
        : spacer { width = 2; }
        help_button;
    }
    errtile;
}

style_dialog : dialog
{
    label = "Style Settings";
    : edit_box {
        label = "Style Name";
        mnemonic = "S";
        key = "style_name";
        edit_width = 15;
    }
    : edit_box {
        label = "Font Filename";
        mnemonic = "F";
        key = "font_file";
        edit_width = 15;
    }
    : edit_box {
        label = "Text Height";
        mnemonic = "H";
        key = "height";
        edit_width = 10;
    }
    : edit_box {
        label = "Width Factor";
        mnemonic = "W";
        key = "width_factor";
        edit_width = 10;
    }
    : edit_box {
        label = "Obliqueing Angle";
        mnemonic = "O";
        key = "obl_ang";
        edit_width = 10;
    }
    : boxed_row {
        : toggle {
            label = "Backwards";
            key = "backwards";
            value = "0";
        }
        : toggle {
            label = "Upside Down";
            key = "upside_down";
            value = "0";
        }
        : toggle {
            label = "Vertical";
            key = "vertical";
            value = "0";
        }
    }
    ok_cancel_help_errtile;
}
