/* 940927 DG1ZX changed crc error display for trace when no crc  */
/*        is generated by the user process function udp_dump()   */
/*                                                               */

#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "netuser.h"
#include "internet.h"
#include "udp.h"
#include "ip.h"
#include "socket.h"
#include "trace.h"
#include "domain.h"

static void near dom_dump __ARGS((FILE *fp,struct mbuf **bpp,int check));
static void near trput_rr __ARGS((FILE *fp,struct rr *rrp));

/* Dump a UDP header */
void
udp_dump(fp,bpp,source,dest,check)
FILE *fp;
struct mbuf **bpp;
int32 source,dest;
int check;              /* If 0, bypass checksum verify */
{
        struct udp udp;
        struct pseudo_header ph;
        int16 csum;

        if(bpp == NULLBUFP || *bpp == NULLBUF)
                return;

        /* Compute checksum */
        ph.source = source;
        ph.dest = dest;
        ph.protocol = UDP_PTCL;
        ph.length = len_p(*bpp);
        csum = (check == 1) ? cksum(&ph,*bpp,ph.length) : 0;

        ntohudp(&udp,bpp);

        trprintf(fp,"UDP: len %u %u->%u",udp.length,udp.source,udp.dest);

        /* an all zero transmitted checksum means that sender generated */
        /* no checksum */
        if(udp.checksum == 0)
          csum = 0;

        if(csum)
                trprintf(fp," CHECKSUM ERROR (%u)",csum);
        trprintf(fp,"\n");

        if(udp.source == IPPORT_DOMAIN || udp.dest == IPPORT_DOMAIN)
                dom_dump(fp,bpp,0);
}

static void near
dom_dump(fp,bpp,check)
FILE *fp;
struct mbuf **bpp;
int check;
{
	struct dhdr *dhdr;
	struct quest *qp;
	int i;
    char *Dopcode[] = {
		"QUERY", "IQUERY", "STATUS", "?", "?", "?", "?", "?", "?", "UPDATEA",
		"UPDATED", "UPDATEDA", "UPDATEM", "UPDATEMA", "ZONEINIT", "ZONEREF"
    };
    char *Drcode[] = {
		"NOERROR", "FORMERR", "SERVFAIL", "NXDOMAIN", "NOTIMP", "REFUSED",
		"?", "?", "?", "?", "?", "?", "?", "?", "?", "NOCHANGE"
    };

	if(bpp == NULLBUFP || *bpp == NULLBUF)
		return;

	dhdr = (struct dhdr *)mxallocw(sizeof(struct dhdr));

	ntohdomain(dhdr,bpp);

	trprintf(fp,"DOMAIN: opcode %s status %s id %lu",
		Dopcode[dhdr->opcode],Drcode[dhdr->rcode],dhdr->id);
	trprintf(fp,"%s%s%s%s%s\n",
		dhdr->aa ? " AA" : "",
		dhdr->qr ? " QR" : "",
		dhdr->rd ? " RD" : "",
		dhdr->ra ? " RA" : "",
		dhdr->tc ? " TC" : "");

	if(dhdr->qdcount) {
		for(i = 0; i < dhdr->qdcount; ){
			qp = dhdr->qlist[i++];
            trprintf(fp,"        Quest%4d: name %s type %s class %s\n",
				i,
				qp->qname,
				type2str(qp->qtype),
				qp->qclass == 1 ? "Internet" : "[unknown]");
		}
	}

	if(dhdr->ancount) {
		for(i = 0; i < dhdr->ancount; i++){
			trprintf(fp,"        Answer%3d: ",i+1);
			trput_rr(fp,dhdr->ans[i]);
		}
	}
	if(dhdr->nscount) {
		for(i = 0; i < dhdr->nscount; i++){
			trprintf(fp,"        Author%3d: ",i+1);
			trput_rr(fp,dhdr->ns[i]);
		}
	}
	if(dhdr->arcount) {
		for(i = 0; i < dhdr->arcount; i++){
			trprintf(fp,"        Addit %3d: ",i+1);
			trput_rr(fp,dhdr->add[i]);
		}
	}
	free_dhdr(dhdr);
}

static void near
trput_rr(fp,rrp)
FILE *fp;
struct rr *rrp;
{
	if(fp == NULLFILE || rrp == NULLRR)
		return;

	trprintf(fp,"%s",rrp->name);

	if(rrp->name[strlen(rrp->name)-1] != '.' && rrp->origin != NULLCHAR)
		trprintf(fp,".%s",rrp->origin);

	if(rrp->ttl)
		trprintf(fp," %lu",rrp->ttl);

	if(rrp->class == CLASS_IN) {
		trprintf(fp," IN");
    } else {
		if(rrp->ttl == 0)
			trprintf(fp," %lu",rrp->ttl);
		trprintf(fp," %u",rrp->class);
	}

	if(rrp->type < NDTYPES)
		trprintf(fp," %s ",type2str(rrp->type));
	else
		trprintf(fp," %u ",rrp->type);

	/* Null data portion, indicates nonexistent record */
	if(rrp->rdlength != 0) {
		switch(rrp->type){
		case TYPE_MINFO:	/* Unsupported type */
			trprintf(fp,"%s %s",
				rrp->rdata.minfo.rmailbx,rrp->rdata.minfo.emailbx);
			break;
		case TYPE_MD:		/* Unsupported type */
		case TYPE_MF:		/* Unsupported type */
		case TYPE_NULL:		/* Unsupported type */
		case TYPE_WKS:		/* Unsupported type */
			trprintf(fp,"%s",rrp->rdata.data);
			break;
		case TYPE_CNAME:
		case TYPE_MB:
		case TYPE_MG:
		case TYPE_MR:
		case TYPE_NS:
		case TYPE_PTR:
		case TYPE_TXT:
			/* These are all printable text strings */
			trprintf(fp,"%s",rrp->rdata.data);
			break;
		case TYPE_A:
			trprintf(fp,"%s",inet_ntoa(rrp->rdata.addr));
			break;
		case TYPE_MX:
			trprintf(fp,"%u %s",
				rrp->rdata.mx.pref,rrp->rdata.mx.exch);
			break;
		case TYPE_SOA:
			trprintf(fp,"%s %s %lu %lu %lu %lu %lu",
				rrp->rdata.soa->mname,rrp->rdata.soa->rname,
				rrp->rdata.soa->serial,rrp->rdata.soa->refresh,
				rrp->rdata.soa->retry,rrp->rdata.soa->expire,
				rrp->rdata.soa->minimum);
			break;
		case TYPE_HINFO:
			trprintf(fp,"%s %s",
				rrp->rdata.hinfo.cpu,rrp->rdata.hinfo.os);
		default:
			break;
		}
	}
	trprintf(fp,"\n");
	return;
}

