/* UDP-related user commands
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "netuser.h"
#include "udp.h"
#include "internet.h"
#include "cmdparse.h"
#include "commands.h"

int
st_udp(udp)
struct udp_cb *udp;
{
	return tprintf("%8lx%6u  %s\n",ptol(udp),udp->rcvcnt,pinet(&udp->socket));
}

/* Dump UDP statistics and control blocks */
static int
doudpstat(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct udp_cb *udp;
	int i;

	for(i = 1; i <= NUMUDPMIB; i++) {
		tprintf("(%2u)udp%-17s%10lu",i,Udp_mib[i].name,Udp_mib[i].value.integer);
		tputs((i % 2) ? "     " : "\n");
	}
	if((i % 2) == 0)
		tputs("\n");

	tputs("&UCB     Rcv-Q  Local socket\n");
	for(udp = Udps;udp != NULLUDP; udp = udp->next)
		st_udp(udp);

	return 0;
}

int
doudp(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct cmds Udpcmds[] = {
		"status",	doudpstat,	0, 0,	NULLCHAR,
		NULLCHAR,
	};
	return subcmd(Udpcmds,argc,argv,p);
}
