#include <stdio.h>
#include <stdlib.h>
#include "global.h"

#define ARP_FILE_VERSION	3
#define NHWTYPES			9

char arp_filename[] = "arproute.dat";
char arp_tmpfilename[] = "arproute.tmp";

struct arp_saverecord {
  int32 ip_addr;          /* IP address, host order */
  int16 hardware;         /* Hardware type */
  int16 hwalen;           /* Length of hardware address */
  char  pub;              /* Publish this entry? */
};
struct arp_saverecord3 {
  int32 ip_addr;          /* IP address, host order */
  int16 hardware;         /* Hardware type */
  int	flags;			  /* AX.25 connection type */
  int16 hwalen;           /* Length of hardware address */
  char  pub;              /* Publish this entry? */
};

main ()
{

  FILE *fp, *fp1;
  char  hw_addr[255];
  struct arp_saverecord  buf;
  struct arp_saverecord3 buf3;
  int version;

  printf("ARPFCONV.EXE - Copyright by DB3FL\n");
  printf("Konvertiert das 'arproute.dat' File von WNOS.2x zu WNOS.3A und hher\n");
  printf("Achtung! Das konvertierte File kann von WNOS.2x nicht mehr verarbeitet werden\n");
  printf("Converts 'arproute.dat' file from WNOS.2x to WNOS.3A and up\n");
  printf("Attention! The converted file is no longer readable by WNOS.2x\n\n");

  if ((fp = fopen(arp_filename,READ_BINARY)) == NULLFILE) {
	printf("'%s' muss im selben Verzeichnis sein\n",arp_filename);
	printf("'%s' must be in the same directory\n",arp_filename);
	exit(1);
  }
  version = getc(fp);

  if(version != 0 && version != 3) {
	printf("Falsches Fileformat\n");
	printf("Incorrect fileformat\n");
	fclose(fp);
	exit(1);
  }
  if(version == 3) {
	printf("File bereits konvertiert\n");
	printf("File already converted\n");
	fclose(fp);
	exit(1);
  }


  if ((fp1 = fopen(arp_tmpfilename,WRITE_BINARY)) == NULLFILE) {
	printf("Fehler beim Schreiben von '%s'\n",arp_tmpfilename);
	printf("Error on writing '%s'\n",arp_tmpfilename);
	fclose(fp);
	exit(1);
  }
  putc(ARP_FILE_VERSION,fp1);

  while (fread((char *) & buf, sizeof(buf), 1, fp))
	if (fread(hw_addr, buf.hwalen, 1, fp))
	  if (buf.hardware < NHWTYPES) {
		buf3.ip_addr = buf.ip_addr;
		buf3.hardware = buf.hardware;
		buf3.flags = 0;		/* here is the difference! */
		buf3.hwalen = buf.hwalen;
		buf3.pub = buf.pub;
		fwrite((char *) & buf3, sizeof(buf3), 1, fp1);
		fwrite(hw_addr, buf3.hwalen, 1, fp1);
	  }

  fclose(fp);
  fclose(fp1);

  unlink("arproute.bak");
  rename(arp_filename,"arproute.bak");
  unlink(arp_filename);
  rename(arp_tmpfilename,arp_filename);

  printf("'%s' gesichert als 'arproute.bak'\n",arp_filename);
  printf("'%s' saved as 'arproute.bak'\n\n",arp_filename);
  printf("Konvertierung beendet\n");
  printf("Conversion finished\n");
  exit(0);
  return;
}

