#include <windows.h>
#include "combosub.h"
static FARPROC fpOrigComboProc=NULL; 
static FARPROC fpNewComboProc=NULL;

LONG FAR PASCAL _export ComboboxSubclassProc(HWND hwnd,WORD message,WORD wParam,LONG lParam);

HINSTANCE hInstance = 0;
BOOL FAR PASCAL SubclassCombobox(HWND hwndCombo){
   //subclasses a control and all its children

	 //a window of cluss button, take its class information and
	 //substitute its window procedure;
	 //old window proc goes to fpOrigButtonProc
	if (!fpOrigComboProc || !fpNewComboProc) {
	
	 HWND hWnd;
	 
	 hInstance = (HINSTANCE)GetWindowWord(hwndCombo, GWW_HINSTANCE);

	 hWnd = CreateWindow( 
		"ComboBox",
		"Noname Window",
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,
		0,
		CW_USEDEFAULT,
		0,
		NULL,
		NULL,
		hInstance,
		NULL);

	 fpOrigComboProc	= (FARPROC) GetClassLong(hWnd,GCL_WNDPROC);
	 fpNewComboProc	= MakeProcInstance((FARPROC)ComboboxSubclassProc,hInstance );
	 DestroyWindow(hWnd);
	}
	if (!fpOrigComboProc || !fpNewComboProc) {
		return FALSE;
	}
	SetWindowLong(hwndCombo,GWL_WNDPROC,(LONG)fpNewComboProc);
   InvalidateRect(hwndCombo, NULL, TRUE); //repaint control with new background 
	return TRUE;
}
HWND GetCtlcolorhandler(HWND hwndControl){
  HWND current = hwndControl;
  do { //looking for a window which has no 'WS_CHILD' style
	  current = GetParent (current);
  } while(GetWindowLong(current, GWL_STYLE) & WS_CHILD);
  return current;
}
LONG FAR PASCAL _export ComboboxSubclassProc(HWND hwnd,WORD message,WORD wParam,LONG lParam){

 if (!fpOrigComboProc){ //we are in serious troble
		return DefWindowProc( hwnd, message, wParam, lParam );
 }

 switch(message){
  case WM_CTLCOLOR: //redirect it to parent.
	return 
		SendMessage(GetParent(hwnd), 
						message, 
						wParam, 
						MAKELONG(hwnd,HIWORD(lParam))
		);//substituted out hwnd for simplicity
 }
 return CallWindowProc(fpOrigComboProc,hwnd,message,wParam,lParam);
}
									  