/*  Development Environment:
	BC++ 3.1, DOS 5.0, Novell Netware 3.11,
	Novell Netware Client API 1.0e

	Thomas H. Smith [70674,3300]
	This source code is public and to be distributed freely to others.
*/

#include <stdlib.h>
#include <stdio.h>
#include <alloc.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include <dir.h>
#include <direct.h>
#include <ctype.h>

#include <nwcalls.h>

void main()
{
	NWCONN_HANDLE	connHandle;
	NWCONN_NUM		connNum;
	NWDIR_HANDLE	dirHandle = 0;
	NWCCODE			ccode;
	NWOBJ_ID		*objectid;
	CONNECT_INFO	connInfo;

	char	nw_maildir[12] 	= "/SYS:MAIL/\0";
	char	szMailDrvO[38];		// will hold "server\sys:mail\xxxx" string
	int		iCurrentDrive;		// current drive
	unsigned long UserNum;      // Hex Numeric swap of objectID
	char	UserMailDir[8];     // for character equivalent of UserNum

	/* For previous drive O: */
	WORD	drvOstatus;
	NWCONN_HANDLE	OconnHandle;
	char	RootPath[65];
	char	RelPath[65];
	char	FullPath[120] = "\0";

	/* Used in search and count of mail files */
	struct	ffblk ffblk;
	int		MsgCount;
	int		done;
	int		i;


	ccode = NWCallsInit( NULL, NULL);
	if(ccode)
		exit(1);

	ccode = NWGetDefaultConnectionID( &connHandle );
	if(ccode){
		printf( "Could not get Default Connection ID. Error: %X\n", ccode);
		exit(1);
		}

	ccode = NWGetConnectionStatus( connHandle,
									&connInfo,
									sizeof(CONNECT_INFO));
	if(ccode){
		printf("Could not get Connection Status.  Error: %X\n", ccode);
		exit(1);
	}

	ccode = NWGetConnectionHandle( connInfo.serverName, 0,
								   &connHandle, NULL );
	if(ccode){
		printf( "Could not get Connection Handle. Error: %X\n", ccode);
		exit(1);
		}

/* Get User ID */
	ccode = NWGetConnectionNumber( connHandle, &connNum );
	if(ccode){
		printf( "Could not get Connection Number. Error: %X\n", ccode);
		exit(1);
	}

	objectid=(unsigned long *)malloc(24);

	ccode = NWGetConnectionInformation( connHandle, connNum, NULL,
		  NULL, objectid, NULL);
	if(ccode){
		printf( "Could not get Connection Info. Error: %X\n", ccode);
		free(objectid);
		exit(1);
		}

	/* Mail directory vales are swapped (don't me why)  */
	UserNum =  NWLongSwap( *objectid );

	/* Change Hex to user directory Text */
	ultoa( UserNum, UserMailDir, 16);

	/* Change the A thru F Hex values from lower case to upper case
	   (All directory characters must be upper case)  */
	for (i=0; i<9; i++)
	{
		if(UserMailDir[i] > '9')
			UserMailDir[i] = toupper(UserMailDir[i]);
	}

//	ptrUserMailDir = userMailDir;   // set pointer

	strcpy( szMailDrvO, connInfo.serverName);
	strcat( szMailDrvO, nw_maildir);
	strcat( szMailDrvO, (char *)UserMailDir);

//////////  BCPP _chdrive numeric equivalents //////////////////////
// A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X
// 1  2  3  4  5  6  7  8  9  10 11 12 13 14 15 16 17 18 19 20 21 22 23
/*************************************************************** */

/* Get current drive. Change back to it later. */
	iCurrentDrive = _getdrive();

/* Make drive O: */

/* Attempt to change to drive O:  */
	if( _chdrive(15) == 0)
	{   /* If drive O: exists, save the setting to restore later  */
		ccode = NWGetDriveStatus( 15,
					NW_FORMAT_SERVER_VOLUME,
					&drvOstatus,
					&OconnHandle,	// Connection Handle
					(char *)RootPath,      // root path
					(char *)RelPath,       // relative path
					(char *)FullPath );    // fullpath

		if( ccode ){
			printf("Drive O: exists. Failure on getting O: setting\n");
			free(objectid);
			_chdrive( iCurrentDrive );
			exit(1);
		}
	}
	ccode = NWSetDriveBase( 15, connHandle, dirHandle,
						(char *) szMailDrvO, 0);
	if(ccode){
		printf("Unable to map %s : error %X", nw_maildir, ccode);
		free(objectid);
		exit(0); }
	else{
		if( _chdrive( 15 ) == 0 )	// set current disk to drive O:
			chdir( (const char *)nw_maildir );
			 // change directory to "objectid"
	}

/* Search for '*.CNM' message file  */
	done = findfirst("*.CNM", &ffblk, 0);
	if(done != 0 )
		MsgCount=0;
	else
	{	 /* Mail message has been read if '!' is first character  */
		if( ffblk.ff_name[0] != '!' )
			MsgCount=1;
		else
			MsgCount=0;
	}
/* Count all *.CNM files without an ! for first character */
	while( !done )
	{
		done = findnext( &ffblk );
		if(done)
			break;
		if( ffblk.ff_name[0] != '!' )
			MsgCount++;
	}

/* Delete drive O: */
	ccode = NWDeleteDriveBase( 15 , 0);
	if(ccode)
		printf("\nFailure in deleting drive O:. Error: %X", ccode);

/* Restore Drive O: if it was previously in use */
	if(strlen( (char *) RootPath ) > 0 )
	{
		ccode=NWSetDriveBase( 15, OconnHandle, dirHandle, (char *) RootPath, 0 );
			if(ccode)
				printf( "\nError in restoring drive O:.  Error: %X\n", ccode);
		_chdrive(15);
		chdir(RelPath);
	}

	if( MsgCount > 0 )
	{	printf( "\n\t\tYou have %d new Mail messages.", MsgCount );
		printf( "\n\t\t- Press any key to continue -\n");
		done = getch();
	}
	_chdrive(iCurrentDrive);
	free(objectid);
}
