/*

	Array class definition for PCOOPE2

	  Copyright (C) 1994, Brian Lee Price

	  released as PUBLIC DOMAIN 4/25/94


*/


#define CLASS Array

#include "pcoope2.h"
#include <mem.h>
#include <stdio.h>

object CLASS;

extern object Dyn;

instVars {
	byte *		base;
	unsigned 	numElems;
	unsigned	elemSize;
	unsigned	curPos;
	 };

INSTANCEPOLY(pReSz);
INSTANCEPOLY(pGetEl);
INSTANCEPOLY(pPutEl);
INSTANCEPOLY(pGetNel);
INSTANCEPOLY(pGetESz);
INSTANCEPOLY(pGetc);
INSTANCEPOLY(pPutc);
INSTANCEPOLY(pGetPos);
INSTANCEPOLY(pSetPos);

EXCLUDEPOLY(pClrErr);


INCLUDEPOLY(pAcc);

cFunc object New(object instance, unsigned numElems,unsigned elemSize);
iFunc object ReSz(object instance, unsigned numElems);
iFunc object GetEl(object instance, unsigned element);
iFunc object PutEl(object instance, unsigned element, void * item);
iFunc object GetNel(object instance);
iFunc object GetESz(object instance);
iFunc object Getc(object instance);
iFunc object Putc(object instance, byte c);
iFunc object GetPos(object instance);
iFunc object SetPos(object instance, long newPos);

ClassInstallFunc
{
pNew(Base,0,sizeof(instVars),&CLASS,Dyn,NULL);

MAKE_C_POLY(New);

MAKE_I_POLY(ReSz);
MAKE_I_POLY(GetEl);
MAKE_I_POLY(PutEl);
MAKE_I_POLY(GetNel);
MAKE_I_POLY(GetESz);
MAKE_I_POLY(Getc);
MAKE_I_POLY(Putc);
MAKE_I_POLY(GetPos);
MAKE_I_POLY(SetPos);

EXCLUDE_POLY(pClrErr);

EndClassInstall;
}

#define pAcc   I_POLY(pAcc)
#define pReSz  I_POLY(pReSz)


cFunc object New(object instance, unsigned numElems, unsigned elemSize)
{
DECLAREivPtr;
BEGIN_NEW;

MakeInstance;
pNew(Dyn,(ivPtr->numElems=numElems)*(ivPtr->elemSize=elemSize));
ivPtr->base=pAcc(instance);

END_NEW;
}


iFunc object ReSz(object instance, unsigned numElems)
{
GETIVPTR;

pReSz(getAinst(Dyn,instance),(ivPtr->numElems=numElems)*ivPtr->elemSize);
ivPtr->base=pAcc(instance);

return instance;
}


iFunc object GetEl(object instance, unsigned element)
{
byte * ptrA;
GETIVPTR;

if(element>=ivPtr->numElems) return NULL;
ptrA=ivPtr->base + (ivPtr->elemSize*element);
return ptrA;
}

iFunc object PutEl(object instance, unsigned element, void * item)
{
byte * ptrA;
GETIVPTR;

if(element>=ivPtr->numElems) return NULL;
ptrA=ivPtr->base + (ivPtr->elemSize*element);
return memmove(ptrA,item,ivPtr->elemSize);
}

iFunc object GetNel(object instance)
{
GETIVPTR;

return (object)((cast)ivPtr->numElems);
}

iFunc object GetESz(object instance)
{
GETIVPTR;

return (object) ((cast) ivPtr->elemSize);
}


iFunc object Getc(object instance)
{
GETIVPTR;

if(ivPtr->curPos>=0 && ivPtr->curPos < ivPtr->elemSize*ivPtr->numElems)
    {
    return (object) ((cast) ((byte) ivPtr->base[ivPtr->curPos++]));
    }
return (object) ((cast) EOF);
}


iFunc object Putc(object instance, byte c)
{
GETIVPTR;

if(ivPtr->curPos>=0 && ivPtr->curPos < ivPtr->elemSize*ivPtr->numElems)
    {
    return (object) ((cast) ((byte)ivPtr->base[ivPtr->curPos++]=c));
    }
return (object) ((cast) EOF);
}


iFunc object GetPos(object instance)
{
GETIVPTR;

if(ivPtr->curPos>=0 && ivPtr->curPos < ivPtr->elemSize*ivPtr->numElems)
    {
    return (object) ((cast) ivPtr->curPos);
    }
return (object) ((cast) -1);
}


iFunc object SetPos(object instance,long newPos)
{
GETIVPTR;

if(newPos>=0 && newPos < ivPtr->elemSize*ivPtr->numElems)
    {
    ivPtr->curPos=(unsigned) newPos;
    return (object) ((cast) 1);
    }
return (object) ((cast) 0);
}

