/************************************************************
* MultiUser - MultiUser Task/File Support System				*
* ---------------------------------------------------------	*
* Change Password															*
* ---------------------------------------------------------	*
*  Copyright 1993 by Geert Uytterhoeven							*
* All Rights Reserved.													*
************************************************************/


#include <exec/types.h>
#include <dos/dos.h>
#include <proto/exec.h>
#include <proto/dos.h>
#include <utility/tagitem.h>
#include <proto/reqtools.h>
#include <libraries/reqtools.h>
#include <string.h>
#include <libraries/multiuser.h>
#include <proto/multiuser.h>

#include "Passwd_rev.h"


char __VersTag__[] = VERSTAG;


static void __regargs myputs(char *str, struct DosLibrary *DOSBase);
static void __regargs mygets(char *str, struct DosLibrary *DOSBase);


int __saveds Start(char *arg)
{
	struct ExecBase *SysBase;
	struct DosLibrary *DOSBase;
	struct muBase *muBase = NULL;
	struct ReqToolsBase *ReqToolsBase = NULL;
	char oldpwd[muPASSWORDSIZE];
	char newpwd1[muPASSWORDSIZE];
	char newpwd2[muPASSWORDSIZE];
	struct RDArgs *args;
	LONG argarray[] = {
		NULL
	};
	static struct TagItem allwaystags[] = {
		RT_ReqPos, REQPOS_CENTERSCR,
		RT_LockWindow, TRUE,
		TAG_DONE
	};
	struct TagItem infotags[] = {
		RTEZ_Flags, EZREQF_CENTERTEXT,
		TAG_MORE, (LONG)allwaystags
	};
	struct TagItem pwdtags[] = {
		RTGS_TextFmt, NULL,
		RTGS_Invisible, TRUE,
		RTGS_AllowEmpty, TRUE,
		RTGS_Flags, GSREQF_CENTERTEXT,
		RTGS_GadFmt, (LONG)"OK",
		TAG_MORE, (LONG)allwaystags
	};
	int rc = RETURN_ERROR;


	SysBase = *(struct ExecBase **)4;
	
	if ((!(DOSBase = (struct DosLibrary *)OpenLibrary("dos.library", 37))) ||
		 (!(muBase = (struct muBase *)OpenLibrary("multiuser.library", 39))) ||
		 (!(ReqToolsBase = (struct ReqToolsBase *)OpenLibrary("reqtools.library", 38)))) {
		rc = RETURN_FAIL;
		goto Exit;
	}

	args = ReadArgs("GUI/S", argarray, NULL);
	if (!args)
		PrintFault(IoErr(), NULL);
	else {
		if (argarray[0]) {
			memset(oldpwd, '\0', sizeof(oldpwd));
			memset(newpwd1, '\0', sizeof(newpwd1));
			memset(newpwd2, '\0', sizeof(newpwd2));
			pwdtags[0].ti_Data = (LONG)"Enter your old password";
			rtGetStringA(oldpwd, muPASSWORDSIZE-1, "MultiUser Passwd Request",
							 NULL, pwdtags);
			pwdtags[0].ti_Data = (LONG)"Enter your new password";
			rtGetStringA(newpwd1, muPASSWORDSIZE-1, "MultiUser Passwd Request",
							 NULL, pwdtags);
			pwdtags[0].ti_Data = (LONG)"Retype your new password";
			rtGetStringA(newpwd2, muPASSWORDSIZE-1, "MultiUser Passwd Request",
							 NULL, pwdtags);
		} else {
			myputs("\nOld password        : [8m", DOSBase);
			mygets(oldpwd, DOSBase);
			myputs("[28m\n\nNew password        : [8m", DOSBase);
			mygets(newpwd1, DOSBase);
			myputs("[28m\n\nRetype new password : [8m", DOSBase);
			mygets(newpwd2, DOSBase);
			myputs("[28m\n\n", DOSBase);
		};

		if (strcmp(newpwd1, newpwd2))
			if (argarray[0])
				rtEZRequestA("Error retyping new password", "OK", NULL, NULL, infotags);
			else
				myputs("Error retyping new password\n", DOSBase);
		else
			if (muPasswd(oldpwd, newpwd1)) {
				if (argarray[0])
					rtEZRequestA("Password successfully changed", "OK", NULL, NULL, infotags);
				else
					myputs("Password successfully changed\n", DOSBase);
				rc = RETURN_OK;
			} else
				if (argarray[0])
					rtEZRequestA("Changing password failed", "OK", NULL, NULL, infotags);
				else
					myputs("Changing password failed\n", DOSBase);
	}
	FreeArgs(args);

Exit:
	CloseLibrary((struct Library *)ReqToolsBase);
	CloseLibrary((struct Library *)muBase);
	CloseLibrary((struct Library *)DOSBase);

	return(rc);
}	


static void __regargs myputs(char *str, struct DosLibrary *DOSBase)
{
	Write(Output(), str, strlen(str));
}


static void __regargs mygets(char *str, struct DosLibrary *DOSBase)
{
	LONG len = 0;
	char buf;
	BOOL done = FALSE;
	BPTR in, out;

	in = Input();
	out = Output();
	SetMode(in, 1);
	do {
		Read(in, &buf, 1);
		switch(buf) {
			case	'\b':
				if (len) {
					FPutC(out, '\b');
					Flush(out);
					len--;
				}
				break;
	
			case	'\n':
			case	'\r':
				done = TRUE;
				break;
	
			default:
				if ((len < muPASSWORDSIZE-1) && ((buf & 0x7f) > 31)
					 && (buf != 127)) {
					FPutC(out, ' ');
					str[len++] = buf;
				} else
					FPutC(out, 7);
				Flush(out);
				break;
		}
	} while (!done);
	str[len] = 0;
	SetMode(in, 0);
	FPutC(out, '\r');
	Flush(out);
}
