/************************************************************
* MultiUser - MultiUser Task/File Support System				*
* ---------------------------------------------------------	*
* Login																		*
* ---------------------------------------------------------	*
*  Copyright 1993 by Geert Uytterhoeven							*
* All Rights Reserved.													*
************************************************************/


#include <exec/types.h>
#include <dos/dos.h>
#include <proto/exec.h>
#include <proto/dos.h>
#include <utility/tagitem.h>
#include <libraries/multiuser.h>
#include <proto/multiuser.h>

#include "Login_rev.h"


char __VersTag__[] = VERSTAG;


int __saveds Start(char *arg)
{
	struct ExecBase *SysBase;
	struct DosLibrary *DOSBase;
	struct muBase *muBase = NULL;
	struct RDArgs *args;
	LONG argarray[] = {
		NULL, NULL, NULL, NULL, NULL
	};
	struct TagItem tags[5];
	struct Task *task = NULL;
	int rc = RETURN_ERROR;

	SysBase = *(struct ExecBase **)4;

	if ((!(DOSBase = (struct DosLibrary *)OpenLibrary("dos.library", 37))) ||
		 (!(muBase = (struct muBase *)OpenLibrary("multiuser.library", 39)))) {
		rc = RETURN_FAIL;
		goto Exit;
	}

	args = ReadArgs("GUI/S,TASK/K,OWN/S,GLOBAL/S,PROCESS/K/N", argarray, NULL);
	if (!args)
		PrintFault(IoErr(), NULL);
	else if (argarray[1] && argarray[4])
		PutStr("You can't specify both TASK and PROCESS\n");
	else if (argarray[1] && !(task = FindTask((char *)argarray[1])))
		VPrintf("Couldn't find task '%s'\n", (ULONG *)&argarray[1]);
	else if (argarray[4] &&
				!(task = (struct Task *)FindCliProc((ULONG)*(ULONG *)argarray[4])))
		VPrintf("Couldn't find process %ld\n", (ULONG *)argarray[4]);
	else {
		tags[0].ti_Tag = muT_Graphical;
		tags[0].ti_Data = argarray[0];
		tags[1].ti_Tag = muT_Task;
		tags[1].ti_Data = (LONG)task;
		tags[2].ti_Tag = muT_Own;
		tags[2].ti_Data = argarray[2];
		tags[3].ti_Tag = muT_Global;
		tags[3].ti_Data = argarray[3];
		tags[4].ti_Tag = TAG_DONE;
		if (muLoginA(tags)) {
			PutStr("Login successful\n");
			rc = RETURN_OK;
		} else {
			PutStr("Login failed\n");
		}
	}
	FreeArgs(args);

Exit:
	CloseLibrary((struct Library *)muBase);
	CloseLibrary((struct Library *)DOSBase);

	return(rc);
}
