TITLE MEMXB
PAGE 55,132
;multiple routines
;xb$malloc
;xb$free
;xb$SetHandleCount
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1992 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      30-Sep-92                                              |
; function:      memory routines                                        |
;                standard memory allocation module using DOS allocation |
;                use MEMCXB.ASM for Borland C compilers                 |
;-----------------------------------------------------------------------|

                .MODEL LARGE,PASCAL

		.DATA
		
PUBLIC _maxPackRAM		;31-Aug-93 added 
PUBLIC _maxIndexToken
				
;The following max values are for compiler/run-time code that gets flakey
;on large allocations made using the patch module. See MEMCXB.ASM for more.
			
_maxPackRAM     dw 65504        ;max bytes PackRecords can allocate (8K-63K)
_maxIndexToken  dw 2            ;max bytes Reindex can allocate
                                ;where token 0=32K, 1=64K, and 2+=128K)
		
                .CODE
;-----------------------------------------------------------------------|
;     date:      31-May-92                                              |
; function:      allocate memory                                        |
;   caller:      FAR, ASSEMBLY                                          |
;    stack:      n/a                                                    |
;       in:      bx=paragraphs to allocate                              |
;      out:      NC=ax=segment of allocation                            |
;                CY=ax=8=not enough memory                              |
;                   ax=7=MCBs trashed                                   |
;     uses:      ax (return)                                            |
;    notes:      call with bx=FFFF and bx returns w/ largest block free |
;-----------------------------------------------------------------------|

xb$malloc       PROC

                mov ah,48h
                int 21h
                ret

xb$malloc       ENDP

;-----------------------------------------------------------------------|
;     date:      31-May-92                                              |
; function:      free allocated memory                                  |
;   caller:      FAR, ASSEMBLY                                          |
;    stack:      n/a                                                    |
;       in:      es=block to free                                       |
;      out:      NC=okay                                                |
;                CY=ax=9=invalid block                                  |
;                   ax=7=MCBs trashed                                   |
;     uses:      ax (return)                                            |
;-----------------------------------------------------------------------|

xb$free         PROC

                mov ah,49h
                int 21h
                ret

xb$free         ENDP

;-----------------------------------------------------------------------|
;     date:      31-May-92                                              |
; function:      set maximum handle count                               |
;   caller:      FAR, ASSEMBLY                                          |
;    stack:      n/a                                                    |
;       in:      bx=handle count                                        |
;      out:      NC=okay                                                |
;                CY=ax=error number                                     |
;     uses:      ax (return)                                            |
;-----------------------------------------------------------------------|

xb$SetHandleCount PROC

                mov ah,67h
                int 21h
                ret

xb$SetHandleCount ENDP

                END
