#include <stdio.h>
#include <stdlib.h>
#include "colors.h"
#include "!bestlib.h"

   /*** NOTE  the names and structure of the routines used in these examples
              have changed in The Best Library 2.00; the updated examples will
              be released soon                                            ***/

#define ERR01 0
#define MSG01 1
#define MSG02 2
#define MSG03 3
#define MSG04 4
#define MSG05 5
#define MSG06 6
#define MSG07 7
#define MSG08 8
#define MSG09 9
#define MSG0A 10
#define MSG0B 11
#define MSG0C 12
#define LOC1 7
#define LOC2 11
#define LOC3 5
#define LOC4 0
#define LOC5 24
#define QUE01 13
#define QUE02 14
#define QUE03 15
#define TXT01 16

void floodtext(void);
void showtext(void);

filldata  fidata = { GREEN, BLACK, 0, 0, 0, 80, 25, 32, 0, "" };
printdata prdata = { -1, -1, -1, 0, 0, "" };
mousedata msdata;
asciiscan keyp;

char buffer[70];
char *text[] = {
   "!!! ERROR OCCURRED INITIALIZING THE MOUSE DRIVER !!!",        /* ERR01 */
   "Demonstration of Microsoft compatible mouse routines",        /* MSG01 */
   "Authored independently by George Vanous",                     /* MSG02 */
   "left button is not pressed",                                  /* MSG03 */
   "left button is pressed    ",                                  /* MSG04 */
   "left button was pressed at",                                  /* MSG05 */
   "left button was released at",                                 /* MSG06 */
   "right button is not pressed",                                 /* MSG07 */
   "right button is pressed    ",                                 /* MSG08 */
   "right button was pressed at",                                 /* MSG09 */
   "right button was released at",                                /* MSG0A */
   " cursor is located at",                                       /* MSG0B */
   "press any key to terminate",                                  /* MSG0C */
   "Do you wish to continue regardless?",                         /* QUE01 */
   "Which ASCII character to use as cursor? [219]",               /* QUE02 */
   "What color? [7]",                                             /* QUE03 */
   "ASCII table",                                                 /* TXT01 */
};

void main(void)
{
   int chart, color, oldmode, z;

   if (!initms()) {                    /* if the mouse could not be found   */
      cursorwhere(&prdata.x);          /* stores the position of the cursor */
      prdata.string2print = text[ERR01];
      print();                         /* print the error message           */
      prdata.string2print = text[QUE01];
      prdata.y++;
      print();                         /* print the question                */
      if (upcase(getchre()) != 'Y')    /* if the user response was not Yes  */
         exit(1);                      /* exit to DOS with errorlevel 1     */
   }
   oldmode = readvideomode();          /* save the current video mode       */
   if (oldmode == 3 || oldmode == 7 || oldmode == 21) {
      textmem(3);   /* if old mode was a text mode, store text video memory */
      cursor(3, 1);                    /* hide and store cursor position    */
   }
   textm(1);                          /* change to 80x25x16 color text mode */
   clear(LIGHTGRAY, BLACK);            /* clear the screen and set colors   */

   prdata.x = 5, prdata.y = 11;        /* set the next print position       */
   prdata.string2print = text[QUE02];
   print();                            /* print the question                */
   z = readnumber(255, 1, prdata.x + stringlen(prdata.string2print)+1,
                  prdata.y, &chart);   /* get the user's input              */
   if (z == FALSE) chart = 219;        /* if <ENTER> or <ESC>, use default  */
   prdata.y += 2;                      /* set the next print position       */
   prdata.string2print = text[QUE03];
   print();                            /* print the question                */
   z = readnumber(15, 0, prdata.x + stringlen(prdata.string2print)+1,
                  prdata.y, &color);   /* get the user's input              */
   if (z == FALSE) color = 7;          /* if <ENTER> or <ESC>, use default  */

   clear(LIGHTGRAY, BLACK);            /* clear the screen and set colors   */
   showtext();                         /* print up the screen               */
   prdata.y = LOC1;                    /* define the y-coordinate to print  */
   prdata.command = -1;                /* specify no modifications          */
   prdata.string2print = text[MSG03];
   print();                            /* print left mouse button status    */
   prdata.y = LOC2;                    /* define the y-coordinate to print  */
   prdata.string2print = text[MSG07];
   print();                            /* print right mouse button status   */
   shapems(chart, color, -1);          /* change the mouse cursor and color */
   showms();                           /* display the mouse cursor          */
   stopw(0, 15);                       /* start stopwatch 0                 */

   while (!keyhit()) {
      floodtext();                     /* fill the entire screen            */
      statms();                        /* read the mouse status             */
      if (msdata.pos[0] != msdata.npos[0]) {
         msdata.pos[0] = msdata.npos[0];
         msdata.update += 1;           /* if the mouse x-position changed.. */
      }
      if (msdata.pos[1] != msdata.npos[1]) {
         msdata.pos[1] = msdata.npos[1];
         msdata.update += 2;           /* if the mouse y-position changed.. */
      }
      if (msdata.buts[0] != msdata.nbuts[0]) {
         msdata.buts[0] = ~msdata.buts[0];
         msdata.update += 4;    /* if the left mouse button state changed.. */
      }
      if (msdata.buts[1] != msdata.nbuts[1]) {
         msdata.buts[1] = ~msdata.buts[1];
         msdata.update += 8;   /* if the right mouse button state changed.. */
      }
      if (msdata.update) {             /* if mouse registered activity..    */
         msdata.update = 0;            /* reset the mouse activity flag     */
         prdata.fgcolor = YELLOW;      /* set the foreground text color     */
         prdata.command = 0;           /* specify text to be centered       */
         prdata.x = 0, prdata.y = LOC3;     /* define the location to print */
         sprintf((prdata.string2print = buffer), "%s %d, %d  ",
                                   text[MSG0B], msdata.pos[0], msdata.pos[1]);
         hidems();                    /* hide mouse cursor, updating screen */
         print();                      /* print cursor location             */
         prdata.command = -1;          /* specify no modifications          */
         prdata.y = LOC1;              /* define y-coordinate of next print */
         if (!msdata.buts[0]) {        /* if left button is not pressed..   */
            prdata.string2print = text[MSG03];
            print();                   /* print left button is not pressed  */
            sprintf((prdata.string2print = buffer), "%s %d, %d  ",
                               text[MSG06], msdata.butlr[0], msdata.butlr[1]);
            prdata.y++;                /* increment y-coordinate of print   */
         }
         else {                        /* else left button is pressed..     */
            prdata.string2print = text[MSG04];
            print();                   /* print left button is pressed      */
            sprintf((prdata.string2print = buffer), "%s %d, %d  ",
                               text[MSG05], msdata.butlp[0], msdata.butlp[1]);
            prdata.y += 2;             /* add to y-coordinate of print      */
         }
         print();                      /* print left button coordinates     */
         prdata.y = LOC2;              /* define new y-coordinate for print */
         if (!msdata.buts[1]) {        /* if right button is not pressed..  */
            prdata.string2print = text[MSG07];
            print();                   /* print right button is not pressed */
            sprintf((prdata.string2print = buffer), "%s %d, %d  ",
                               text[MSG0A], msdata.butrr[0], msdata.butrr[1]);
            prdata.y++;                /* increment y-coordinate of print   */
         }
         else {                        /* else right button is pressed..    */
            prdata.string2print = text[MSG08];
            print();                   /* print right button is pressed     */
            sprintf((prdata.string2print = buffer), "%s %d, %d  ",
                               text[MSG09], msdata.butrp[0], msdata.butrp[1]);
            prdata.y += 2;             /* add to y-coordinate of print      */
         }
         print();                      /* print right button coordinates    */
         showms();                     /* show mouse cursor, done updating  */
      }
   }
   changevideomode(oldmode);           /* restore the original video mode   */
   if (oldmode == 3 || oldmode == 7 || oldmode == 21) {
                                       /* if the old mode was a text mode.. */
      textmem(1);                      /* restore text video memory         */
      cursor(1, 1);                    /* show and restore cursor position  */
   }
}

/*
 *  32 250 249 46 7 176 177 178 219
 *            .             
 */
void floodtext(void)
#define FLOODCHARNO 8
{
   static int cycle = 1, dir = 1,
              data[] = { 32, 250, 249, 46, 7, 176, 177, 178, 219 };

   if (stopw(0, 0) == TRUE) {
      fidata.fillchar = data[cycle];   /* set the character to fill with    */
      fidata.char2overwrite = data[cycle - dir];   /* set char to overwrite */
      if (cycle == FLOODCHARNO || (cycle == 1 && dir < 0))
         dir = -dir;        /* start cycling the fill characters in reverse */
      cycle += dir;                    /* get the next fill character       */
      hidems(); fillarea(); showms();  /* fill screen with the character    */
      msdata.update++;                 /* reprint the mouse status onscreen */
      showtext();                      /* reprint the standard text         */
      stopw(0, 15);                    /* reset stopwatch 0                 */
   }
}

/*
 * PRINTS INITIAL TEXT
 */
void showtext(void)
{
   prdata.fgcolor = WHITE, prdata.bgcolor = BLUE;    /* set printing colors */
   prdata.command = 0;                 /* center the text to print          */
   prdata.x = 0, prdata.y = LOC4;      /* define the coordinates to print   */
   prdata.string2print = text[MSG01];
   print();                            /* print first line of title         */
   prdata.y++;                         /* increment the y-coordinate        */
   prdata.string2print = text[MSG02];
   print();                            /* print second line of title        */
   prdata.y = LOC5;                    /* define the y-coordinate to print  */
   prdata.string2print = text[MSG0C];
   print();                            /* print the "any key exits" message */
}
