#ifndef WTimeIncluded
#define WTimeIncluded

// copyright (c) 1992, 1993 by Paul Wheaton
// 1916 Brooks #205, Missoula, MT  59801
//
// voice phone:  (406)543-7543
// modem phone:  (406)543-1144 (2400N81)
//  CompuServe:  72707,207
//    Internet:  72707.207@CompuServe.com

#include <WStr.h>

extern const char* MonthName[13]; // 0 is nothing, 1 is January
extern const char* WeekdayName[7];  // 0 is Monday

class JulianDate;

class Date
  {
      int Y,M,D;  // Year, Month, Day
      friend JulianDate;
    public:
      Date(int Year, int Month, int Day){Y=Year;M=Month;D=Day;}
        //  Some of you programming greenhorns may be offended at the order
        //  of these parameters - more than once it paid off for me to order
        //  my stuff this way - most significant value first.
      Date(){Y=0;M=0;D=0;}
      Date(const JulianDate&);
      Date(const Date& X){Y=X.Y; M=X.M; D=X.D;}
      Date(const char* Text);
      int Year() const {return Y;}
      int Month() const {return M;}
      String40 MonthStr() const;  // e.g. "January"
      String40 MonthStr2() const; // e.g. "01" "02" ... "12"
      String40 DayStr() const;    // e.g. "01" "02" ... "31"
      String40 FullDesc() const;  // e.g. "Wednesday, September 24, 1965"
      String40 ShortDesc() const; // e.g. "09-24-1965"
      int Day() const {return D;}
      int DOW() const;
      String40 DayName() const;   // e.g. "Monday"
      String40 RelativePastStr() const;
      void SetYear(int Year){Y=Year;}
      void SetMonth(int Month){M=Month;}
      void SetDay(int Day){D=Day;}
      Bool Valid() const; //  test to see if the date is a valid Gregorian day

      void operator=(const JulianDate&);
      void operator=(const Date& X){Y=X.Y; M=X.M; D=X.D;}

      Bool operator==(const JulianDate&) const;
      Bool operator<=(const JulianDate&) const;
      Bool operator>=(const JulianDate&) const;
      Bool operator!=(const JulianDate&) const;
      Bool operator<(const JulianDate&) const;
      Bool operator>(const JulianDate&) const;

      JulianDate operator+(long Days) const;
      JulianDate operator-(long Days) const;
      long operator-(const JulianDate&) const;
      JulianDate operator++(); // prefix operators
      JulianDate operator--();
      JulianDate operator++(int);  // postfix operators
      JulianDate operator--(int);
      void operator+=(long Days);
      void operator-=(long Days);
      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

class Moment;

const long MinutesInADay=1440;

class JulianDate
  {
      long J;  //  number of days since Jan 1, 0000
      friend Date;
      friend class Moment;
      JulianDate(long JJ){J=JJ;}
    public:
      JulianDate(int Year, int Month, int Day);
      JulianDate(){J=0;}
      JulianDate(const JulianDate& JJ){J=JJ.J;}
      JulianDate(const Date&);
      JulianDate(const Moment& M);// {J=long(M)/MinutesInADay;}
      long Val(){return J;}
      int Year() const;
      int Month() const;
      int Day() const;
      int DOW() const {return int((J-2)%7);}
      String40 DayName() const;
      String40 FullDesc();
      String40 ShortDesc(){return Date(*this).ShortDesc();}
      String40 RelativePastStr(Bool AlphaDate=True) const;
      void SetYear(int Year);
      void SetMonth(int Month);
      void SetDay(int Day);

      void operator=(const JulianDate& JJ){J=JJ.J;}
      void operator=(const Date&);

      Bool operator==(const JulianDate& JJ) const {return Bool(J==JJ.J);}
      Bool operator<=(const JulianDate& JJ) const {return Bool(J<=JJ.J);}
      Bool operator>=(const JulianDate& JJ) const {return Bool(J>=JJ.J);}
      Bool operator!=(const JulianDate& JJ) const {return Bool(J!=JJ.J);}
      Bool operator<(const JulianDate& JJ) const {return Bool(J<JJ.J);}
      Bool operator>(const JulianDate& JJ) const {return Bool(J>JJ.J);}
      Bool operator==(long JJ) const {return Bool(J==JJ);}
      Bool operator<=(long JJ) const {return Bool(J<=JJ);}
      Bool operator>=(long JJ) const {return Bool(J>=JJ);}
      Bool operator!=(long JJ) const {return Bool(J!=JJ);}
      Bool operator<(long JJ) const {return Bool(J<JJ);}
      Bool operator>(long JJ) const {return Bool(J>JJ);}
      friend Bool operator==(long J,const JulianDate& JJ) {return Bool(J==JJ.J);}
      friend Bool operator<=(long J,const JulianDate& JJ) {return Bool(J<=JJ.J);}
      friend Bool operator>=(long J,const JulianDate& JJ) {return Bool(J>=JJ.J);}
      friend Bool operator!=(long J,const JulianDate& JJ) {return Bool(J!=JJ.J);}
      friend Bool operator<(long J,const JulianDate& JJ) {return Bool(J<JJ.J);}
      friend Bool operator>(long J,const JulianDate& JJ) {return Bool(J>JJ.J);}

      JulianDate operator+(long Days) const;
      JulianDate operator-(long Days) const;
      long operator-(const JulianDate& JJ) const {return J-JJ.J;}
      JulianDate operator++(){J++; return *this;}
      JulianDate operator--(){J--; return *this;}
      JulianDate operator++(int);
      JulianDate operator--(int);
      void operator+=(long Days){J+=Days;}
      void operator-=(long Days){J-=Days;}
      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

Date Today();

class Moment;

class Time  // still working on this one
  {
      int H; // 0..23
      int M; // 0..59
      int S; // 0..59
    public:
      Time(int Hr=0, int Min=0, int Sec=0){H=Hr; M=Min; S=Sec;}
      Time(const Moment&);
      String40 Desc();
      String40 ShortDesc();
      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

Time CurTime();

class Moment
  {
      long M;
    public:
      Moment(long X=0){M=X;}
      Moment(Moment& MM){M=MM.M;}
      Moment(const JulianDate& J){M=J.J*MinutesInADay;}
      Moment(const JulianDate& J, const Time&);
      Moment(const JulianDate& J, int Hour, int Minute);
      operator long() const {return M;}
      //operator JulianDate();//{return JulianDate(M/MinutesInADay);}
      int MinCount(){return int(M%MinutesInADay);}
      void SetMinCount(int X){M=M-MinCount()+X;}
      void operator=(long X){M=X;}
      void operator=(Moment MM){M=MM.M;}
      // comparison operators
      Bool operator==(long X) const {return (M==X);}
      Bool operator!=(long X) const {return (M!=X);}
      Bool operator<=(long X) const {return (M<=X);}
      Bool operator>=(long X) const {return (M>=X);}
      Bool operator<(long X)  const {return (M<X);}
      Bool operator>(long X)  const {return (M>X);}
      Bool operator==(Moment X) const {return (M==X.M);}
      Bool operator!=(Moment X) const {return (M!=X.M);}
      Bool operator<=(Moment X) const {return (M<=X.M);}
      Bool operator>=(Moment X) const {return (M>=X.M);}
      Bool operator<(Moment X)  const {return (M<X.M);}
      Bool operator>(Moment X)  const {return (M>X.M);}
      friend Bool operator==(long X, Moment M) {return (X==M.M);}
      friend Bool operator!=(long X, Moment M) {return (X!=M.M);}
      friend Bool operator<=(long X, Moment M) {return (X<=M.M);}
      friend Bool operator>=(long X, Moment M) {return (X>=M.M);}
      friend Bool operator<(long X, Moment M)  {return (X<M.M);}
      friend Bool operator>(long X, Moment M)  {return (X>M.M);}
      // modifiers
      void operator+=(long X){M+=X;}
      void operator+=(Moment MM)
          {FatalError("increment a moment by a moment");} // not allowed
      void operator-=(long X){M-=X;}
      void operator-=(Moment MM)
          {FatalError("increment a moment by a moment");} // not allowed
      Moment operator-(long X);
      long operator-(Moment MM){return (M-MM.M);}
      Moment operator+(long X);
      void operator+(Moment);  // not allowed
      friend Moment operator+(long X, Moment M);
      String40 RelativeDesc();
      String40 FullDesc();
      String40 ShortDesc();
      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

inline JulianDate::JulianDate(const Moment& M)
  {J=long(M)/MinutesInADay;}

Bool LeapYear(int Year);

Moment CurMoment();  // number of minutes passed since 1-1-0000
int CurMinCount();  // number of minutes passed since midnight


#endif
