#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <WStr.h>
#pragma hdrstop

// copyright (c) 1992, 1993 by Paul Wheaton

//.parse

/////////  BaseString class

static char GarbageChar;

char& BaseString::operator[](int Index)
  {
    if (Index >= Len)
      {
        GarbageChar=0;
        return GarbageChar;
      }
    return P[Index];
  }

  /*

  The idea here is that if a programmer were to give an index out of range
  then they won't be messing up something.  If they wrote "S[5]='X'" and S
  was a string of length 2, then GarbageChar would be set to 'X' and S would
  be unaffected.  "MyChar=S[5]" would result in MyChar being assigned 0.

  */

//.parse

Bool BaseString::operator==(const BaseString& S) const
  {
    if (Len != S.Len) return No;
    int I = Len/(sizeof(int));
    const int* P1 = (const int*)P;
    const int* P2 = (const int*)S.P;
    while (I!=0)
      {
        if (*P1 != *P2) return No;
        P1++;
        P2++;
        I--;
      }
    I= Len%(sizeof(int));
    if (I!=0)
      {
        const char* PP1=(const char*)P1;
        const char* PP2=(const char*)P2;
        while (I!=0)
          {
            if (*PP1 != *PP2) return No;
            PP1++;
            PP2++;
            I--;
          }
      }
    return Yes;
  }

//.parse

void BaseString::ToLower()
  {
    int I = Len;
    char* Q = P;
    while (I--) { *Q = tolower(*Q); Q++; }
  }

//.parse

void BaseString::ToUpper()
  {
    register int I = Len;
    register char* Q = P;
    while (I--) { *Q = toupper(*Q); Q++; }
  }

//.parse

int BaseString::Index(char SearchChar, int StartIndex) const
  {
    if (StartIndex>=Len) return(NotFound);
    int I=StartIndex;
    while ((I<Len) && (P[I]!=SearchChar)) I++;
    if (I==Len) return(NotFound);
    else return(I);
  }

//.parse

int BaseString::Index(const char* SearchStr, int StartIndex) const
  {
    if (StartIndex>=Len) return(NotFound);
    char* Pos=strstr(P+StartIndex,SearchStr);
    if (Pos==NULL) return NotFound;
    else return int(Pos-P);
  }

//.parse

int BaseString::Count(char C) const
  {
    int Num=0;
    int I;
    For(I,Len) if(P[I]==C) Num++;
    return Num;
  }

//.parse

void BaseString::Delete(int Index,int Length)
  {
    // *this=BeforeSub(Index)+FromSub(Index+Length);
    int S=Index+Length;
    while (S<Len)
      {
        P[Index]=P[S];
        Index++;
        S++;
      }
    P[Index]='\0';
    Len=Index;
  }

//.parse

void BaseString::DeleteLast()
  {
    if (Len>0)
      {
        Len--;
        P[Len]='\0';
      }
  }

//.parse

void BaseString::Trim()
  {
    if (Len==0) return;
    int I=0;
    while ((P[I]==' ')&&(I<Len)) I++;
    if (I>0) Delete(0,I);
    if (Len==0) return;
    TrimTrail();
  }

//.parse

void BaseString::TrimTrailTo(char C)
  {
    if (Len>0)
      {
        Len--;
        while ((P[Len]!=C)&&(Len>0)) Len--;
        P[Len]='\0';
      }
  }

//.parse

void BaseString::TrimTrail()
  {
    if (Len>0)
      {
        Len--;
        while ((P[Len]==' ')&&(Len>0)) Len--;
        Len++;
        P[Len]='\0';
      }
  }

//.parse

char BaseString::At(int Index) const
  {
    if (Index>=Len) return '\0';
    return (P[Index]);
  }

//.parse

char BaseString::Last() const
  {
    if (Len==0) return '\0';
    else return P[Len-1];
  }

//.parse

void BaseString::Clip(int NewLen)
  {
    if ((NewLen<Len)&&(NewLen>=0))
      {
        Len=NewLen;
        P[Len]='\0';
      }
  }

//.parse

String40 BaseString::Word(int Num)
  {
    String40 S;
    if (Len>0)
      {
        int LastPos=0;
        int Pos=0;
        int I=0;
        Bool Done=False;
        while (!Done)
          {
            Pos=Index(' ',LastPos);
            if (Pos==NotFound)
              {
                if (I==Num)
                  {
                    // functions such as "From" and "At" are not available here
                    S.Len=Len-LastPos;
                    if (S.Len>40) S.Len=40;
                    memcpy(S.P,P+LastPos,S.Len);
                    S.P[S.Len]='\0';
                  }
                Done=True;
              }
            else
              {
                if (I==Num)
                  {
                    S.Len=Pos-LastPos;
                    if (S.Len>40) S.Len=40;
                    memcpy(S.P,P+LastPos,S.Len);
                    S.P[S.Len]='\0';
                    Done=True;
                  }
                else
                  {
                    I++;
                    LastPos=Pos+1;
                  }
              }
          }
      }
    return S;
  }

//.parse

String40 BaseString::XWord(int Num)
  {
    String40 S;
    if (Len>0)
      {
        int LastPos=0;
        int Pos=0;
        int I=0;
        Bool Done=False;
        while (!Done)
          {
            Pos=Index(' ',LastPos);
            if (Pos==NotFound)
              {
                if (I==Num)
                  {
                    S.Len=Len-LastPos;
                    if (S.Len>40) S.Len=40;
                    memcpy(S.P,P+LastPos,S.Len);
                    S.P[S.Len]='\0';
                    Delete(LastPos,S.Length());
                    TrimTrail();
                  }
                Done=True;
              }
            else
              {
                if (I==Num)
                  {
                    int L=Pos-LastPos;
                    S.Len=Pos-LastPos;
                    if (S.Len>40) S.Len=40;
                    memcpy(S.P,P+LastPos,S.Len);
                    S.P[S.Len]='\0';
                    Delete(LastPos,L+1);
                    Done=True;
                  }
                else
                  {
                    I++;
                    LastPos=Pos+1;
                  }
              }
          }
      }
    return S;
  }

///////////  String class

//.parse

void String::ReNew(int NewCapacity)  // replaces ANSI-C realloc
  {
    #ifdef MAJORBBS
      char* P2=(char*)malloc(NewCapacity);
    #else
      char* P2=new char[NewCapacity];
    #endif
    if (P2==NULL)
      {
        char* E="00000 out of string mem rn";
        E[4]=NewCapacity%10+'0';
        NewCapacity/=10;
        E[3]=NewCapacity%10+'0';
        NewCapacity/=10;
        E[2]=NewCapacity%10+'0';
        NewCapacity/=10;
        E[1]=NewCapacity%10+'0';
        NewCapacity/=10;
        E[0]=NewCapacity%10+'0';
        NewCapacity/=10;
        FatalError(E);
      }
    strncpy(P2,P,NewCapacity-1);
    #ifdef MAJORBBS
      free(P);
    #else
      delete(P);
    #endif
    P=P2;
    P[NewCapacity-1]=0;
  }

void String::New()
  {
    if (Alloc<16) Alloc=16;
    #ifdef MAJORBBS
      P = (char*)malloc(Alloc);
    #else
      P = new char[Alloc];
    #endif
    if (P==NULL)
      {
        char* E="00000 out of string mem";
        E[4]=Alloc%10+'0';
        Alloc/=10;
        E[3]=Alloc%10+'0';
        Alloc/=10;
        E[2]=Alloc%10+'0';
        Alloc/=10;
        E[1]=Alloc%10+'0';
        Alloc/=10;
        E[0]=Alloc%10+'0';
        FatalError(E);
      }
  }

//.parse

String::String(const char& C, int L, int Extra)
  {
    Len = L;
    Alloc = Len + Extra + 1;
    New();
    register int I=Len;
    P[I] = 0;
    while (I) P[--I] = C;
  }

//.parse

String::String(int Extra)
  {
    Len = 0;
    Alloc = Extra + 1;
    New();
    *P='\0';
  }

//.parse

String::String(const char* CS, int Extra)
  {
    Len = strlen(CS);
    Alloc = Len + Extra + 1;
    New();
    strcpy(P,CS);
  }

//.parse

String::String(const BaseString& S, int Extra)
  {
    Len = S.Len;
    Alloc = Len + Extra + 1;
    New();
    strcpy(P,S.P);
  }

//.parse

String::String(const String& S)
  {
    Len=S.Len;
    Alloc=Len+1;
    New();
    strcpy(P,S.P);
  }

//.parse

void String::operator=(const BaseString& S)
  {
    if (P == S.P) return;
    Len = S.Len;
    if (Len >= Alloc)
      {
        #ifdef MAJORBBS
          free(P);
        #else
          delete(P);
        #endif
        Alloc = S.Alloc;
        New();
      }
    strcpy(P,S.P);
  }

//.parse

void String::operator=(const char* CS)
  {
    Len = strlen(CS);
    if (Len >= Alloc)
      {
        Alloc = Len + DefaultStringExtra + 1;
        #ifdef MAJORBBS
          free(P);
        #else
          delete(P);
        #endif
        New();
      }
    strcpy(P,CS);
  }

//.parse

void String::operator=(const char C)
  {
    Len=1;
    P[0]=C;
    P[1]='\0';
  }

//.parse

String String::operator+(const String40& S) const
  {
    String T(Len+S.Len+1);
    strcpy(T.P,P);
    strcpy(&(T.P[Len]), S.P);
    T.Len = Len+S.Len;
    return(T);
  }

//.parse

String String::operator+(const String120& S) const
  {
    String T(Len+S.Len+1);
    strcpy(T.P,P);
    strcpy(&(T.P[Len]), S.P);
    T.Len = Len+S.Len;
    return(T);
  }

//.parse

String String::operator+(const String& S) const
  {
    String T(Len+S.Len+1);
    strcpy(T.P,P);
    strcpy(&(T.P[Len]), S.P);
    T.Len = Len+S.Len;
    return(T);
  }

//.parse

String String::operator+(const char* CS) const
  {
    int CSLen = strlen(CS);
    String T(Len+CSLen+1);
    strcpy (T.P,P);
    strcpy (&(T.P[Len]), CS);
    T.Len = Len+CSLen;
    return T;
  }

//.parse

String String::operator+(char C) const
  {
    String S(*this,1);
    S.P[Len]=C;
    S.Len++;
    S.P[S.Len]='\0';
    return S;
  }

//.parse

String operator+(const String40& SS, const String& S)
  {
    String T(SS.Length()+S.Len+1);
    strcpy(T.P,(const char*)SS);
    strcpy(&(T.P[SS.Length()]), S.P);
    T.Len = SS.Length()+S.Len;
    return(T);
  }

//.parse

String operator+(const String120& SS, const String& S)
  {
    String T(SS.Length()+S.Len+1);
    strcpy(T.P,(const char*)SS);
    strcpy(&(T.P[SS.Length()]), S.P);
    T.Len = SS.Length()+S.Len;
    return(T);
  }

//.parse

String operator+(const char* CS, const String& S)
  {
    int CSLen=strlen(CS);
    String T(int(CSLen+S.Len+1));
    strcpy(T.P,CS);
    strcpy(&(T.P[CSLen]),S.P);
    T.Len = CSLen + S.Len;
    return T;
  }

//.parse

String operator+(char C, const String& S)
  {
    int NewLen=S.Len+1;
    String T(NewLen);
    T.P[0]=C;
    strcpy(&(T.P[1]),S.P);
    T.Len = NewLen;
    return T;
  }

//.parse

void String::operator+=(const BaseString& S)
  {
    if (S.Len==0) return;
    int NewLen=Len+S.Len;
    if (Alloc <= NewLen)
      {
        Alloc = NewLen+1;
        ReNew(Alloc);
      }
    strcpy(&P[Len],S.P);
    Len += S.Len;
  }

//.parse

void String::operator+=(const char* CS)
  {
    int CSLen = strlen(CS);
    if (CSLen==0) return;
    int NewLen=Len+CSLen;
    if (Alloc <= NewLen)
      {
        Alloc = NewLen+1;
        ReNew(Alloc);
      }
    strcpy(&(P[Len]),CS);
    Len += CSLen;
  }

//.parse

void String::operator+=(char C)
  {
    *this=*this+C;
    /*
    if (Alloc < Len+2)
      {
        Alloc += (DefaultStringExtra+1);
        ReNew(Alloc);
      }
    P[Len]=C;
    Len++;
    P[Len]=0;
    */
  }

//.parse

void String::Left(int NewSize)
  {
    if (Len>NewSize)
      {
        Len=NewSize;
        P[Len]=0;
      }
    else *this+=Spaces(NewSize-Len);
  }

//.parse

void String::Right(int NewSize)
  {
    if (Len>NewSize)
      {
        Len=NewSize;
        P[Len]=0;
      }
    else
      {
        String T=Spaces(NewSize-Len)+(*this);
        *this=T;
      }
  }

//.parse

void String::Center(int NewSize)
  {
    if (Len>NewSize)
      {
        Len=NewSize;
        P[Len]=0;
      }
    else
      {
        int TotSpaces=NewSize-Len;
        int LeftSpaces=TotSpaces/2;
        *this=Spaces(LeftSpaces)+(*this)+Spaces(TotSpaces-LeftSpaces);
      }
  }

//.parse

void String::Tail(int NewSize)
  {
    if (Len>NewSize) *this=From(Len-NewSize);
    else *this=Spaces(NewSize-Len)+*this;
  }

//.parse

int String::ReAlloc(int NewCapacity)
  {
    if (NewCapacity < Len) NewCapacity = Len;
    if (Alloc != NewCapacity+1)
      {
        Alloc = NewCapacity+1;
        ReNew(Alloc);
      }
    return Alloc - 1;
  }

//.parse

String String::At(int Index, int Length) const
  {
    if (Index>=Len)
      {
        String S="";
        return S;
      }
    if (Index+Length>Len) Length=Len-Index;
    String S(int(Length+1));
    memcpy(S.P,&P[Index],Length);
    S.P[Length]='\0';
    S.Len=Length;
    return S;
  }

//.parse

void String::Insert(char C,int Index)
  {
    if (Index<0) Index=0;
    if ((Len+1)>=Alloc) ReNew(Alloc+DefaultStringExtra+1);
    if (Index>=Len)
      {
        P[Len]=C;
        P[Len+1]='\0';
      }
    else
      {
        memmove(P+Index+1,P+Index,Len-Index+1);
        P[Index]=C;
      }
    Len++;
  }

void String::Insert(const char* St,int Index)
  {
    if (Index<0) Index=0;
    int SLen=strlen(St);
    if (SLen>0)
      {
        if ((Len+SLen)>=Alloc) ReNew(Alloc+DefaultStringExtra+SLen);
        if (Index>=Len) strcpy(P+Len,St);
        else
          {
            memmove(P+Index+SLen,P+Index,Len-Index+1);
            memcpy(P+Index,St,SLen);
          }
        Len+=SLen;
      }
    //*this=Before(Index)+St+From(Index);
  }

////////  StackString class

//.parse

void StackString::operator=(const BaseString& S)
  {
    if (P == S.P) return;
    Len = Min(S.Len,Alloc-1);
    memcpy(P,S.P,Len);
    P[Len]='\0';
  }

//.parse

void StackString::operator=(const char* CS)
  {
    Len = Min(int(strlen(CS)),Alloc-1);
    memcpy(P,CS,Len);
    P[Len]='\0';
  }

void StackString::operator=(const char C)
  {
    Len=1;
    P[0]=C;
  }

//.parse

void StackString::operator+=(const BaseString& S)
  {
    if (S.Len==0) return;
    int MaxCopy=Alloc-Len-1;
    int CopyLen=Min(MaxCopy,S.Len);
    memcpy(&P[Len],S.P,CopyLen);
    Len+=CopyLen;
    P[Len]='\0';
  }

//.parse

void StackString::operator+=(const char* CS)
  {
    int CSLen = strlen(CS);
    if (CSLen==0) return;
    int MaxCopy=Alloc-Len-1;
    int CopyLen=Min(MaxCopy,CSLen);
    memcpy(&P[Len],CS,CopyLen);
    Len+=CopyLen;
    P[Len]='\0';
  }

//.parse

void StackString::operator+=(char C)
  {
    if (Len<(Alloc-1))
      {
        P[Len]=C;
        Len++;
        P[Len]='\0';
      }
  }

//.parse

void StackString::Left(int NewSize)
  {
    if (Len>NewSize)
      {
        Len=NewSize;
        P[Len]=0;
      }
    else if (NewSize>Len)
      {
        int End=Min(NewSize,Alloc-1);
        int Dif=End-Len;
        memset(P+Len,' ',Dif);
        Len+=Dif;
        P[Len]='\0';
      }
  }

//.parse

void StackString::Right(int NewSize)
  {
    if (Len>NewSize)
      {
        Len=NewSize;
        P[Len]=0;
      }
    else if (NewSize>Len)
      {
        int End=Min(NewSize,Alloc-1);
        int Dif=End-Len;
        memmove(P+Dif,P,Len);
        memset(P,' ',Dif);
        Len+=Dif;
        P[Len]='\0';
      }
  }

//.parse

void StackString::Center(int NewSize)
  {
    if (Len>NewSize)
      {
        Len=NewSize;
        P[Len]=0;
      }
    else
      {
        NewSize=Min(NewSize,Alloc-1);
        Right(((NewSize-Len)/2)+Len);
        Left(NewSize);
      }
  }

//.parse

void StackString::Tail(int NewSize)
  {
    if (Len>NewSize)
      {
        memmove(P,P+(Len-NewSize),NewSize);
        Len=NewSize;
        P[Len]='\0';
      }
    else Right(NewSize);
  }

//.parse

void StackString::Sub(StackString& D, int I, int L)
  {
    if ((I+L)>Len) L=Len-I;
    D.Len=L;
    memcpy(D.P,P+I,L);
    D.P[L]='\0';
  }

//.parse

void StackString::Insert(char C,int Index)
  {
    if ((Len==Alloc-1)&&(Index<Len)) Len--;
    if (Index>=Len)
      {
        P[Len]=C;
        Len++;
      }
    else
      {
        memmove(P+Index+1,P+Index,Len-Index+1);
        P[Index]=C;
        Len++;
      }
    P[Len]='\0';
  }

//.parse

void StackString::Insert(const char* St,int Index)
  {
    int StLen=strlen(St);
    if (Index>Len) Index=Len;
    int MoveNum=Len-Index;
    int TotLen=StLen+Len;
    int Excess=TotLen-(Alloc-1);
    if (Excess>0)
      {
        MoveNum-=Excess;
        if (MoveNum<0) StLen+=MoveNum;
      }
    if (MoveNum>0)
      {
        memmove(P+Index+StLen,P+Index,MoveNum);
        Len+=MoveNum;
      }
    if (StLen>0)
      {
        memcpy(P+Index,St,StLen);
        Len+=StLen;
      }
    P[Len]='\0';
  }

///////  String40 class

//.parse

String40::String40()
  {
    P=&Buf[0];
    Buf[0]='\0';
    Len=0;
    Alloc=41;
  }

//.parse

String40::String40(const char& C, int L)
  {
    P=&Buf[0];
    Alloc=41;
    Len=L;
    if (Len>40) Len=40;
    memset(P,C,Len);
    Buf[Len]='\0';
  }

//.parse

String40::String40(const char* CS)
  {
    P=&Buf[0];
    Alloc=41;
    Len=strlen(CS);
    if (Len>40) Len=40;
    memcpy(P,CS,Len);
    Buf[Len]='\0';
  }

//.parse

String40::String40(const BaseString& BS)
  {
    P=&Buf[0];
    Alloc=41;
    Len=BS.Len;
    if (Len>40) Len=40;
    memcpy(P,BS.P,Len);
    Buf[Len]='\0';
  }

//.parse

String40::String40(const String40& S)
  {
    P=&Buf[0];
    Alloc=41;
    Len=S.Len;
    strcpy(P,S.P);
  }

//.parse

String40 String40::operator+(const String40& S) const
  {
    String40 T(*this);
    T+=S;
    return T;
  }

//.parse

String40 String40::operator+(const char* S) const
  {
    String40 T(*this);
    T+=S;
    return T;
  }

//.parse

String40 String40::operator+(char C) const
  {
    String40 T(*this);
    T+=C;
    return T;
  }

//.parse

String40 operator+(const char* S1, const String40& S2)
  {
    String40 T(S1);
    T+=S2;
    return T;
  }

//.parse

String40 operator+(char C, const String40& S)
  {
    String40 T(C);
    T+=S;
    return T;
  }

//.parse

String40 String40::At(int Index, int Length) const
  {
    String40 T;
    StackString::Sub(T,Index,Length);
    return T;
  }

///////  String120 class

//.parse

String120::String120()
  {
    P=&Buf[0];
    Buf[0]='\0';
    Len=0;
    Alloc=121;
  }

//.parse

String120::String120(const char& C, int L)
  {
    P=&Buf[0];
    Alloc=121;
    Len=L;
    if (Len>120) Len=120;
    memset(P,C,Len);
    Buf[Len]='\0';
  }

//.parse

String120::String120(const char* CS)
  {
    P=&Buf[0];
    Alloc=121;
    Len=strlen(CS);
    if (Len>120) Len=120;
    memcpy(P,CS,Len);
    Buf[Len]='\0';
  }

//.parse

String120::String120(const BaseString& BS)
  {
    P=&Buf[0];
    Alloc=121;
    Len=BS.Len;
    if (Len>120) Len=120;
    memcpy(P,BS.P,Len);
    Buf[Len]='\0';
  }

//.parse

String120::String120(const String120& S)
  {
    P=&Buf[0];
    Alloc=121;
    Len=S.Len;
    strcpy(P,S.P);
  }

//.parse

String120 String120::operator+(const String40& S) const
  {
    String120 T(*this);
    T+=S;
    return T;
  }

//.parse

String120 String120::operator+(const String120& S) const
  {
    String120 T(*this);
    T+=S;
    return T;
  }

//.parse

String120 String120::operator+(const char* S) const
  {
    String120 T(*this);
    T+=S;
    return T;
  }

//.parse

String120 String120::operator+(char C) const
  {
    String120 T(*this);
    T+=C;
    return T;
  }

//.parse

String120 operator+(const String40& S1, const String120& S2)
  {
    String120 T(S1);
    T+=S2;
    return T;
  }

//.parse

String120 operator+(const char* S1, const String120& S2)
  {
    String120 T(S1);
    T+=S2;
    return T;
  }

//.parse

String120 operator+(char C, const String120& S)
  {
    String120 T(C);
    T+=S;
    return T;
  }

//.parse

String120 String120::At(int Index, int Length) const
  {
    String120 T;
    StackString::Sub(T,Index,Length);
    return T;
  }

//.parse

String CenterText(const char* CS, int NewSize)
  {
    String S=CS;
    S.Center(NewSize);
    return S;
  }

//.parse

String Form(int FLen,SLong Val)
  {
    String Mask=TailText("##,###,###,###",FLen);
      //  SLong has 10 significant digits + 1 sign digit
    if (Mask[0]==',') Mask[0]='#';
    String ReturnString=Form(Mask,double(Val));
    return ReturnString;
  }

//.parse

static Bool DigitToken(char C)
  {
    return ((C=='@') || (C=='#'));
  }

static void FindDigitToken(String &S, int &I)
  {
    while (!DigitToken(S[I])) I++;
  }

static void DoFillers(String &Mask, int Fillers)
  {
    int I=0;
    while (Fillers)
      {
        FindDigitToken(Mask,I);
        if (Mask[I]=='@') Mask[I]='0';
        else Mask[I]=' ';
        Fillers--;
      }
  }

static void DoSpaceFillers(String &Mask, int Fillers)
  {
    int I=0;
    FindDigitToken(Mask,I);
    while (Fillers)
      {
        if (Mask[I]=='#') Fillers--;
        Mask[I]=' ';
        I++;
      }
    if (Mask[I]==',') Mask[I]=' ';
  }

static void DoNeg(String &Mask)
  {
    int I=0;
    FindDigitToken(Mask,I);
    if (Mask[I+1]==',')
      {
        Mask[I]=' ';
        I++;
      }
    Mask[I]='-';
  }

String Form(const char* M,double Val)
  {
    String Mask=M;
    Bool Negative=(Val<0.0);
    Val=Abs(Val);
    int MaskDecPos=Mask.Index('.'); //  The position of the decimal in Mask
    int MI;  //  Mask Index:  the part of the mask currently being fooled with
    String DecStr="";
    if (MaskDecPos!=NotFound)
      {
        int Digits=0;
        for(MI=MaskDecPos+1;MI<Mask.Length();MI++)
          {
            if (Mask[MI]=='#') Mask[MI]='@';
            if (Mask[MI]=='@') Digits++;
          }
        MI=MaskDecPos+1;
        double D=(Val-floor(Val));
        Val-=D;
        double Mult=pow(10,Digits);
        D*=Mult;
        if (D+0.5>Mult)
          {
            D=0.0;
            Val+=1.0;
          }
        DecStr=Form(Mask.From(MI),D);
          //  recursive call!  This part will be skipped cuz there's no decimal in the mask
        Mask.Left(MI);  //  chop off decimal portion
      }
    int Digits=0;  // the number of digits there are available to fill
    For(MI,Mask.Length())
        if (DigitToken(Mask[MI])) Digits++;
    String IStr=DStr(Val+0.5);  //  convert the integral part to a string
    Bool NegBrackets=(Mask[0]=='<');
    Bool NegCharNeeded=((!NegBrackets)&&(Negative));
    if (NegCharNeeded) Digits--;
    if (IStr.Length()>Digits)  // then fill with *'s
      {
        For(MI,Mask.Length())
            if (DigitToken(Mask[MI])) Mask[MI]='*';
      }
    else
      {
        int Fillers=Digits-IStr.Length();
        MI=0;
        FindDigitToken(Mask,MI);
        if (Mask[MI]=='#')
          {
            DoSpaceFillers(Mask,Fillers);
            if (NegCharNeeded) DoNeg(Mask);
          }
        else
          {
            if (NegCharNeeded) DoNeg(Mask);
            DoFillers(Mask,Fillers);
          }
        int I;  //  IStr Index
        For(I,IStr.Length())
          {
            FindDigitToken(Mask,MI);
            Mask[MI]=IStr[I];
          }
      }
    Mask+=DecStr;
    if (NegBrackets && (!Negative))
      {
        Mask[0]=' ';
        Mask[Mask.Length()-1]=' ';
      }
    return (Mask);
  }

//.parse

String Form(int FLen,const double& Val)
  {
    String Mask=TailText("#,###,###,###",FLen);
      //  SLong has 10 significant digits
    if (Mask[0]==',') Mask[0]='#';
    String ReturnString=Form(Mask,Val);
    return ReturnString;
  }

//.parse

String Form(int FLen,const Long& Val)
  {return Form(FLen,float(Val));}

String Form(int FLen,const float& Val)
  {
    return Form(int(FLen),double(Val));
  }

#ifndef MAJORBBS
String HexStr(Long Num)
  {
    char TmpStr[35];
    ltoa(Num,TmpStr,16);
    String X=TmpStr;
    return(X);
  }
#endif

//.parse

String LeftText(const char* CS, int NewSize)
  {
    String S=CS;
    S.Left(NewSize);
    return(S);
  }

#ifndef MAJORBBS
String OctalStr(Long Num)
  {
    char TmpStr[35];
    ltoa(Num,TmpStr,8);
    String X=TmpStr;
    return(X);
  }
#endif

//.parse

String StringOf(int HowMany, char What)
 {
   String S(What,HowMany,0);
   return(S);
 }

//.parse

String Str(long Num)
  {
    const BuffyLen=13;
    char Buffy[BuffyLen]="           0";
    char* BuffyPos=&Buffy[BuffyLen-2];
    Bool Neg=False;
    if (Num<0)
      {
        Neg=True;
        Num=-Num;
      }
    if (Num>0)
      {
        while (Num>0)
          {
            *BuffyPos=char((Num%10)+48);
            Num/=10;
            BuffyPos--;
          }
        BuffyPos++;
        if (Neg)
          {
            BuffyPos--;
            *BuffyPos='-';
          }
      }
    return String(BuffyPos);
  }

//.parse

String40 CommaStr(long Num)
  {
    const BuffyLen=15;
    char Buffy[BuffyLen]=",,,,,,,,,,,,,0";
    int I=0;
    char* BuffyPos=&Buffy[BuffyLen-2];
    while (Num>0)
      {
        *BuffyPos=char((Num%10)+48);
        Num/=10;
        BuffyPos--;
        I++;
        if (I%3==0) BuffyPos--;
      }
    BuffyPos++;
    if (*BuffyPos==',') BuffyPos++;
    return String(BuffyPos);
  }

//.parse

String RightText(const char* CS, int NewSize)
  {
    String S=CS;
    S.Right(NewSize);
    return S;
  }

//.parse

String TailText(const char* CS, int NewSize)
  {
    String S=CS;
    S.Tail(NewSize);
    return S;
  }

//.parse

String Trim(const char* S)
  {
    String St=S;
    St.Trim();
    return St;
  }

//.parse

String TrimTrail(const char* S)
  {
    String St=S;
    St.TrimTrail();
    return St;
  }

//.parse

String DStr(double Num)
  {
    Bool Sign=(Num<(-0.0000000000001));
    if (Sign) Num=-Num;
    double N=floor(Num);
    String S;
    while (N>0.1)
      {
        N/=10.0;
        double D=(N-floor(N));
        S=char(Round(D*10.0)+48)+S;
        N-=D;
      }
    if (Sign) S='-'+S;
    if (S.Length()==0) S='0';
    return(S);
  }

//.parse

String Spaces(int HowMany)
 {
   String S(' ',HowMany,0);
   return(S);
 }

//.parse

void String::Replace(const char* SearchStr, const char* ReplaceStr)
  {
    int SLen=strlen(SearchStr);
    int RLen=strlen(ReplaceStr);
    Bool SameLen=(SLen==RLen);
    int Pos=0;
    while((Pos=Index(SearchStr,Pos))!=NotFound)
      {
        if (SameLen)
          {
            int I;
            For(I,SLen) P[Pos+I]=ReplaceStr[I];
          }
        else if (SLen>RLen)
          {
            Delete(Pos,SLen-RLen);
            int I;
            For(I,RLen) P[Pos+I]=ReplaceStr[I];
          }
        else
          {
            int I;
            For(I,SLen) P[Pos+I]=ReplaceStr[I];
            Insert(&ReplaceStr[SLen],Pos+SLen);
          }
      }
  }

//.parse

void String::Replace(const char SearchChar, const char* ReplaceStr)
  {
    int RLen=strlen(ReplaceStr);
    int Pos=0;
    while((Pos=Index(SearchChar,Pos))!=NotFound)
      {
        if (RLen>1)
          {
            P[Pos]=*ReplaceStr;
            Insert(&ReplaceStr[1],Pos+1);
          }
        if (RLen==1) P[Pos]=*ReplaceStr;
        else Delete(Pos);
      }
  }

//.parse

void String::Replace(const char* SearchStr, const char ReplaceChar)
  {
    int SLen=strlen(SearchStr);
    int Pos=0;
    while((Pos=Index(SearchStr,Pos))!=NotFound)
      {
        if (SLen>1)
          {
            Delete(Pos,SLen-1);
            P[Pos]=ReplaceChar;
          }
        else P[Pos]=ReplaceChar;
      }
  }

//.parse

void String::Replace(const char SearchChar, const char ReplaceChar)
  {
    int Pos=0;
    while((Pos=Index(SearchChar,Pos))!=NotFound) P[Pos]=ReplaceChar;
  }

//.parse

void String120::Replace(const char* SearchStr, const char* ReplaceStr)
  {
    int SLen=strlen(SearchStr);
    int RLen=strlen(ReplaceStr);
    Bool SameLen=(SLen==RLen);
    int Pos=0;
    while((Pos=Index(SearchStr,Pos))!=NotFound)
      {
        if (SameLen)
          {
            int I;
            For(I,SLen) P[Pos+I]=ReplaceStr[I];
          }
        else if (SLen>RLen)
          {
            Delete(Pos,SLen-RLen);
            int I;
            For(I,RLen) P[Pos+I]=ReplaceStr[I];
          }
        else
          {
            int I;
            For(I,SLen) P[Pos+I]=ReplaceStr[I];
            Insert(&ReplaceStr[SLen],Pos+SLen);
          }
      }
  }

//.parse

void String120::Replace(const char SearchChar, const char* ReplaceStr)
  {
    int RLen=strlen(ReplaceStr);
    int Pos=0;
    while((Pos=Index(SearchChar,Pos))!=NotFound)
      {
        if (RLen>1)
          {
            P[Pos]=*ReplaceStr;
            Insert(&ReplaceStr[1],Pos+1);
          }
        if (RLen==1) P[Pos]=*ReplaceStr;
        else Delete(Pos);
      }
  }

//.parse

void String120::Replace(const char* SearchStr, const char ReplaceChar)
  {
    int SLen=strlen(SearchStr);
    int Pos=0;
    while((Pos=Index(SearchStr,Pos))!=NotFound)
      {
        if (SLen>1)
          {
            Delete(Pos,SLen-1);
            P[Pos]=ReplaceChar;
          }
        else P[Pos]=ReplaceChar;
      }
  }

//.parse

void String120::Replace(const char SearchChar, const char ReplaceChar)
  {
    int Pos=0;
    while((Pos=Index(SearchChar,Pos))!=NotFound) P[Pos]=ReplaceChar;
  }

//.parse

void String40::Replace(const char* SearchStr, const char* ReplaceStr)
  {
    int SLen=strlen(SearchStr);
    int RLen=strlen(ReplaceStr);
    Bool SameLen=(SLen==RLen);
    int Pos=0;
    while((Pos=Index(SearchStr,Pos))!=NotFound)
      {
        if (SameLen)
          {
            int I;
            For(I,SLen) P[Pos+I]=ReplaceStr[I];
          }
        else if (SLen>RLen)
          {
            Delete(Pos,SLen-RLen);
            int I;
            For(I,RLen) P[Pos+I]=ReplaceStr[I];
          }
        else
          {
            int I;
            For(I,SLen) P[Pos+I]=ReplaceStr[I];
            Insert(&ReplaceStr[SLen],Pos+SLen);
          }
      }
  }

//.parse

void String40::Replace(const char SearchChar, const char* ReplaceStr)
  {
    int RLen=strlen(ReplaceStr);
    int Pos=0;
    while((Pos=Index(SearchChar,Pos))!=NotFound)
      {
        if (RLen>1)
          {
            P[Pos]=*ReplaceStr;
            Insert(&ReplaceStr[1],Pos+1);
          }
        if (RLen==1) P[Pos]=*ReplaceStr;
        else Delete(Pos);
      }
  }

//.parse

void String40::Replace(const char* SearchStr, const char ReplaceChar)
  {
    int SLen=strlen(SearchStr);
    int Pos=0;
    while((Pos=Index(SearchStr,Pos))!=NotFound)
      {
        if (SLen>1)
          {
            Delete(Pos,SLen-1);
            P[Pos]=ReplaceChar;
          }
        else P[Pos]=ReplaceChar;
      }
  }

//.parse

void String40::Replace(const char SearchChar, const char ReplaceChar)
  {
    int Pos=0;
    while((Pos=Index(SearchChar,Pos))!=NotFound) P[Pos]=ReplaceChar;
  }



