#include "VecLocal.h"
#pragma hdrstop

// copyright (c) 1992, 1993 by Paul Wheaton

//.parse

void ObjVec::ExtraAlloc(long Quan)
  {
    ByteVector::ExtraAlloc(Quan*BlockSize);
  }

//.parse

void ObjVec::CopyFrom(void* Source, long Quan)
  {
    ByteVector::CopyFrom(Source,Quan*ObjSize);
  }

//.parse

void ObjVec::AppendOneObj(void* X)
  {
    memcpy(Ref(Size()),X,ObjSize);
  }

//.parse

ObjVec ObjVec::PrependOneObj(void* X) const
  {
    ObjVec V(ObjSize,X);
    V+=*this;
    return V;
  }

//.parse

void ObjVec::operator+=(const ObjVec& V)
  {ByteVector::operator+=(*((ByteVector*)&V));}

//.parse

void* ObjVec::Ref(long Index)
  {
    ByteVector::Ref(((Index+1)*BlockSize)-1);
    return PtrInc(P,Index*BlockSize);
  }

//.parse

void ObjVec::Insert(const ObjVec& V,long Index)
  { ByteVector::Insert(*((ByteVector*)&V),Index*BlockSize); }

//.parse

void ObjVec::Insert(void* X,long Index)
  {
    ObjVec V(ObjSize,X);
    ByteVector::Insert(*((ByteVector*)&V),Index*BlockSize);
  }

//.parse

void ObjVec::Delete(long Index,long Length)
  { ByteVector::Delete(Index*BlockSize,Length*BlockSize); }

//.parse

void ObjVec::operator=(const ObjVec& V){Assign(*((ByteVector*)&V));}

//.parse

void ObjVec::CopyTo(void* Dest, long Quan) const
  {
    ByteVector::CopyTo(Dest,Quan*ObjSize);
  }

//.parse

ObjVec ObjVec::Concat(void* X) const
  {
    ObjVec V(*this);
    memcpy(V.Ref(Size()),X,ObjSize);
    return V;
  }

//.parse

ObjVec ObjVec::Concat(const ObjVec&V2) const
  {
    ObjVec V3(*this);
    V3+=V2;
    return V3;
  }

//.parse

void ObjVec::CtorHelper(int ObjectSize)
  {
    ObjSize=ObjectSize;
    BlockSize=ObjectSize;
  }

ObjVec::ObjVec(int ObjectSize):ByteVector()
  {CtorHelper(ObjectSize);}

ObjVec::ObjVec(int ObjectSize,void* X):ByteVector(X,ObjectSize)
  {CtorHelper(ObjectSize);}

ObjVec::ObjVec(int ObjectSize,void* P, long Len):ByteVector(P,ObjectSize*Len)
  {CtorHelper(ObjectSize);}

ObjVec::ObjVec(const ObjVec& V):ByteVector(*((ByteVector*)&V))
  {CtorHelper(V.ObjSize);}

//.parse

void ObjVec::Empty(){ByteVector::Empty();}
ObjVec::operator ConstVoidPointerType()const{return P;}
long ObjVec::Capacity()const{return (Alloc/BlockSize);}
long ObjVec::ByteCapacity()const{return Alloc;}
long ObjVec::ReAlloc(long NewCap){return ByteVector::ReAlloc(NewCap*BlockSize);}
long ObjVec::Size()const{return Len/BlockSize;}

//.parse

long ObjVec::Index(void* SearchObj, long StartIndex) const
  {
    if (StartIndex>=Size()) return(VecObjNotFound);
    long I=StartIndex;
    while ((I<Size()) && (memcmp(SearchObj,PtrInc(P,I*BlockSize),ObjSize)!=0)) I++;
    if (I==Size()) return(VecObjNotFound);
    else return(I);
  }

//.parse

ObjVec ObjVec::After(long Index) const
  {
    return At(Index+1,Size()-Index-1);
  }

//.parse

ObjVec ObjVec::From(long Index) const
  {
    return At(Index,Size()-Index);
  }

//.parse

void* ObjVec::At(long I) const
  {
    if (I>=Size()) I=Size()-1;
    return PtrInc(P,I*BlockSize);
  }

//.parse

ObjVec ObjVec::At(long I,long L) const
  {
    long S=Size();
    ObjVec V(ObjSize);
    if (I<S)
      {
        if (I+L>=S) L=S-I;
        *((ByteVector*)&V)=ByteVector::At(I*BlockSize,L*BlockSize);
      }
    return V;
  }

