//
// strcmp.cpp : Non-Ansi string routines
// Author     : Roy S. Woll
//
// Copyright (c) 1993 by Roy S. Woll
// You may distribute this source freely as long as you leave all files
// in their original form, including the copyright notice as is.
//
// Description:
//   Case insensitive compare and case conversion routines.
//   These are not part of the standard ansi C library.  
//   Vax-Vms and Unix systems should place the object file in their library.
//
// Date: Dec 4, 1992
// Name: Roy S. Woll
//
#include <ctype.h>

int stricmp(const char * s1, const char * s2){
   if (s1==s2) return 1;
   if (!s1) return -1;
   
   while (*s1) if (toupper(*s1++)!=toupper(*s2++)) break;
   if (*s1){
      if (toupper(*--s1) > toupper(*--s2)) return 1;
      else return -1;
   }
   else if (*s2) return -1;  // s2 is longer than s1
   else return 0;
};

int strnicmp(const char * s1, const char * s2, unsigned n){
   if (s1==s2) return 1;
   if (!s1) return -1;

   while ((*s1) && n--) if (toupper(*s1++)!=toupper(*s2++)) break;
   if (!n) return 0;    // match

   if (*s1)  // search terminated due to difference
   {
      if (toupper(*--s1) > toupper(*--s2)) return 1;
      else return -1;
   }
   else if (*s2) return -1;
   else return 0;
};

char * strlwr(char * s){ 
   char * start = s;
   do { *s = tolower(*s); } while (*s++); 
   return start;
};

char * strupr(char * s){ 
   char * start = s;
   do { *s = toupper(*s); } while (*s++); 
   return start;
};

