//
// dynstream.cpp : dynstream class implementation
// Author  : Roy S. Woll
//
// Copyright (c) 1993 by Roy S. Woll
// You may distribute this source freely as long as you leave all files
// in their original form, including the copyright notice as is.
//
//
// Version 2.00     11/30/92
//    Override member function streambuf::sync()   Roy S. Woll
//
// Version 1.00     10/20/92
//
//
#include <iostream.h>
#include "str.h"
#include "dynstream.h"

dynstreambuf::dynstreambuf(str* AstrPtr):
      streambuf(),strPtr(AstrPtr)
{
   str::strdata * data = strPtr->data;
   setNewBuffer(data->buf, data->cursize, data->curlength);
};

// Create new buffer of size newbufsize
char * dynstreambuf::getNewBuffer(int newbufsize)
{
   return strPtr->getNewBuffer(out_waiting(), newbufsize);
};

// Use new buffer as specified by buf
void dynstreambuf::setNewBuffer(char * buf, int newbufsize, int buflen)
{
   if (base()) buflen = (int)(pptr() - base());
   setb(buf, buf+newbufsize, 0);
   setp(buf, ebuf());
   pbump(buflen);
};

//
// Called when buffer is full
//
int dynstreambuf::overflow(int c)
{
   if (!base())
      if (!getNewBuffer(0)) return EOF;

   if (!pbase()) setp(base(), ebuf());

   if (pbase()){
      if (pptr() >= epptr()) 
         if (!getNewBuffer(0)) return EOF;
      if (pptr() < epptr()) return sputc(c);
   }
   return EOF;
};

streampos dynstreambuf::seekoff(streamoff offset, ios::seek_dir dir, int){
   streamoff pos = EOF;

   if (dir == ios::end) pos = blen() + offset;
   else if (dir == ios::beg) pos = offset;
   else if (dir == ios::cur) {
      if (!pptr()) pos = offset;
      else pos = streamoff( (pptr()-base()) + offset);
   };
   if (pos < 0 || pos > blen()) return EOF;

   set_len(pos);
   return streampos(pos);
};

void dynstreambuf::set_len(int len){pbump(len- (pptr()-base()));};

void dynstreambuf::set_str(str* AstrPtr){ strPtr = AstrPtr;};

int dynstreambuf::sync(){ return 0; };

dynstream::~dynstream(void){ 
#ifdef DEBUG_STR
   str::dynstreamCount--;
#endif
};

dynstream::dynstream(str* AstrPtr)
   :dynstreambase(AstrPtr),ostream(rdbuf())
{
#ifdef DEBUG_STR
 str::dynstreamCount++;
#endif
};


