//
// BCstr.h -- Borland object-based str interface
// Author  : Roy S. Woll
//
// Copyright (c) 1993 by Roy S. Woll
// You may distribute this source freely as long as you leave all files
// in their original form, including the copyright notice as is.
//
// Version 1.00     10/20/92
//

#ifndef _BCSTR_H
#define _BCSTR_H


#ifndef __SORTABLE_H
#include <sortable.h>
#endif

#ifndef _STR_H
#include "str.h"
#endif


//
// Base class Sortable is a protected base class to prevent
// ambiguities where Object and str define the same member function
// or operator (ie. operator !=).
//
class BCstr : protected Sortable, public str{

protected:
//
// Required functions for Base Class Object
//
    virtual int isEqual( const Object & ) const;
    virtual int isLessThan( const Object & ) const;
    virtual classType isA() const { return __firstUserClass; };
    virtual char *nameOf() const { return "str"; };
    virtual hashValueType hashValue() const;
    virtual void printOn( ostream& ) const;

public:

//
// Constructors
//
   BCstr(void);
   BCstr(int p_bufsize, int  p_incr=STR_DEFAULT_MEMINCR);
   BCstr(const char * s, int p_bufsize=0, int p_incr=STR_DEFAULT_MEMINCR);
   BCstr(const BCstr&, int p_bufsize=0, int p_incr=STR_DEFAULT_MEMINCR);
   BCstr(const str&, int p_bufsize=0, int p_incr=STR_DEFAULT_MEMINCR);

   operator Object&(void){ return *(Object*)this; };

   str& operator = (const BCstr& s){ return str::operator =(s);};
   str& operator = (const str& s){ return str::operator =(s);};
   str& operator = (const char * s){ return str::operator =(s);};
   str& operator = (const char s){ return str::operator =(s);};
};


#endif
