//
//      **************************************************************
//       JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//      **************************************************************
//
// CONSOLE I/O (MS-DOS) and BORLAND VIDEO FUNCTIONS
//

#if !defined(___STDDEF_H_INCLUDED)
#include <_stddef.h>
#endif
#if !defined(___PORTINT_H_INCLUDED)
#include <_portint.h>       // PORT and INTERRUPT FUNCTIONS
#endif

#if !defined(__CONIO_H_INCLUDED)

#define NULL    _NULL

#define _NOCURSOR      0
#define _SOLIDCURSOR   1
#define _NORMALCURSOR  2

#define BLINK       128 /* blink bit */

#ifndef _CONIO_H_COLORS
enum COLORS {
    BLACK,      BLUE,           GREEN,      CYAN,
    RED,        MAGENTA,        BROWN,      LIGHTGRAY,
    DARKGRAY,   LIGHTBLUE,      LIGHTGREEN, LIGHTCYAN,
    LIGHTRED,   LIGHTMAGENTA,   YELLOW,     WHITE
};
#define _CONIO_H_COLORS
#endif

struct text_info {
    unsigned char winleft;
    unsigned char wintop;
    unsigned char winright;
    unsigned char winbottom;
    unsigned char attribute;
    unsigned char normattr;
    unsigned char currmode;
    unsigned char screenheight;
    unsigned char screenwidth;
    unsigned char curx;
    unsigned char cury;
};

enum text_modes { LASTMODE=-1, BW40=0, C40, BW80, C80, MONO=7, C4350=64 };

extern "C" {

char *      _CDECL  cgets   (char *);
int         _CDECL  cprintf (const char *, ...);
int         _CDECL  cputs   (const char *);
int         _CDECL  cscanf  (const char *, ...);
int         _CDECL  getch   (void);
int         _CDECL  getche  (void);
int         _CDECL  putch   (int);
int         _CDECL  ungetch (int);

int         _CDECL  kbhit   (void);

void        _CDECL  clreol  (void);
void        _CDECL  clrscr  (void);
void        _CDECL  gotoxy  (int, int);
int         _CDECL  wherex  (void);
int         _CDECL  wherey  (void);
void        _CDECL  delline (void);
int         _CDECL  gettext (int, int, int, int, void *);
void        _CDECL  gettextinfo (struct text_info *);
void        _CDECL  highvideo   (void);
void        _CDECL  insline (void);
void        _CDECL  lowvideo(void);
int         _CDECL  movetext(int, int, int, int, int, int);
void        _CDECL  normvideo(void);
int         _CDECL  puttext (int, int, int, int, void *);
void        _CDECL  textattr(int);
void        _CDECL  textbackground (int);
void        _CDECL  textcolor(int);
void        _CDECL  textmode(int);
void        _CDECL  window  (int, int, int, int);

void        _CDECL  _setcursortype(int);
char *      _CDECL  getpass (const char *);

extern  int _CDECL  directvideo;
extern  int _CDECL  _wscroll;

}

#define __CONIO_H_INCLUDED
#endif
