/***************************************************************
 * file: DISPLAY.H
 * purpose: prototypes and defines for display.c
 * copyright: 1993 by David Weber.  All rights reserved.
 *  This software can be used for any purpose as object, library or executable.
 *  It cannot be sold for profit as source code.
 * history:
 *  02-26-93 - initial code
 **************************************************************/

/* definitions */
#define PCX_READ_BUFFER 16384       /* PCX file buffer */
#define DISPLAY_BUFFER_SIZE 16384   /* one of an array of display buffers */
#define MAX_DISPLAY_BUFFERS 64      /* enough for a 1024 by 1024 picture */
#define I_LOVE_BLACK 1              /* black enhanced scaling */
#define IDEAL_SCREEN_ASPECT 133     /* expected screen aspect ratio = 1.33, fixed point */

/* types */
typedef struct { short x,y,width,height; } DISPLAY_BOX;
typedef struct numbox
    {
    short x,y,width,height;
    struct numbox *next;
    } NUMBERED_BOX;

/* prototypes */
int display_file(char *filename);
void display_free(void);
unsigned char *display_sample(int *samplex,int *sampley,int *dx,int *dy);
void display_numbered_box(int x1,int y1,int x2,int y2,int num);
void display_numbered_box_close(void);
int display_redraw(void);
