
/* ------------- Function ToJul2 --------------- */
/* Function to convert a Gregorian calendar date */
/* (month,day,year) to a Julian day number.      */
/* ALGORITHM: Faster adaption of Fortran code in */
/*            H. Fliegl and T. Van Flanders,     */
/*            Communications of the ACM, Vol 11  */
/*            No. 10, Oct. 1968, page 657        */
/* RETURNS: Julian day number, as long int.      */
/* --------------------------------------------- */
long ToJul2(int month,int day,int year)
{
   int  tl=0;
   long jul_day;

   if (month<3)
      tl--;

   jul_day=(long)day-32075L
           +((1461L*(long)(year+4800+tl))>>2)
           +(long)(367*(month-2-tl*12)/12)
           -(3*((year+4900+tl)/100)>>2);

    return (jul_day);
}

