/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include <dos.h>


/***
 *
 *  Function   :    getdensity
 *
 *  Topics     :    Returns the density of a floppy drive.
 *
 *  Parameters :    in    int drive         0 = A:, 1 = B:
 *
 *  Return code:    density in Kb (360, 720, 1200, 1440)
 *                  0 if invalid drive
 ***/

int getdensity( int drive )

{ union REGS regs, outregs;
  
  regs.h.ah = 8;
  regs.h.dl = drive;
  int86( 0x13, &regs, &outregs );     /* sometimes fails first time */
  int86( 0x13, &regs, &outregs );
  switch( outregs.h.bl )
  	{
          case 1 :  return 360;

	  case 2 :  return 1200;

	  case 3 :  return 720;

	  case 4 :  return 1440;

	  default:  return 0;
	}
}
              