***************************************************************************
*:
*:      Program: JOBUTIL.PRG
*:
*:       System: Job Search - Version 2.0
*:       Author: R. J. Kovach
*:
*:*************************************************************************
*:       Copyright (C) 1993, R.J. Kovach & Assoc.    ALL RIGHTS RESERVED
*:*************************************************************************
*:
*:Procs & Fncts: SUMMARY        Summary menu
*:             : SICSEARCH      List companies for a SIC code
*:             : INDSEARCH      Lists search firms for an industry code
*:             : DBDIR          Database directory
*:             : EXPENSES       Summarizes job hunting expenses
*:             : PACKDB         Pack selected database
*:             : BACKUP         Backup all database and index files
*:             : CPYCOLOR       Set color while copying files
*:             : CPTCOLOR       Set color for completed file copy
*:             : UTILITIES      Utilities menu
*:             : DISPLAY        Display setup info
*:             : SETUP          Change setup
*:             : DBINDX         Index all databases
*:             : DBSORT         Sort all databases
*:             : FIXMEMO        Repair and pack all memo (.dbt) files
*:             : MRGCHCE        Select database for mail merge
*:             : MAILMERGE      Export records for mail merge
*:             : STOPRET        Returns to previous menu after pressing Esc
*:             : NOTVALID       Not valid message
*:
*:      Formats:
*:
*:      Filters:
*:             :
*:         Uses: COMPANY.DBF
*:             : NETWORK.DBF
*:             : EXECSRCH.DBF
*:             : TEMPSRCH.DBF
*:             : JOBEXPEN.DBF
*:             : SIC.DBF
*:
*:   Memo files: COMPANY.DBT
*:             : NETWORK.DBT
*:             : EXECSRCH.DBT
*:             : TEMPSRCH.DBT
*:
*:      Indexes: DIVISION.NDX
*:             : NETWORK.NDX
*:             : EXECNAME.NDX
*:             : TEMPNAME.NDX
*:             : JOBEXPEN.NDX
*:             : SICNO.NDX
*:
*: Memory Files: SETUP.MEM
*:
*:       Set by: JOBS.PRG
*:
*: Documented: 4/23/93
*: Revised:    6/01/93
*:*************************************************************************


*****************
PROCEDURE summary
*****************

CLEAR
CLEAR GETS
DO WHILE .T.
   CLEAR
   IF monitor = 'C'
      SET COLOR TO &mcolor2
   ENDIF
   @ 3,4 TO 13,76
   @ 1,29 TO 3,53 DOUBLE
   IF monitor = 'C'
      SET COLOR TO &mcolor3
   ENDIF
   @ 2,5 SAY DATE()
   @ 2,68 SAY TIME()
   IF monitor = 'C'
      SET COLOR TO &mcolor2
   ENDIF
   @ 2,33 SAY 'S U M M A R I E S'
   IF monitor = 'C'
      SET COLOR TO &mcolor
   ENDIF
   @ 5,30 SAY '1> Search by SIC Code'
   @ 7,30 SAY '2> Search by Industry'
   @ 9,30 SAY '3> Database Directory'
   @11,30 SAY '4> Job Hunting Expenses'
   IF monitor = 'C'
      SET COLOR TO &mcolor5
   ENDIF
   @ 15,0 SAY ' '
   WAIT '                        Pick a number or type Q to Quit  ' TO choice
   IF monitor = 'C'
      SET COLOR TO &mcolor
   ENDIF

   DO CASE
      CASE choice = '1'
         IF type = 'C'
            DO sicsearch
         ELSE
            DO notvalid
         ENDIF
      CASE choice = '2'
         IF type = 'E'
            DO indsearch
         ELSE
            IF type = 'T'
               DO indsearch
            ELSE
               DO notvalid
            ENDIF
         ENDIF
      CASE choice = '3'
         DO dbdir
      CASE choice = '4'
         DO expenses
      CASE UPPER(choice) = 'Q'
         RETURN
   ENDCASE
ENDDO


*******************
PROCEDURE sicsearch
*******************

CLEAR GETS
SELECT 6
USE sic INDEX sicno
SELECT 1
USE company INDEX division
CLEAR
STORE ' ' to sic
@ 13,5 SAY ' '
ACCEPT '          Enter the SIC code to search for or type Q to quit:  ' TO sic
CLEAR
@ 0,33 SAY 'SIC code: '+ sic
@ 1, 5 SAY ' '
LIST division, city, state, sales, employees FOR code1=sic .OR. code2=sic .OR. code3=sic .OR. code4=sic OFF
WAIT
RETURN


*******************
PROCEDURE indsearch
*******************

CLEAR GETS
SELECT 6
IF type = 'E'
   SELECT 3
   USE execsrch INDEX execname
ELSE
   SELECT 4
   USE tempsrch INDEX tempname
ENDIF
CLEAR
STORE ' ' to sic
@ 13,5 SAY ' '
ACCEPT '        Enter the Industry code to search for or type Q to quit:  ' TO sic
CLEAR
@ 0,30 SAY 'Industry: '+ sic
@ 1, 5 SAY ' '
LIST name, city, state for indus1=sic .OR. indus2=sic .OR. indus3=sic .OR. indus4=sic OFF
WAIT
RETURN


***************
PROCEDURE dbdir
***************

CLEAR GETS
CLEAR
@ 5,5 SAY ' '
DIR
WAIT
RETURN


******************
PROCEDURE expenses
******************

CLEAR GETS
SELECT 5
STORE 0 TO jobtot
STORE 0 TO jobtot1
USE jobexpen INDEX jobexpen
CLEAR
@ 1,28 TO 3,51
@ 2,30 SAY 'Job Hunting Expenses'
@ 4,43 SAY 'Type'
@ 6,20 SAY 'Lodging                  L'
SUM amount FOR type = 'L' TO jobtot
@ 6,50 SAY jobtot PICTURE "99,999.99"
@ 8,20 SAY 'Meals                    M'
SUM amount FOR type = 'M' TO jobtot
@ 8,50 SAY jobtot PICTURE "99,999.99"
@10,20 SAY 'Auto Expenses            A'
SUM amount FOR type = 'A' TO jobtot
@10,50 SAY jobtot PICTURE "99,999.99"
@12,20 SAY 'Auto mileage             A'
SUM miles FOR type = 'A' TO jobtot
@12,50 SAY jobtot * monimile PICTURE "99,999.99"
@14,20 SAY 'Transportation           T'
SUM amount FOR type = 'T' TO jobtot
@14,50 SAY jobtot PICTURE "99,999.99"
@16,20 SAY 'Postage & Stationery     P'
SUM amount FOR type = 'P' TO jobtot
@16,50 SAY jobtot PICTURE "99,999.99"
@18,20 SAY 'All Other                O'
SUM amount FOR type = 'O' TO jobtot
@18,50 SAY jobtot PICTURE "99,999.99"
@19,49 SAY '___________'
@21,30 SAY 'T O T A L'
SUM amount TO jobtot
SUM miles TO jobtot1
@21,50 SAY jobtot + (jobtot1 * monimile) PICTURE "99,999.99"
@23,0
WAIT


****************
PROCEDURE packdb
****************

CLEAR GETS
STORE ' ' TO enter
CLEAR
IF monitor = 'C'
   SET COLOR TO &mcolor2
ENDIF
@3,4 TO 17,76
@1,26 TO 3,54 DOUBLE
@2,29 SAY 'F I L E   P A C K I N G'
IF monitor = 'C'
   SET COLOR TO &mcolor
ENDIF
@6,7 SAY 'C A U T I O N :  This operation will permanently remove records'
@10,24 SAY 'marked for deletion from the active database.'
@14,24 SAY 'Press P to continue, or Q to quit. ' GET enter
READ
IF UPPER(enter) <> 'P'
   RETURN
ELSE
   SET TALK ON
   SET STATUS ON
   IF type = 'C'
      SELECT 1
      USE company INDEX division
   ELSE
      IF type = 'N'
         SELECT 2
         USE network INDEX network
      ELSE
         IF type = 'E'
            SELECT 3
            USE execsrch INDEX execname
         ELSE
            IF type = 'T'
               SELECT 4
               USE tempsrch INDEX tempname
            ELSE
               SELECT 5
               USE jobexpen INDEX jobexpen
            ENDIF
         ENDIF
      ENDIF
   ENDIF
   CLEAR
   PACK
   WAIT
   SET TALK OFF
   SET STATUS OFF
   RETURN
ENDIF


****************
PROCEDURE backup
****************

CLEAR GETS
CLEAR
STORE ' ' TO enter
CLEAR
IF monitor = 'C'
   SET COLOR TO &mcolor2
ENDIF
@3,0 TO 22,79
@1,26 TO 3,54 DOUBLE
@2,30 SAY 'F I L E   B A C K U P'
IF monitor = 'C'
   SET COLOR TO &mcolor
ENDIF
@5,4 SAY 'Place a formatted disk in drive A and press B when ready or Q to Quit' GET enter
READ
IF UPPER(enter) <> 'B'
   RETURN
ELSE
   DO cpycolor
   @ 5,4 SAY '                                                                       '
   @ 6,23 SAY 'Backup in process, do not interrupt.'
   IF monitor = 'C'
      SET COLOR TO &mcolor
   ELSE
      SET COLOR TO &mono
   ENDIF
   CLOSE DATABASES
   @ 9, 3 SAY 'COMPANY.DBF'
   @11, 3 SAY 'NETWORK.DBF'
   @13, 3 SAY 'EXECSRCH.DBF'
   @15, 3 SAY 'TEMPSRCH.DBF'
   @17, 3 SAY 'SIC.DBF'
   @19, 3 SAY 'JOBEXPEN.DBF'
   IF monidb = 'F'
      @ 9,29 SAY 'COMPANY.FPT'
      @11,29 SAY 'NETWORK.FPT'
      @13,29 SAY 'EXECSRCH.FPT'
      @15,29 SAY 'TEMPSRCH.FPT'
      @ 9,55 SAY 'DIVISION.IDX'
      @11,55 SAY 'NETWORK.IDX'
      @13,55 SAY 'EXECNAME.IDX'
      @15,55 SAY 'TEMPNAME.IDX'
      @17,55 SAY 'SICNO.IDX'
      @19,55 SAY 'JOBEXPEN.IDX'
   ELSE
      @ 9,29 SAY 'COMPANY.DBT'
      @11,29 SAY 'NETWORK.DBT'
      @13,29 SAY 'EXECSRCH.DBT'
      @15,29 SAY 'TEMPSRCH.DBT'
      @ 9,55 SAY 'DIVISION.NDX'
      @11,55 SAY 'NETWORK.NDX'
      @13,55 SAY 'EXECNAME.NDX'
      @15,55 SAY 'TEMPNAME.NDX'
      @17,55 SAY 'SICNO.NDX'
      @19,55 SAY 'JOBEXPEN.NDX'
   ENDIF
   DO cpycolor
   @ 9,16 SAY 'Copying'
   @23, 0
   COPY FILE company.dbf TO A:company.dbf
   DO cptcolor
   @ 9,16 SAY 'Completed'
   DO cpycolor
   @11,16 SAY 'Copying'
   @23, 0
   COPY FILE network.dbf TO A:network.dbf
   DO cptcolor
   @11,16 SAY 'Completed'
   DO cpycolor
   @13,16 SAY 'Copying'
   @23, 0
   COPY FILE execsrch.dbf TO A:execsrch.dbf
   DO cptcolor
   @13,16 SAY 'Completed'
   DO cpycolor
   @15,16 SAY 'Copying'
   @23, 0
   COPY FILE tempsrch.dbf TO A:tempsrch.dbf
   DO cptcolor
   @15,16 SAY 'Completed'
   DO cpycolor
   @17,16 SAY 'Copying'
   @23, 0
   COPY FILE sic.dbf TO A:sic.dbf
   DO cptcolor
   @17,16 SAY 'Completed'
   DO cpycolor
   @19,16 SAY 'Copying'
   @23, 0
   COPY FILE jobexpen.dbf TO A:jobexpen.dbf
   DO cptcolor
   @19,16 SAY 'Completed'
   DO cpycolor
   @ 9,42 SAY 'Copying'
   @23, 0
   IF monidb = 'F'
      COPY FILE company.fpt TO A:company.fpt
      DO cptcolor
      @ 9,42 SAY 'Completed'
      DO cpycolor
      @11,42 SAY 'Copying'
      @23, 0
      COPY FILE network.fpt TO A:network.fpt
      DO cptcolor
      @11,42 SAY 'Completed'
      DO cpycolor
      @13,42 SAY 'Copying'
      @23, 0
      COPY FILE execsrch.fpt TO A:execsrch.fpt
      DO cptcolor
      @13,42 SAY 'Completed'
      DO cpycolor
      @15,42 SAY 'Copying'
      @23, 0
      COPY FILE tempsrch.fpt TO A:tempsrch.fpt
      DO cptcolor
      @15,42 SAY 'Completed'
      DO cpycolor
      @ 9,68 SAY 'Copying'
      @23, 0
      COPY FILE division.idx TO A:division.idx
      DO cptcolor
      @ 9,68 SAY 'Completed'
      DO cpycolor
      @11,68 SAY 'Copying'
      @23, 0
      COPY FILE network.idx TO A:network.idx
      DO cptcolor
      @11,68 SAY 'Completed'
      DO cpycolor
      @13,68 SAY 'Copying'
      @23, 0
      COPY FILE execname.idx TO A:execname.idx
      DO cptcolor
      @13,68 SAY 'Completed'
      DO cpycolor
      @15,68 SAY 'Copying'
      @23, 0
      COPY FILE tempname.idx TO A:tempname.idx
      DO cptcolor
      @15,68 SAY 'Completed'
      DO cpycolor
      @17,68 SAY 'Copying'
      @23, 0
      COPY FILE sicno.idx TO A:sicno.idx
      DO cptcolor
      @17,68 SAY 'Completed'
      DO cpycolor
      @19,68 SAY 'Copying'
      @23, 0
      COPY FILE jobexpen.idx TO A:jobexpen.idx
      DO cptcolor
      @19,68 SAY 'Completed'
   ELSE
      COPY FILE company.dbt TO A:company.dbt
      DO cptcolor
      @ 9,42 SAY 'Completed'
      DO cpycolor
      @11,42 SAY 'Copying'
      @23, 0
      COPY FILE network.dbt TO A:network.dbt
      DO cptcolor
      @11,42 SAY 'Completed'
      DO cpycolor
      @13,42 SAY 'Copying'
      @23, 0
      COPY FILE execsrch.dbt TO A:execsrch.dbt
      DO cptcolor
      @13,42 SAY 'Completed'
      DO cpycolor
      @15,42 SAY 'Copying'
      @23, 0
      COPY FILE tempsrch.dbt TO A:tempsrch.dbt
      DO cptcolor
      @15,42 SAY 'Completed'
      DO cpycolor
      @ 9,68 SAY 'Copying'
      @23, 0
      COPY FILE division.ndx TO A:division.ndx
      DO cptcolor
      @ 9,68 SAY 'Completed'
      DO cpycolor
      @11,68 SAY 'Copying'
      @23, 0
      COPY FILE network.ndx TO A:network.ndx
      DO cptcolor
      @11,68 SAY 'Completed'
      DO cpycolor
      @13,68 SAY 'Copying'
      @23, 0
      COPY FILE execname.ndx TO A:execname.ndx
      DO cptcolor
      @13,68 SAY 'Completed'
      DO cpycolor
      @15,68 SAY 'Copying'
      @23, 0
      COPY FILE tempname.ndx TO A:tempname.ndx
      DO cptcolor
      @15,68 SAY 'Completed'
      DO cpycolor
      @17,68 SAY 'Copying'
      @23, 0
      COPY FILE sicno.ndx TO A:sicno.ndx
      DO cptcolor
      @17,68 SAY 'Completed'
      DO cpycolor
      @19,68 SAY 'Copying'
      @23, 0
      COPY FILE jobexpen.ndx TO A:jobexpen.ndx
      DO cptcolor
      @19,68 SAY 'Completed'
   ENDIF
   @ 6,10 SAY '                                                       '
   @21,23 SAY 'File backup successfully completed.'
   @23,0
   IF monitor = 'C'
      SET COLOR TO &mcolor2
   ENDIF
   WAIT '                            Press any key to continue'
   IF monitor = 'C'
      SET COLOR TO &mcolor
   ENDIF
   RETURN
ENDIF


******************
PROCEDURE cpycolor
******************

IF monitor = 'C'
   IF monidb = 'F'
      SET COLOR TO &mcolor3
   ELSE
      SET COLOR TO &mcolor7
   ENDIF
ELSE
   SET COLOR TO &mono2
ENDIF
RETURN


******************
PROCEDURE cptcolor
******************

IF monitor = 'C'
   SET COLOR TO &mcolor2
ELSE
   SET COLOR TO &mono
ENDIF
RETURN


*******************
PROCEDURE utilities
*******************

CLEAR
CLEAR GETS
DO WHILE .T.
   CLEAR
   IF monitor = 'C'
      SET COLOR TO &mcolor2
   ENDIF
   @ 3,4 TO 17,76
   @ 1,12 TO 3,68 DOUBLE
   @ 2,19 SAY 'S E T U P   &   U T I L I T I E S   M E N U'
   IF monitor = 'C'
      SET COLOR TO &mcolor
   ENDIF
   @  5,25 SAY '1> Display Setup Data'
   @  7,25 SAY '2> Change Setup Data'
   @  9,25 SAY '3> Sort all Databases'
   @ 11,25 SAY '4> Pack all Memo Files'
   @ 13,25 SAY '5> Export Records for Mail Merge'
   IF monitor = 'C'
      SET COLOR TO &mcolor5
   ENDIF
   @ 20,0 SAY ' '
   WAIT '                         Pick a number or type Q to Quit  ' TO choice
   IF monitor = 'C'
      SET COLOR TO &mcolor
   ENDIF

   DO CASE
   CASE choice = '1'
      DO display
   CASE choice = '2'
      DO setup
   CASE choice = '3'
      DO dbsort
   CASE choice = '4'
      DO fixmemo
   CASE choice = '5'
      DO mrgchce
      DO mailmerge
   CASE UPPER(choice) = 'Q'
      RETURN

   ENDCASE
ENDDO


*****************
PROCEDURE display
*****************

CLEAR
@1,29 TO 3,51 DOUBLE
@2,31 SAY 'S E T U P   D A T A'
@ 8,21 SAY 'Color or Monochrome monitor    =   ' + monitor
@10,21 SAY 'Epson, IBM or Laserjet printer =   ' + moniprnt
@12,21 SAY 'dBASE III or Foxpro version    =   ' + monidb
@14,21 SAY 'Mileage rate used on expenses  =  $'
@14,56 SAY monimile PICTURE "9.99"
@18,14 SAY ' '
WAIT '                            Press any key to continue'
RETURN


***************
PROCEDURE setup
***************

CLEAR TYPEAHEAD
STORE ' ' TO msg
SET COLOR TO &mono
CLEAR
STORE ' ' TO enter
@1,26 TO 3,54 DOUBLE
@2,28 SAY 'I N I T I A L   S E T U P'
STORE 'CM' TO msg
@ 9,23 SAY 'Color or Monochrome monitor (C/M)? ' GET enter PICTURE '!'
READ SAVE
DO WHILE .NOT. enter $ msg
   ?? CHR(7)
   READ SAVE
ENDDO
STORE enter TO monitor
CLEAR
STORE ' ' TO enter
@1,26 TO 3,54 DOUBLE
@2,28 SAY 'I N I T I A L   S E T U P'
STORE 'EIL' TO msg
@ 9,9 SAY 'Epson, IBM printer or Hewlett Packard Laserjet (E/I/L)? ' GET enter PICTURE '!'
READ SAVE
DO WHILE .NOT. enter $ msg
   ?? CHR(7)
   READ SAVE
ENDDO
STORE enter TO moniprnt
CLEAR
STORE ' ' TO enter
@1,26 TO 3,54 DOUBLE
@2,28 SAY 'I N I T I A L   S E T U P'
STORE 'DF' TO msg
@ 9,8 SAY 'What database are you using; dBASE III or Foxpro (D/F)? ' GET enter PICTURE '!'
READ SAVE
DO WHILE .NOT. enter $ msg
   ?? CHR(7)
   READ SAVE
ENDDO
STORE enter TO monidb
CLEAR
STORE 0 TO monimile
@1,26 TO 3,54 DOUBLE
@2,28 SAY 'I N I T I A L   S E T U P'
@ 9,10 SAY 'Enter the mileage rate   $' GET monimile PICTURE "9.99"
READ SAVE
STORE DATE() TO monidate

SAVE ALL LIKE moni* TO setup
CLEAR
RETURN


****************
PROCEDURE dbindx
****************

CLEAR
@11,30 SAY 'Please wait. . . . . .'
SELECT 1
USE company INDEX division
REINDEX
SELECT 2
USE network INDEX network
REINDEX
SELECT 3
USE execsrch INDEX execname
REINDEX
SELECT 4
USE tempsrch INDEX tempname
REINDEX
SELECT 5
USE jobexpen INDEX jobexpen
REINDEX
SELECT 6
USE sic INDEX sicno
REINDEX
CLOSE DATABASES
@11,30 SAY '                                       '
@15,20 SAY 'Files have been successfully reindexed.'
@20,10 SAY ' '
IF monitor = 'C'
   SET COLOR TO &mcolor2
ENDIF
WAIT '                         Press any key to continue'
IF monitor = 'C'
   SET COLOR TO &mcolor
ENDIF
RETURN


****************
PROCEDURE dbsort
****************

CLEAR GETS
CLEAR
STORE ' ' TO enter
CLEAR
IF monitor = 'C'
   SET COLOR TO &mcolor2
ENDIF
@3,4 TO 17,76
@1,26 TO 3,54 DOUBLE
@2,30 SAY 'F I L E   R E S O R T'
IF monitor = 'C'
   SET COLOR TO &mcolor
ENDIF
@6,8 SAY 'Make sure that the data files have been backed up prior to resort.'
@8,25 SAY 'Press S when ready or Q to Quit' GET enter
READ
IF UPPER(enter) <> 'S'
   RETURN
ELSE
   IF DISKSPACE() < 1000000
      @ 12, 8 SAY 'You must have at least 1 megabyte of free space on the disk'
      @ 13, 8 SAY 'to resort the data files.  Currently the disk has free space'
      @ 14, 8 SAY 'of'
      @ 14,10 SAY DISKSPACE()
      @ 14,21 SAY 'bytes.  Delete unnecessary files and try again.'
      @ 20,10 SAY ' '
      WAIT '                           Press any key to continue'
      RETURN
   ENDIF
   IF monitor = 'C'
      SET COLOR TO &mcolor7
   ELSE
      SET COLOR TO &mono2
   ENDIF
   @13,10 SAY 'Sort is in process, do not interrupt.'
   IF monitor = 'C'
      SET COLOR TO &mcolor
   ELSE
      SET COLOR TO &mono
   ENDIF
   CLOSE DATABASES
   SELECT 1
   USE company INDEX division
   IF RECCOUNT() > 1
      SORT TO comp ON division, company
      CLOSE DATABASES
      ERASE company.dbf
      RENAME comp.dbf TO company.dbf
      IF monidb = 'F'
         ERASE company.fpt
         RENAME comp.fpt TO company.fpt
      ELSE
         ERASE company.dbt
         RENAME comp.dbt TO company.dbt
      ENDIF
      USE company INDEX division
      REINDEX
      CLOSE DATABASES
   ENDIF
   SELECT 2
   USE network INDEX network
   IF RECCOUNT() > 1
      SORT TO net ON last, first
      CLOSE DATABASES
      ERASE network.dbf
      RENAME net.dbf TO network.dbf
      IF monidb = 'F'
         ERASE network.fpt
         RENAME net.fpt TO network.fpt
      ELSE
         ERASE network.dbt
         RENAME net.dbt TO network.dbt
      ENDIF
      USE network INDEX network
      REINDEX
      CLOSE DATABASES
   ENDIF
   SELECT 3
   USE execsrch INDEX execname
   IF RECCOUNT() > 1
      SORT TO exec ON name
      CLOSE DATABASES
      ERASE execsrch.dbf
      RENAME exec.dbf TO execsrch.dbf
      IF monidb = 'F'
         ERASE execsrch.fpt
         RENAME exec.fpt TO execsrch.fpt
      ELSE
         ERASE execsrch.dbt
         RENAME exec.dbt TO execsrch.dbt
      ENDIF
      USE execsrch INDEX execname
      REINDEX
      CLOSE DATABASES
   ENDIF
   SELECT 4
   USE tempsrch INDEX tempname
   IF RECCOUNT() > 1
      SORT TO temp ON name
      CLOSE DATABASES
      ERASE tempsrch.dbf
      RENAME temp.dbf TO tempsrch.dbf
      IF monidb = 'F'
         ERASE tempsrch.fpt
         RENAME temp.fpt TO tempsrch.fpt
      ELSE
         ERASE tempsrch.dbt
         RENAME temp.dbt TO tempsrch.dbt
      ENDIF
      USE tempsrch INDEX tempname
      REINDEX
      CLOSE DATABASES
   ENDIF
   SELECT 5
   USE jobexpen INDEX jobexpen
   IF RECCOUNT() > 1
      SORT TO job2 ON date
      CLOSE DATABASES
      ERASE jobexpen.dbf
      RENAME job2.dbf TO jobexpen.dbf
      USE jobexpen INDEX jobexpen
      REINDEX
      CLOSE DATABASES
   ENDIF
   SELECT 6
   USE sic INDEX sicno
   IF RECCOUNT() > 1
      SORT TO sic2 ON sic
      CLOSE DATABASES
      ERASE sic.dbf
      RENAME sic2.dbf TO sic.dbf
      USE sic INDEX sicno
      REINDEX
      CLOSE DATABASES
   ENDIF

   @13,10 SAY '                                      '
   @15,10 SAY 'File sort successfully completed.'
   @20,10 SAY ' '
   IF monitor = 'C'
      SET COLOR TO &mcolor2
   ENDIF
   WAIT '                    Press any key to continue'
   IF monitor = 'C'
      SET COLOR TO &mcolor
   ENDIF
   RETURN
ENDIF


*****************
PROCEDURE fixmemo
*****************

CLEAR GETS
CLEAR
STORE ' ' TO enter
CLEAR
IF monitor = 'C'
   SET COLOR TO &mcolor2
ENDIF
@3,4 TO 17,76
@1,25 TO 3,55 DOUBLE
@2,27 SAY 'M E M O   F I L E   P A C K'
IF monitor = 'C'
   SET COLOR TO &mcolor
ENDIF
@6,13 SAY 'Make sure that the data files have been backed up prior'
@8,13 SAY 'to pack of memo files.'
@10,25 SAY 'Press R when ready or Q to Quit' GET enter
READ
IF UPPER(enter) <> 'R'
   RETURN
ELSE
   IF DISKSPACE() < 1000000
      @ 12, 8 SAY 'You must have at least 1 megabyte of free space on the disk'
      @ 13, 8 SAY 'to repair the memo files.  Currently the disk has free space'
      @ 14, 8 SAY 'of'
      @ 14,10 SAY DISKSPACE()
      @ 14,21 SAY 'bytes.  Delete unnecessary files and try again.'
      @ 20,10 SAY ' '
      WAIT '                           Press any key to continue'
      RETURN
   ENDIF
   IF monitor = 'C'
      SET COLOR TO &mcolor7
   ELSE
      SET COLOR TO &mono2
   ENDIF
   @13,10 SAY 'Repair and pack is in process, do not interrupt.'
   IF monitor = 'C'
      SET COLOR TO &mcolor
   ELSE
      SET COLOR TO &mono
   ENDIF
   CLOSE DATABASES
   SET TALK ON
   SET STATUS ON
   IF monidb = 'F'
      SELECT 1
      USE company INDEX division
      COPY TO comp
      CLOSE DATABASES
      ERASE company.dbf
      ERASE company.fpt
      RENAME comp.dbf TO company.dbf
      RENAME comp.fpt TO company.fpt
      USE company INDEX division
      REINDEX
      SELECT 2
      USE network INDEX network
      COPY TO net
      CLOSE DATABASES
      ERASE network.dbf
      ERASE network.fpt
      RENAME net.dbf TO network.dbf
      RENAME net.fpt TO network.fpt
      USE network INDEX network
      REINDEX
      CLOSE DATABASES
      SELECT 3
      USE execsrch INDEX execname
      COPY TO exec
      CLOSE DATABASES
      ERASE execsrch.dbf
      ERASE execsrch.fpt
      RENAME exec.dbf TO execsrch.dbf
      RENAME exec.fpt TO execsrch.fpt
      USE execsrch INDEX execname
      REINDEX
      CLOSE DATABASES
      SELECT 4
      USE tempsrch INDEX tempname
      COPY TO temp
      CLOSE DATABASES
      ERASE tempsrch.dbf
      ERASE tempsrch.fpt
      RENAME temp.dbf TO tempsrch.dbf
      RENAME temp.fpt TO tempsrch.fpt
      USE tempsrch INDEX tempname
      REINDEX
      CLOSE DATABASES
   ELSE
      SELECT 1
      USE company INDEX division
      COPY TO comp
      CLOSE DATABASES
      ERASE company.dbf
      ERASE company.dbt
      RENAME comp.dbf TO company.dbf
      RENAME comp.dbt TO company.dbt
      USE company INDEX division
      REINDEX
      SELECT 2
      USE network INDEX network
      COPY TO net
      CLOSE DATABASES
      ERASE network.dbf
      ERASE network.dbt
      RENAME net.dbf TO network.dbf
      RENAME net.dbt TO network.dbt
      USE network INDEX network
      REINDEX
      CLOSE DATABASES
      SELECT 3
      USE execsrch INDEX execname
      COPY TO exec
      CLOSE DATABASES
      ERASE execsrch.dbf
      ERASE execsrch.dbt
      RENAME exec.dbf TO execsrch.dbf
      RENAME exec.dbt TO execsrch.dbt
      USE execsrch INDEX execname
      REINDEX
      CLOSE DATABASES
      SELECT 4
      USE tempsrch INDEX tempname
      COPY TO temp
      CLOSE DATABASES
      ERASE tempsrch.dbf
      ERASE tempsrch.dbt
      RENAME temp.dbf TO tempsrch.dbf
      RENAME temp.dbt TO tempsrch.dbt
      USE tempsrch INDEX tempname
      REINDEX
      CLOSE DATABASES
   ENDIF
   SET TALK OFF
   SET STATUS OFF
   RETURN
ENDIF


*****************
PROCEDURE mrgchce
*****************

DO WHILE .T.
   CLEAR
   CLOSE DATABASES
   @ 4,19 SAY 'Choose Database:'
   @ 7,23 SAY 'C> Company Database'
   @10,23 SAY 'E> Executive Search Firm Database'
   @13,23 SAY 'N> Network Database'
   @16,23 SAY 'T> Temporary Placement Firm Database'
   @19,0 SAY ' '
   WAIT '                   Choose C, E, N or T  ' TO choice
   DO CASE
   CASE UPPER(choice) = 'C'
      STORE 'C' TO type2
      RETURN
   CASE UPPER(choice) = 'N'
      STORE 'N' TO type2
      RETURN
   CASE UPPER(choice) = 'E'
      STORE 'E' TO type2
      RETURN
   CASE UPPER(choice) = 'T'
      STORE 'T' TO type2
      RETURN
   ENDCASE
ENDDO


*******************
PROCEDURE mailmerge
*******************

CLEAR GETS
CLEAR
IF type2 = 'C'
   SELECT 1
   USE company INDEX division
   @ 6,31 SAY 'Company Database:'
ENDIF
IF type2 = 'E'
   SELECT 3
   USE execsrch INDEX execname
   @ 6,24 SAY 'Executive Search Firm Database:'
ENDIF
IF type2 = 'N'
   SELECT 2
   USE network INDEX network
   @ 6,31 SAY 'Network Database:'
ENDIF
IF type2 = 'T'
   SELECT 4
   USE tempsrch INDEX tempname
   @6,22 SAY 'Temporary Placement Firm Database:'
ENDIF
STORE ' ' TO fname
@  8,17 SAY 'Records with no date in the ' + CHR(34) + 'Init Cont' + CHR(34) + ' field'
IF type2 = 'C'
   @  9,23 SAY 'and Y in the ' + CHR(34) + 'Direct Mail' + CHR(34) + ' field'
   @ 10,23 SAY 'will be exported to MERGLIST.DBF'
ELSE
   @  9,23 SAY 'will be exported to MERGLIST.DBF'
ENDIF
@ 13,25 SAY 'Press <Enter> to continue  ' GET fname
READ
IF type2 = 'C'
   COPY TO merglist FOR init_cont = CTOD('  /  /  ') .AND. dir_mail = 'Y'
ELSE
   COPY TO merglist FOR init_cont = CTOD('  /  /  ')
ENDIF
@ 13,0
SELECT 7
USE merglist
@ 13,12 SAY STR(RECCOUNT()) + ' records exported to MERGLIST.DBF'
@ 17,0
WAIT '                         Press any key to continue... '
CLOSE DATABASES
RETURN


*****************
PROCEDURE stopret
*****************

CLOSE FORMAT
RETURN TO MASTER


******************
PROCEDURE notvalid
******************

CLEAR
@ 10,18 SAY 'This function is not valid for this database.'
@ 15,14 SAY ' '
WAIT
RETURN


*: EOF: JOBUTIL.PRG

