*:*************************************************************************
*:
*:      Program: JOBREP.PRG
*:
*:       System: Job Search - Version 2.0
*:       Author: R. J. Kovach
*:
*:*************************************************************************
*:       Copyright (C) 1993, R.J. Kovach & Assoc.    ALL RIGHTS RESERVED
*:*************************************************************************
*:
*:Procs & Fncts: REPORTS        Main report menu
*:             : DIVORDER       Prints company data sorted by division
*:             : COMPCONT       Prints companies, phone #s & key contacts
*:             : TGTORDER       Prints list of target companies
*:             : CPYSALES       Prints companies within a sales range
*:             : COMPCHCE       Choose companies for printing (1 per page)
*:             : INDCOMP        Choose individual company for printing
*:             : PRNTDIV        Print complete company info (1 per page)
*:             : SRCHCHCE       Choose search firms for printing
*:             : SRCHLIST       Print search firms
*:             : SRCHCONT       Print search firm contact list
*:             : SRCHLABL       Print search firm labels
*:             : PROSPECT       Print search firm job prospect list
*:             : NETLIST        Print network list
*:             : REFERENCE      Print reference list
*:             : JBEXPEN        Print job hunting expenses
*:             : PRINTWAIT      Pause to make sure printer is on line
*:             : PRNTRESET      Reset printer
*:             : PRNT10         Set printer to 10 CPI
*:             : PRNT12         Set printer to 12 CPI
*:             : PRNT17         Set printer to 17 CPI
*:             : STOPRET        Returns to previous menu after pressing Esc
*:             : STOP           Interrupt printing
*:
*:         Uses: COMPANY.DBF
*:             : NETWORK.DBF
*:             : EXECSRCH.DBF
*:             : TEMPSRCH.DBF
*:             : JOBEXPEN.DBF
*:             : SIC.DBF
*:
*:   Memo Files: COMPANY.DBT
*:             : NETWORK.DBT
*:             : EXECSRCH.DBT
*:             : TEMPSRCH.DBT
*:
*:      Indexes: DIVISION.NDX
*:             : NETWORK.NDX
*:             : EXECNAME.NDX
*:             : TEMPNAME.NDX
*:             : JOBEXPEN.NDX
*:             : SICNO.NDX
*:             : SIC.NDX
*:
*: Report Forms: COMPANY.FRM
*:             : COMPANY2.FRM
*:             : COMPMEMO.FRM
*:             : EXECSRCH.FRM
*:             : EXECCONT.FRM
*:             : NETWORK.FRM
*:             : REFERENC.FRM
*:             : JOBEXPEN.FRM
*:             : EXECSRCH.LBL
*:
*:       Set by: JOBS.PRG
*:
*: Documented: 4/23/93
*: Revised:    6/01/93
*:*************************************************************************


******************
PROCEDURE register
******************

IF monidate <> CTOD('06/01/93')
   IF DATE() > monidate + 21
      DO registnow
   ENDIF
ENDIF
CLEAR
STORE ' ' TO enter
TEXT
                              JOBS, Release 2.0

        Copyright (c) 1993  R.J. Kovach & Assoc.  All Rights Reserved.

        This is an unlicensed copy of JOBS, to be used for evaluation
        only.  Thanks for giving JOBS a try.

        This application is shareware.  You may use and evaluate it for
        21 days, after which you must pay for it.

        The shareware registration fee for JOBS is $25.00.

        To register send a check, payable to R.J. Kovach & Associates,
        for $25.00 to:

                          R.J. Kovach & Associates
                              9 Canterbury Lane
                              Lebanon, NJ 08833
                            CompuServe 72315,1370

        I understand that I may evaluate JOBS for 21 days and that any
        any other use requires purchase of a license.

ENDTEXT
STORE 'YQ' TO msg
@ 24,8 SAY 'Press "Y" to agree to the above or "Q" to quit now (Y/Q)? ' GET enter PICTURE '!'
READ SAVE
DO WHILE .NOT. enter $ msg
   ?? CHR(7)
   READ SAVE
ENDDO
IF enter = 'Q'
   QUIT
ENDIF
RETURN


*******************
PROCEDURE registnow
*******************

CLEAR
STORE ' ' TO enter
TEXT


                              JOBS, Release 2.0





           Your 21 day trial period for evaluating JOBS has expired.

                          Please register JOBS now.






ENDTEXT
WAIT
RETURN


*****************
PROCEDURE reports
*****************

CLEAR
SET TALK OFF
CLEAR GETS
* ON KEY DO stop

DO WHILE .T.
   CLEAR
   IF monitor = 'C'
      SET COLOR TO &mcolor2
   ENDIF
   @3,8 TO 22,72
   @1,25 TO 3,53 DOUBLE
   IF monitor = 'C'
      SET COLOR TO &mcolor3
   ENDIF
   @2,9 SAY DATE()
   @2,57 SAY 'Printer = '
   IF moniprnt = 'E'
      @2,67 SAY 'Epson'
   ELSE
      IF moniprnt = 'L'
         @2,67 SAY 'Laserjet'
      ELSE
         @2,67 SAY 'IBM'
      ENDIF
   ENDIF
   IF monitor = 'C'
      SET COLOR TO &mcolor2
   ENDIF
   @2,28 SAY 'R E P O R T S   M E N U'
   IF monitor = 'C'
      SET COLOR TO &mcolor
   ENDIF
   @ 5,15 SAY '1> Print Companies in Division Order'
   @ 6,15 SAY '2> Print Company Key Contact List'
   @ 7,15 SAY '3> Print Target Companies'
   @ 8,15 SAY '4> Print Companies Within a Sales Range'
   @ 9,15 SAY '5> Print Complete Company Information (1 per page)'
   @11,15 SAY '6> Print Search Firm List'
   @12,15 SAY '7> Print Search Firm Key Contact List'
   @13,15 SAY '8> Print Search Firm List in Label Format'
   @14,15 SAY '9> Print Search Firm Job Prospect List'
   @16,15 SAY 'A> Print Network List'
   @18,15 SAY 'B> Print Reference List'
   @20,15 SAY 'C> Print Job Hunting Expenses'
   IF monitor = 'C'
      SET COLOR TO &mcolor5
   ENDIF
   @23,0 SAY ' '
   WAIT '                         Pick a number or type Q to Quit  ' TO choice
   IF monitor = 'C'
      SET COLOR TO &mcolor
   ENDIF

   DO CASE
   CASE choice = '1'
      DO divorder
   CASE choice = '2'
      DO compcont
   CASE choice = '3'
      DO tgtcomp
   CASE choice = '4'
      DO cpysales
   CASE choice = '5'
      DO compchce
   CASE choice = '6'
      DO srchchce
      DO srchlist
   CASE choice = '7'
      DO srchchce
      DO srchcont
   CASE choice = '8'
      DO srchchce
      DO srchlabl
   CASE choice = '9'
      DO srchchce
      DO prospect
   CASE UPPER(choice) = 'A'
      DO netlist
   CASE UPPER(choice) = 'B'
      DO reference
   CASE UPPER(choice) = 'C'
      DO jbexpense
   CASE UPPER(choice) = 'Q'
      ON KEY
      RETURN TO MASTER

   ENDCASE choice
ENDDO


******************
PROCEDURE divorder
******************

DO printwait
DO prnt17
SELECT 1
USE company INDEX division
REPORT FORM company HEADING 'COMPANY DATA SORTED BY DIVISION' FOR division <> '  ' TO PRINT
SET PRINT ON
?
? '        ***  Printed '+LTRIM(STR(RECCOUNT(),5,0))+' Records  ***'
EJECT
SET PRINT OFF
DO prntreset
RETURN


******************
PROCEDURE compcont
******************

DO printwait
DO prnt17
SELECT 1
USE company INDEX division
REPORT FORM compcont HEADING 'Companies and Key Contacts' TO PRINT
SET PRINT ON
?
? '        ***  Total Records = '+LTRIM(STR(RECCOUNT(),5,0))+'  ***'
EJECT
SET PRINT OFF
DO prntreset
RETURN


*****************
PROCEDURE tgtcomp
*****************

CLEAR
PRIVATE rcds, tgt
STORE 0 TO rcds
STORE ' ' TO tgt
@ 10,10 SAY ' '
ACCEPT '                Search TARGET field for ... ' TO tgt
CLEAR
DO printwait
DO prnt12
SELECT 1
USE company INDEX division
REPORT FORM company2 HEADING 'POTENTIAL TARGET COMPANIES' FOR target = tgt TO PRINT
GO TOP
DO WHILE .NOT. EOF()
   IF target = tgt
      rcds = rcds + 1
   ENDIF
   SKIP
   LOOP
ENDDO
SET PRINT ON
?
? '        ***  Printed '+LTRIM(STR(rcds,5,0))+' of '+LTRIM(STR(RECCOUNT(),5,0))+' Records       ***'
? '        ***  Selection criteria: TARGET = '+tgt+'  ***'
EJECT
SET PRINT OFF
DO prntreset
RETURN


******************
PROCEDURE cpysales
******************

CLEAR
PRIVATE minsls, maxsls, rcds
STORE 0 TO rcds
@ 5,10 SAY ' '
INPUT '          Minimum sales (in $ MM) ' TO minsls
@ 7,10 SAY ' '
INPUT '          Maximum sales (in $ MM) ' TO maxsls
CLEAR
DO printwait
DO prnt17
SELECT 1
USE company INDEX division
REPORT FORM company HEADING 'COMPANY DATA FOR SALES BETWEEN '+STR(minsls,4,1)+' AND '+STR(maxsls,4,1)+' MILLION' FOR sales >= minsls .AND. sales <= maxsls TO PRINT
GO TOP
DO WHILE .NOT. EOF()
   IF sales >= minsls .AND. sales <= maxsls
      rcds = rcds + 1
   ENDIF
   SKIP
   LOOP
ENDDO
SET PRINT ON
?
? '        ***  Printed '+LTRIM(STR(rcds,5,0))+' of '+LTRIM(STR(RECCOUNT(),5,0))+' Records  ***'
EJECT
SET PRINT OFF
DO prntreset
RETURN


******************
PROCEDURE compchce
******************

DO WHILE .T.
   CLEAR
   CLOSE DATABASES
   @7,19 SAY 'Choose Type of Report:'
   @10,30 SAY 'I> Individual Company'
   @13,30 SAY 'T> Group of Companies by Target Field'
   @16,30 SAY 'S> Group of Companies Within a Sales Range'
   @19,0 SAY ' '
   WAIT '                Choose I, T or S  ' TO choice
   DO CASE
   CASE UPPER(choice) = 'I'
      DO indcomp
      RETURN
   CASE UPPER(choice) = 'T'
      CLEAR
      PRIVATE rcds, tgt
      STORE 0 TO rcds
      STORE ' ' TO tgt
      @ 10,10 SAY ' '
      ACCEPT '                Search TARGET field for ... ' TO tgt
      CLEAR
      DO printwait
      DO prnt10
      SELECT 6
      USE sic INDEX sicno
      SELECT 1
      USE company INDEX division
      DO WHILE .NOT. EOF()
         IF target = tgt
            DO prntdiv
         ENDIF
         SKIP
         LOOP
      ENDDO
      DO prntreset
      RETURN
   CASE UPPER(choice) = 'S'
      CLEAR
      PRIVATE minsls, maxsls, rcds
      STORE 0 TO rcds
      @ 5,10 SAY ' '
      INPUT '          Minimum sales (in $ MM) ' TO minsls
      @ 7,10 SAY ' '
      INPUT '          Maximum sales (in $ MM) ' TO maxsls
      CLEAR
      DO printwait
      DO prnt10
      SELECT 6
      USE sic INDEX sicno
      SELECT 1
      USE company INDEX division
      DO WHILE .NOT. EOF()
         IF sales >= minsls
            IF sales <= maxsls
               DO prntdiv
            ENDIF
         ENDIF
         SKIP
         LOOP
      ENDDO
      DO prntreset
      RETURN
   ENDCASE
ENDDO


*****************
PROCEDURE indcomp
*****************

CLEAR
* DO printwait
SELECT 1
USE company INDEX division
SELECT 6
USE sic INDEX sicno
* DO prnt10
SELECT 1
STORE ' ' TO div
STORE ' ' TO divcomp
DO WHILE .NOT. EOF()
   CLEAR
   @ 11,5 SAY ' '
   ACCEPT '    Enter the division to be edited or press [Esc] to quit:  ' TO div
   ON ESCAPE DO stopret
   SEEK UPPER(div)
   IF FOUND()
      STORE division TO divcomp
      SET FUNCTION 2 TO divcomp
      DO prnt10
      DO prntdiv
      IF EOF()
         ? 'No additional records found.'
         WAIT
         GO TOP
         RETURN
      ENDIF
   ELSE
      ?
      ? 'This division is not in the file'
      WAIT
      CLEAR
      GO TOP
      LOOP
   ENDIF
ENDDO


*****************
PROCEDURE prntdiv1
*****************

SET DEVICE TO PRINT
SELECT 1
IF moniprnt = 'E'
   @ 2,35 SAY CHR(27)+'4'+'Company Prospect'+CHR(27)+'5'
ELSE
   @ 2,35 SAY 'Company Prospect'
ENDIF
@ 6, 8 SAY 'Division:'
IF moniprnt = 'L'
   @ 6,20 SAY CHR(27)+'E'+division
ELSE
   @ 6,20 SAY CHR(27)+'G'+CHR(27)+'E'+CHR(14)+division
ENDIF
@ 8, 8 SAY CHR(27)+'H'+CHR(27)+'F'+'Parent Co.:'
@ 8,20 SAY CHR(27)+'G'+CHR(27)+'E'+company
@ 9, 8 SAY CHR(27)+'H'+CHR(27)+'F'+'Address:'
@ 9,24 SAY CHR(27)+'G'+CHR(27)+'E'+address
@10,20 SAY TRIM(city)+', '+state+' '+zip
@12, 8 SAY CHR(27)+'H'+CHR(27)+'F'+'Phone:'+CHR(27)+'G'+CHR(27)+'E'
@12,28 SAY TRANSFORM(VAL(phone),'(999)999-9999')
@12,49 SAY CHR(27)+'H'+CHR(27)+'F'+'DUNS #:'+CHR(27)+'G'+CHR(27)+'E'
@12,49 SAY LEFT(duns,2)+'-'+SUBSTR(duns,3,3)+'-'+RIGHT(duns,4)
@14, 8 SAY CHR(27)+'H'+CHR(27)+'F'+'Sales:'+CHR(27)+'G'+CHR(27)+'E'
IF sales >0
   @14,28 SAY sales PICTURE '9,999.9'
   @14,28 SAY 'million'
ELSE
   @14,28 SAY 'N/A'
ENDIF
@14,38 SAY CHR(27)+'H'+CHR(27)+'F'+'Employees:'+CHR(27)+'G'+CHR(27)+'E'
IF employees >0
   @14,49 SAY employees PICTURE '999,999'
ELSE
   @14,49 SAY 'N/A'
ENDIF
@16, 8 SAY CHR(27)+'H'+CHR(27)+'F'+'Sq ft:'+CHR(27)+'G'+CHR(27)+'E'
IF sq_ft >0
   @16,28 SAY sq_ft PICTURE '999,999'
ELSE
   @16,28 SAY 'N/A'
ENDIF
@16,50 SAY CHR(27)+'H'+CHR(27)+'F'+'Acres:'+CHR(27)+'G'+CHR(27)+'E'
IF acres >0
   @16,49 SAY acres
ELSE
   @16,49 SAY 'N/A'
ENDIF
@16,60 SAY CHR(27)+'H'+CHR(27)+'F'+'Year Estab.:'+CHR(27)+'G'+CHR(27)+'E'
IF establish = ' '
   @16,73 SAY 'N/A'
ELSE
   @16,73 SAY establish
ENDIF
@18, 8 SAY CHR(27)+'H'+CHR(27)+'F'+'Product:'+CHR(27)+'G'+CHR(27)+'E'
@19,12 SAY product
@21, 8 SAY CHR(27)+'H'+CHR(27)+'F'+'SIC Codes:'+CHR(27)+'G'+CHR(27)+'E'
SET RELATION TO code1 INTO sic
@21,20 SAY code1
@21,26 SAY sic->descript
SET RELATION TO code2 INTO sic
@22,20 SAY code2
@22,26 SAY sic->descript
SET RELATION TO code3 INTO sic
@23,20 SAY code3
@23,26 SAY sic->descript
SET RELATION TO code4 INTO sic
@24,20 SAY code4
@24,26 SAY sic->descript
@26, 8 SAY CHR(27)+'H'+CHR(27)+'F'+'Contact:'+CHR(27)+'G'+CHR(27)+'E'
@26,24 SAY RTRIM(contact)+', '+TRIM(title)
@28, 8 SAY CHR(27)+'H'+CHR(27)+'F'+'Info Source:'+CHR(27)+'G'+CHR(27)+'E'
@28,21 SAY source
@28,48 SAY CHR(27)+'H'+CHR(27)+'F'+'Status:'+CHR(27)+'G'+CHR(27)+'E'
@28,56 SAY RTRIM(status)
* @30, 8 SAY CHR(27)+'H'+CHR(27)+'F'+'Comments:'+CHR(27)+'G'+CHR(27)+'E'
REPORT FORM compmemo NOEJECT PLAIN RECORD RECNO() TO PRINT
set device to screen
SET PRINT ON
?? CHR(27)+'H'+CHR(27)+'F'
EJECT
SET PRINT OFF
RETURN


*****************
PROCEDURE prntdiv
*****************

SET DEVICE TO PRINT
SELECT 1
IF moniprnt = 'E'
   @ 1,35 SAY CHR(27)+'4'+'Company Prospect'+CHR(27)+'5'
ELSE
   @ 1,35 SAY 'Company Prospect'
ENDIF
@ 4, 8 SAY 'Division:'
IF moniprnt = 'L'
   @ 4,20 SAY CHR(27)+'E'+division
ELSE
   @ 4,20 SAY CHR(27)+'E'+CHR(14)+division
ENDIF
@ 6, 8 SAY CHR(27)+'F'+'Parent Co.:'
@ 6,20 SAY CHR(27)+'E'+company
@ 7, 8 SAY CHR(27)+'F'+'Address:'
@ 7,22 SAY CHR(27)+'E'+address
@ 9,20 SAY TRIM(city)+', '+state+' '+zip
@10, 8 SAY CHR(27)+'F'+'Phone:'+CHR(27)+'E'
@10,24 SAY TRANSFORM(VAL(phone),'(999)999-9999')
@10,45 SAY CHR(27)+'F'+'DUNS #:'+CHR(27)+'E'
@10,49 SAY LEFT(duns,2)+'-'+SUBSTR(duns,3,3)+'-'+RIGHT(duns,4)
@12, 8 SAY CHR(27)+'F'+'Sales:'+CHR(27)+'E'
IF sales >0
   @12,24 SAY sales PICTURE '99,999.9'
   @12,33 SAY 'million'
ELSE
   @12,24 SAY 'N/A'
ENDIF
@12,42 SAY CHR(27)+'F'+'Employees:'+CHR(27)+'E'
IF employees >0
   @12,49 SAY employees PICTURE '999,999'
ELSE
   @12,49 SAY 'N/A'
ENDIF
@14, 8 SAY CHR(27)+'F'+'Sq ft:'+CHR(27)+'E'
IF sq_ft >0
   @14,24 SAY sq_ft PICTURE '999,999'
ELSE
   @14,24 SAY 'N/A'
ENDIF
@14,46 SAY CHR(27)+'F'+'Acres:'+CHR(27)+'E'
IF acres >0
   @14,49 SAY acres
ELSE
   @14,49 SAY 'N/A'
ENDIF
@14,60 SAY CHR(27)+'F'+'Year Estab.:'+CHR(27)+'E'
IF establish = ' '
   @14,73 SAY 'N/A'
ELSE
   @14,73 SAY establish
ENDIF
@16, 8 SAY CHR(27)+'F'+'Product:'+CHR(27)+'E'
@17,12 SAY product
@19, 8 SAY CHR(27)+'F'+'SIC Codes:'+CHR(27)+'E'
SET RELATION TO code1 INTO sic
@19,24 SAY code1
@19,30 SAY sic->descript
SET RELATION TO code2 INTO sic
@20,20 SAY code2
@20,26 SAY sic->descript
SET RELATION TO code3 INTO sic
@21,20 SAY code3
@21,26 SAY sic->descript
SET RELATION TO code4 INTO sic
@22,20 SAY code4
@22,26 SAY sic->descript
@24, 8 SAY CHR(27)+'F'+'Contact:'+CHR(27)+'E'
@24,24 SAY RTRIM(contfirst)+' '+RTRIM(contlast)+', '+TRIM(title)
@26, 8 SAY CHR(27)+'F'+'Info Source:'+CHR(27)+'E'
@26,21 SAY source
@26,48 SAY CHR(27)+'F'+'Status:'+CHR(27)+'E'
@26,56 SAY RTRIM(status)
IF monidb = 'F'
   @28, 8 SAY CHR(27)+'F'+'Comments:'+CHR(27)+'E'
   @30, 0
ENDIF
REPORT FORM compmemo NOEJECT PLAIN RECORD RECNO() TO PRINT
set device to screen
SET PRINT ON
?? CHR(27)+'F'
EJECT
SET PRINT OFF
RETURN


******************
PROCEDURE srchchce
******************

DO WHILE .T.
   CLEAR
   CLOSE DATABASES
   @7,19 SAY 'Choose Database:'
   @10,30 SAY 'E> Executive Search Firm Database'
   @13,30 SAY 'T> Temporary Placement Firm Database'
   @16,0 SAY ' '
   WAIT '                  Choose E or T  ' TO choice
   DO CASE
   CASE UPPER(choice) = 'E'
      STORE 'E' To type2
      RETURN
   CASE UPPER(choice) = 'T'
      STORE 'T' TO type2
      RETURN
   ENDCASE
ENDDO


******************
PROCEDURE srchlist
******************

DO printwait
DO prnt17
IF type2 = 'E'
   SELECT 3
   USE execsrch INDEX execname
   REPORT FORM execsrch HEADING 'EXECUTIVE SEARCH FIRMS' FOR name <> '  ' TO PRINT
ELSE
   SELECT 4
   USE tempsrch INDEX tempname
   REPORT FORM execsrch HEADING 'TEMPORARY PLACEMENT SEARCH FIRMS' FOR name <> '  ' TO PRINT
ENDIF
SET PRINT ON
?
? '        ***  Total Records = '+LTRIM(STR(RECCOUNT(),5,0))+'  ***'
EJECT
SET PRINT OFF
DO prntreset
CLOSE DATABASES
RETURN


******************
PROCEDURE srchcont
******************

DO printwait
DO prnt17
IF type2 = 'E'
   SELECT 3
   USE execsrch INDEX execname
   REPORT FORM execcont HEADING 'Executive Search Firms and Key Contacts' TO PRINT
ELSE
   SELECT 4
   USE tempsrch INDEX tempname
   REPORT FORM execcont HEADING 'Temporary Placement Search Firms and Key Contacts' TO PRINT
ENDIF
SET PRINT ON
?
? '        ***  Total Records = '+LTRIM(STR(RECCOUNT(),5,0))+'  ***'
EJECT
SET PRINT OFF
DO prntreset
CLOSE DATABASES
RETURN


******************
PROCEDURE srchlabl
******************

DO printwait
DO prnt10
IF type2 = 'E'
   SELECT 3
   USE execsrch INDEX execname
ELSE
   SELECT 4
   USE tempsrch INDEX tempname
ENDIF
LABEL FORM execsrch FOR DTOC(init_cont) = '  /  /  ' TO PRINT
DO prntreset
CLOSE DATABASES
RETURN


******************
PROCEDURE prospect
******************

DO printwait
DO prnt17
STORE 0 TO rcds
IF type2 = 'E'
   SELECT 3
   USE execsrch INDEX execname
   REPORT FORM execsrch HEADING 'EXECUTIVE SEARCH FIRM JOB PROSPECTS' FOR prospect = 'Y' TO PRINT
ELSE
   SELECT 4
   USE tempsrch INDEX tempname
   REPORT FORM execsrch HEADING 'TEMPORARY PLACEMENT SEARCH FIRM JOB PROSPECTS' FOR prospect = 'Y' TO PRINT
ENDIF
GO TOP
DO WHILE .NOT. EOF()
   IF prospect = 'Y'
      rcds = rcds + 1
   ENDIF
   SKIP
   LOOP
ENDDO
SET PRINT ON
?
? '        ***  Printed '+LTRIM(STR(rcds,5,0))+' of '+LTRIM(STR(RECCOUNT(),5,0))+' Records       ***'
? '        ***  Selection criteria: PROSPECT not blank  ***'
EJECT
SET PRINT OFF
DO prntreset
CLOSE DATABASES
RETURN


*****************
PROCEDURE netlist
*****************

DO printwait
DO prnt17
SELECT 2
USE network INDEX network
REPORT FORM network TO PRINT
SET PRINT ON
?
? '        ***  Total Records = '+LTRIM(STR(RECCOUNT(),5,0))+'  ***'
EJECT
SET PRINT OFF
DO prntreset
RETURN


*******************
PROCEDURE reference
*******************

CLEAR
PRIVATE rcds
STORE 0 TO rcds
DO printwait
DO prnt10
SELECT 2
USE network INDEX network
REPORT FORM referenc FOR reference = 'Y' TO PRINT
GO TOP
DO WHILE .NOT. EOF()
   IF reference = 'Y'
      rcds = rcds + 1
   ENDIF
   SKIP
   LOOP
ENDDO
SET PRINT ON
?
? '        ***  Printed '+LTRIM(STR(rcds,5,0))+' of '+LTRIM(STR(RECCOUNT(),5,0))+' Records  ***'
EJECT
SET PRINT OFF
DO prntreset
RETURN


*******************
PROCEDURE jbexpense
*******************

CLEAR
PRIVATE mamt, mmil
STORE 0 TO mamt, mmil
DO printwait
DO prnt10
SELECT 5
USE jobexpen INDEX jobexpen
REPORT FORM jobexpen TO PRINT
SUM amount TO mamt
SUM miles TO mmil
mtot = mamt + (mmil * monimile)
SET PRINT ON
?
? '      ***  Total Expenses = $' + TRANSFORM(mtot,"99,999.99") + '  ***'
EJECT
SET PRINT OFF
DO prntreset
RETURN


*******************
PROCEDURE printwait
*******************

CLEAR
@4,20 SAY 'Make sure the printer is ready and on line.'
@8,20 SAY '  '
WAIT
CLEAR
RETURN


*******************
PROCEDURE prntreset
*******************

SET PRINT ON
IF moniprnt = 'E'
   ?? CHR(27)+'@'            && Reset Epson
ELSE
   IF moniprnt = 'L'
      ?? CHR(27)+'E'         && Reset Laserjet
   ELSE                      && moniprnt = I
      ?? CHR(18)             && Set IBM to 10 CPI
   ENDIF
ENDIF
SET PRINT OFF
RETURN


****************
PROCEDURE prnt10
****************

SET PRINT ON
IF moniprnt = 'E'
   ?? CHR(27)+'@'            && Reset Epson
ELSE
   IF moniprnt = 'L'
      ?? CHR(27)+'E'         && Reset Laserjet
   ELSE                      && moniprnt = I
      ?? CHR(18)             && Set IBM to 10 CPI
   ENDIF
ENDIF
SET PRINT OFF
RETURN


****************
PROCEDURE prnt12
****************

SET PRINT ON
IF moniprnt = 'E'
   ?? CHR(27)+'@'            && Reset Epson
   ?? CHR(27)+'M'            && Set to 12 CPI
ELSE
   IF moniprnt = 'L'
      ?? CHR(27)+'E'         && Reset Laserjet
      ?? CHR(27)+'(s12H'     && Set to 12 CPI
   ELSE                      && moniprnt = I
      ?? CHR(27)+':'         && Set IBM to 12 CPI
   ENDIF
ENDIF
SET PRINT OFF
RETURN


****************
PROCEDURE prnt17
****************

SET PRINT ON
IF moniprnt = 'E'
   ?? CHR(27)+'@'            && Reset Epson
   ?? CHR(15)                && Set to 17 CPI
ELSE
   IF moniprnt = 'L'
      ?? CHR(27)+'E'         && Reset Laserjet
      ?? CHR(27)+'(s16.66H'  && Set to 16.66 CPI
   ELSE                      && moniprnt = I
      ?? CHR(15)             && Set IBM to 17 CPI
   ENDIF
ENDIF
SET PRINT OFF
RETURN


*****************
PROCEDURE stopret
*****************

CLOSE FORMAT
RETURN TO MASTER


**************
PROCEDURE stop
**************

i = INKEY()
WAIT "Press A to abort printing, " +;
"any other key to continue:  " TO choice
IF choice $ "Aa"
   EJECT
   ON KEY
   ON ERROR
   SET DEVICE TO SCREEN
   RETURN TO MASTER
ELSE
   RETURN
ENDIF



*: EOF JOBREP.PRG

