/********************************************************
 * CONFIGURATION FILE FOR THE GN PACKAGE (vers 2.23)
 ********************************************************/

/********************************************************
 * Compulsory items to fill in.
 ********************************************************/


#define GN_HOSTNAME	"your.host.edu"
/*
 * Enter your fully qualified host name here
 */


#define ROOT_DIR	"/your/root/data/dir"
/*
 * Enter the complete path of your root data directory here.
 */

#define SUN_OS4
/*
   Pick one of the following Operating System types which describes
   your system and replace the SUN_OS4 value above

   AIX, AUX, BSD_386, CONVEX_0S, HPUX, IRIX, LINUX, NEXT, OSF1, PYRAMID,
   SCO, SEQUENT, SOLARIS2, SUN_OS4, SVR4, ULTRIX, OTHER

   I have no way to test all these, let me know if something doesn't work
   or is incomplete.  If you pick OTHER you must edit the last few lines
   of this file per the directions there.
*/

#define MAINTAINER	"mailto:your.name@your.host.edu"
/*
 * Enter "mailto:" followed by the e-mail address of the individual
 * responsible for maintaining your server.  This is a default and
 * can be changed on a per directory basis.  It is used only by WWW
 * clients.
 */


#define ROOT_MENU_NAME	"GN --  A Gopher/HTTP Server"
/*
 * Enter a name for your root directory.  This is used by WWW only, 
 * there is no way for a gopher server to specify the title of the
 * root menu.
 */

/*
#define NO_MENU_TITLES
*/
/*
 * Uncomment this if you do not want GN to put <H2>menu title</h2> at
 * the start of each menu displayed for HTTP clients.  Of course
 * the "menu name" here is one of the names you provide in the menu files.
 */

#define GN_LOGFILE  "" 			/* "/path/to/gn.log" */

/*
 * Full path of the file you want to use for a log file.  Replace
 * the empty string with the complete path like "/path/to/gn.log"
 * to turn on logging.  You can also use the -L command line 
 * option.  If you do both the -L option takes priority.
 */


#define MIME_TYPE_FILE  "/path/to/src/mkcache/gn_mime.types"
/*
 * This file contains information permitting mkcache to translate 
 * ascertain the MIME "Content-type" from the suffix of a file name
 * together with the gopher type of the file.  This information is
 * necessary for HTTP/1.0 clients to know how to display
 * files.  If this file is not present mkcache will issue a warning
 * but use internal default values.  The file exists so that you
 * can add to it if you wish to add new kinds of documents to your
 * server.  The format of the file is explained in the file.
 * The default version of the file is in mkcache/gn_mime.types.
 * The internal defaults are the same as what is currently in this
 * file.
 */


#define WAISGN  "/usr/local/etc/waisgn"
/*
 * This is the complete path name of the waisgn program which 
 * handles WAIS indexes.  If you do not use WAIS indexing use 
 * a value of "".
 * NOTE: THIS MUST BE THE SAME AS $(SERVBINDIR)/waisgn AS SERVBINDIR
 * IS DEFINED IN THE MAKEFILE IF YOU USE MAKE INSTALL TO INSTALL waisgn.
 */

/*
#define FORBID_EXEC
*/

/*
 * Uncomment this if you wish to forbid the use of the use of exec
 * or CGI scripts on your host.  This will enhance security but will,
 * of course, decrease functionality.
 */


/*
 ****************************************************************
 * This is the end of the compulsory fill out items (unless you
 * picked OTHER as your OS type above).  If you wish you can change
 * the following defaults; it is a good idea to at least look them
 * over.
 ****************************************************************
 */


#define USERID		(65534)
#define GROUPID		(65534)
/*
 * These are the group and user id you want the server to switch to when
 * running inetd or when sgn is run by root.  They are also used by gn running
 * under inetd and in this case should agree with the uid you set in 
 * inetd.conf.  If you are using gn and can't set the uid in your inetd.conf
 * (e.g. Ultrix) be sure to #define SET_UID (uncomment it in this file below).
 */


#define DEFAULTPORT	"70"
/*
 * If you wish to run at a different port than 70, edit this line.
 */

#define DECOMPRESS	"/usr/local/bin/zcat"
/*
 * This is the program which does "on the fly" decompression
 */


#define ACCESSFNAME	".access"

#define CACHEFNAME	".cache"

#define MENUFNAME	"menu"

/* If you change CGI_EXT, set its length correctly! */
#define CGI_EXT		".cgi"
#define CGI_EXT_LEN	(4)

/* If you change HTML_EXT, set its length correctly! */
#define HTML_EXT	".html"
#define HTML_EXT_LEN	(5)

#define TEMPDIR		"/tmp"

#define MAXDEPTH	(10)    /* maximum depth of menus to search */

#define TIMEOUT (600)		/* Time in seconds to wait before timeout */
				/* Ten minutes should be adequate except
				   for very long downloads */


#define SEARCHABLE_ROOT	TRUE
/*
 * Change to FALSE to prevent searching of the items in the root directory
 */



/*
 * #define GOPHERD_LOG_STYLE
 * #define OLDGN_LOG_STYLE
 * Uncomment one of these for log files like those of gopherd or gn 
 * in versions before 2.0.
 */

/*
 * #define EXPLICIT_CACHE
 *
 * Ucomment this if you want to use "explicit caches" included in
 * parentheses in the path.  Of course, if you do then you can't
 * put parentheses in your pathnames.  (You shouldn't anyway).
 * I don't use this myself, because everything I would do with them
 * I seem to be able to accomplish without them.  I have thought a lot
 * about the security implications of this also.  I believe it is 
 * secure, but I am more comfortable without it.
 * 
 */

/*
 * #define DO_LINGER
 *
 * Uncomment this if you have problems with truncated documents being
 * returned to requests from remote hosts.
 *
 */


#define SYSLOG43
/*
 * Set this if you have a 4.3-style openlog() with three arguments.  Unset
 * it if you have 4.2-style openlog() with one argument.  This has no
 * effect if NO_SYSLOG is set.
 */

#define LOGFACILITY   LOG_DAEMON
/*
 * Change this if you wish to use a local syslog facility.  This only has
 * effect if you are using the "-S" option.
 *
 */


/********************************************************
 * Edit the lines in this section if you chose OTHER as 
 * your OS type.
 ********************************************************/


#ifdef OTHER   /* Don't change this */


#define BSD
/*
 * This should be defined if your system is BSD-like, i.e. tends
 * to use BSD system calls rather than SysV system calls.
 */


/* #define NO_FLOCK */
/*
 * Uncomment this if your system does not have the flock() system call.
 * Doing this means that if more than one client is using your server 
 * at the same time, your logfile might be garbled.  There are no other
 * ill effects.
 *
 */


/*
 * #define SET_UID
 *
 *  Uncomment this if you are using an inetd without the capability 
 *  to set UID on startup (e.g., Ultrix). The user id and group id
 *  under which gn runs will then be set to the values of USERID and
 *  GROUPID set above.
 */

/*
 * #define NO_SYSLOG
 *
 * Uncomment this if your system does not have the openlog()/syslog()
 * system calls.  Doing this means that you won't be able to have your
 * log entries put in the system log ( the "-S" option to gn).  You
 * can still use the "-L" option to write the entries to a named log file.
 *
 */

/*
 * #define NO_VOID_PTR
 *
 * Uncomment this if your compiler does not support void pointers.
 *
 */

/*
 * #define NEED_PUTENV
 *
 * Uncomment this if your compiler library does not have the function
 * putenv().  
 *
 */

/*
 * #define NEED_STRFTIME
 *
 * Uncomment this if your compiler library does not have the function
 * strftime()
 *
 */

/*
 * #define NEED_STRSTR
 *
 * Uncomment this if your compiler library does not have the function
 * strstr()
 *
 */

/*
 * #define NEED_STRNCASECMP
 *
 * Uncomment this if your compiler library does not have the function
 * strcasecmp()
 *
 */

#endif

/*************************************************************
 * Hopefully you shouldn't need to change things below here.
 *************************************************************/

#if defined(SUN_OS4)
#define BSD
#endif

#if defined(BSD_386)

#ifndef BSD
#define BSD
#endif

#endif

#if defined(SOLARIS2)
#define bzero(A,B)   memset((void *)(A),0,(B))
#undef BSD
#endif

#if defined(AIX) || defined(IRIX)
#undef BSD
#endif

#if defined(HPUX)
#undef BSD
#define _HPUX_SOURCE
#endif

#if defined(ULTRIX)
#define BSD
#define SET_UID
#endif

#if defined(OSF1)
#define BSD
#define _BSD
#endif

#if defined(SEQUENT)
#define BSD
#define NO_SETSID
#endif

#if defined(NEXT)
#define BSD
#define NEED_PUTENV
#define NO_SETSID
#define _POSIX_SOURCE
typedef int pid_t;

#ifndef S_ISDIR
#define S_ISDIR(m)      (((m)&(S_IFMT)) == (S_IFDIR))
#endif

#endif

#if defined(LINUX) || defined(SCO) || defined(CONVEX_OS)
#define DO_LINGER
#undef BSD
#endif

#if defined(PYRAMID)
#define NEED_PUTENV
#define NEED_STRFTIME
#define NO_SETSID
#define NEED_STRSTR
#endif

#if defined(AUX)
#undef BSD
#define _POSIX_SOURCE
#endif

#if defined(SVR4)
#define bzero(A,B)   memset((void *)(A),0,(B))
#define DO_LINGER
#define NEED_STRNCASECMP
#endif

