// DoublePoint - a double version of java.awt.point
//
// Copyright (C) 1996 by Jef Poskanzer <jef@acme.com>.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// Visit the ACME Labs Java page for up-to-date versions of this and other
// fine Java utilities: http://www.acme.com/java/

package Acme;

import java.util.*;

/// A double version of java.awt.point.
// <P>
// <A HREF="/resources/classes/Acme/DoublePoint.java">Fetch the software.</A><BR>
// <A HREF="/resources/classes/Acme.tar.Z">Fetch the entire Acme package.</A>

public class DoublePoint extends Acme.GenericCloneable
    {

    public double x, y;

    public DoublePoint()
	{
	}

    public DoublePoint( double x, double y )
	{
	this.x = x;
	this.y = y;
	}

    public void move( double x, double y )
	{
	this.x = x;
	this.y = y;
	}	

    public void translate( double dx, double dy )
	{
	x += dx;
	y += dy;
	}	

    public int hashCode()
	{
	return (int)
	    ( Double.doubleToLongBits( x ) ^
	      ( Double.doubleToLongBits( y ) * 31 ) );
	}

    public boolean equals( Object obj )
	{
	if ( ! ( obj instanceof DoublePoint ) )
	    return false;
	DoublePoint fp = (DoublePoint) obj;
	return ( x == fp.x ) && ( y == fp.y );
	}

    public String toString()
	{
	return getClass().getName() + "[x=" + x + ",y=" + y + "]";
	}

    }
