/*

     ABRAXAS SOFTWARE, PCLEX example

     mdate.c - main program and semantic action routines

     this example program is from the July 1978, Bell System Tech. Journal
     "Language develoment tools", pp.2155 by Johnson and Lesk.
     We believe this is an excellent example of the "marriage" 
     between yacc and lex.
*/

#include <stdio.h>

int noleap[] = {

  0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31

  };

int leap[] = {

  0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 

  };

char * dayname[] = {

  "Sunday",
  "Monday",
  "Tuesday",
  "Wednesday",
  "Thursday",
  "Friday",
  "Saturday",

  };


main()
{
  yyparse(); /* generated by pcyacc */
}


showday( month, day, year )
int month, day, year;
{

  int *daysin;

  printf( "mon=%d day=%d year=%d\n", month, day, year );


  daysin = isleap( year ) ? leap : noleap;

  if ( month < 1 || month > 12 ) { 

     printf( "month out of range\n" ); return;
  }

  if ( day < 1 || day > daysin[month] ) {

     printf( "day of month out of range\n" ); return;
  }

  while ( month > 1 ) day += daysin[--month]; /* sum days of prev. months */

  if ( year > 0 ) { /* from jan 1, 0000 */

     --year;

     day += year;

     day += year / 4 - year/100 + year/400;
  }

  printf( "   %s\n", dayname[day%7] );
}

isleap( year )
int year;
{
  if ( year % 4  !=  0 ) return( 0 );

  if ( year % 100  != 0 ) return( 1 );

  if ( year % 400  != 0 ) return( 0 );

  return( 1 );

}


     
     
