
		{--------------------------------}
                {         FKEY   V 1.1           }
                {      ।         }
                {   楤  㭪樮   }
                {       㣨 蠬         }
                {   Turbo Pascal 5.5 }
                {			         }
                {    (c), 1990  ᫠     }
                {--------------------------------}

UNIT fkey11;

{$F+,O+,D-,R-,S-,I-}

INTERFACE       { 䥩᭠ ᥪ }

USES Crt, Def;

{----------------------------------------------------------}

CONST          {   㭪樮쭮  }
     f1 = #59;  {           ( ᫥ ESC )               }
     f2 = #60;
     f3 = #61;
     f4 = #62;
     f5 = #63;
     f6 = #64;
     f7 = #65;
     f8 = #66;
     f9 = #67;
     f10 = #68;

     Shift_f1 = #84;
     Shift_f2 = #85;
     Shift_f3 = #86;
     Shift_f4 = #87;
     Shift_f5 = #88;
     Shift_f6 = #89;
     Shift_f7 = #90;
     Shift_f8 = #91;
     Shift_f9 = #92;
     Shift_f10 =#93;

     Ctl_f1 = #94;
     Ctl_f2 = #95;
     Ctl_f3 = #96;
     Ctl_f4 = #97;
     Ctl_f5 = #98;
     Ctl_f6 = #99;
     Ctl_f7 = #100;
     Ctl_f8 = #101;
     Ctl_f9 = #102;
     Ctl_f10 =#103;

     Alt_f1 = #104;
     Alt_f2 = #105;
     Alt_f3 = #106;
     Alt_f4 = #107;
     Alt_f5 = #108;
     Alt_f6 = #109;
     Alt_f7 = #110;
     Alt_f8 = #111;
     Alt_f9 = #112;
     Alt_f10 =#113;

     Arrow_down = #80;
     Arrow_up = #72;
     Arrow_left = #75;
     Arrow_right = #77;
     Page_down = #81;
     Page_up = #73;
     Key_home = #71;
     Key_end = #79;
     Key_ins = #82;
     Key_del = #83;

     Shift_tab = #15;

     Ctl_Arrow_left = #115;
     Ctl_Arrow_right = #116;
     Ctl_Page_up = #132;
     Ctl_Page_down = #118;
     Ctl_Key_end = #117;
     Ctl_Key_home = #119;

     Alt_Q = #16;
     Alt_W = #17;
     Alt_E = #18;
     Alt_R = #19;
     Alt_T = #20;
     Alt_Y = #21;
     Alt_U = #22;
     Alt_I = #23;
     Alt_O = #24;
     Alt_P = #25;
     Alt_A = #30;
     Alt_S = #31;
     Alt_D = #32;
     Alt_F = #33;
     Alt_G = #34;
     Alt_H = #35;
     Alt_J = #36;
     Alt_K = #37;
     Alt_L = #38;
     Alt_Z = #44;
     Alt_X = #45;
     Alt_C = #46;
     Alt_V = #47;
     Alt_B = #48;
     Alt_N = #49;
     Alt_M = #50;

{----------------------------------------------------------}

TYPE
    pointer_fkey = ^control_func_key;
                   { 㪠⥫  쥪 ࠢ }
                   { 㭪樮쭮 ன     }

    func_key = ARRAY [ 0..255 ] OF RunProcedure;
    logical = ARRAY [ 0..255 ] OF BOOLEAN;
                   {  㪠⥫  楤  }
                   {     믮塞       }
                   {     㭪樮       }

    parameters = RECORD   { ࠬ }

                       point_param : ARRAY [ 0..255 ] OF POINTER;
                       size_param : ARRAY [ 0..255 ] OF WORD
                 END;

    control_func_key = OBJECT
    		   { 쥪  ࠢ 㭪樮쭮 }
                   {          ன                }

                   up : pointer_fkey;
                               { 㪠⥫  ᫥騩  }
                               {      楯窥 쥪       }

                   point_proc : ^func_key;
                               { 㪠⥫   㪠⥫ }
                               {           楤            }

                   label_proc : ^logical;
                               { ⪨  ⠭ 楤 }

                   param : ^parameters;
                               { ࠬ 쥪 }

                   CONSTRUCTOR init;
                               { 樠 쥪 }

                   PROCEDURE set_key ( key : CHAR;  proc : RunProcedure );
                             VIRTUAL;
                                { ⠭ 楤   }
                                {    㭪樮쭮      }
                                { ᫥   쥪}

                   PROCEDURE get_key ( key : CHAR; VAR proc : RunProcedure );
                             VIRTUAL;
                                {  㪠⥫  楤    }
                                {   㭪樮쭮  }
                                {  ᫥       }
                                {              쥪               }

                   PROCEDURE set_param ( num : BYTE; VAR parametr;
                             size : WORD ); VIRTUAL;
                                { ⠭ ࠬ   }
                                {          ஬               }

                   PROCEDURE get_param ( num : BYTE; VAR parametr );
                             VIRTUAL;
                                {  ࠬ   }
                                {          ஬             }

                   PROCEDURE push_clear; VIRTUAL;
                                { ࠭ 祭 ⥪饣 쥪 }
                                {  "⥪"  ᮧ  ⥪騩     }
                                {    쥪  ⪮        }
                                {              祭               }

                   PROCEDURE push_save; VIRTUAL;
                                { ࠭ 祭 ⥪饣 쥪 }
                                {  "⥪"  ᮧ  ⥪騩     }
                                {    쥪  ࠭     }
                                {              祭               }

                   PROCEDURE pop; VIRTUAL;
                                { 㤠  ⥪騥 祭     }
                                { ⠭  ⥪ ।騥 }

                   PROCEDURE run_for_key ( VAR key : CHAR ); VIRTUAL;
    	                        { ᯮ    }
                                {  ᫥   }
                                {            쥪            }

                   FUNCTION run_char : CHAR; VIRTUAL;
                                {  祭   ᯮ }
                                {     ᫨ ॡ 室      }
                                {     楤  .       }

                   DESTRUCTOR done;
                                { 㭨⮦ 饣 쥪 }

                       END; { object control_func_key }

PROCEDURE null;
          { 楤  ⢫ }
          {      ⢨      }

{----------------------------------------------------------}

IMPLEMENTATION    { ᥪ ॠ樨 }

PROCEDURE null;
          { 楤  ⢫ }
          {      ⢨      }

BEGIN

END; { procedure null }

{----------------------------------------------------------}

CONSTRUCTOR control_func_key.init;

            { 樠 쥪 }
VAR
   indx : BYTE;
              { ᭠ ६ }
BEGIN
     SetHeapMess ( ' Fkey11, 楤 樠樨 쥪' );
     up := NIL;
     NEW ( point_proc );
     NEW ( label_proc );
     NEW ( param );
     FOR indx := 0 TO 255 DO
         BEGIN
              point_proc^[ indx ] := NulRunProcedure;
              label_proc^[ indx ] := FALSE;
              param^.point_param [ indx ] := NIL;
              param^.size_param [ indx ] := 0
         END

END; { constroctor  control_func_key.init }

{----------------------------------------------------------}

PROCEDURE control_func_key.push_clear;

          { 樠 ᫥饣  楯窥 쥪 }
          {  㭨⮦ । 祭      }
          {        㭪樮쭮             }
BEGIN
     SetHeapMess ( ' Fkey11, 楤 ࠭ ࠬ஢  ⥪' );
     IF ( up <> NIL ) THEN
        up^.push_clear
     ELSE
         BEGIN
              NEW ( up );
              up^.init
         END

END; { procedure  control_func_key.push_clear }

{----------------------------------------------------------}

PROCEDURE control_func_key.push_save;

          { 樠 ᫥饣  楯窥 쥪 }
          {   ࠭ । 祭      }
          {        㭪樮쭮             }
VAR
   indx : BYTE;
             { ᭠ ६ }
BEGIN
     SetHeapMess ( ' Fkey11, 楤 ࠭ ࠬ஢  ⥪' );
     IF ( up <> NIL ) THEN
        up^.push_save
     ELSE
         BEGIN
              NEW ( up );
              up^.init;
              FOR indx := 1 TO 255 DO
                  BEGIN
                       up^.point_proc^[ indx ] := point_proc^[ indx ];
                       up^.label_proc^[ indx ] := label_proc^[ indx ]
                  END
         END

END; { procedure control_func_key.push_save }

{----------------------------------------------------------}

PROCEDURE control_func_key.pop;

          { 㤠 ⥪ 祭  ⠭ }
          {           "⥪" ।               }
BEGIN
     IF ( up = NIL ) THEN
        EXIT;
     IF ( up^.up <> NIL ) THEN
        up^.pop
     ELSE
         BEGIN
              up^.done;
              DISPOSE ( up );
              up := NIL
         END

END; { procedure control_func_key.pop }

{----------------------------------------------------------}

PROCEDURE control_func_key.set_key ( key : CHAR; proc : RunProcedure );

         { ⠭ 楤  }
         {   祭    }
BEGIN
     IF ( up <> NIL ) THEN
        up^.set_key ( key, proc )
     ELSE
         BEGIN
              point_proc^[ ORD ( key ) ] := proc;
              label_proc^[ ORD ( key ) ] := TRUE
         END

END; { procedure control_func_key.set_key }

{----------------------------------------------------------}

PROCEDURE control_func_key.get_key ( key : CHAR; VAR proc : RunProcedure );

         {  楤   }
         {                         }
BEGIN
     IF ( up <> NIL ) THEN
        up^.get_key ( key, proc )
     ELSE
         proc := point_proc^[ ORD ( key ) ]

END; { procedure control_func_key.get_key }

{----------------------------------------------------------}

PROCEDURE control_func_key.set_param ( num : BYTE; VAR parametr;
				       size : WORD );

        { ⠭  ࠬ }
VAR
    Help : WORD;

BEGIN
     SetHeapMess ( ' Fkey11, 楤 ⠭ ࠬ' );
     IF ( size = 0 ) THEN
        EXIT;
     IF ( up <> NIL ) THEN
        up^.set_param ( num, parametr, size )
     ELSE
         WITH param^ DO
              BEGIN
                   Help := size_param [ num ];
                   IF ( ( point_param [ num ] <> NIL ) AND ( size <> 0 )
                      AND ( Size <> size_param [ num ] )  ) THEN
                      BEGIN
                           FREEMEM ( point_param [ num ], size_param [ num ] );
                           point_param [ num ] := NIL
                      END;
                   IF ( ( size <> 0 ) AND ( size <> size_param [ num ] ) )
                      THEN
                          GETMEM ( point_param [ num ], size );
                   size_param [ num ] := size;
                   MOVE ( parametr, point_param [ num ]^, size )
              END

END; { procedure control_func_key.set_param }

{----------------------------------------------------------}

PROCEDURE control_func_key.get_param ( num : BYTE; VAR parametr );

         {   ࠬ }
BEGIN
     IF ( up <> NIL ) THEN
        up^.get_param ( num, parametr )
     ELSE
         WITH param^ DO
              IF ( point_param [ num ] <> NIL ) THEN
                 MOVE ( point_param [ num ]^, parametr, size_param [ num ] )

END; { procedure control_func_key.get_param }

{----------------------------------------------------------}

PROCEDURE control_func_key.run_for_key ( VAR key : CHAR );

         { 믮 楤    }
         {  ᫨ 楤 뫠 믮,     }
         {      ⢥ key  #0       }
BEGIN
     IF ( up <> NIL ) THEN
        up^.run_for_key ( key )
     ELSE
         IF ( label_proc^[ ORD ( key ) ] ) THEN
            BEGIN
                 point_proc^[ ORD ( key ) ];
                 key := #0
            END

END; { procedure control_func_key.run_for_key }

{----------------------------------------------------------}

FUNCTION control_func_key.run_char : CHAR;

         {   ⮩ ,  }
         { ESC ᫥⥫쭮  믮    }
         {    室  楤      }
VAR
   ch : CHAR;
            { ६  }
BEGIN
     IF ( up <> NIL ) THEN
        ch := up^.run_char
     ELSE
         BEGIN
              ch := READKEY;
              IF ( KEYPRESSED ) THEN
                 BEGIN
                      ch := READKEY;
                      IF ( label_proc^[ ORD ( ch ) ] ) THEN
                         BEGIN
                              point_proc^[ ORD ( ch ) ];
                              ch := #0
                         END
                 END;
              run_char := ch
         END

END; { function control_func_key.run_char }

{----------------------------------------------------------}

DESTRUCTOR control_func_key.done;

         { 㭨⮦ 쥪 }
VAR
   indx : BYTE;
               { ᭠ ६ }
BEGIN
     DISPOSE ( point_proc );
     DISPOSE ( label_proc );
     WITH param^ DO
          FOR indx := 0 TO 255 DO
              IF ( point_param [ indx ] <> NIL ) THEN
                 FREEMEM ( point_param [ indx ], size_param [ indx ] );
     DISPOSE ( param )

END; { destructor control_func_key.done }

{----------------------------------------------------------}

END.
