

         {----------------------------------------------------}
         {    LcText  V 1.3.07   TURBO SUPPORT    }
         {      ணࠬ஢ Turbo Pascal  V 6.0      }
         {----------------------------------------------------}
         {  ᫥  :  02/01/1991             }
         {----------------------------------------------------}
         {  ।祭  ࠡ⪨ ⥪⮢ 䠩 }
         {           ஢ ⮪ /뢮            }
         {----------------------------------------------------}
         { (c) 1991,  ᫠                            }
         {----------------------------------------------------}

UNIT LcText;

{$IFDEF DEBUGTEXT}
      {$D+,L+,R+,S+}
{$ELSE}
      {$D-,L-,R-,S-}
{$ENDIF}

{$F+,O+,I-,V-,B-,A+}

INTERFACE

USES Dos, Crt, Def;

TYPE
     RecLinePtr = ^RecLine;
                { ⥫   ப ᯨ᪠ }


     RecLine = RECORD  {  ப ᯨ᪠ }

                     Line : STRING;
                            { ப ᯨ᪠ }
                     Next : RecLinePtr
                            { 㪠⥫  ᫥騩  ᯨ᪠ }

               END; { record RecLine }

     TypeBuffer = ARRAY [ 0..$FFFE ] OF BYTE;
                  { ⨯   ࠭  ࠡ⪨  ⥪⮢ }
                  {                     䠩                            }

     ErrorProcedure = PROCEDURE ( Err : BYTE );
                  { 楤 뤠 ᮮ饭  訡 }

{----------------------------------------------------------}

     LocationTextPtr = ^LocationText;

     LocationText = OBJECT { ⮪ /뢮  ࠡ⪨ ⥪ }

                    BufferPtr : ^TypeBuffer;
                            { 㪠⥫   ࠭  ࠡ⪨ }
                            { ⥪⮢ 䠩                        }

                    SizeBuf : WORD;
                             { ࠧ ⢥    }

                    SizeFact : WORD;
                             { ⢮ ଠ樨 ࠧ饭   }

                    PointBeginBuf : LONGINT;
                    DublePointBeginBuf : LONGINT;
                             {  砫   䠩 }

                    NowLinePtr : WORD;
                    DubleNowLinePtr : WORD;
                             { 㪠⥫  ⥪ ப   }

                    NowLineNumber : LONGINT;
                    DubleNowLineNumber : LONGINT;
                             {  ⥪饩 ப }

                    MaxLineNumber : LONGINT;
                             { ⢮ ப  ⥪⮢ 䠩 }

                    DubleKeyEOF : BOOLEAN;
                    KeyEOF : BOOLEAN;
                             { ਧ 室 㪠⥫  ࠭ ⮪ }

                    SingState : BOOLEAN;
                              { ਧ ࠭ ﭨ }

                    Fl : FILE;
                             { 䠩 ⮪ }

                    NumError : BYTE;
                             {  訡 樨 }

                    ErrorProc : ErrorProcedure;
                             { 楤 뤠 ᮮ饭  訡 }

                    SingWrite : BOOLEAN;
                             { ਧ  ⥪饣  }

                    SingStreamEOF : BOOLEAN;
                             { ਧ 砭 ⮪ }

                    CONSTRUCTOR Init ( SzBuf : WORD; Name : STRING );
                             { 樠 쥪, १ࢨ஢  }
                             {  ⨥ 䠩                             }

                    PROCEDURE ReSetStream;
                              { 砫쭠 ⠭ ⥪⮢ ⮪ }

                    FUNCTION GetNumberError : BYTE;
                             {   訡  }

                    PROCEDURE SetLineNumber ( Num : LONGINT ); VIRTUAL;
                             { ⠭  ࠡ뢠 ப       }

                    FUNCTION GetLineNumber : LONGINT;
                             {   ࠡ뢠 ப         }

                    FUNCTION GetSize : LONGINT;
                             {  饥 ⢮ ப  ⥪⮢  }
                             { ⮪                                       }

                    FUNCTION GetCurrentChar : CHAR; VIRTUAL;
                              { 頥 ⥪騩 ᨬ ⮪ }

                    PROCEDURE SetCurrentChar ( Ch : CHAR ); VIRTUAL;
                              { ⠭ ⥪騩 ᨬ ⮪ }

                    PROCEDURE NextChar;
                              { ⢫ 室  ᫥饬 ᨬ }

                    PROCEDURE PrevChar;
                              { ⢫ 室  ।饬 ᨬ }

                    FUNCTION EofText : BOOLEAN;
                             {  ਧ 襭 ⮪           }

                    PROCEDURE TruncateLines;
                              { ᥪ ப   ⮪ 稭  }
                              {              ⥪饩                   }

                    PROCEDURE DelLines ( Quantity : LONGINT ); VIRTUAL;
                             { 㤠  ⮪  ⢮ ப  }
                             { 稭  ⥪饩                            }

                    PROCEDURE ReadLines ( Quantity : LONGINT;
                                          VAR LnPtr : RecLinePtr ); VIRTUAL;
                              { ᮧ ᯨ᮪   ⢠      }
                              { ப 㦠   ⮪                 }

                    PROCEDURE InsertLines ( Quantity : LONGINT;
                                            LnPtr : RecLinePtr ); VIRTUAL;
                              { ⠢  ⢮ ப       }
                              { ᯨ᪠  ⮪                              }

                    PROCEDURE AddLines ( Quantity : LONGINT;
                                            LnPtr : RecLinePtr ); VIRTUAL;
                              {   ⢮ ப       }
                              { ᯨ᪠  ⮪                              }

                    PROCEDURE ReplaseLines ( DelQuantity : LONGINT;
                                             InsQuantity : LONGINT;
                                             LnPtr : RecLinePtr ); VIRTUAL;
                              {   ⢮ ப ⥪  }
                              { ⮪                                      }

                    PROCEDURE ReadLine ( VAR Line : STRING );
                              { 㦠  ப  ⮪             }

                    PROCEDURE InsLine ( Line : STRING );
                              { ⠢  ப  ⮪              }

                    PROCEDURE DelLine;
                              { 㤠  ப  ⮪              }

                    PROCEDURE WriteLine ( Line : STRING );
                              {   ப  ⮪                  }

                    PROCEDURE AddLine ( Line : STRING );
                              {  ப  ⮪ }

                    PROCEDURE SetErrorProc ( Param : ErrorProcedure );
                              { ⠭ 楤 ࠡ⪨ 訡 }
                              { 権                                 }

                    PROCEDURE SaveState; VIRTUAL;
                              { ࠭ ⥪饥 ﭨ }

                    PROCEDURE RestoreState; VIRTUAL;
                              { ⠭ ࠭ ࠭ ﭨ }

                    DESTRUCTOR Done; VIRTUAL;
                              { 뢠 䠩, 㭨⮦           }
                              { 樠 쥪                    }

                    {$IFDEF DEBUGTEXT}
                    FUNCTION CheckBeginLine : BOOLEAN;
                              { 㭪 ஢ન ⠭ 㪠⥫ }
                              {       砫 ⥪饩 ப        }

                    FUNCTION CheckLineNumber : BOOLEAN;
                              { 㭪 ஢ન  ᮮ⢥⢨      }
                              { ⠭ ப  樨 }

                    FUNCTION CheckLend : BOOLEAN;
                              { 㭪 ஫  ⮪ }
                    {$ENDIF}

                    END; { object LocationText }

{----------------------------------------------------------}

     LocationListTextPtr = ^LocationListText;

     LocationListText = OBJECT   ( LocationText )
                    { ⮪ /뢮  ࠡ⪨ ᯨ᪮ ⥪ }

                    List : RecLinePtr;
                           { ᯨ᮪ ப ⥪ }

                    MaxLine : LONGINT;
                           { ᨬ쭮 ⢮ ப  ᯨ᪥ }


                    CONSTRUCTOR Init ( LnPtr : RecLinePtr; Max : LONGINT );
                             { 樠 쥪, १ࢨ஢  }
                             {  ⨥ 䠩                             }

                    PROCEDURE ReSetStream;
                              { 砫쭠 ⠭ ⥪⮢ ⮪ }

                    FUNCTION GetListPtr : RecLinePtr;
                             {  㪠⥫  ᯨ᮪ ⮪ }

                    PROCEDURE SetLineNumber ( Num : LONGINT ); VIRTUAL;
                             { ⠭  ࠡ뢠 ப       }

                    PROCEDURE TruncateLines;
                              { ᥪ ப   ⮪ 稭  }
                              {              ⥪饩                   }

                    PROCEDURE DelLines ( Quantity : LONGINT ); VIRTUAL;
                             { 㤠  ⮪  ⢮ ப  }
                             { 稭  ⥪饩                            }

                    PROCEDURE ReadLines ( Quantity : LONGINT;
                                          VAR LnPtr : RecLinePtr ); VIRTUAL;
                              { ᮧ ᯨ᮪   ⢠      }
                              { ப 㦠   ⮪                 }

                    PROCEDURE InsertLines ( Quantity : LONGINT;
                                            LnPtr : RecLinePtr ); VIRTUAL;
                              { ⠢  ⢮ ப       }
                              { ᯨ᪠  ⮪                              }

                    PROCEDURE AddLines ( Quantity : LONGINT;
                                            LnPtr : RecLinePtr ); VIRTUAL;
                              {   ⢮ ப       }
                              { ᯨ᪠  ⮪                              }

                    PROCEDURE SaveState; VIRTUAL;
                              { ࠭ ⥪饥 ﭨ }

                    PROCEDURE RestoreState; VIRTUAL;
                              { ⠭ ࠭ ࠭ ﭨ }

                    DESTRUCTOR Done; VIRTUAL;
                              { 樠 쥪                    }

                    END; { object LocationListText }

{----------------------------------------------------------}

     LocationProtectTextPtr = ^LocationProtectText;

     LocationProtectText = OBJECT   ( LocationText )
                    { ⮪ /뢮  ࠡ⪨ 饭 ⥪ }

                    Password : BYTE;
                           { ⠭  }

                    CONSTRUCTOR Init ( SzBuf : WORD; Name : STRING;
                                       Ps : BYTE );
                             { 樠 쥪, १ࢨ஢  }
                             {  ⨥ 䠩                             }

                    FUNCTION GetCurrentChar : CHAR; VIRTUAL;
                              { 頥 ⥪騩 ᨬ ⮪ }

                    PROCEDURE SetCurrentChar ( Ch : CHAR ); VIRTUAL;
                              { ⠭ ⥪騩 ᨬ ⮪ }

                    PROCEDURE SetPassword ( Ps : BYTE );
                             { ⠭  ஫ }

                    END; { object LocationProtectText }

{----------------------------------------------------------}

PROCEDURE NulErrProc ( Err : BYTE );
PROCEDURE ClearListRecLine ( VAR LnPtr : RecLinePtr );
FUNCTION FindLine ( Quantity : LONGINT; LnPtr : RecLinePtr ) : RecLinePtr;
FUNCTION SizeListLine ( LnPtr : RecLinePtr ) : LONGINT;
PROCEDURE DelListLine ( Number : LONGINT; VAR LnPtr : RecLinePtr );
PROCEDURE AddListLine ( VAR LnPtr, InsPtr : RecLinePtr );
PROCEDURE AddListOneLine ( VAR Lst : RecLinePtr; Line : STRING );
PROCEDURE InsertList ( Number : LONGINT; VAR LnPtr, InsPtr : RecLinePtr );
FUNCTION FullSizeList ( LnPtr : RecLinePtr ) : LONGINT;
FUNCTION FullSizeQLines ( Quantity : LONGINT; LnPtr : RecLinePtr ) : LONGINT;
PROCEDURE TruncateListLine ( MaxLine : LONGINT; VAR LnPtr : RecLinePtr );
FUNCTION BuildLineList ( Line : STRING;
                         Next : RecLinePtr ) : RecLinePtr;
FUNCTION GetCurrentDir : STRING;
PROCEDURE SwapLines ( Num1, Num2 : LONGINT; VAR List : RecLinePtr );
FUNCTION BuildDirList ( DirPath : STRING ) : RecLinePtr;
FUNCTION SortList ( List : RecLinePtr ) : RecLinePtr;
FUNCTION SortDirList ( List : RecLinePtr ) : RecLinePtr;
FUNCTION CopyListLine ( Quantity : LONGINT; LnPtr : RecLinePtr ) : RecLinePtr;

IMPLEMENTATION

{----------------------------------------------------------}

PROCEDURE FatalError ( Line : STRING );

BEGIN
     WINDOW ( 1, 1, 80, 25 );
     TEXTBACKGROUND ( BLACK );
     TEXTCOLOR ( LIGHTGRAY );
     CLRSCR;
     WRITELN ( #07 );
     WRITELN ( '᪨ ᡮ  쥪 LocationText' );
     WRITELN ( Line );
     WRITELN ( '믮 ணࠬ ४頥,'
              ,' 頩  ணࠬ' );
     HALT ( 1 )

END; { procedure FatalError }

{----------------------------------------------------------}

{$IFDEF DEBUGTEXT}

PROCEDURE ErrorInProc ( Line : STRING );

BEGIN
     WINDOW ( 1, 1, 80, 25 );
     TEXTBACKGROUND ( BLACK );
     TEXTCOLOR ( LIGHTGRAY );
     CLRSCR;
     WRITELN ( #07 );
     WRITELN ( '᪨ ᡮ  楤  LcText' );
     WRITELN ( Line );
     WRITELN ( '믮 ணࠬ ४頥,'
              ,' 頩  ணࠬ' );
     HALT ( 1 )

END; { procedure ErrorInProc }

{$ENDIF}

{----------------------------------------------------------}

PROCEDURE NulErrProc ( Err : BYTE );

{$IFDEF DEBUGTEXT}
VAR
   HelpS : StandartString;
{$ENDIF}

BEGIN
     {$IFDEF DEBUGTEXT}
     STR ( Err, HelpS );
     FatalError ( '맢 楤 ࠡ⪨ 訡   #' + HelpS )
     {$ENDIF}

END; { procedure NulErrProc }

{----------------------------------------------------------}

FUNCTION GetCurrentDir : STRING;

VAR
   DirPath : STRING;

BEGIN
     GETDIR ( 0, dirpath );
     IF ( DirPath [ LENGTH ( dirpath ) ] <> '\' ) THEN
        dirpath := CONCAT ( dirpath, '\' );
     GetCurrentDir := DirPath

END; { function GetCurrentDir }

{----------------------------------------------------------}

PROCEDURE ClearListRecLine ( VAR LnPtr : RecLinePtr );

          { 楤 ⪨ ப ᯨ᪠ }
VAR
   Index, Hlp : RecLinePtr;

BEGIN
     IF ( LnPtr = NIL ) THEN
        EXIT;
     IF ( LnPtr^.Next <> NIL ) THEN
        ClearListRecLine ( LnPtr^.Next );
     {$IFDEF DEBUGTEXT}
     IF ( LnPtr^.Next <> NIL ) THEN
        ErrorInProc ( '訡  楤 ClearListRecLine' );
     {$ENDIF}
     DISPOSE ( LnPtr );
     LnPtr := NIL

END; { procedure ClearListRecLine }

{----------------------------------------------------------}

FUNCTION CopyListLine ( Quantity : LONGINT; LnPtr : RecLinePtr ) : RecLinePtr;

         { । 㪪⥫  㡫 ᯨ᪠ }
VAR
   Hlp : RecLinePtr;

BEGIN
     IF ( ( LnPtr = NIL ) OR ( Quantity = 0 ) ) THEN
        BEGIN
             CopyListLine := NIL;
             EXIT
        END;
     Hlp := NIL;
     NEW ( Hlp );
     IF ( LnPtr^.Next = NIL ) THEN
        BEGIN
             Hlp^.Next := NIL;
             Hlp^.Line := LnPtr^.Line;
             CopyListLine := Hlp
        END;
     Hlp^.Next := CopyListLine ( Quantity - 1, LnPtr^.Next );
     Hlp^.Line := LnPtr^.Line;
     CopyListLine := Hlp

END; { function CopyListLine }

{----------------------------------------------------------}

FUNCTION FindLine ( Quantity : LONGINT; LnPtr : RecLinePtr ) : RecLinePtr;

        { 頥 㪠⥫    ᯨ᪠ }
BEGIN
     FindLine := NIL;
     IF ( ( Quantity < 1 ) OR ( LnPtr = NIL ) ) THEN
        EXIT;
     IF ( Quantity = 1 ) THEN
        BEGIN
             FindLine := LnPtr;
             EXIT
        END;
     FindLine := FindLine ( ( Quantity - 1 ), LnPtr^.Next )

END; { function FindLine }

{----------------------------------------------------------}

FUNCTION SizeListLine ( LnPtr : RecLinePtr ) : LONGINT;

         { 頥 ⢮ ப  ᯨ᪥ }
BEGIN
     IF ( LnPtr = NIL ) THEN
        SizeListLine := 0
     ELSE
         SizeListLine := SizeListLine ( LnPtr^.Next ) + 1

END; { function SizeListLine }

{----------------------------------------------------------}

PROCEDURE DelListLine ( Number : LONGINT; VAR LnPtr : RecLinePtr );

         { 㤠  ப  ᯨ᪠ }
VAR
   Prev, Now, Next : RecLinePtr;

BEGIN
     Now := FindLine ( Number, LnPtr );
     IF ( Now = NIL ) THEN
        EXIT;
     Next := Now^.Next;
     IF ( Number <> 1 ) THEN
        BEGIN
             Prev := FindLine ( Number - 1, LnPtr );
             Prev^.Next := Next
        END
     ELSE
         LnPtr := Next;
     DISPOSE ( Now )

END; { procedure DelLine }

{----------------------------------------------------------}

PROCEDURE AddListLine ( VAR LnPtr, InsPtr : RecLinePtr );

VAR
   Hlp : RecLinePtr;

BEGIN
     IF ( InsPtr = NIL ) THEN
        EXIT;
     IF ( LnPtr = NIL ) THEN
        BEGIN
             LnPtr := InsPtr;
             InsPtr := NIL;
             EXIT
        END;
     IF ( LnPtr^.Next = NIL ) THEN
        BEGIN
             LnPtr^.Next := InsPtr;
             InsPtr := NIL;
             EXIT
        END;
     Hlp := FindLine ( SizeListLine ( LnPtr ), LnPtr );
     IF ( Hlp^.Next <> NIL ) THEN
        FatalError ( '訡  楤 AddListLine' );
     Hlp^.Next := InsPtr;
     InsPtr := NIL

END; { procedure AddListLine }

{----------------------------------------------------------}

PROCEDURE AddListOneLine ( VAR Lst : RecLinePtr; Line : STRING );

          {   ᯨ᮪  ப }
VAR
   Hlp : RecLinePtr;

BEGIN
     NEW ( Hlp );
     Hlp^.Next := NIL;
     Hlp^.Line := Line;
     AddListLine ( Lst, Hlp )

END; { procedure AddListOneLine }

{----------------------------------------------------------}

PROCEDURE InsertList ( Number : LONGINT; VAR LnPtr, InsPtr : RecLinePtr );

          { ⠢ ᯨ᮪  ᯨ᮪ 稭  ப  }
          {                ஬                  }
VAR
   HlpRes, HlpPrev : RecLinePtr;
   HelpInsPtr : RecLinePtr;
   NumIns : LONGINT;
   NextLnPtr : RecLinePtr;

BEGIN
     IF ( InsPtr = NIL ) THEN
        EXIT;
     IF ( LnPtr = NIL ) THEN
        BEGIN
             LnPtr := InsPtr;
             InsPtr := NIL;
             EXIT
        END;
     IF ( Number = 1 ) THEN
        BEGIN
             AddListLine ( InsPtr, LnPtr );
             LnPtr := InsPtr;
             InsPtr := NIL;
             EXIT
        END;
     IF ( Number > SizeListLine ( LnPtr ) ) THEN
        BEGIN
             AddListLine ( LnPtr, InsPtr );
             EXIT
        END;
     HlpRes := FindLine ( Number, LnPtr );
     HlpPrev := FindLine ( Number - 1, LnPtr );
     HlpPrev^.Next := NIL;
     AddListLine ( LnPtr, InsPtr );
     AddListLine ( LnPtr, HlpRes )

END; { procedure InsertList }

{----------------------------------------------------------}

FUNCTION FullSizeList ( LnPtr : RecLinePtr ) : LONGINT;

         { ࠧ ᯨ᪠ ப   }
BEGIN
     IF ( LnPtr = NIL ) THEN
        BEGIN
             FullSizeList := 0;
             EXIT
        END;
     IF ( LnPtr^.Next = NIL ) THEN
        BEGIN
             FullSizeList := LENGTH ( LnPtr^.Line ) + 2;
             EXIT
        END;
     FullSizeList := FullSizeList ( LnPtr^.Next ) +
                                      LENGTH ( LnPtr^.Line ) + 2

END; { function FullSizeList }

{----------------------------------------------------------}

FUNCTION FullSizeQLines ( Quantity : LONGINT; LnPtr : RecLinePtr ) : LONGINT;

         { ࠧ ᯨ᪠  ᪮쪨 ப   }
BEGIN
     IF ( ( LnPtr = NIL ) OR ( Quantity = 0 ) ) THEN
        BEGIN
             FullSizeQLines := 0;
             EXIT
        END;
     IF ( LnPtr^.Next = NIL ) THEN
        BEGIN
             FullSizeQLines := LENGTH ( LnPtr^.Line ) + 2;
             EXIT
        END;
     DEC ( Quantity );
     FullSizeQLines := FullSizeQLines ( Quantity, LnPtr^.Next ) +
                                      LENGTH ( LnPtr^.Line ) + 2

END; { function FullSizeQLines }

{----------------------------------------------------------}

PROCEDURE TruncateListLine ( MaxLine : LONGINT; VAR LnPtr : RecLinePtr );

       { ᥪ ᯨ᮪ ப   ࠧ }
BEGIN
     WHILE ( SizeListLine ( LnPtr ) > MaxLine ) DO
           DelListLine ( SizeListLine ( LnPtr ), LnPtr )

END; { procedure TruncateListLine }

{----------------------------------------------------------}

FUNCTION BuildLineList ( Line : STRING;
                         Next : RecLinePtr ) : RecLinePtr;

         { ந ᯨ᮪ ப }
VAR
   Hlp : RecLinePtr;

BEGIN
     NEW ( Hlp );
     Hlp^.Line := Line;
     Hlp^.Next := Next;
     BuildLineList := Hlp

END; { function BuildLineList }

{----------------------------------------------------------}

FUNCTION BuildDirList ( DirPath : STRING ) : RecLinePtr;

VAR
   Line, Stroka : STRING;
   Catalog : SEARCHREC;
   Hlp : RecLinePtr;
   Line2 : STRING;
   First : RecLinePtr;

BEGIN
     Stroka := DirPath + '*.*';
     First := NIL;
     FINDFIRST ( Stroka, ANYFILE  - VOLUMEID, Catalog );
     IF ( DOSERROR <> 0 ) THEN
        BEGIN
             AddListOneLine ( First, ' 䠩  ᪥ ' );
             BuildDirList := First;
             EXIT
        END;
     IF ( Catalog.Name = '.' ) THEN
        Line := '..'
     ELSE
         Line := Catalog.Name;
     WHILE ( LENGTH ( Line ) < 14 ) DO
           Line := Line + ' ';
     IF ( ( Catalog.Attr AND Directory ) <> 0 ) THEN
        Line := Line +'< SUB-DIR >'
     ELSE
         BEGIN
              STR ( Catalog.Size, Line2 );
              Line := Line + Line2
         END;
     AddListOneLine ( First, Line );
     WHILE ( DOSERROR = 0 ) DO
         BEGIN
              FINDNEXT ( Catalog );
              IF ( ( Catalog.Name <> '..' ) AND ( DOSERROR = 0 ) ) THEN
                 BEGIN
                      Line := Catalog.Name;
                      WHILE ( LENGTH ( Line ) < 14 ) DO
                            Line := Line + ' ';
                      IF ( ( Catalog.Attr AND Directory ) <> 0 ) THEN
                         Line := Line +'< SUB-DIR >'
                      ELSE
                          BEGIN
                               STR ( Catalog.Size, Line2 );
                               Line := Line + Line2
                          END;
                      AddListOneLine ( First, Line )
                 END
         END;
     BuildDirList := First

END; { function BuildDirList }

{----------------------------------------------------------}

PROCEDURE SwapLines ( Num1, Num2 : LONGINT; VAR List : RecLinePtr );

          {  ⠬  ப  ᯨ᪥ }
VAR
   Hlp1, Hlp2 : RecLinePtr;

BEGIN
     NEW ( Hlp1 );
     Hlp1^.Line := FindLine ( Num1, List )^.Line;
     Hlp1^.Next := NIL;
     NEW ( Hlp2 );
     Hlp2^.Line := FindLine ( Num2, List )^.Line;
     Hlp2^.Next := NIL;
     DelListLine ( Num1, List );
     InsertList ( Num1, List, Hlp2 );
     DelListLine ( Num2, List );
     InsertList ( Num2, List, Hlp1 )

END; { procedure SwapLines }

{----------------------------------------------------------}

FUNCTION SortDirList ( List : RecLinePtr ) : RecLinePtr;

        { ஢  䠩  ᯨ᪥ ४ }
VAR
   Quantity : LONGINT;
   Index : LONGINT;
   IndexFind : LONGINT;
   FindNumber : LONGINT;
   RecHlp1, RecHlp2 : RecLinePtr;
   Line1 : STRING;
   NewList : RecLinePtr;

FUNCTION EqLines ( VAR Line2 : STRING ) : BOOLEAN;

         { ਧ  }
VAR
   Hlp : BYTE;

BEGIN
     EqLines := TRUE;
     IF ( ( POS ( '< SUB-DIR >', Line1 ) = 0 ) AND
          ( POS ( '< SUB-DIR >', Line2 ) <> 0 ) ) THEN
        EXIT;
     IF ( ( POS ( '< SUB-DIR >', Line1 ) <> 0 ) AND
         ( POS ( '< SUB-DIR >', Line2 ) = 0 ) ) THEN
        BEGIN
             EqLines := FALSE;
             EXIT
        END;

      Hlp := 1;
      WHILE ( Line1 [ Hlp ] <> ' ' ) DO
            BEGIN
                 IF ( Line1 [ Hlp ] > Line2 [ Hlp ] ) THEN
                    EXIT;
                 IF ( Line1 [ Hlp ] < Line2 [ Hlp ] ) THEN
                    BEGIN
                         EqLines := FALSE;
                         EXIT
                    END;
                 INC ( Hlp )
            END;
      EqLines := FALSE

END; { Function EdLines }

BEGIN
     NewList := NIL;
     Quantity := SizeListLine ( List );
     RecHlp1 := List;
     FOR IndexFind := 1 TO Quantity DO
         BEGIN
              FindNumber := 1;
              Line1 := List^.Line;
              RecHlp1 := List;
              RecHlp2 := RecHlp1^.Next;
              FOR Index := 2 TO SizeListLine ( List ) DO
                  BEGIN
                       IF ( EqLines (  RecHlp2^.Line ) ) THEN
                          BEGIN
                               Line1 := RecHlp2^.Line;
                               FindNumber := Index
                          END;
                       RecHlp2 := RecHlp2^.Next
                  END;
              AddListOneLine ( NewList, Line1 );
              DelListLine ( FindNumber, List );
         END;
     SortDirList := NewList

END; { function SortDirList }

{----------------------------------------------------------}

FUNCTION SortList ( List : RecLinePtr ) : RecLinePtr;

        { ஢ ப ᯨ᪠ }
VAR
   Quantity : LONGINT;
   Index : LONGINT;
   IndexFind : LONGINT;
   FindNumber : LONGINT;
   RecHlp1, RecHlp2 : RecLinePtr;
   Line1 : STRING;
   NewList : RecLinePtr;

FUNCTION EqLines ( VAR Line2 : STRING ) : BOOLEAN;

         { ਧ  }
VAR
   Hlp : BYTE;

BEGIN
     EqLines := TRUE;
      Hlp := 1;
      WHILE ( Line1 [ Hlp ] <> ' ' ) DO
            BEGIN
                 IF ( Line1 [ Hlp ] > Line2 [ Hlp ] ) THEN
                    EXIT;
                 IF ( Line1 [ Hlp ] < Line2 [ Hlp ] ) THEN
                    BEGIN
                         EqLines := FALSE;
                         EXIT
                    END;
                 INC ( Hlp )
            END;
      EqLines := FALSE

END; { Function EdLines }

BEGIN
     NewList := NIL;
     Quantity := SizeListLine ( List );
     RecHlp1 := List;
     FOR IndexFind := 1 TO Quantity DO
         BEGIN
              FindNumber := 1;
              Line1 := List^.Line;
              RecHlp1 := List;
              RecHlp2 := RecHlp1^.Next;
              FOR Index := 2 TO SizeListLine ( List ) DO
                  BEGIN
                       IF ( EqLines (  RecHlp2^.Line ) ) THEN
                          BEGIN
                               Line1 := RecHlp2^.Line;
                               FindNumber := Index
                          END;
                       RecHlp2 := RecHlp2^.Next
                  END;
              AddListOneLine ( NewList, Line1 );
              DelListLine ( FindNumber, List );
         END;
     SortList := NewList

END; { function SortList }

{----------------------------------------------------------}

{$IFDEF DEBUGTEXT}

FUNCTION LocationText.CheckBeginLine : BOOLEAN;

         { 㭪 ஢ન ⠭ 㪠⥫ }
         {       砫 ⥪饩 ப        }
BEGIN
     CheckBeginLine := TRUE;
     IF ( NowLineNumber <> 1 ) THEN
        BEGIN
             IF ( NowLineNumber <> MaxLineNumber ) THEN
                PrevChar
             ELSE
                 IF ( GetCurrentChar = #$0A ) THEN
                    BEGIN
                         IF ( NOT KeyEOF ) THEN
                            BEGIN
                                 NextChar;
                                 IF ( NOT KeyEOF ) THEN
                                    BEGIN
                                         CheckBeginLine := FALSE;
                                         EXIT
                                    END;
                                 KeyEOF := FALSE
                            END
                    END
                 ELSE
                     PrevChar;
             IF ( GetCurrentChar <> #$0A ) THEN
                CheckBeginLine := FALSE;
             PrevChar;
             IF ( GetCurrentChar <> #$0D ) THEN
                CheckBeginLine := FALSE;
             NextChar;
             NextChar
        END
     ELSE
         BEGIN
              PrevChar;
              CheckBeginLine := KeyEOF;
              KeyEOF := FALSE
         END

END; { function LocationText.CheckBeginLine }

{$ENDIF}

{----------------------------------------------------------}

{$IFDEF DEBUGTEXT}

FUNCTION LocationText.CheckLineNumber : BOOLEAN;

         { 㭪 ஢ન  ᮮ⢥⢨      }
         { ⠭ ப  樨 }
VAR
   SaveBufferPtr : LONGINT;
   SaveLinePtr : WORD;
   LineNumber : LONGINT;

BEGIN
     CheckLineNumber := TRUE;
     IF ( NowLineNumber = 1 ) THEN
        EXIT;
     LineNumber := NowLineNumber;
     SaveBufferPtr := PointBeginBuf;
     SaveLinePtr := NowLinePtr;

     { ।,  楤 SetLineNumber }
     {             ࠡ⠥ ४⭮              }

     SetLineNumber ( 1 );
     SetLineNumber ( LineNumber );
     IF ( SaveBufferPtr <> PointBeginBuf ) THEN
        CheckLineNumber := FALSE;
     IF ( SaveLinePtr <> NowLinePtr ) THEN
        CheckLineNumber := FALSE

END; { function LocationText.CheckLineNumber }

{$ENDIF}

{----------------------------------------------------------}

{$IFDEF DEBUGTEXT}

FUNCTION LocationText.CheckLend : BOOLEAN;

         { 㭪 ஫  ⮪ }
VAR
   OldSize : LONGINT;
   OldLineNumber : LONGINT;

BEGIN
     OldLineNumber := NowLineNumber;
     OldSize := MaxLineNumber;
     ReSetStream;
     CheckLend := ( MaxLineNumber = OldSize );
     SetLineNumber ( OldLineNumber )

END; { function LocationText.CheckLend }

{$ENDIF}

{----------------------------------------------------------}

CONSTRUCTOR LocationText.Init ( SzBuf : WORD; Name : STRING );

            { 樠 쥪, १ࢨ஢  }
            {  ⨥ 䠩                             }
VAR
   Index : WORD;
           { ᭠ ६ }

   GetByte : CHAR;
           { ᯮ⥫ ᨬ }

BEGIN
           { 砫 ⠭ }

     ErrorProc := NulErrProc;
     SizeBuf := SzBuf;
     BufferPtr := NIL;
     SizeFact := 0;
     NowLinePtr := 0;
     NowLineNumber := 1;
     MaxLineNumber := 1;
     PointBeginBuf := 0;
     SingWrite := FALSE;
     NumError := 0;
     SingStreamEOF := FALSE;
     KeyEOF :=FALSE;
     IF ( SizeBuf < 512 ) THEN
        SizeBuf := 512;
     IF ( Name = '' ) THEN
        BEGIN
             FAIL;
             EXIT
        END;
     SaveState;

           { ᮧ  }

     GETMEM ( BufferPtr, SizeBuf );
     IF ( BufferPtr = NIL ) THEN
        BEGIN
             FAIL;
             EXIT
        END;

           { ⨥ 䠩 }

     ASSIGN ( Fl, Name );
     RESET ( Fl, 1 );
     IF ( IORESULT <> 0 ) THEN
        BEGIN
             REWRITE ( Fl, 1 );
             IF ( IORESULT <> 0 ) THEN
                BEGIN
                     FREEMEM ( BufferPtr, SizeBuf );
                     FAIL;
                     EXIT
                END;
             EXIT
        END;
     IF ( FILESIZE ( Fl ) = 0 ) THEN
        BEGIN
             SingStreamEOF := TRUE;
             EXIT
        END;

     ReSetStream

END; { constructor LocationText.Init }

{----------------------------------------------------------}

PROCEDURE LocationText.ReSetStream;

          { 砫쭠 ⠭ ⥪⮢ ⮪ }
VAR
   GetByte : CHAR;
             { ᯮ⥫ ᨬ }
BEGIN
     NumError := 0;
     NowLinePtr := 0;
     PointBeginBuf := 0;
     MaxLineNumber := 1;
     SingStreamEOF := FALSE;

           { ⠭  砫 䠩 }

     SEEK ( Fl, 0 );
     BLOCKREAD ( Fl, BufferPtr^, SizeBuf, SizeFact );
     IF ( IORESULT <> 0 ) THEN
        BEGIN
             NumError := 1;
             ErrorProc ( NumError );
             EXIT
        END;

           {  ⢠ ப  䠩 }

     REPEAT
           GetByte := GetCurrentChar;
           NextChar;
           IF ( ( GetCurrentChar = #$0A ) AND ( GetByte = #$0D ) ) THEN
              INC ( MaxLineNumber );
           IF ( NumError <> 0 ) THEN
              EXIT;
     UNTIL ( KeyEOF );
     KeyEOF := FALSE;

           { ⠭  砫 䠩 }

     SEEK ( Fl, 0 );
     BLOCKREAD ( Fl, BufferPtr^, SizeBuf, SizeFact );
     IF ( IORESULT <> 0 ) THEN
        BEGIN
             NumError := 1;
             ErrorProc ( NumError );
             EXIT
        END;
     NowLinePtr := 0;
     PointBeginBuf := 0;
     SingStreamEOF := FALSE;
     NowLineNumber := 1

END; { procedure LocationText.ReSetStream }

{----------------------------------------------------------}

FUNCTION LocationText.GetNumberError : BYTE;

         {   訡   }
BEGIN
     GetNumberError := NumError;
     NumError := 0

END; { function LocationText.GetNumberError }

{----------------------------------------------------------}

FUNCTION LocationText.GetCurrentChar : CHAR;

         { 頥 ⥪騩 ᨬ ⮪ }
BEGIN
     GetCurrentChar := CHR ( BufferPtr^ [ NowLinePtr ] )

END; { function LocationText.GetCurrentChar }

{----------------------------------------------------------}

PROCEDURE LocationText.SetCurrentChar ( Ch : CHAR );

          { ⠭ ⥪騩 ᨬ ⮪ }
BEGIN
     BufferPtr^ [ NowLinePtr ] := ORD ( Ch )

END; { procedure LocationText.SetCurrentChar }

{----------------------------------------------------------}

PROCEDURE LocationText.NextChar;

          { ⢫ 室  ᫥饬 ᨬ }
VAR
   HelpS : StandartString;

BEGIN
     KeyEOF := FALSE;
     IF ( SizeFact = 0 ) THEN
        BEGIN
             KeyEOF := TRUE;
             EXIT
        END;
     IF ( NowLinePtr < ( SizeFact - 1 ) ) THEN
        BEGIN
             INC ( NowLinePtr );
             EXIT
        END;
     IF ( SizeFact < SizeBuf ) THEN
        BEGIN
             KeyEOF := TRUE;
             EXIT
        END;
     IF ( NumError <> 0 ) THEN
        BEGIN
             STR ( NumError, Helps );
             FatalError ( '⠭  訡 #'+Helps+
                          '  室  NextChar' )
        END;
     NowLinePtr := 0;
     PointBeginBuf := PointBeginBuf + SizeBuf;
     SEEK ( Fl, PointBeginBuf );
     BLOCKREAD ( Fl, BufferPtr^, SizeBuf, SizeFact );
     IF ( IORESULT <> 0 ) THEN
        BEGIN
             NumError := 1;
             ErrorProc ( NumError );
             EXIT
        END;
     IF ( SizeFact = 0 ) THEN
        BEGIN
             KeyEOF := TRUE;
             EXIT
        END

END; { procedure LocationText.NextChar }

{----------------------------------------------------------}

PROCEDURE LocationText.PrevChar;

          { ⢫ 室  ।饬 ᨬ }
VAR
   HelpS : StandartString;

BEGIN
     KeyEOF := FALSE;
     IF ( SizeFact = 0 ) THEN
        BEGIN
             KeyEOF := TRUE;
             EXIT
        END;
     IF ( NowLinePtr > 0 ) THEN
        BEGIN
             DEC ( NowLinePtr );
             EXIT
        END;
     IF ( PointBeginBuf = 0 ) THEN
        BEGIN
             KeyEOF := TRUE;
             EXIT
        END;
     IF ( NumError <> 0 ) THEN
        BEGIN
             STR ( NumError, Helps );
             FatalError ( '⠭  訡 #'+Helps+
                          '  室  PrevChar' )
        END;
     PointBeginBuf := PointBeginBuf - SizeBuf;
     IF ( PointBeginBuf < 0 ) THEN
        PointBeginBuf := 0;
     SEEK ( Fl, PointBeginBuf );
     BLOCKREAD ( Fl, BufferPtr^,SizeBuf, SizeFact );
     IF ( IORESULT <> 0 ) THEN
        BEGIN
             NumError := 1;
             ErrorProc ( NumError )
        END;
     IF ( SizeFact = 0 ) THEN
        BEGIN
             KeyEOF := TRUE;
             EXIT
        END;
     NowLinePtr := SizeFact - 1

END; { procedure LocationText.PrevChar }

{----------------------------------------------------------}

PROCEDURE LocationText.SetLineNumber ( Num : LONGINT );

          { ⠭  ࠡ뢠 ப       }
VAR
   Key    : BOOLEAN;
            { ਧ ࠢ ᪠ }

   HelpS : StandartString;
            { ᯮ⥫쭠 ப }
BEGIN

        { ஢ન  砫 ⠭ }

     IF ( NumError <> 0 ) THEN
        BEGIN
             STR ( NumError, Helps );
             FatalError ( '⠭  訡 #'+Helps+
                          '  室  SetLineNumber' )
        END;

     SingStreamEOF := FALSE;
     IF ( Num = NowLineNumber ) THEN
        EXIT;
     IF ( ( Num < 1 ) OR ( Num > MaxLineNumber ) ) THEN
        BEGIN
             NumError := 4;
             ErrorProc ( NumError );
             EXIT
        END;

          { ⠭   ப 䠩 ⮪ }

     IF ( Num = 1 ) THEN
        BEGIN
             NowLineNumber := 1;
             NowLinePtr := 0;
             IF ( PointBeginBuf <> 0 ) THEN
                BEGIN
                     PointBeginBuf := 0;
                     SEEK ( Fl, 0 );
                     BLOCKREAD ( Fl, BufferPtr^, SizeBuf, SizeFact );
                     IF ( IORESULT <> 0 ) THEN
                        BEGIN
                             NumError := 1;
                             ErrorProc ( NumError )
                        END
                END;
             KeyEOF := FALSE;
             EXIT
        END;

        { ⠭ ࠢ  㪠⥫  ⮪ }
        { TRUE - אַ ࠢ  }
        { FALSE - ॢᨢ  }

     Key := ( ( Num - NowLineNumber ) > 0 );
     KeyEOF := FALSE;

        { ⠭ 㪠⥫  ॢᨢ   ⮪ }

     IF ( NOT Key ) THEN
        BEGIN
             IF ( GetCurrentChar <> #$0A ) THEN
                PrevChar;
             IF ( GetCurrentChar <> #$0A ) THEN
                FatalError ( ' #$0A  ⭮ 室  SetLineNumber' );
             PrevChar;
             IF ( GetCurrentChar <> #$0D ) THEN
                FatalError ( ' #$0D  ⭮ 室  SetLineNumber' )
        END;

         { 横 ᪠  ⮪ }

     WHILE ( ( Num <> NowLineNumber ) AND ( NOT KeyEOF ) ) DO
           BEGIN
                IF ( Key ) THEN
                   BEGIN
                        IF ( GetCurrentChar = #$0D ) THEN
                           BEGIN
                                NextChar;
                                IF ( GetCurrentChar = #$0A ) THEN
                                   INC ( NowLineNumber )
                           END;
                        NextChar
                   END
                ELSE
                    BEGIN
                         PrevChar;
                         IF ( ( GetCurrentChar = #$0A ) OR ( KeyEOF ) ) THEN
                            BEGIN
                                 IF ( NOT KeyEOF ) THEN
                                    PrevChar;
                                 IF ( ( GetCurrentChar = #$0D )
                                      OR ( KeyEOF ) ) THEN
                                    DEC ( NowLineNumber )
                            END
                    END
           END;

        {  砥 ॢᨢ  ⠭ 㪠⥫ }
                 {  砫 ᫥饩 ப }

     IF ( ( NOT Key ) AND ( NOT KeyEOF ) ) THEN
        BEGIN
             IF ( GetCurrentChar = #$0A ) THEN
                FatalError ( '   ப  ⭮ '+
                             '室  SetLineNumber' )
             ELSE
                 IF ( GetCurrentChar = #$0D ) THEN
                    BEGIN
                         NextChar;
                         NextChar
                    END
        END;

        { ஢ઠ  ᮮ⢥⢨ ⠭  訢  }

     IF ( Num <> NowLineNumber ) THEN
        FatalError ( '訡  楤 SetLineNumber'+
                     ' - ᮮ⢥⢨   ᪥ ப' );

     {$IFDEF DEBUGTEXT}
     IF ( NOT CheckBeginLine ) THEN
        BEGIN
             STR ( NowLineNumber, HelpS );
             FatalError ( ' ⠭  砫 ப #' + HelpS +
                          '  楤 SetLineNumber' )
        END;
     {$ENDIF}

END; { procedure LocationText.SetLineNumber }

{----------------------------------------------------------}

FUNCTION LocationText.GetLineNumber : LONGINT;

         {   ࠡ뢠 ப         }
BEGIN
     GetLineNumber := NowLineNumber

END; { function LocationText.GetLineNumber }

{----------------------------------------------------------}

FUNCTION LocationText.GetSize : LONGINT;

         {  饥 ⢮ ப  ⥪⮢  }
         { ⮪                                       }
BEGIN
     GetSize := MaxLineNumber

END; { function LocationText.GetSize }

{----------------------------------------------------------}

FUNCTION LocationText.EofText : BOOLEAN;

         {  ਧ 襭 ⮪           }
BEGIN
     EofText := SingStreamEOF

END; { function LocationText.EofText }

{----------------------------------------------------------}

PROCEDURE LocationText.ReadLines ( Quantity : LONGINT;
                                   VAR LnPtr : RecLinePtr );

          { ᮧ ᯨ᮪   ⢠      }
          { ப 㦠   ⮪                 }
VAR
   HelpS : StandartString;
          { ᯮ⥫쭠 ६ }

FUNCTION GetLine ( Quantity : LONGINT ) : RecLinePtr;

         { 頥 㪠⥫  ᯨ᮪   ⢠ ப }
VAR
   Hlp : RecLinePtr;
   GetByte : CHAR;
   Sz : WORD;
   KeyFind : BOOLEAN;

BEGIN
        { 砫 ⠭  ஢ન }

     IF ( NumError <> 0 ) THEN
        BEGIN
             STR ( NumError, Helps );
             FatalError ( '⠭  訡 #'+Helps+
                          '  室  GetLine/ReadLines' )
        END;
     Sz := 0;
     IF ( Quantity = 0 ) THEN
        BEGIN
             GetLine := NIL;
             EXIT
        END;
     NEW ( Hlp );
     IF ( Hlp = NIL ) THEN
        BEGIN
             NumError := 6;
             ErrorProc ( NumError );
             GetLine := NIL;
             EXIT;
        END;
     Hlp^.Line := '';
     KeyFind := FALSE;

           { ନ஢ ப ⮪ }

     WHILE ( ( NOT KeyFind ) AND ( NOT KeyEOF ) ) DO
           BEGIN
                Hlp^.Line := Hlp^.Line + GetCurrentChar;
                IF ( GetCurrentChar = #$0D ) THEN
                   BEGIN
                        NextChar;
                        IF ( GetCurrentChar = #$0A ) THEN
                           KeyFind := TRUE
                         ELSE
                             Hlp^.Line := Hlp^.Line + GetCurrentChar
                    END;
                 NextChar
           END;

           { ନ஢ ਧ ᫥ ப }

     INC ( NowLineNumber );
     IF ( NowLineNumber > MaxLineNumber ) THEN
        BEGIN
             NowLineNumber := MaxLineNumber;
             SingStreamEOF := TRUE;
             IF ( NOT KeyEOF ) THEN
                FatalError ( '砭 ⮪   GetChar/ReadLines' );
        END;

          {   砫 ᫥ ப }

     IF ( ( SingStreamEOF ) AND ( GetCurrentChar <> #$0A ) ) THEN
        BEGIN
             REPEAT
                   GetByte := GetCurrentChar;
                   PrevChar
             UNTIL ( ( KeyEOF ) OR ( ( GetByte = #$0A ) AND
                     ( GetCurrentChar = #$0D ) ) );
             IF ( NOT KeyEOF ) THEN
                BEGIN
                     NextChar;
                     NextChar
                END
        END;

         { 㤠  ப "譨" ᨬ 祭  ନ஢ }

     IF ( ( Hlp^.Line <> '' ) AND
        ( Hlp^.Line [ LENGTH ( Hlp^.Line ) ] = #$0D ) ) THEN
        DELETE ( Hlp^.Line, LENGTH ( Hlp^.Line ), 1 );
     IF ( ( Hlp^.Line [ 1 ] = #$0A ) AND ( SingStreamEOF ) ) THEN
        Hlp^.Line := '';

        { 㯨  ନ஢ ᫥饩 ப ᯨ᪠ }

     DEC ( Quantity );
     Hlp^.Next := GetLine ( Quantity );
     GetLine := Hlp

END; { function GetLine }

BEGIN  { ReadLines }

        { ஢ન }

     IF ( NumError <> 0 ) THEN
        BEGIN
             STR ( NumError, Helps );
             FatalError ( '⠭  訡 #'+Helps+
                          '  室  ReadLines' )
        END;

     IF ( ( ( NowLineNumber + Quantity ) > MaxLineNumber + 1 ) OR
           ( Quantity < 0 ) ) THEN
        BEGIN
             NumError := 4;
             ErrorProc ( NumError );
             EXIT
        END;
     IF ( Quantity = 0 ) THEN
        EXIT;

        { 㧪 ᯨ᪠ ப }

     IF ( LnPtr <> NIL ) THEN
        FatalError ( '।  ⮩ 㪠⥫  ReadLines' );
     KeyEOF := FALSE;
     LnPtr := GetLine ( Quantity );

END; { procedure LocationText.ReadLines }

{----------------------------------------------------------}

PROCEDURE LocationText.TruncateLines;

          { ᥪ ப  ⮪ 稭  ⥪饩 }
VAR
   HelpS : StandartString;
            { ᯮ⥫쭠 ப }

   HelpChar : CHAR;
            { ᯮ⥫ ᨬ }

BEGIN
        { ஢ન }

     IF ( NumError <> 0 ) THEN
        BEGIN
             STR ( NumError, Helps );
             FatalError ( '⠭  訡 #'+Helps+
                          '  室  TruncateLines' )
        END;

        { 㭨⮦ ᥣ ⮪ }

     IF ( NowLineNumber = 1 ) THEN
        BEGIN
             SEEK ( Fl, 0 );
             TRUNCATE ( Fl );
             PointBeginBuf := 0;
             KeyEOF := TRUE;
             NowLinePtr := 0;
             SizeFact := 0;
             MaxLineNumber := 1;
             SingState := FALSE;
             IF ( IORESULT <> 0 ) THEN
                BEGIN
                     NumError := 5;
                     ErrorProc ( NumError );
                     EXIT
                END;
             {$IFDEF DEBUGTEXT}
             IF ( NOT CheckBeginLine ) THEN
                BEGIN
                     STR ( NowLineNumber, HelpS );
                     FatalError ( ' ⠭  砫 ப #' + HelpS +
                                  '  楤 TruncateLines' )
                END;
             {$ENDIF}
             EXIT
        END;

           { ⠭ 㪠⥫   ।饩 ப }

        IF ( GetCurrentChar <> #$0A ) THEN
           PrevChar;
        IF ( GetCurrentChar <> #$0A ) THEN
           FatalError ( ' #$0A  ⭮ 室  TruncateLines' );
        PrevChar;
        IF ( GetCurrentChar <> #$0D ) THEN
           FatalError ( ' #$0D  ⭮ 室  TruncateLines' );

           { 祭  㪠⥫ }

        SEEK ( Fl, PointBeginBuf + NowLinePtr );
        TRUNCATE ( Fl );
        SizeFact := NowLinePtr;
        MaxLineNumber := NowLineNumber - 1;
        IF ( IORESULT <> 0 ) THEN
           BEGIN
                NumError := 5;
                ErrorProc ( NumError );
                EXIT
           END;

           { ⠭ 㪠⥫  砫 ᫥ ப }

        PrevChar;
        REPEAT
              HelpChar := GetCurrentChar;
              PrevChar
        UNTIL ( ( KeyEOF ) OR ( HelpChar = #$0A ) AND
                ( GetCurrentChar = #$0D ) );
        IF ( NOT KeyEOF ) THEN
           BEGIN
                NextChar;
                NextChar
           END;
        KeyEOF := FALSE;
        DEC ( NowLineNumber );
        IF ( DubleNowLineNumber > NowLineNumber ) THEN
           SingState := FALSE;

     {$IFDEF DEBUGTEXT}
     IF ( NOT CheckBeginLine ) THEN
        BEGIN
             STR ( NowLineNumber, HelpS );
             FatalError ( ' ⠭  砫 ப #' + HelpS +
                          '  楤 TruncateLines' )
        END;
     IF ( NOT CheckLineNumber ) THEN
        BEGIN
             STR ( NowLineNumber, HelpS );
             FatalError ( '୮ ⠭ ப #' + HelpS +
                          '  楤 TruncateLines' )
        END;
     IF ( NOT CheckLend ) THEN
        FatalError ( 'ᮮ⢥⢨  ⮪ ᫥ TruncateLines' );

     {$ENDIF}

END; { procedure LocationText.TruncateLines }

{----------------------------------------------------------}

PROCEDURE LocationText.DelLines ( Quantity : LONGINT );

          { 㤠  ⮪  ⢮ ப  }
          { 稭  ⥪饩                            }
VAR
   SaveLineNumber : LONGINT;
           { ࠭  ⥪饩 ப  }

   SaveLinePointer : WORD;
           { ࠭ 㪠⥫  ⥪ ப   }

   SaveBufPtr : LONGINT;
           { ࠭ 㪠⥫  砫   䠩 }

   BeginDel, EndDel : LONGINT;
           { 砫   㤠塞 ⪠ }

   DelBuf : LONGINT;
           { 㪠⥫ 砫   १ }

   SizeDel : LONGINT;
           { ⢮  㤠塞 ଠ樨 }

   SizeFl : LONGINT;
            { ࠧ 䠩 }

   HelpS : StandartString;
            { ᯮ⥫쭠 ப }

   HelpChar : CHAR;
            { ᯮ⥫ ᨬ }

BEGIN
        { ஢ન }

     IF ( NumError <> 0 ) THEN
        BEGIN
             STR ( NumError, Helps );
             FatalError ( '⠭  訡 #'+Helps+
                          '  室  DelLines' )
        END;

     IF ( ( ( NowLineNumber + Quantity ) > MaxLineNumber + 1) OR
           ( Quantity < 0 ) ) THEN
        BEGIN
             NumError := 4;
             ErrorProc ( NumError );
             EXIT
        END;
     IF ( Quantity = 0 ) THEN
        EXIT;

     IF ( ( NowLineNumber + Quantity ) = MaxLineNumber + 1 ) THEN
        BEGIN
             TruncateLines;
             EXIT
        END;

        { ࠭ ⥪ ࠬ஢ }

     SaveLineNumber := NowLineNumber;
     SaveLinePointer := NowLinePtr;
     SaveBufPtr := PointBeginBuf;

        { 塞 ࠧ 㤠塞 ⪠ }

     SetLineNumber ( NowLineNumber +  Quantity );
     BeginDel := SaveBufPtr + SaveLinePointer;
     EndDel := PointBeginBuf + NowLinePtr;
     SizeDel := EndDel - BeginDel;
     IF ( SizeDel <= 0 ) THEN
        FatalError ( '祭 㤠塞 ⪠ <= 0  楤 DelLines' );

        { 㤠塞 ⮪ c 䠩 }

     SizeFl := FILESIZE ( Fl );
     DelBuf := EndDel;
     PointBeginBuf := BeginDel;
     REPEAT
           SEEK ( Fl, DelBuf );
           BLOCKREAD ( Fl, BufferPtr^, SizeBuf, SizeFact );
           IF ( IORESULT <> 0 ) THEN
              BEGIN
                   NumError := 1;
                   ErrorProc ( NumError );
                   EXIT
              END;
           SEEK ( Fl, PointBeginBuf );
           IF ( SizeFact <> 0 ) THEN
              BLOCKWRITE ( Fl, BufferPtr^, SizeFact );
           IF ( IORESULT <> 0 ) THEN
              BEGIN
                   NumError := 2;
                   ErrorProc ( NumError );
                   EXIT
              END;
           PointBeginBuf := PointBeginBuf + SizeBuf;
           DelBuf := DelBuf + SizeBuf
     UNTIL ( SizeFact = 0 );
     SEEK ( Fl, ( SizeFl - SizeDel ) );
     TRUNCATE ( Fl );
     IF ( IORESULT <> 0 ) THEN
        BEGIN
             NumError := 5;
             ErrorProc ( NumError );
             EXIT
        END;

        { ⠭ ࠬ }

     PointBeginBuf := SaveBufPtr;
     NowLinePtr := SaveLinePointer;
     NowLineNumber := SaveLineNumber;
     MaxLineNumber := MaxLineNumber - Quantity;
     SEEK ( Fl, PointBeginBuf );
     BLOCKREAD ( Fl, BufferPtr^, SizeBuf, SizeFact );
     IF ( IORESULT <> 0 ) THEN
         BEGIN
              NumError := 1;
              ErrorProc ( NumError );
              EXIT
         END;

     IF ( DubleNowLineNumber > NowLineNumber ) THEN
        SingState := FALSE;

     {$IFDEF DEBUGTEXT}
     IF ( NOT CheckBeginLine ) THEN
        BEGIN
             STR ( NowLineNumber, HelpS );
             FatalError ( ' ⠭  砫 ப #' + HelpS +
                          '  楤 DelLines' )
        END;
     IF ( NOT CheckLineNumber ) THEN
        BEGIN
             STR ( NowLineNumber, HelpS );
             FatalError ( '୮ ⠭ ப #' + HelpS +
                          '  楤 DelLines' )
        END;
     IF ( NOT CheckLend ) THEN
        FatalError ( 'ᮮ⢥⢨  ⮪ ᫥ DelLines' );
     {$ENDIF}

END; { procedure LocationText.DelLines }

{----------------------------------------------------------}

PROCEDURE LocationText.AddLines ( Quantity : LONGINT; LnPtr : RecLinePtr );

          {   ⢮ ப       }
          { ᯨ᪠  ⮪                              }
VAR
   SaveBufPtr : LONGINT;
           { ࠭ 㪠⥫  砫   䠩 }

   SaveLinePtr : WORD;
           { ࠭ 㪠⥫   }

   Hlp : RecLinePtr;
           { ᯮ⥫ 㪠⥫ }

   SizeAdd : WORD;
           { ⢮  塞 ଠ樨 }

   Index : BYTE;
           {  ᨬ  ப }

   HelpS : StandartString;
           { ᯮ⥫쭠 ப }

   KeyLine : BOOLEAN;
           { ਧ  ⢨ ⠭  砫 ப }

PROCEDURE AddChar ( HlpCh : CHAR );

          {  ᨬ  ⮪ }
BEGIN
     IF ( NumError <> 0 ) THEN
        BEGIN
             STR ( NumError, Helps );
             FatalError ( '⠭  訡 #'+Helps+
                          '  室  AddLines/AddChar' )
        END;

     IF ( SizeFact < SizeBuf ) THEN
        BEGIN
             INC ( SizeFact );
             INC ( NowLinePtr );
             SetCurrentChar ( HlpCh );
             EXIT
        END;
     SEEK ( Fl, PointBeginBuf );
     BLOCKWRITE ( Fl, BufferPtr^, SizeFact );
     PointBeginBuf := PointBeginBuf + SizeBuf;
     IF ( IORESULT <> 0 ) THEN
        BEGIN
             NumError := 2;
             ErrorProc ( NumError );
             EXIT;
        END;
     NowLinePtr := 0;
     SizeFact := 1;
     SetCurrentChar ( HlpCh )

END; { procedure AddChar }

BEGIN
        { ஢ન  砫 ⠭ }

     IF ( NumError <> 0 ) THEN
        BEGIN
             STR ( NumError, Helps );
             FatalError ( '⠭  訡 #'+Helps+
                          '  室  AddLines' )
        END;

     IF ( ( LnPtr = NIL ) OR ( Quantity = 0 ) ) THEN
        EXIT;
     IF ( Quantity < 0 ) THEN
        BEGIN
             NumError := 4;
             ErrorProc ( NumError );
             EXIT
        END;

           { 砫 ⠭ }

     SaveBufPtr := PointBeginBuf;
     SaveLinePtr := NowLinePtr;
     KeyLine := ( ( NowLineNumber = MaxLineNumber ) AND
                  ( GetCurrentChar = #$0A ) );
     PointBeginBuf := ( FILESIZE ( Fl ) DIV SizeBuf ) * SizeBuf;
     SEEK ( Fl, PointBeginBuf );
     BLOCKREAD ( Fl, BufferPtr^, SizeBuf, SizeFact );
     NowLinePtr := SizeFact - 1;
     Hlp := LnPtr;

        {  ப  ᯨ᪠  䠩 }

     REPEAT
           IF NOT ( ( SizeFact = 0 ) AND ( MaxLineNumber = 1 ) ) THEN
              BEGIN
                   INC ( MaxLineNumber );
                   AddChar ( #$0D );
                   AddChar ( #$0A )
              END;
           FOR Index := 1 TO LENGTH ( Hlp^.Line ) DO
               AddChar ( Hlp^.Line [ Index ]  );
           Hlp := Hlp^.Next;
           DEC ( Quantity );
     UNTIL ( ( Hlp = NIL ) OR ( Quantity = 0 ) OR ( NumError <> 0 ) );
     SEEK ( Fl, PointBeginBuf );
     BLOCKWRITE ( Fl, BufferPtr^, SizeFact );
     IF ( IORESULT <> 0 ) THEN
        BEGIN
             NumError := 2;
             ErrorProc ( NumError );
             EXIT;
        END;

        {  室 ﭨ }

     PointBeginBuf := SaveBufPtr;
     NowLinePtr := SaveLinePtr;
     KeyEOF := FALSE;
     SEEK ( Fl, PointBeginBuf );
     BLOCKREAD ( Fl, BufferPtr^, SizeBuf, SizeFact );
     IF ( IORESULT <> 0 ) THEN
        BEGIN
             NumError := 1;
             ErrorProc ( NumError );
             EXIT
        END;
     IF ( KeyLine ) THEN
        IF ( GetCurrentChar = #$0A ) THEN
           NextChar
        ELSE
            FatalError ( '訡  AddLines  ⠭  砫 ப' );

     {$IFDEF DEBUGTEXT}
     IF ( NOT CheckBeginLine ) THEN
        BEGIN
             STR ( NowLineNumber, HelpS );
             FatalError ( ' ⠭  砫 ப #' + HelpS +
                          '  楤 AddLines' )
        END;
     IF ( NOT CheckLineNumber ) THEN
        BEGIN
             STR ( NowLineNumber, HelpS );
             FatalError ( '୮ ⠭ ப #' + HelpS +
                          '  楤 AddLines' )
        END;
     IF ( NOT CheckLend ) THEN
        FatalError ( 'ᮮ⢥⢨  ⮪ ᫥ AddLines' );
     {$ENDIF}

END; { procedure LocationText.AddLines }

{----------------------------------------------------------}

PROCEDURE LocationText.InsertLines ( Quantity : LONGINT; LnPtr : RecLinePtr );

          { ⠢  ⢮ ப       }
          { ᯨ᪠  ⮪                              }
VAR
   SaveLineNumber : LONGINT;
           { ࠭  ⥪饩 ப  }

   SaveLinePointer : WORD;
           { ࠭ 㪠⥫  ⥪ ப   }

   SaveBufPtr : LONGINT;
           { ࠭ 㪠⥫  砫   䠩 }

   Index : BYTE;
           { ᭠ ६ ப }

   SizeAdd : LONGINT;
           {  砥 墮 }

   OldSize : LONGINT;
           { ஥ 祭  䠩 }

   SizeCheck : WORD;
           { ஫ ࠧ }

   Hlp : RecLinePtr;
           { ᯮ⥫ 㪠⥫ }

   HelpS : StandartString;
           { ᯮ⥫쭠 ப }

PROCEDURE LocationChar ( HlpCh : CHAR );

          { ࠧ ᨬ  ⮪ }
BEGIN
     IF ( NumError <> 0 ) THEN
        BEGIN
             STR ( NumError, Helps );
             FatalError ( '⠭  訡 #'+Helps+
                          '  室  InsertLines/LocationChar' )
        END;

     IF ( NowLinePtr < SizeFact  - 1 ) THEN
        BEGIN
             SetCurrentChar ( HlpCh );
             INC ( NowLinePtr );
             EXIT
        END;

     SetCurrentChar ( HlpCh );
     SEEK ( Fl, PointBeginBuf );
     BLOCKWRITE ( Fl, BufferPtr^, SizeFact );
     PointBeginBuf := PointBeginBuf + SizeBuf;
     IF ( IORESULT <> 0 ) THEN
        BEGIN
             NumError := 2;
             ErrorProc ( NumError );
             EXIT;
        END;
     SEEK ( Fl, PointBeginBuf );
     BLOCKREAD ( Fl, BufferPtr^, SizeBuf, SizeFact );
     IF ( IORESULT <> 0 ) THEN
        BEGIN
             NumError := 1;
             ErrorProc ( NumError );
             EXIT;
        END;
     IF ( SizeFact = 0 ) THEN
        FatalError ( ' 砭 ⮪  '+
                     'InsertLines/LocationChar' );
     NowLinePtr := 0

END; { procedure LocationChar }

BEGIN
        { ஢ન }

     IF ( NumError <> 0 ) THEN
        BEGIN
             STR ( NumError, Helps );
             FatalError ( '⠭  訡 #'+Helps+
                          '  室  InsertLines' )
        END;

     IF ( Quantity < 0 ) THEN
        BEGIN
             NumError := 4;
             ErrorProc ( NumError );
             EXIT
        END;

     IF ( ( Quantity = 0 ) OR ( LnPtr = NIL ) ) THEN
        EXIT;

        { ⠢  ⮩ ⮪ }

     IF ( ( NowLineNumber = 1 ) AND ( SizeFact = 0 ) ) THEN
        BEGIN
             AddLines ( Quantity, LnPtr );
             EXIT
        END;

        { ࠭ ⥪ ࠬ஢ }

     SaveLineNumber := NowLineNumber;
     SaveLinePointer := NowLinePtr;
     SaveBufPtr := PointBeginBuf;
     IF ( DubleNowLineNumber > NowLineNumber ) THEN
        SingState := FALSE;

        { 塞  䠩 "墮"   }

     OldSize := FILESIZE ( Fl );
     SizeAdd := FullSizeQLines ( Quantity, LnPtr );
     WHILE ( SizeAdd > 0 ) DO
           BEGIN
                PointBeginBuf := FILESIZE ( Fl );
                SEEK ( Fl, PointBeginBuf );
                IF ( SizeAdd >= SizeBuf ) THEN
                   BEGIN
                        SizeAdd := SizeAdd - SizeBuf;
                        SizeFact := SizeBuf
                   END
                ELSE
                    BEGIN
                         SizeFact := SizeAdd;
                         SizeAdd := 0
                    END;
                BLOCKWRITE ( Fl, BufferPtr^, SizeFact );
                IF ( IORESULT <> 0 ) THEN
                   BEGIN
                        NumError := 2;
                        ErrorProc ( NumError );
                        EXIT
                   END
           END;

        { ७  䠩  "墮" }

        PointBeginBuf := FILESIZE ( Fl );
        WHILE ( OldSize > SaveBufPtr + SaveLinePointer ) DO
              BEGIN
                   IF ( ( OldSize - ( SaveBufPtr + SaveLinePointer) )
                         >= SizeBuf ) THEN
                      SizeFact := SizeBuf
                   ELSE
                       SizeFact := OldSize - ( SaveBufPtr + SaveLinePointer);
                   PointBeginBuf := PointBeginBuf - SizeFact;
                   OldSize := OldSize - SizeFact;
                   SEEK ( Fl, OldSize );
                   BLOCKREAD ( Fl, BufferPtr^, SizeFact, SizeCheck );
                   IF ( SizeCheck <> SizeFact ) THEN
                      FatalError ( 'ᮮ⢥⢨ ࠧ  楤 '+
                                   'InsertLines  ७ "墮"' );
                   IF ( IORESULT <> 0 ) THEN
                      BEGIN
                           NumError := 1;
                           ErrorProc ( NumError );
                           EXIT
                      END;
                   SEEK ( Fl, PointBeginBuf );
                   BLOCKWRITE ( Fl, BufferPtr^, SizeFact );
                   IF ( IORESULT <> 0 ) THEN
                      BEGIN
                           NumError := 2;
                           ErrorProc ( NumError );
                           EXIT
                      END
              END;

        { ⠭ ࠬ஢ }

     PointBeginBuf := SaveBufPtr;
     NowLinePtr := SaveLinePointer;
     NowLineNumber := SaveLineNumber;
     SEEK ( Fl, PointBeginBuf );
     IF ( NumError = 0 ) THEN
        BLOCKREAD ( Fl, BufferPtr^, SizeBuf, SizeFact );
     IF ( IORESULT <> 0 ) THEN
         BEGIN
              NumError := 1;
              ErrorProc ( NumError )
         END;

       { ᥭ ⠢塞 ப  ⮪ }

     Hlp := LnPtr;
     REPEAT
           INC ( MaxLineNumber );
           INC ( NowLineNumber );
           FOR Index := 1 TO LENGTH ( Hlp^.Line ) DO
               LocationChar ( Hlp^.Line [ Index ]  );
           LocationChar ( #$0D );
           LocationChar ( #$0A );
           Hlp := Hlp^.Next;
           DEC ( Quantity );
     UNTIL ( ( Hlp = NIL ) OR ( Quantity = 0 ) OR ( NumError <> 0 ) );
     SEEK ( Fl, PointBeginBuf );
     BLOCKWRITE ( Fl, BufferPtr^, SizeFact );
     IF ( IORESULT <> 0 ) THEN
        BEGIN
             NumError := 2;
             ErrorProc ( NumError );
             EXIT;
        END;

     {$IFDEF DEBUGTEXT}
     IF ( NOT CheckBeginLine ) THEN
        BEGIN
             STR ( NowLineNumber, HelpS );
             FatalError ( ' ⠭  砫 ப #' + HelpS +
                          '  楤 InsertLines' )
        END;
     IF ( NOT CheckLineNumber ) THEN
        BEGIN
             STR ( NowLineNumber, HelpS );
             FatalError ( '୮ ⠭ ப #' + HelpS +
                          '  楤 InsertLines' )
        END;
     IF ( NOT CheckLend ) THEN
        FatalError ( 'ᮮ⢥⢨  ⮪ ᫥ InsertLines' );
     {$ENDIF}

END; { procedure LocationText.InsertLines }

{----------------------------------------------------------}

PROCEDURE LocationText.ReplaseLines ( DelQuantity : LONGINT;
                         InsQuantity : LONGINT; LnPtr : RecLinePtr );

          {   ⢮ ப ⥪  }
          { ⮪                                      }
VAR
   HelpLineNumber : LONGINT;

   HelpS : StandartString;

BEGIN
     IF ( NumError <> 0 ) THEN
        BEGIN
             STR ( NumError, Helps );
             FatalError ( '⠭  訡 #'+Helps+
                          '  室  ReplaseLines' )
        END;

     IF ( ( NowLineNumber + DelQuantity ) = MaxLineNumber + 1 ) THEN
        HelpLineNumber := NowLineNumber
     ELSE
         HelpLineNumber := 0;
     DelLines ( DelQuantity );
     IF ( HelpLineNumber = 0 ) THEN
        InsertLines ( InsQuantity, LnPtr )
     ELSE
         BEGIN
              AddLines ( InsQuantity, LnPtr );
              SetLineNumber ( HelpLineNumber )
         END

END; { procedure LocationText.ReplaceLines }

{----------------------------------------------------------}

PROCEDURE LocationText.ReadLine ( VAR Line : STRING );

         { 㦠  ப  ⮪             }
VAR
   Hlp : RecLinePtr;

BEGIN
     IF ( NumError <> 0 ) THEN
        EXIT;
     Hlp := NIL;
     ReadLines ( 1, Hlp );
     Line := Hlp^.Line;
     ClearListRecLine ( Hlp )

END; { procedure LocationText.ReadLine }

{----------------------------------------------------------}

PROCEDURE LocationText.InsLine ( Line : STRING );

          { ⠢  ப  ⮪              }
VAR
   Hlp : RecLinePtr;

BEGIN
     IF ( NumError <> 0 ) THEN
        EXIT;
     NEW ( Hlp );
     IF ( Hlp = NIL ) THEN
        BEGIN
             NumError := 6;
             ErrorProc ( NumError );
             EXIT
        END;
     Hlp^.Line := Line;
     Hlp^.Next := NIL;
     InsertLines ( 1, Hlp );
     DISPOSE ( Hlp )

END; { procedure LocationText.InsLine }

{----------------------------------------------------------}

PROCEDURE LocationText.DelLine;

          { 㤠  ப  ⮪              }
BEGIN
     IF ( NumError = 0 ) THEN
        DelLines ( 1 )

END; { procedure LocationText.DelLine }

{----------------------------------------------------------}

PROCEDURE LocationText.WriteLine ( Line : STRING );

          {   ப  ⮪                  }
VAR
   Hlp : RecLinePtr;

BEGIN
     IF ( NumError <> 0 ) THEN
        EXIT;
     NEW ( Hlp );
     IF ( Hlp = NIL ) THEN
        BEGIN
             NumError := 6;
             ErrorProc ( NumError );
             EXIT
        END;
     Hlp^.Line := Line;
     Hlp^.Next := NIL;
     ReplaseLines ( 1, 1, Hlp );
     DISPOSE ( Hlp )

END; { procedure LocationText.WriteLine }

{----------------------------------------------------------}

PROCEDURE LocationText.AddLine ( Line : STRING );

          {  ப  ⮪ }
VAR
   Hlp : RecLinePtr;

BEGIN
     IF ( NumError <> 0 ) THEN
        EXIT;
     NEW ( Hlp );
     IF ( Hlp = NIL ) THEN
        BEGIN
             NumError := 6;
             ErrorProc ( NumError );
             EXIT
        END;
     Hlp^.Line := Line;
     Hlp^.Next := NIL;
     AddLines ( 1, Hlp );
     DISPOSE ( Hlp )

END; { procedure LocationText.AddLine }

{----------------------------------------------------------}

PROCEDURE LocationText.SetErrorProc ( Param : ErrorProcedure );

          { ⠭ 楤 ࠡ⪨ 訡 }
          { 権                                 }
BEGIN
     ErrorProc := Param

END; { procedure LocationText.SetErrorProc }

{----------------------------------------------------------}

PROCEDURE LocationText.SaveState;

          { ࠭ ⥪饥 ﭨ }
BEGIN
     DublePointBeginBuf := PointBeginBuf;
     DubleNowLinePtr := NowLinePtr;
     DubleNowLineNumber := NowLineNumber;
     DubleKeyEOF := KeyEof;
     SingState := TRUE

END; { procedure LocationText.SaveState }

{----------------------------------------------------------}
PROCEDURE LocationText.RestoreState;

          { ⠭ ࠭ ࠭ ﭨ }
VAR
   HelpS : StandartString;
            { ᯮ⥫쭠 ப }

BEGIN
        { ஢ન }

     IF ( NumError <> 0 ) THEN
        BEGIN
             STR ( NumError, Helps );
             FatalError ( '⠭  訡 #'+Helps+
                          '  室  RestoreState' )
        END;

     IF ( NOT SingState ) THEN
        BEGIN
             IF ( DubleNowLineNumber > GetSize ) THEN
                FatalError ( ' ⠭ ࠭ ﭨ'+
                             ' - RestoreState' );
             SetLineNumber ( DubleNowLineNumber );
             EXIT
        END;

     IF ( DublePointBeginBuf <> PointBeginBuf ) THEN
        BEGIN
             SEEK ( fl, DublePointBeginBuf );
             BLOCKREAD ( Fl, BufferPtr^, SizeBuf, SizeFact );
             IF ( IORESULT <> 0 ) THEN
                 BEGIN
                      NumError := 1;
                      ErrorProc ( NumError );
                      EXIT
                 END
        END;
     PointBeginBuf := DublePointBeginBuf;
     NowLinePtr := DubleNowLinePtr;
     NowLineNumber := DubleNowLineNumber;
     KeyEOF := DubleKeyEOF;

     {$IFDEF DEBUGTEXT}
     IF ( NOT CheckBeginLine ) THEN
        BEGIN
             STR ( NowLineNumber, HelpS );
             FatalError ( ' ⠭  砫 ப #' + HelpS +
                          '  楤 RestoreState' )
        END;
     IF ( NOT CheckLineNumber ) THEN
        BEGIN
             STR ( NowLineNumber, HelpS );
             FatalError ( '୮ ⠭ ப #' + HelpS +
                          '  楤 RestoreState' )
        END;
     {$ENDIF}

END; { procedure LocationText.RestoreState }

{----------------------------------------------------------}

DESTRUCTOR LocationText.Done;

           { 뢠 䠩, 㭨⮦           }
           { 樠 쥪                    }

BEGIN
     IF ( SingWrite ) THEN
        BEGIN
             SEEK ( Fl, PointBeginBuf );
             BLOCKWRITE ( Fl, BufferPtr^, SizeFact );
             IF ( IORESULT <> 0 ) THEN
                BEGIN
                     NumError := 2;
                     ErrorProc ( NumError )
                END;
        END;
     CLOSE ( Fl );
     IF ( IORESULT <> 0 ) THEN
        BEGIN
             NumError := 2;
             ErrorProc ( NumError )
        END;
     FREEMEM ( BufferPtr, SizeBuf )

END; { destructor LocationText.Done }

{==========================================================}

CONSTRUCTOR LocationListText.Init ( LnPtr : RecLinePtr; Max : LONGINT );

            { 樠 쥪, १ࢨ஢  }
            {  ⨥ 䠩                             }

BEGIN
     NumError := 0;
     List := LnPtr;
     IF ( List = NIL ) THEN
        BEGIN
             NEW ( List );
             List^.Next := NIL;
             List^.Line := ''
        END;
     NowLineNumber := 1;
     MaxLine := Max;
     TruncateListLine ( MaxLine, List );
     MaxLineNumber := SizeListLine ( List );
     SaveState

END; { constructor LocationListText.Init }

{----------------------------------------------------------}

PROCEDURE LocationListText.ReSetStream;

          { 砫쭠 ⠭ ⥪⮢ ⮪ }
BEGIN
     NumError := 0;
     NowLinePtr := 0;
     MaxLineNumber := SizeListLine ( List );
     SingStreamEOF := FALSE

END; { procedure LocationListText.ReSetStream }

{----------------------------------------------------------}

FUNCTION LocationListText.GetListPtr : RecLinePtr;

         {  㪠⥫  ᯨ᮪ ⮪ }
BEGIN
     GetListPtr := List

END; { function LocationListText.GetListPtr }

{----------------------------------------------------------}

PROCEDURE LocationListText.SetLineNumber ( Num : LONGINT );

          { ⠭  ࠡ뢠 ப       }
BEGIN
     IF ( NumError <> 0 ) THEN
        EXIT;
     IF ( ( Num < 1 ) OR ( Num > MaxLineNumber ) ) THEN
        BEGIN
             NumError := 4;
             ErrorProc ( NumError );
             EXIT
        END;
     SingStreamEOF := FALSE;
     NowLineNumber := Num

END; { procedure LocationListText.SetLineNumber }

{----------------------------------------------------------}

PROCEDURE LocationListText.DelLines ( Quantity : LONGINT );

          { 㤠  ⮪  ⢮ ப  }
          { 稭  ⥪饩                            }
VAR
   Index : LONGINT;

BEGIN
     IF ( ( NowLineNumber + Quantity ) = MaxLineNumber + 1 ) THEN
        BEGIN
             TruncateLines;
             EXIT
        END;

     FOR Index := 1 TO QuanTity DO
         DelListLine ( NowLineNumber, List );
     MaxLineNumber := MaxLineNumber - Quantity;
     IF ( MaxLineNumber <> SizeListLine ( List ) ) THEN
        FatalError ( '訡  㤠 ப  ᯨ᪠  DelLines' );
     IF ( NowLineNumber > MaxLineNumber ) THEN
        FatalError ( '訡  ⠭ ப  楤 '+
                     '㤠  DelLines' )

END; { procedure LocationListText.DelLines }

{----------------------------------------------------------}

PROCEDURE LocationListText.ReadLines ( Quantity : LONGINT;
                       VAR LnPtr : RecLinePtr );

         { ᮧ ᯨ᮪   ⢠      }
         { ப 㦠   ⮪                 }
VAR
   Hlp : RecLinePtr;
   Build : RecLinePtr;

BEGIN
     IF ( Quantity < 1 ) THEN
        BEGIN
             NumError := 4;
             ErrorProc ( NumError );
             EXIT
        END;
     Hlp := FindLine ( NowLineNumber, List );
     IF ( Hlp = NIL ) THEN
        FatalError ( '⨣ ⮩ 㪠⥫  ⥭ ReadLines' );
     LnPtr := CopyListLine ( Quantity, Hlp );
     NowLineNumber := NowLineNumber + Quantity;
     IF ( NowLineNumber > MaxLineNumber ) THEN
        BEGIN
             SingStreamEOF := TRUE;
             NowLineNumber := MaxLineNumber
        END
     ELSE
         SingStreamEOF := FALSE

END; { procedure LocationListText.ReadLines }

{----------------------------------------------------------}

PROCEDURE LocationListText.InsertLines ( Quantity : LONGINT;
                               LnPtr : RecLinePtr );

         { ⠢  ⢮ ப       }
         { ᯨ᪠  ⮪                              }
VAR
   First : RecLinePtr;

BEGIN
     IF ( ( MaxLineNumber = 1 ) AND ( List^.Line = '' ) ) THEN
        BEGIN
             AddLines ( Quantity, LnPtr );
             EXIT
        END;
     First := CopyListLine ( Quantity, LnPtr );
     Quantity := SizeListLine ( First );
     InsertList ( NowLineNumber, List, First );
     TruncateListLine ( MaxLine, List );
     NowLineNumber := NowLineNumber + Quantity;
     MaxLineNumber := MaxLineNumber   +  Quantity;
     IF ( MaxLineNumber <> SizeListLine ( List ) ) THEN
        FatalError ( '訡    ᯨ᮪  In  sertLines' );
     IF ( NowLineNumber > MaxLineNumber ) THEN
        NowLineNumber := MaxLineNumber

END; { procedure LocationListText.InsertLines }

{----------------------------------------------------------}

PROCEDURE LocationListText.AddLines ( Quantity : LONGINT;
                              LnPtr : RecLinePtr );

         {   ⢮ ப       }
         { ᯨ᪠  ⮪                              }
VAR
   First : RecLinePtr;

BEGIN
     First := CopyListLine ( Quantity, LnPtr );
     Quantity := SizeListLine ( First );
     IF ( ( SizeListLine ( List ) = 1 ) AND ( List^ .Line = '' ) ) THEN
        BEGIN
             DISPOSE ( List );
             List := NIL;
             AddListLine ( List, First );
             MaxLineNumber := Quantity
        END
     ELSE
         BEGIN
             AddListLine ( List, First );
             MaxLineNumber := MaxLineNumber + Quantity
         END;
     IF ( MaxLineNumber <> SizeListLine ( List ) ) THEN
        FatalError ( '訡   ப  ᯨ᮪  AddLines' );
     TruncateListLine ( MaxLine, List );
     MaxLineNumber := SizeListLine ( List );
     IF ( NowLineNumber > MaxLineNumber ) THEN
        NowLineNumber := MaxLineNumber

END; { procedure LocationListText.AddLines }

{----------------------------------------------------------}

PROCEDURE LocationListText.TruncateLines;

          { ᥪ ப  ⮪ 稭  ⥪饩 }
BEGIN
     IF ( NowLineNumber = 1 ) THEN
        BEGIN
             ClearListRecLine ( List );
             List := NIL;
             NEW ( List );
             List^.Line := '';
             List^.Next := NIL;
             EXIT
        END;
     TruncateListLine ( NowLineNumber, List );
     MaxLineNumber := SizeListLine ( List );
     NowLineNumber := MaxLineNumber

END; { procedure LocationListText.TruncateLines }

{----------------------------------------------------------}

PROCEDURE LocationListText.SaveState;

          { ࠭ ⥪饥 ﭨ }
BEGIN
     DubleNowLineNumber := NowLineNumber;
     SingState := TRUE

END; { procedure LocationListText.SaveState }

{----------------------------------------------------------}

PROCEDURE LocationListText.RestoreState;

          { ⠭ ࠭ ࠭ ﭨ }

BEGIN
     NowLineNumber := DubleNowLineNumber;
     IF ( NowLineNumber > MaxLineNumber ) THEN
        FatalError ( ' ⠭ ﭨ ᯨ᪮ ⮪' )

END; { procedure LocationListText.RestoreState }

{----------------------------------------------------------}

DESTRUCTOR LocationListText.Done;

           { 樠 쥪                    }
BEGIN
     ClearListRecLine ( List )

END; { destructor LocationListText.Done }

{==========================================================}

CONSTRUCTOR LocationProtectText.Init ( SzBuf : WORD; Name : STRING;
                                       Ps : BYTE );

            { 樠 쥪, १ࢨ஢  }
            {  ⨥ 䠩                             }
BEGIN
     Password := Ps;
     LocationText.Init ( SzBuf, Name );

END; { constructor LocationProtectText.Init }

{----------------------------------------------------------}

FUNCTION LocationProtectText.GetCurrentChar : CHAR;

         { 頥 ⥪騩 ᨬ ⮪ }
BEGIN
     GetCurrentChar := CHR ( BufferPtr^ [ NowLinePtr ] - Password )

END; { function LocationProtectText.GetCurrentChar }

{----------------------------------------------------------}

PROCEDURE LocationProtectText.SetCurrentChar ( Ch : CHAR );

          { ⠭ ⥪騩 ᨬ ⮪ }
BEGIN
     BufferPtr^ [ NowLinePtr ] := ORD ( Ch ) + Password

END; { procedure LocationProtectText.SetCurrentChar }

{----------------------------------------------------------}

PROCEDURE LocationProtectText.SetPassword ( Ps : BYTE );

          { ⠭  ஫ }
BEGIN
     Password := Ps

END; { procedure LocationProtectText.SetPassword }

{----------------------------------------------------------}

END.
