; 
;       Module name        : DIRSIZE.ASM
;       Last revision date : 24.5.92
;       Subroutine(s)      : DirSize
;  
;                          Description
;  
;       ।  ࠧ  ४ਨ,    ன  ᮤন
;    ६ DirBuf. OffsEnd 㪠뢠   ப .
;     頥    ॣ   DX:AX  (᫨  CF  襭).
;   ᫨ CF ⠭,  ४  .
;  
;        (C) Copyright by Al Snyatkov & Nick Velichko
; 

	.Data

SizeOfDir	dw	0		;  ⥪饣 ⠫  䠩

	.Code

DirSize	Proc	C

	Local	DTA:Byte:128		; ⢮  ⥪   
					; 쭮 DTA
FileAttr EQU	DTA[15h]
FileSize EQU	DTA[1Ah]
FileName EQU	DTA[1Eh]

	push	SizeOfDir ds es bx si
	
	mov	SizeOfDir,0
	
	mov	ah,2Fh			; --- Get DTA address
	int	21h
	push	es bx			; ࠭塞   DTA
	
	sub	bx,bx			;  ⥪饣 ⠫
	mov	si,bx			; ন  SI:BX = 0
	lea	dx,DTA			
	mov	ah,1Ah			; --- Set new DTA
	int	21h
	
	mov	di,OffsEnd		; 뢠   ப 
	mov	ax,'*\'			; '\*.*',0  㭪権 4Eh-4Fh
	stosw				;		
	mov	al,'.'			;		
	stosw				;		
	sub	ax,ax			;		
	stosw				;		V
	
	lea	dx,DirBuf
	mov	cx,00110111b		; ᪠ , ஬ Volume labels
	mov	ah,4Eh			; --- Find 1st file
	jmp	short	@@Entry
Cycle:	
	mov	ah,4Fh			; --- Find 2nd file
@@Entry:
	int	21h			; ᪠ 䠩.
	jc	@@Exit			;  ᬮ ⠫
	
	add	SizeOfDir,32		;  ⠫  䠩 += 32 
	test	Byte Ptr FileAttr,00010000b	;  ⠫ ?
	jnz	SubDirFound		; .
	
	test	Flags,Wild		;  ᪠  ᪠?
	jz	NoPresent		; .
	
	push	si
	lea	si,FileName		; ਢ  䠩  FCB-
	mov	di,6Ch			;  ⨬   ᬥ饭 006Ch
	mov	ax,2901h		; --- Parse file name
	int	21h
	pop	si
	
	mov	dx,5Dh			;  ᬥ饭 005Dh ࠭ ᪠
	mov	cx,11			; ࠢ 11   005Dh c
	inc	di			; ⠬  006Dh
Compare:
	xchg	si,dx
	lodsb				; 稬  ᪨
	xchg	si,dx
	cmp	al,'?'			;  '?' ?
	je	@@Next			; ,  ࠢ
	cmp	al,[di]			; ࠢ  ⮬  䠩
	jne	Cycle			;  ᮢ - த 
@@Next:	
	inc	di
	loop	Compare			; ࠢ ᫥騥 

NoPresent:
	add	bx,word ptr FileSize	;  ࠧ ⠫
	adc	si,word ptr FileSize+2

	inc	FileCount		;  ᫮  䠩
	
	test	Flags,VERB		; ७ ଠ ?
	jz	Cycle			; , த .
	
	push	cx dx
	mov	al,Byte Ptr FileAttr	; AX - ਡ 䠩
	mov	ah,0
	mov	dx,word ptr FileSize	; CX:DX -  
	mov	cx,word ptr FileSize+2

	push	cx dx			; ࠭ 
	
	shr	ax,1			;  Read-Only 䠩 ?
	jnc	@@1			; .
	inc	ROFiles
	add	word ptr ROSize  ,dx
	adc	word ptr ROSize+2,cx


  @@1:	shr	ax,1			;  Hidden 䠩 ?
	jnc	@@2			; .
	inc	HDFiles
	add	word ptr HDSize  ,dx
	adc	word ptr HDSize+2,cx


  @@2:	shr	ax,1			;  System 䠩 ?
	jnc	@@3			; .
	inc	SYFiles
	add	word ptr SYSize  ,dx
	adc	word ptr SYSize+2,cx


  @@3:	pop	ax dx			; ⠭  䠩
	add	ax,ClustSize		;  稬  ࠧ
	adc	dx,0			;    㫥
	sub	ax,1			; Int ( Size / ClustSize + 1)
	sbb	dx,0			;
	div	ClustSize		;
	add	ClustCnt,ax		; 稬 饥 ᫮ ஢
	pop	dx cx
	
	jmp	Cycle			; த 
; --------------------------------------
SubDirFound:
	cmp	Byte Ptr FileName,'.'	;  CurrentDir  ParentDir ?
	je	Cycle			; , த .
	
	inc	DirCount		; 稬 ᫮ ⠫

	mov	di,OffsEnd
	push	di si			; ࠭ ⥪騩 OffsEnd
	mov	al,'\'			; ⠥ ࠧ ⮣
	stosb				; ⠫.  ⮣
	lea	si,FileName		; ᮧ   ⠫
@@Loop:	SegSS				;  ⥪饣  .
	lodsb				;	     
	stosb				;	     
	or	al,al			;	     
	jnz	@@Loop			;	     V
					;
	pop	si			;
	dec	di			;
	mov	OffsEnd,di		; ⠭  OffsEnd
	call	DirSize			;  맮 ४ᨢ DirSize
	
	add	bx,ax			; 稬 ࠧ ⠫
	adc	si,dx

	pop	OffsEnd			; ⠭  OffsEnd
	jmp	Cycle			; த 
; --------------------------------------
@@Exit:	cmp	ax,3			;  訡 - '  ' ?
	jne	@@4			; 

	stc				;  ⠭ ਧ 訡
	jmp	short	@@5

@@4:	clc				; ᨬ ਧ 訡
@@5:	pop	dx ds			; ⠭  DTA
	pushf
	mov	ah,1Ah			; --- Set new DTA
	int	21h
	
	mov	di,OffsEnd
	mov	Byte Ptr [di],0		; ⠭ ஥  ⠫
		
	test	Flags,VERB
	jz	@@6
	
	mov	ax,SizeOfDir		; ⠥ ᫮ ஢,
	sub	dx,dx			;   ⠫
	add	ax,ClustSize		;  䠩  㫥
	adc	dx,0			; Int ( Size / ClustSize + 1)
	sub	ax,1			;
	sbb	dx,0			;
	div	ClustSize		;
	add	ClustCnt,ax		; 稬 饥 ᫮ ஢
	
@@6:	
	mov	dx,si			; ⨬ १
	mov	ax,bx			;  SI:BX  DX:AX
	popf
	pop	si bx es ds SizeOfDir
	
	ret
	
DirSize	Endp
