{$i-}

{ ================================================================ }
{                                                                  }
{      BADLIST  ver. 1.0.  5 ﭢ  1992                          }
{            ਩ ᨬ ᮢ                           }
{                 340005, ., 筠, 4-34                   }
{                 ⥫. (0622) 91-92-77 (ࠡ稩)                   }
{      ࠭ - Turbo Pascal ver. 6.0.                         }
{      ணࠬ  ண ஫ 䨧᪮ ﭨ       }
{      ᪥  ⬥⪨   ᮬ⥫ ᥪ஢  FAT.      }
{                                                                  }
{ ================================================================ }

Program BadList;

Uses Floppy, Crt, Dos;

TYPE
   TDiskTable = array[0..11] of byte;

CONST
   FoundBadClust : word = 0;
   BadFound      : boolean = false;
   FATCorrected  : boolean = false;

VAR
   DiskTable                         : TDiskTable;
   Track,Head,Sect                   : byte;
   f                                 : text;
   FAT, Buffer, Old1e, Old23         : Pointer;
   Correct                           : boolean;
   r                                 : registers;

Procedure My23; interrupt;
var r: registers;
begin
FreeMem(FAT,BootInfo.SectSize*BootInfo.FatSize);
FreeMem(Buffer,BootInfo.SectSize*BootInfo.TrkSecs);
Close(f);
SetIntVec($1e,Old1e);
SetIntVec($23,Old23);
Intr($23,r)
end;

Procedure SetDiskTable(var OldVector);
var OldTable: TDiskTable absolute OldVector;
begin
DiskTable:=OldTable;
if DiskTable[4]<BootInfo.TrkSecs then DiskTable[4]:=BootInfo.TrkSecs;
DiskTable[5]:=2;
SetIntVec($1e,@DiskTable);
end;

Procedure Teach;
begin
Writeln('ᯮ짮: BADLIST drive output [c]');
writeln('.......................................');
writeln('drive  -  ஢塞 c');
writeln('output -  䠩,   㤥 饭 ᯨ᮪ ');
writeln('         䥪 ᥪ஢');
writeln('      - 易⥫ ࠬ. ᫨  ,  ');
writeln('         䥪 ᥪ  ⬥祭  FAT.');
writeln('.......................................');
writeln('ਬ:');
writeln('badlist  a:  bad.a');
writeln('badlist  b:  prn  c');
Intr($23,r);
end;



Procedure Init;
Const Header:string=#10#13+'BadList ver. 1.0.  ਩ ..  .  (c) 1991.'
                   +#10#13+'  ⬥⪠ ᡮ ᥪ஢  ᪥.';
var ch: char;
    s:  string[1];
    i:  byte;
begin
Writeln(Header);
Writeln;
if (ParamCount<2) or (ParamCount>3) then    Teach;
if ParamCount=3 then
   begin
   s:=ParamStr(3);
   ch:=s[1];
   if UpCase(ch)<>'C' then  Teach;
   Correct:=true;
   end
else Correct:=false;
GetBootInfo(ParamStr(1));
if not InfoAvail then
   begin
   Writeln('Can''t access boot sector of drive ',ParamStr(1));
   Intr($23,r);
   end;
GetMem(FAT,BootInfo.SectSize*BootInfo.FatSize);
GetMem(Buffer,BootInfo.SectSize*BootInfo.TrkSecs);
if not ReadFAT(FAT^) then
   begin
   Writeln('Can''t read FAT of drive ',ParamStr(1));
   Intr($23,r);
   end;
if Correct then
   begin
   Writeln(' 砥 㦥 ᡮ ᥪ஢  ᥭ ࠢ  ⠡');
   writeln('ࠧ饭 䠩. , ᮤঠ騥 ᡮ ᥪ,   ');
   writeln('ᯮ祭. ⮬ 室 ।⥫쭮   ᪥ ,  ');
   writeln('.    த(Y/N)?');
   Readln(ch);
   if UpCase(ch)<>'Y' then Intr($23,r);
   end;
Assign(f,ParamStr(2));
Rewrite(f);
if IOResult<>0 then
   begin
   Writeln('Can''t open ',ParamStr(2));  Intr($23,r);
   end;
writeln(f,' ᪠ ',ParamStr(1));
if IOResult<>0 then
   begin
   Writeln('Error while writing ',ParamStr(2));  Close(f);  Intr($23,r);
   end;
writeln(f,'.....................');
if IOResult<>0 then
   begin
   Writeln('Error while writing ',ParamStr(2));  Close(f);  Intr($23,r);
   end;
writeln(f,'Cluster':8,'Track':7,'Head':7,'Sector':7);
if IOResult<>0 then
   begin
   Writeln('Error while writing ',ParamStr(2));  Close(f);  Intr($23,r);
   end;
GetIntVec($1e,Old1e);
SetDiskTable(Old1e^);
GetIntVec($23,Old23);
SetIntVec($23,@My23);
end;


Procedure ScanSector;
var LogSect, Clust, NextClust: word;
    buf                      : array[1..2048] of byte;
begin
LogSect:=LogicSectNo(Track,Head,Sect);
Clust:=ClusterNo(LogSect);
if Clust > 0 then
   begin
   NextClust:=FATContents(Clust,FAT^);
   if NextClust = $ff7 then
      begin
      if (Clust<>FoundBadClust) then
         begin
         writeln(f,Clust:8,'':22,' ⬥祭  ᡮ.');
         if IOResult<>0 then
            begin
            Writeln('Error while writing ',ParamStr(2));  Intr($23,r);
            end;
         BadFound:=True;
         FoundBadClust:=Clust;
         end;
      end
   else
      begin
      ReadSectors(DriveNo,Track,Head,Sect,1,Buf);
      if CarrySet then
         begin
         ResetDrive;
         if Correct then
            begin
            SetFATContents(ClusterNo(LogicSectNo(Track,Head,Sect)),$ff7,FAT^);
            FATCorrected:=true;
            end;
         Write(f,Clust:8,Track:7,Head:7,Sect:7,' . ');
         if Correct then
            begin
            writeln(f,' FAT ᤥ ⬥⪠.');
            if IOResult<>0 then
               begin
               Writeln('Error while writing ',ParamStr(2));  Intr($23,r);
               end;
            end
         else
            begin
            Writeln(f,'  !');
            if IOResult<>0 then
               begin
               Writeln('Error while writing ',ParamStr(2));  Intr($23,r);
               end;
            end;
         BadFound:=true;
         end;
      end;
   end
else      { Sector in System area }
   begin
   ReadSectors(DriveNo,Track,Head,Sect,1,Buf);
   if CarrySet then
      begin
      ResetDrive;
      Writeln(f,'':8,Track:7,Head:7,Sect:7,'  ᥪ  ⥬ . 祭 .');
      if IOResult<>0 then
         begin
         Writeln('Error while writing ',ParamStr(2));  Intr($23,r);
         end;
      BadFound:=true;
      end;
   end;
end;


Procedure Done;
begin
if Correct and FATCorrected then
   if not WriteFAT(FAT^) then
      begin
      Writeln(f,'Error while updating FAT.   All changes lost!');
      if IOResult<>0 then
         begin
         Writeln('Error while writing ',ParamStr(2));  Intr($23,r);
         end;
      end;
FreeMem(FAT,BootInfo.SectSize*BootInfo.FatSize);
FreeMem(Buffer,BootInfo.SectSize*BootInfo.TrkSecs);
if not BadFound then
   begin
   writeln(f,'  ᥪ  .');
   if IOResult<>0 then
      begin
      Writeln('Error while writing ',ParamStr(2));  Intr($23,r);
      end;
   GotoXY(1,WhereY-1); ClrEOL;
   writeln('  ᥪ  .');
   end
else
   begin
   writeln(f,' 㦥 ᡮ ᥪ.');
   if IOResult<>0 then
      begin
      Writeln('Error while writing ',ParamStr(2));  Intr($23,r);
      end;
   GotoXY(1,WhereY-1); ClrEOL;
   writeln(' 㦥 ᡮ ᥪ.');
   end;
Close(f);
SetIntVec($1e,Old1e);
end;


begin
Init;
With BootInfo do
   for Track:=0 to MaxTrackNo do
      for Head:=0 to HeadCnt-1 do
         begin
         GotoXY(1,WhereY-1); ClrEOL;
         Writeln('Track: ',Track,' Head: ',Head);
         ReadSectors(DriveNo,Track,Head,1,TrkSecs,Buffer^);
         if CarrySet then
            begin
            ResetDrive;
            for Sect:=1 to TrkSecs do
               begin
               r.AH:=$0B;
               MsDos(r);
               ScanSector;
               end;
            end;
         end;
Done;
end.