#ifndef MN_POP_H			/* To prevent redefinition	*/

#define MN_POP_H                        /* Prevents redefinition        */

#include <mn_core.h>
#include <mn_find.h>
#include <wnfrdef.h>
#include <kbd.h>
#include <kbdcodes.h>

/************************************************************************/
/*                - 䠩   ⨯ pop                         */
/************************************************************************/

/*----------------------------------------------------------------------*/
/*                      ᠭ                          */
/*----------------------------------------------------------------------*/

typedef struct {            /*       ᠭ pop-      */
                  /*     ⮢ ਡ 㭪⮢            */
   MN_COLORS  current,          /* ⥪騩                              */
              selected,         /* ࠭                            */
              protected,        /* 饭                           */
              pick_out;         /* 祢 ᨬ                     */
   WIN_DEF    hole;             /* ᠭ                         */
} MN_POP_DEF;

typedef struct {
   LOC          loc;            /* 砫쭠  ⥪          */
   int          width;          /* ਭ  뢮  㭪      */
   char         *name;          /* , 騩 㭪        */
   char         *keys;          /* , 롨騥  㭪     */
} MN_POP_ITEM_DEF;

typedef struct {                /*    㪠뢠           */
                                /*  link -㭪                   */
   char 	*name;          /* , 騩 㭪        */
   int		pickInName;	/*  롨饩 㪢  -1.	*/
   char 	*keys;          /* , 롨騥  㭪     */
   void 	*link;          /* ᢮ 㪠⥫                  */
} MN_POP_FIELD, *MN_POP_FIELD_PTR;

                                        /*------------------------------*/
                                        /* ⥫  ⥫쭮  */
                                        /*   pop-㭪       */
#define mn_PopFields(pitem)	((MN_POP_FIELD_PTR)((pitem)->link))
                                        /*------------------------------*/
                                        /*  pop-㭪               */
#define mn_PopItemName(pitem)	(mn_PopFields(pitem)->name)
                                        /*------------------------------*/
                                        /*  롨饩 㪢	*/
#define mn_PopPickInName(pitem)	(mn_PopFields(pitem)->pickInName)
                                        /*------------------------------*/
                                        /* ப ᯥ. ᨬ        */
                                        /* pop-㭪                   */
#define mn_PopItemKeys(pitem)	(mn_PopFields(pitem)->keys)


typedef struct {                /*   pop-           */
   MN_ITEM_SET  *set;               /* ᮪ 㭪⮢                   */
   MN_HOLE      *hole;          /* ᪮                       */
                            /*     ⮢ ਡ 㭪⮢            */
   MN_COLORS    current,             /* ⥪騩                         */
                protected,           /* 饭                      */
                selected,            /* ࠭                       */
                pick_out;            /* 祢 ᨬ                */
   int          last_key;            /* 祥 , ᯮ㥬   */
                                     /* 樨                       */
} MN_POP, *MN_POP_PTR;


/*----------------------------------------------------------------------*/
/*                  ⨯ 짮⥫᪨ 㭪権                  */
/*----------------------------------------------------------------------*/
                                        /*  pop-             */
MN_POP_PTR _Cdecl mn_makePop(MN_POP_DEF *pdef, LOC *pupper_left);
                                        /*------------------------------*/
                                        /* ⮦ pop-          */
void  _Cdecl    mn_disposePop(MN_POP_PTR pmenu);
                                        /*------------------------------*/
void disposePopField(MN_ITEM_PTR pitem);
                                        /* ⮦ 㭪 pop-    */
byte  _Cdecl    mn_disposePopItem(MN_POP_PTR pmenu,unsigned ident);
                                        /*------------------------------*/
                                        /*  㭪     */
                                        /* 祭ﬨ            */
MN_ITEM_PTR _Cdecl mn_addPopItem(MN_POP_PTR pmenu, unsigned ident,
				 MN_POP_ITEM_DEF *pdef, int pickInName);
                                        /*------------------------------*/
					/* ⥫    pop-	*/
#define mn_HoleInPop(pmenu)	((pmenu)->hole)
                                        /*------------------------------*/
                                        /* ⥫   㭪⮢	*/
                                        /*  pop-.			*/
#define mn_SetInPop(pmenu)	((pmenu)->set)
                                        /*------------------------------*/
                                        /*  pop-㭪      */
void  _Cdecl    mn_showPopItem(MN_POP_PTR pmenu,MN_ITEM_PTR pitem);
                                        /*------------------------------*/
                                        /*  pop-         */
int   _Cdecl    mn_displayPop(MN_POP_PTR pmenu);
                                        /*------------------------------*/
                                        /*  ᢮ ⨥        */
MN_ITEM_PTR _Cdecl mn_navPopKey(MN_ITEM_SET *pset, unsigned scan);
                                        /*------------------------------*/
                                     	/* ਧ⠫쭮-⨪   */
                                     	/*                     */
MN_ITEM_PTR _Cdecl mn_traverseGridStyle(MN_ITEM_SET *pset, unsigned key);
                                     	/*------------------------------*/

#endif                                  /* Ends "#ifndef MN_POP_H"      */
