SET PROC TO CFD
DO MAT
************************************************************
*                         R2                               *
************************************************************

PROCEDURE R2
*:*********************************************************************
*:
*:        Program: R2.PRG
*:
*:         System: CatFd
*:         Author: Alperovitch L.Z. & Suravsky Yaroslaw Wla
*:      Copyright (c) 1991, A&S + SoftPanorama
*:  Last modified: 01/30/91     13:01
*:
*:      Called by: MATI.PRG       
*:
*:     Documented: 01/30/91 at 13:06               FoxDoc version 1.0
*:*********************************************************************
*  "䠩-஡-᪥"
GO TOP
IF EOF()
   CLEAR
   @ 15,30 SAY '  !!!'
   ? CHR(7)+CHR(7)
   RETURN
ENDIF
SET PRINT TO cfd.txt
SET PRINT ON
SET CONS OFF
? REPL('-',70)
? '   Fname  ext  ,         ஡ N ᪥ N'
? '   '
? REPL('-',70)
z=0
DO WHILE .NOT. EOF()
   ? cod,ext,' ',lenf,' ',tipevm,' ',tipcopy,BOX,disketn
   IF LEN(TRIM(name1)) # 0
      ? TRIM(name1)
   ENDIF
   IF LEN(TRIM(name2)) # 0
      ? TRIM(name2)
   ENDIF
   z=z+1
   sz=LTRIM(STR(z))
   IF RIGHT(sz,1)='0'
      SET PRIN OFF
      @ 24,46 SAY z PICT '9999'
      SET PRIN ON
   ENDIF
   SKIP
ENDDO
? repl('-',70)
SET PRINT TO
SET PRINT OFF
*: EOF: R2.PRG


************************************************************
*                         R1                               *
************************************************************

PROCEDURE R1
*:*********************************************************************
*:
*:        Program: R1.PRG
*:
*:         System: CatFd
*:         Author: Alperovitch L.Z. & Suravsky Yaroslaw Wla
*:      Copyright (c) 1991, A&S + SoftPanorama
*:  Last modified: 01/30/91     13:01
*:
*:      Called by: MATI.PRG       
*:
*:     Documented: 01/30/91 at 13:06               FoxDoc version 1.0
*:*********************************************************************
*  "஡-᪥-䠩"
GO TOP
IF EOF()
   CLEAR
   @ 15,30 SAY '  !!!'
   ? CHR(7)+CHR(7)
   RETURN
ENDIF
old_b=BOX
old_d=disketn
SET PRINT TO cfd.txt
SET PRINT ON
SET CONS OFF
? '             ஡ N',BOX
? '        ᪥ N',disketn,' ⨯ ',tipd,' ꥬ ',dens,' K'
? '   Fname  ext  ,        '
? '   '
? REPL('-',70)
z=0
DO WHILE .NOT. EOF()
   IF BOX # old_b
      ? REPL('-',70)
      ? '             ஡ N',BOX
      ? '        ᪥ N',disketn,' ⨯ ',tipd,' ꥬ ',dens,' K'
      ? '   Fname  ext  ,        '
      ? '   '
      ? REPL('-',70)
      old_b=BOX
      old_d=disketn
   ELSE
      IF disketn # old_d
         ? REPL('-',70)
         ? '        ᪥ N',disketn,' ⨯ ',tipd,' ꥬ ',dens,' K'
         ? '   Fname  ext  ,        '
         ? '   '
         ? REPL('-',70)
         old_d=disketn
      ENDIF
   ENDIF
   ? cod,ext,' ',lenf,' ',tipevm,' ',tipcopy
   IF LEN(TRIM(name1)) # 0
      ? TRIM(name1)
   ENDIF
   IF LEN(TRIM(name2)) # 0
      ? TRIM(name2)
   ENDIF
   z=z+1
   sz=LTRIM(STR(z))
   IF RIGHT(sz,1)='0'
      SET PRIN OFF
      @ 24,46 SAY z PICT '9999'
      SET PRIN ON
   ENDIF
   SKIP
ENDDO
? repl('-',70)
SET PRINT TO
SET PRINT OFF
*: EOF: R1.PRG


************************************************************
*                         SETSW                            *
************************************************************

PROCEDURE SETSW
*:*********************************************************************
*:
*:        Program: SETSW.PRG
*:
*:         System: CatFd
*:         Author: Alperovitch L.Z. & Suravsky Yaroslaw Wla
*:      Copyright (c) 1991, A&S + SoftPanorama
*:  Last modified: 01/02/91     17:00
*:
*:      Called by: MAT.PRG        
*:               : P1.PRG         
*:               : DELA.PRG       
*:
*:     Documented: 01/30/91 at 13:06               FoxDoc version 1.0
*:*********************************************************************
* SETSW.PRG
SET STEP OFF
SET ECHO OFF
SET DATE       BRITISH
SET TALK       OFF
SET BELL       OFF
SET STATUS     OFF
SET ESCAPE     OFF
SET DELETED    ON
SET CONFIRM    ON
SET SCOREBOARD OFF
SET STEP OFF
SET ECHO OFF
SET PRINT OFF
SET DEVICE TO SCREEN
* on error do errhand with error(),sys(16)
* on key=315 do helptxt with hlptxtn
ON ESCAPE RETURN
SET PRINT TO


************************************************************
*                         MATI                             *
************************************************************

PROCEDURE MATI
*:*********************************************************************
*:
*:        Program: MATI.PRG
*:
*:         System: CatFd
*:         Author: Alperovitch L.Z. & Suravsky Yaroslaw Wla
*:      Copyright (c) 1991, A&S + SoftPanorama
*:  Last modified: 01/30/91     13:00
*:
*:      Called by: MAT.PRG        
*:
*:          Calls: MATIDR1.PRG
*:               : R1.PRG
*:               : R2.PRG
*:
*:     Documented: 01/30/91 at 13:06               FoxDoc version 1.0
*:*********************************************************************
* MATI
* FOXBASE: ணࠬ 뤠 ⠫ -
*
DO WHILE .T.
   CLEAR
   DO matidr1
   @ 15,10 SAY  "ਠ a  Esc"
   @ 16,9 TO 19,32
   @ 17,10 PROM "஡-᪥-䠩"
   @ 18,10 PROM "-஡-᪥ "
   *
   MENU TO rx
   DO CASE
   CASE rx=0
      RETURN
   CASE rx=1
      SET COLOR TO W+*/B
      @ 24,20 SAY ', ⮢  '
      SET COLOR TO W+/B
      SET ORDER TO 2
      DO r1
   CASE rx=2
      SET COLOR TO W+*/B
      @ 24,20 SAY ', ⮢  '
      SET COLOR TO W+/B
      SET ORDER TO 1
      DO r2
   ENDCASE
   @ 24,20
   ! prpage cfd.txt v
   ! del cfd.txt
ENDDO
*: EOF: MATI.PRG


************************************************************
*                         MAT                              *
************************************************************

PROCEDURE MAT
* ணࠬ 뤠 ⠫ -
* MAT -  
DO setsw
SET COLOR TO W+/B,GR+/N
*
DO WHILE .T.
   CLOSE ALL
   USE mat
   IF .NOT.FILE('matfbd.idx')
      INDEX  TO matfbd ON cod+ext+STR(BOX*100+disketn,4)
   ENDIF
   IF .NOT.FILE('matbdf.idx')
      INDEX  TO matbdf ON STR(BOX*100+disketn,4)+cod+ext
   ENDIF
   USE mat INDEX matfbd,matbdf
   *
   DO matidr1 && ⠢
   @ 16,22 SAY    "Ŀ"
   @ 17,22 PROMPT "       H ஡        "
   @ 18,22 PROMPT "  ᬮ  ४஢  "
   @ 19,22 PROMPT "                      "
   @ 20,22 PROMPT "       (Esc)           "
   @ 21,22 SAY    ""
   SET MESSAGE TO 24
   choice=2
   MENU TO choice
   *
   DO CASE
   CASE choice = 1
      DO p1
   CASE choice = 2
      DO dela
   CASE choice = 3
      DO mati
   OTHERWISE
      close all
      ! del mat?????.idx>nul 
      QUIT
   ENDCASE
   *
ENDDO
*: EOF: MAT.PRG


************************************************************
*                         P1                               *
************************************************************

PROCEDURE P1
*:*********************************************************************
*:
*:        Program: P1.PRG
*:
*:         System: CatFd
*:         Author: Alperovitch L.Z. & Suravsky Yaroslaw Wla
*:      Copyright (c) 1991, A&S + SoftPanorama
*:  Last modified: 01/30/91     12:05
*:
*:      Called by: MAT.PRG        
*:
*:          Calls: SETSW.PRG
*:               : SIGNFD.PRG
*:
*:           Uses: DIRTXT.DBF     
*:
*:     Documented: 01/30/91 at 13:06               FoxDoc version 1.0
*:*********************************************************************
* H ஡
DO setsw
SET COLOR TO W+/B
*
rdisketn=10
rtipd='-130'
rdens=800
rtipevm='MSDOS'
SET COLOR TO ,GR+/N
*
SET ORDER TO 2 && use mat index matbdf - ஡,᪥,䠩
rbox=1
GO BOTT
IF .NOT. EOF()
   rbox=BOX+1
ENDIF
fl_del=0
DO WHILE .T.
   CLEAR
   @  3,27 SAY "⠫ ᪥:  ஡ !"
   @  5, 0 SAY "஡ N "
   @  5,14 SAY "ন ᪥ "
   @  7, 0 SAY " ᪥ "
   @  9, 0 SAY "ꥬ Kb "
   @ 11, 0 SAY "  "
   @ 11,15 SAY "<--- : MSDOS / RT11( -3) / ..."
   @  5,10 GET rbox        PICTURE "999"
   @  5,32 GET rdisketn    PICTURE "99" RANGE 1,10
   @  7,13 GET rtipd
   @  9,10 GET rdens       PICTURE "9999"
   @ 11, 7 GET rtipevm
   @ 15,20 SAY 'Esc-室;'
   READ
   IF READKEY()=12 .OR. READKEY()=268
      EXIT
   ENDIF
   SEEK ltrim(str(rbox))
   IF FOUND().and.rbox=box
      @ 5,40 SAY '<-- ஡ N '+STR(rbox,3)+' 㦥 ॣ஢ !' 
      ? chr(7)
      LOOP
   ENDIF
   *
   CLEAR
   SET COLOR TO W+/B
   @  3,27
   @  3,27 SAY "⠫ ᪥:"
   @  5, 0 SAY '஡ N ᪥ N  N '
   @  7, 0 SAY "Filename"
   @  7, 9 SAY "Ext"
   @  7,15 SAY '  '
   @  9, 0 SAY ""
   SET COLOR TO BG+/R+
   @ 12,0  SAY REPL(CHR(4),60)
   SET COLOR TO W+/B,GR+/N
   @ 13, 0 SAY " ᪥"
   @ 15, 0 SAY "ꥬ Kb "
   @ 17, 0 SAY " "
   @ 20, 9 SAY "Esc - 室  ᫥.᪥; PgDown/室  ࠩ - ᫥.䠩"
   *
   I=1
   DO WHILE I<=rdisketn
      DO signfd &&  ᨣ ᪥
      I=I+1
   ENDDO
   rbox=rbox+1
ENDDO
IF fl_del=1
   PACK
   REIN
ENDIF
CLOSE DATA
IF FILE('DIRTXT.DBF')
   SET SAFE OFF
   DELE FILE dirtxt.dbf
   DELE FILE dir.txt
ENDIF
*: EOF: P1.PRG


************************************************************
*                         DELA                             *
************************************************************

PROCEDURE DELA
*:*********************************************************************
*:
*:        Program: DELA.PRG
*:
*:         System: CatFd
*:         Author: Alperovitch L.Z. & Suravsky Yaroslaw Wla
*:      Copyright (c) 1991, A&S + SoftPanorama
*:  Last modified: 01/30/91     12:43
*:
*:      Called by: MAT.PRG        
*:
*:          Calls: SETSW.PRG
*:               : MATIDR1.PRG
*:               : RPAGE.PRG
*:               : RAMKA.PRG
*:               : SHPAGE.PRG
*:               : IN_KEY.PRG
*:
*:     Documented: 01/30/91 at 13:06               FoxDoc version 1.0
*:*********************************************************************
*
* H   "⠫ ᪥"
*
*  䠩 - matf : cod+ext
*
DO setsw     && Set switches
CLEAR
SET COLOR TO W+/B,GR+/N
*
DO matidr1
*
@ 14,20 SAY  '     冷 뤠         '
@ 15,19 TO 18,55
@ 16,20 PROM '  䠩,N ஡,N ᪥'
@ 17,20 PROM ' N ஡,N ᪥, 䠩'
MENU TO m1
IF m1=0
   RETURN
ENDIF
*
SET ORDER TO m1
*
GO TOP
IF .NOT. EOF()
   rn1st=RECNO() &&  ࠣ 䠩()  ,稭  ...
ENDIF
*          -   ⠥ od+ext+recno() -  樨  
rx=5
ry=14
DIME page(rx*ry)
*
RECC=0        && ⢮ ᥩ,㦥  
*
fl_del=0      &&  ᫥  㤠ﬨ
*
x1=0          && Nn ./⮫殢
y1=0
dcol=15       && ﭨ  ⮫栬
ip=1          && ⥫  ,㤠 ⠢ 
H=CHR(24)+CHR(25)+CHR(26)+CHR(27)
H=H+'/Enter-।/Ins-⠢/Del-㤠/Esc-./PgUp/Down-c./।'
*
DO WHILE .T.  &&  横
   SET ORDER TO m1	
   DO rpage   &&    
   DO ramka   && ⪠ ࠭
   DO shpage  &&  
   in_key=0
   DO in_key  &&    -    
   IF in_key=27
      exit
   ENDIF
ENDDO
*
IF fl_del = 1
   PACK
ENDIF
CLOSE DATA
*: EOF: DELA.PRG


************************************************************
*                         IN_KEY                           *
************************************************************

PROCEDURE IN_KEY
*:*********************************************************************
*:
*:        Program: IN_KEY.PRG
*:
*:         System: CatFd
*:         Author: Alperovitch L.Z. & Suravsky Yaroslaw Wla
*:      Copyright (c) 1991, A&S + SoftPanorama
*:  Last modified: 01/30/91     12:06
*:
*:      Called by: DELA.PRG       
*:
*:          Calls: ITOXY.PRG
*:
*:     Documented: 01/30/91 at 13:06               FoxDoc version 1.0
*:*********************************************************************
*
I=ip          && 㤠 ⠢ 
DO itoxy      &&  i  न
DIME recr(11) &&  
*
DO WHILE .T.
   SET COLOR TO GR+/N
   SET ORDER TO m1
   @ y1+1,x1*dcol+1 SAY LEFT(page(I),8)+'.'+SUBSTR(page(I),9,3)
   SET COLOR TO W+/B
   lens=LEN(page(I))-11
   rn=VAL(SUBSTR(page(I),12,lens))
   GO rn
   @ 17,1  SAY '஡'      GET BOX PICT '999'
   @ 17,13 SAY '᪥ N'   GET disketn PICT '99'
   @ 17,27 SAY '⨯a'         GET tipd
   @ 17,43 SAY 'ꥬ'        GET dens PICT '9999'
   @ 17,54 SAY 'OC'           GET tipevm
   @ 18,1  SAY 'Fname'        GET cod
   @ 18,16 SAY 'Ext'          GET ext
   @ 18,25 SAY ' '       GET lenf
   @ 18,47 SAY ' '    GET tipcopy
   @ 19,20 SAY ''
   @ 20,1  GET name1
   @ 21,1  GET name2
   @ 22,01 SAY H
   CLEAR GETS
   Cursor=SYS(2002)
   in_key=INKEY(0)
   DO CASE
   CASE in_key=27
      EXIT
   CASE in_key=24 && 
      @ y1+1,x1*dcol+1 SAY LEFT(page(I),8)+'.'+SUBSTR(page(I),9,3)
      *         ⨢   אַ㣮쭨
      I=I+1
      IF I>RECC  && C ᫥ -  
         I=1
      ENDIF
      DO itoxy   &&  i  न
   CASE in_key=5 && 
      @ y1+1,x1*dcol+1 SAY LEFT(page(I),8)+'.'+SUBSTR(page(I),9,3)
      I=I-1
      IF I=0     && C ࢮ -  ᫥
         I=RECC
      ENDIF
      DO itoxy
   CASE in_key=19 && 
      @ y1+1,x1*dcol+1 SAY LEFT(page(I),8)+'.'+SUBSTR(page(I),9,3)
      IF I>ry
         I=I-ry
      ELSE     && C 祣  - 룠  ࠢ ࠩ
         IF I=1
            I=RECC
         ELSE
            I = INT(RECC/ry-0.01)*ry+y1-1
            IF I>RECC
               I=RECC
            ENDIF
         ENDIF
      ENDIF
      DO itoxy
   CASE in_key=4 && ࠢ
      @ y1+1,x1*dcol+1 SAY LEFT(page(I),8)+'.'+SUBSTR(page(I),9,3)
      IF I=RECC
         I=1
      ELSE  && Cࠢ 祣  - 룠   ࠩ
         I=I+ry
         IF I>RECC
            I = y1+1
         ENDIF
      ENDIF
      DO itoxy
   CASE in_key=3 && PgDown
      lens=LEN(page(RECC))-11
      rn=VAL(SUBSTR(page(RECC),12,lens))
      GO rn
      ip=1
      SKIP
      IF EOF()
         GO TOP
      ENDIF
      rn1st=RECNO()
      EXIT
   CASE in_key=18 && PgUp
      lens=LEN(page(1))-11
      rn=VAL(SUBSTR(page(1),12,lens))
      GO rn      && ३  砫 
      ip=1
      back=rx*ry &&    
      DO WHILE .NOT. BOF() .AND. back > 0
         SKIP -1
         back=back-1
      ENDDO
      rn1st=RECNO()
      EXIT
      * -------------------------------------------------------------------------
      *    ⢨  ﬨ: 㤠
      * -------------------------------------------------------------------------
   CASE in_key=7 && Del
      SET COLOR TO GR+/R*
      @ y1+1,x1*dcol+1 SAY LEFT(page(I),8)+'.'+SUBSTR(page(I),9,3)
      @ 24,20 SAY ' (Enter/Esc)'
      in_key=INKEY(0)
      SET COLOR TO W+/B
      @ 24,20
      IF in_key=13
         lens=LEN(page(I))-11
         rn=VAL(SUBSTR(page(I),12,lens))
         GO rn
         DELETE
         fl_del=1
         RECC=RECC-1
         IF RECC=0
            rn1st=0
         ELSE
            i1=IIF(I=1,2,1)
            lens=LEN(page(i1))-11
            rn1st=VAL(SUBSTR(page(i1),12,lens))
            ip=IIF(I=1,1,I-1)
         ENDIF
         EXIT
      ENDIF
      @ y1+1,x1*dcol+1 SAY LEFT(page(I),8)+'.'+SUBSTR(page(I),9,3)
      *  ⠢
   CASE in_key=22 && Ins
      fl_ex=0
      @ y1+1,x1*dcol+1 SAY LEFT(page(I),8)+'.'+SUBSTR(page(I),9,3)
      SET COLOR TO GR+/R*
      @ 24,20 SAY '⠢ ?(Enter/Esc)'
      in_key=INKEY(0)
      SET COLOR TO W+/B
      @ 24,20
      IF in_key=13
         SCATTER TO recr
         Cursor=SYS(2002,1)
         DO WHILE .T.
            SET ORDER TO m1
            @ 17,1  SAY '஡'      GET recr(6) PICT '999'
            @ 17,13 SAY '᪥ N'   GET recr(7) PICT '99'
            @ 17,27 SAY '⨯a'         GET recr(8)
            @ 17,43 SAY 'ꥬ'        GET recr(9) PICT '9999'
            @ 17,54 SAY 'OC'           GET recr(10)
            @ 18,1  SAY 'Fname'        GET recr(1)
            @ 18,16 SAY 'Ext'          GET recr(2)
            @ 18,25 SAY ' '       GET recr(5)
            @ 18,47 SAY ' '    GET recr(11)
            @ 19,20 SAY ''
            @ 20,1  GET recr(3)
            @ 21,1  GET recr(4)
            READ
            IF READKEY()=12 .OR. READKEY()=268
               EXIT
            ENDIF
            SET ORDER TO 2 && matbdf - ஡,᪥,䠩
            SEEK LTRIM(STR(recr(6)*100+recr(7)))+recr(1)+recr(2)
            IF FOUND()
               @ 24,2 SAY ' 䠩  ⮩ ᪥ 㦥  !'
               ! beep /r2
               @ 24,2
               LOOP
            ENDIF
            fl_ex=1
            INSERT Blank
            GATHER FROM recr
            ip=1           && 뤠,稭  ⠢
            rn1st=RECNO()
            SET ORDER TO m1
            EXIT
         ENDDO
      ENDIF
      IF fl_ex=1
         EXIT
      ENDIF
      *  ஢ - Enter
   CASE in_key=13 && Ins
      fl_ex=0
      SET COLOR TO GR+/R*
      @ y1+1,x1*dcol+1 SAY LEFT(page(I),8)+'.'+SUBSTR(page(I),9,3)
      SET COLOR TO W+/B
      SCATTER TO recr
      tempbdf=LTRIM(STR(BOX*100+disketn))+cod+ext
      Cursor=SYS(2002,1)
      DO WHILE .T.
         SET ORDER TO m1
         @ 17,1  SAY '஡'      GET recr(6) PICT '999'
         @ 17,13 SAY '᪥ N'   GET recr(7) PICT '99'
         @ 17,27 SAY '⨯a'         GET recr(8)
         @ 17,43 SAY 'ꥬ'        GET recr(9) PICT '9999'
         @ 17,54 SAY 'OC'           GET recr(10)
         @ 18,1  SAY 'Fname'        GET recr(1)
         @ 18,16 SAY 'Ext'          GET recr(2)
         @ 18,25 SAY ' '       GET recr(5)
         @ 18,47 SAY ' '    GET recr(11)
         @ 19,20 SAY ''
         @ 20,1  GET recr(3)
         @ 21,1  GET recr(4)
         @ 24,20 SAY ' ...'
         READ
         IF READKEY()=12 .OR. READKEY()=268
            EXIT
         ENDIF
         SET ORDER TO 2 && matbdf - ஡,᪥,䠩
         tempkey=LTRIM(STR(recr(6)*100+recr(7)))+recr(1)+recr(2)
         IF tempbdf # tempkey
            SEEK tempkey
            IF FOUND()
               @ 24,2 SAY ' 䠩  ⮩ ᪥ 㦥  !'
               ! beep /r2
               LOOP
            ENDIF
         ENDIF
         GO rn
         GATHER FROM recr
         IF tempbdf # tempkey
            fl_ex=1
            ip=1           && 뤠,稭  ।஢
            rn1st=RECNO()
         ENDIF
         SET ORDER TO m1
         EXIT
      ENDDO
      @ 24,20
      IF fl_ex=1
         EXIT
      ENDIF
   ENDCASE
ENDDO
Cursor=SYS(2002,1)
*
*: EOF: IN_KEY.PRG


************************************************************
*                         ITOXY                            *
************************************************************

PROCEDURE ITOXY
*:*********************************************************************
*:
*:        Program: ITOXY.PRG
*:
*:         System: CatFd
*:         Author: Alperovitch L.Z. & Suravsky Yaroslaw Wla
*:      Copyright (c) 1991, A&S + SoftPanorama
*:  Last modified: 01/30/91     11:50
*:
*:      Called by: SHPAGE.PRG     
*:               : IN_KEY.PRG     
*:
*:     Documented: 01/30/91 at 13:06               FoxDoc version 1.0
*:*********************************************************************
x1 = INT (I/ry-0.01)
y1 = I - ry*x1
*: EOF: ITOXY.PRG


************************************************************
*                         MATIDR1                          *
************************************************************

PROCEDURE MATIDR1
*:*********************************************************************
*:
*:        Program: MATIDR1.PRG
*:
*:         System: CatFd
*:         Author: Alperovitch L.Z. & Suravsky Yaroslaw Wla
*:      Copyright (c) 1991, A&S + SoftPanorama
*:  Last modified: 01/30/91      8:31
*:
*:      Called by: MAT.PRG        
*:               : DELA.PRG       
*:               : MATI.PRG       
*:
*:     Documented: 01/30/91 at 13:06               FoxDoc version 1.0
*:*********************************************************************
CLEAR
@ 01,06 SAY "                       "
@ 02,06 SAY "                                                 "
@ 03,06 SAY "                                             "
@ 04,06 SAY "                                      "
@ 05,06 SAY "                                             "
@ 06,06 SAY "                                            "
@ 07,06 SAY "                                       "
@ 08,12 SAY ""
@ 10,14  SAY "ͻ    ɻ ͻ    ͻ ͻ ͻ  "
@ 11,14  SAY "      ɼ     ʻ              ʻ"
@ 12,14  SAY "     ɼ                         "
@ 13,13 SAY "ʻ ȼ         ͼ       ͼ    "
@ 22,13 SAY "COPYRIGHT(C) - Alperovitch L.Z. & Suravsky Yaroslaw Wladim.-1990,91"
*: EOF: MATIDR1.PRG


************************************************************
*                         RAMKA                            *
************************************************************

PROCEDURE RAMKA
*:*********************************************************************
*:
*:        Program: RAMKA.PRG
*:
*:         System: CatFd
*:         Author: Alperovitch L.Z. & Suravsky Yaroslaw Wla
*:      Copyright (c) 1991, A&S + SoftPanorama
*:  Last modified: 01/29/91     18:33
*:
*:      Called by: DELA.PRG       
*:
*:     Documented: 01/30/91 at 13:06               FoxDoc version 1.0
*:*********************************************************************
CLEAR
*
@ 01, 00 SAY "ͻ"
I=1
DO WHILE I<ry+1
   I=I+1
   @ I, 00 SAY "                                                                      "
ENDDO
@ I+1,00 SAY "͹"
@ I+2,00 SAY "                                                                          "
@ I+3,00 SAY "                                                                          "
@ I+4,00 SAY "                                                                          "
@ I+5,00 SAY "                                                                          "
@ I+6,00 SAY "                                                                          "
@ I+7,00 SAY "                                                                          "
@ I+8,00 SAY "Ľ"

*: EOF: RAMKA.PRG


************************************************************
*                         RPAGE                            *
************************************************************

PROCEDURE RPAGE
*:*********************************************************************
*:
*:        Program: RPAGE.PRG
*:
*:         System: CatFd
*:         Author: Alperovitch L.Z. & Suravsky Yaroslaw Wla
*:      Copyright (c) 1991, A&S + SoftPanorama
*:  Last modified: 01/30/91      9:08
*:
*:      Called by: DELA.PRG       
*:
*:     Documented: 01/30/91 at 13:06               FoxDoc version 1.0
*:*********************************************************************
*    rpage   && 1 -    
GO TOP
IF .NOT. EOF()
   GO rn1st   &&  稭  ...
ENDIF
*
RECC=1  && ⢮ ᥩ,㦥  
*
DO WHILE .NOT. EOF() .AND. RECC<=rx*ry
   page (RECC) = cod+ext+LTRIM(STR(RECNO()))
   SKIP
   RECC=RECC+1
ENDDO
RECC=RECC-1
*
IF RECC = 0
   @ 10,15,12,62 BOX
   @ 11,16 SAY '  - ॣ 1-  ஡ !'
   ? REPL(CHR(7),5)
   close all
   ! del mat?????.idx>nul
   quit 
ENDIF
*: EOF: RPAGE.PRG


************************************************************
*                         SHPAGE                           *
************************************************************

PROCEDURE SHPAGE
*:*********************************************************************
*:
*:        Program: SHPAGE.PRG
*:
*:         System: CatFd
*:         Author: Alperovitch L.Z. & Suravsky Yaroslaw Wla
*:      Copyright (c) 1991, A&S + SoftPanorama
*:  Last modified: 01/30/91      8:36
*:
*:      Called by: DELA.PRG       
*:
*:          Calls: ITOXY.PRG
*:
*:     Documented: 01/30/91 at 13:06               FoxDoc version 1.0
*:*********************************************************************
*  
I=1            && N 祩  
dcol=15        && ﭨ  ⮫栬
*
DO WHILE I <= RECC
   DO itoxy &&  i  न x,y
   @ y1+1,x1*dcol+1 SAY LEFT(page(I),8)+'.'+SUBSTR(page(I),9,3)
   I=I+1
ENDDO
*: EOF: SHPAGE.PRG


************************************************************
*                         SIGNFD                           *
************************************************************

PROCEDURE SIGNFD
*            ᨣ   ᪥
DO WHILE .T. && ⠭ ०   ᢥﬨ  䠩 ᪥
   m=2
   kvofiles=0
   rtipcopy='COPY    '
   @  6, 6 GET rbox        PICTURE "999"
   @  6,10 GET I           PICTURE "99"
   @  6,13 SAY '  ' GET rdisketn PICT '99'
   @  6,21
   @  7,25
   @  8, 0
   @ 10, 0
   @ 11, 0
   @ 13,13 GET rtipd
   @ 15,10 GET rdens       PICTURE "9999"
   @ 17, 7 GET rtipevm
   CLEAR GETS
   SET COLOR TO ,2+*/209
   @ 5,35 SAY  ' 㤥   Filename Ext  ?'
   @ 6,35 PROM '1       - ; Esc - 室'
   @ 7,35 PROM '2/Enter -  XDIR (⮫쪮  SDOS COPY !)'
   MENU TO m
   SET COLOR TO W+/B,GR+/N
   DO CASE
   CASE m=0
      RETURN 
   CASE m=2
      @ 6,35
      @ 7,35 SAY '        -  XDIR (⮫쪮  SDOS COPY !)'
      SET COLOR TO 2+*/209,GR+*/N
      drv='A'
      @ 23,20 SAY '.᪥  (ABEFGH)' GET drv ;
         VALID AT(drv,'ABEFGHabefgh')#0
      READ
      @ 23,20 SAY ' ⠫  XDIR ...           '
      ! xdir &drv:>dir.txt
      @ 23,20
      @ 23,20 SAY '᪥ ⥭ ...'
      ? CHR(7)
      @ 23,20 say '  ᪥ ...                            '
      ? chr(7)
      @ 23,20
      set color to w+/b,gr+/n
      SELE 2
      SET SAFE OFF
      IF FILE('dirtxt.dbf')
         USE dirtxt
         ZAP
      ELSE
         SAVE SCREEN TO scrt
         SET COLO TO N/N,N/N,N
         KEYBOARD 'TXT'+CHR(13)+'C80'+CHR(13)+CHR(13)+CHR(13)+'N'
         CREA DIRTXT
         CLEA TYPE
         SET COLO TO W+/B,GR+/N
         REST SCREEN FROM scrt
      ENDIF
      APPE FROM dir.txt TYPE SDF
      DELE && 㤠 ᫥ ப ⠫,   㦭
      GO TOP
      PACK
      dele file dir.txt
      kvofiles=RECCOUNT()
      IF kvofiles=0
         @ 7,25
         SET COLO TO GR+*/N
         @ 7,25 SAY 'TA   !!!'
         SET COLO TO W+/B,GR+/N
         ? REPL(CHR(7),5)
         LOOP
      ENDIF
   CASE m=1
      @ 6,35 SAY '        - '
      @ 7,25
      CLEAR GETS
      @ 7,25 SAY ' :/LONGCOPY/BACKUP/PCBACKUP/FASTBACK/...'
      @ 8,25 GET rtipcopy
      READ
      @ 8,25
      @ 7,25
      @ 7,25 SAY ' ' GET rtipcopy
   ENDCASE
   EXIT
ENDDO
SELE 1
SET COLO TO W+/B,GR+/N
J=1
DO WHILE .T. && H  ᪥ . ᪮쪮 䠩
   @  6,21 GET J PICT '99'
   IF m=2
      @  6,23 SAY '' GET kvofiles PICT '99'
   ENDIF
   CLEAR GETS
   *
   INSERT Blank
   REPL BOX     WITH rbox
   REPL disketn WITH I
   REPL tipd    WITH rtipd
   REPL dens    WITH rdens
   REPL tipevm  WITH rtipevm
   REPL tipcopy WITH rtipcopy
   *
   IF m=2
      SELE 2
      GO J
      RTXT=FIELD(1)
      rtxt=&RTXT
      SELE 1
      ptr=AT('.',SUBSTR(rtxt,41,9))
      IF ptr=0
         REPL cod  WITH SUBSTR(rtxt,41,8)
      ELSE
         REPL cod  WITH SUBSTR(rtxt,41,ptr-1)
         REPL ext  WITH SUBSTR(rtxt,41+ptr,3)
      ENDIF
      IF LEFT(rtxt,9) = 'DIRECTORY'
         REPL name1 WITH 'DIR'
      ELSE
         REPL lenf  WITH SUBSTR(rtxt,9,10)
         REPL name1 WITH LEFT(rtxt,6)
      ENDIF
   ENDIF
   @  8, 0 GET cod
   @  8, 9 GET ext
   @  8,15 GET lenf
   IF m=2
      CLEAR GETS
   ENDIF
   *
   @ 10, 0 GET name1
   @ 11, 0 GET name2
   READ
   IF READKEY()=12 .OR. READKEY()=268
      fl_del=1
      DELETE
      EXIT
   ENDIF
   J=J+1
   IF m=2 .AND. J>kvofiles
      EXIT
   ENDIF
ENDDO
*: EOF: SIGNFD.PRG
