<?php
/********************************************************************
 * gopherproxy.php - Proxy for accessing gopher sites
 *
 ********************************************************************/

if(!defined('GOPHERPROXY_SOCKET_ERROR')) define('GOPHERPROXY_SOCKET_ERROR', 'Socket error');
if(!defined('GOPHERPROXY_READ_LENGTH')) define('GOPHERPROXY_READ_LENGTH', 1024);
if(!defined('GOPHERPROXY_SELECT_TIMEOUT')) define('GOPHERPROXY_SELECT_TIMEOUT', 30);

class GopherProxy
{
	var $wakka;
	var $host;
	var $port;	 // Default: 70
	var $timeout; // Default: 30 seconds
	var $socket;
	var $config;
	var $err;

	function GopherProxy($wakka, $host, $port=70, $timeout=30)
	{
		$this->wakka = $wakka;
		$this->err = false;
		include_once('plugins/actions/gopher/gopherclient/gopherproxy.config.php');
		$this->config = $gopherProxyConfig;
		$buffer = explode(",", $this->config['restrict_pages_to']);
		$restrict_pages = array_map("trim", $buffer);
		if(FALSE===in_array($this->wakka->GetPageTag(), $restrict_pages))
		{
			print $this->ThrowError("Not permitted to call this action from this page");
			# Disable the following line for PHP5!
			# $this = NULL;
			return;
		}
		if(strpos($host, ":") > 0)
		{
			$this->host = substr($host, 0, strpos($host, ":"));
			$this->port = substr($host, strpos($host, ":")+1);
		}
		else
		{
			$this->host = $host;
			$this->port = $port;
		}
		$this->timeout = $timeout;
	}

	function _setup_socket($request='') 
	{
		if(FALSE===$this->ValidateHost($this->host, $this->port))
		{
			$this->err =  $this->ThrowError("Access denied")." ".__FILE__.":".__LINE__;
			return;
		}
		$this->socket = socket_create(AF_INET, SOCK_STREAM, 6);
		if(FALSE===$this->socket)
		{
			$this->err = $this->ThrowError()." ".__FILE__.":".__LINE__;

			return;
		}
		if(FALSE===socket_set_nonblock($this->socket))
		{
			$this->err = $this->ThrowError("socket_set_nonblock() failed")." ".__FILE__.":".__LINE__;

			return;
		}

		//socket_bind($this->socket, '127.0.0.1', 0);

		$arrOpt = array('l_onoff'=>1, 'l_linger'=>0);
		#if(FALSE===socket_set_option($this->socket, SOL_SOCKET, SO_REUSEADDR, 1))
		if(FALSE===socket_set_option($this->socket, SOL_SOCKET, SO_LINGER, $arrOpt))
		{
			$this->err = $this->ThrowError()." ".__FILE__.":".__LINE__;

			return;
		}

		$time = time();
		while(FALSE===@socket_connect($this->socket, $this->host, $this->port))
		{
			$err = socket_last_error($this->socket)." ".__FILE__.":".__LINE__;

			if($err == 115 || $err == 114 || $err == 36)
			{
				if((time() - $time) >= $this->timeout)
				{
					$this->err = $this->ThrowError("Connection timed out")." ".__FILE__.":".__LINE__;

					return;
				}
				sleep(1);
				continue;
			}
			if($err == 56)
			{
				return;
			}
			$this->err = $this->ThrowError(socket_strerror($err))." ".__FILE__.":".__LINE__;

			return;
		}
	}

	function _shutdown_socket()
	{
		if(isset($this->socket))
		{
			socket_shutdown($this->socket);
			usleep(500);
			socket_shutdown($this->socket);
			socket_close($this->socket);
		}
	}

	function ProcessRequest($request='')
	{
		$this->_setup_socket();
		if($this->err)
		{
			return;
		}

		if(FALSE===$this->socket || empty($this->socket))
		{
			$this->err = $this->ThrowError()." ".__FILE__.":".__LINE__;

			return;
		}

		if(FALSE===socket_set_block($this->socket))
		{
			$this->err = $this->ThrowError()." ".__FILE__.":".__LINE__;

			return;
		}

		if(FALSE===socket_write($this->socket, "$request\r\n"))
		{
			$this->err = $this->ThrowError()." ".__FILE__.":".__LINE__;

			return;
		}

		$read = array($this->socket);
		$buffer = '';
		while(true)
		{
			$select = socket_select($read, $write=NULL, $except=NULL, GOPHERPROXY_SELECT_TIMEOUT);
			if(false !== $select && $select > 0)
			#if(false === $select)
			{
				$readbuf = socket_read($this->socket, GOPHERPROXY_READ_LENGTH);
				if(''==$readbuf)
				{
					break;
				}
				while(0 != strlen($readbuf))
				{
					$buffer .= $readbuf;
					$readbuf = socket_read($this->socket, GOPHERPROXY_READ_LENGTH);
				}
			}
			else
			{
				$this->err = $this->ThrowError()." ".__FILE__.":".__LINE__;
				break;	
			}
		}
		$this->_shutdown_socket();
		return $buffer;
	}

	function ThrowError($err='')
	{
		$this->_shutdown_socket();
		$this->socket = NULL;
		if(empty($err))
		{
			$err = socket_strerror(socket_last_error());

			return '<em class="error">'.GOPHERPROXY_SOCKET_ERROR.": ".$err.'</em>';
		}
		return '<em class="error">'.$err.'</em>'; 
	}

	// Returns TRUE if access is permitted, FALSE otherwise
	function ValidateHost($host, $port=70)
	{
		// Check for allowed hosts first
		$vals = explode(",", $this->config['hosts_allow']);
		if(!empty($vals[0]))
		{
			foreach($vals as $str)
			{
				$str = trim($str);
				$spec = explode(":", $str);
				if(preg_match("/$spec[0]/", $host) > 0)
				{
					if(!isset($spec[1]) || 
						preg_match("/$spec[1]/", $port) > 0)
					{
						return TRUE;
					}
				}
			}
		}

		// Check for denied hosts
		$vals = explode(",", $this->config['hosts_deny']);
		if(!empty($vals[0]))
		{
			foreach($vals as $str)
			{
				$str = trim($str);
				$spec = explode(":", $str);
				if(preg_match("/$spec[0]/", $host) > 0)
				{
					if(!isset($spec[1]) || 
						preg_match("/$spec[1]/", $port) > 0)
					{
						return FALSE;
					}
				}
			}
		}

		// No matches always default to allowed access
		return TRUE;
	}

	function GetError()
	{
		return $this->err;
	}
}
?>
