<?php

// hosts_allow, hosts_deny:
//
// Modeled after UNIX hosts_access. The proxy consults two settings, 
// 'hosts_allow' and 'hosts_deny'. The host search stops at the first 
// match:
//		- Access will be granted when a host matches on an entry in 
//		'hosts_allow'.
//		- Otherwise, access will be denied when a host matches an 
//		entry in 'hosts_deny'.
//		- Otherwise, access will be granted.
// A non-existing config entry is treated as if it were empty. Thus, 
// access control can be turned off by providing no entries (or 
// setting the entries to '').
//
// Valid regexp expressions may be used.  It is up to you to ensure 
// your regexp expressions work. If in doubt, simply list the IPs one 
// at a time. To allow and/or deny all hostnames, use '.*'. Subnets 
// (i.e., 192.168.0/24) are not supported at this time. 
//
// You may optionally append a port number (i.e., 192.168.0.3:70). 
// The port number is stripped prior to preforming the match; 
// wildcards are not allowed here. If you don't want to restrict any 
// ports, don't specify a port number.
//
// restrict_pages_to:
//
// Allow this action to be called only from the specified wiki pages. 
// An empty value allows the action to be called from any page 
// (meaning a user can create a page and call this action, so you 
// probably want to set hosts_allow and hosts_deny as well).  
// Restricting write access to these pages will keep a malicious 
// person from modifying the action params. Comma-separate multiple pages.

$gopherProxyConfig = array(
	'hosts_allow'=>'',
	'hosts_deny'=>'localhost, 127\.0\.0\.1, 192\.168\., 172\., .*:80',
	'restrict_pages_to' => 'GopherProxy,Hal3000');
?>
